package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLayer7CCRule invokes the ddoscoo.DeleteLayer7CCRule API synchronously
func (client *Client) DeleteLayer7CCRule(request *DeleteLayer7CCRuleRequest) (response *DeleteLayer7CCRuleResponse, err error) {
	response = CreateDeleteLayer7CCRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLayer7CCRuleWithChan invokes the ddoscoo.DeleteLayer7CCRule API asynchronously
func (client *Client) DeleteLayer7CCRuleWithChan(request *DeleteLayer7CCRuleRequest) (<-chan *DeleteLayer7CCRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteLayer7CCRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLayer7CCRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLayer7CCRuleWithCallback invokes the ddoscoo.DeleteLayer7CCRule API asynchronously
func (client *Client) DeleteLayer7CCRuleWithCallback(request *DeleteLayer7CCRuleRequest, callback func(response *DeleteLayer7CCRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLayer7CCRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteLayer7CCRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLayer7CCRuleRequest is the request struct for api DeleteLayer7CCRule
type DeleteLayer7CCRuleRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Name            string `position:"Query" name:"Name"`
}

// DeleteLayer7CCRuleResponse is the response struct for api DeleteLayer7CCRule
type DeleteLayer7CCRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLayer7CCRuleRequest creates a request to invoke DeleteLayer7CCRule API
func CreateDeleteLayer7CCRuleRequest() (request *DeleteLayer7CCRuleRequest) {
	request = &DeleteLayer7CCRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DeleteLayer7CCRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteLayer7CCRuleResponse creates a response to parse from DeleteLayer7CCRule response
func CreateDeleteLayer7CCRuleResponse() (response *DeleteLayer7CCRuleResponse) {
	response = &DeleteLayer7CCRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
