# Build Cache

## Background

Like all build systems, there are dependencies that may be required to build a package. These dependencies often are large and immutable, and can be cached to speed up the build process.

For example, Go has its modules cache, NPM keeps installed packages in `node_modules`, Maven stores downloaded
packages in its `.m2` directory, and so on.

As each build often requires all the same packages, it can be very inefficient to download and install them with each build. To optimize this, melange has an optional build cache feature.

## How to use it

When you run `melange build`, you can specify a cache directory with the `--cache-dir` flag. The value you provide here should be a path to a directory on your local filesystem. This local directory will be mounted into the build workspace (e.g. a running container) at the path `/var/cache/melange` as a read/write volume.

This enables you to speed up builds by preloading data into the cache before you run `melange build`. You can additionally use this mounted directory to persist cache data generated by the build itself, taking advantage of the cache in subsequent builds.

### Example: Go Modules

If you're using Melange to build a Go project, and you already have Go set up on your local machine, you can use your Go modules cache as a _build cache_ by running:

```shell
melange build --cache-dir "$(go env GOMODCACHE)" ...
```

This will mount your local Go modules cache (usually a path like `/Users/<you>/go/pkg/mod`) into the build workspace at `/var/cache/melange`. **IMPORTANT:** To tell Go where to find this cache, make sure to set the environment variable `GOMODCACHE` to `/var/cache/melange`. You can set environment variables in your Melange config here:

```yaml
environment:
  contents:
    packages:
      # ...
  environment:
    GOMODCACHE: '/var/cache/melange'   # <-- here!
```

Or you can just set the variable as a normal shell command within the `runs:` pipeline step where you're running Go:

```yaml
pipeline:
  - runs: |
      GOMODCACHE="/var/cache/melange"
      # ...
```

Now you're all set! If you've already downloaded the Go modules you need for your Go project to your local filesystem, you'll no longer need to wait for Melange to download those Go modules during every build. This can significantly speed up builds! 

Keep in mind that because the build cache is a read/write-able mount, modifications to data in this directory during a Melange build **will affect** your local filesystem.