package batchaiapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/batchai/mgmt/2018-05-01/batchai"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result batchai.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result batchai.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*batchai.OperationsClient)(nil)

// UsagesClientAPI contains the set of methods on the UsagesClient type.
type UsagesClientAPI interface {
	List(ctx context.Context, location string) (result batchai.ListUsagesResultPage, err error)
	ListComplete(ctx context.Context, location string) (result batchai.ListUsagesResultIterator, err error)
}

var _ UsagesClientAPI = (*batchai.UsagesClient)(nil)

// WorkspacesClientAPI contains the set of methods on the WorkspacesClient type.
type WorkspacesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, workspaceName string, parameters batchai.WorkspaceCreateParameters) (result batchai.WorkspacesCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string) (result batchai.WorkspacesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string) (result batchai.Workspace, err error)
	List(ctx context.Context, maxResults *int32) (result batchai.WorkspaceListResultPage, err error)
	ListComplete(ctx context.Context, maxResults *int32) (result batchai.WorkspaceListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, maxResults *int32) (result batchai.WorkspaceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, maxResults *int32) (result batchai.WorkspaceListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, workspaceName string, parameters batchai.WorkspaceUpdateParameters) (result batchai.Workspace, err error)
}

var _ WorkspacesClientAPI = (*batchai.WorkspacesClient)(nil)

// ExperimentsClientAPI contains the set of methods on the ExperimentsClient type.
type ExperimentsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string) (result batchai.ExperimentsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string) (result batchai.ExperimentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string) (result batchai.Experiment, err error)
	ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string, maxResults *int32) (result batchai.ExperimentListResultPage, err error)
	ListByWorkspaceComplete(ctx context.Context, resourceGroupName string, workspaceName string, maxResults *int32) (result batchai.ExperimentListResultIterator, err error)
}

var _ ExperimentsClientAPI = (*batchai.ExperimentsClient)(nil)

// JobsClientAPI contains the set of methods on the JobsClient type.
type JobsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, parameters batchai.JobCreateParameters) (result batchai.JobsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result batchai.JobsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result batchai.Job, err error)
	ListByExperiment(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, maxResults *int32) (result batchai.JobListResultPage, err error)
	ListByExperimentComplete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, maxResults *int32) (result batchai.JobListResultIterator, err error)
	ListOutputFiles(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, outputdirectoryid string, directory string, linkexpiryinminutes *int32, maxResults *int32) (result batchai.FileListResultPage, err error)
	ListOutputFilesComplete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, outputdirectoryid string, directory string, linkexpiryinminutes *int32, maxResults *int32) (result batchai.FileListResultIterator, err error)
	ListRemoteLoginInformation(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result batchai.RemoteLoginInformationListResultPage, err error)
	ListRemoteLoginInformationComplete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result batchai.RemoteLoginInformationListResultIterator, err error)
	Terminate(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result batchai.JobsTerminateFuture, err error)
}

var _ JobsClientAPI = (*batchai.JobsClient)(nil)

// FileServersClientAPI contains the set of methods on the FileServersClient type.
type FileServersClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, workspaceName string, fileServerName string, parameters batchai.FileServerCreateParameters) (result batchai.FileServersCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string, fileServerName string) (result batchai.FileServersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string, fileServerName string) (result batchai.FileServer, err error)
	ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string, maxResults *int32) (result batchai.FileServerListResultPage, err error)
	ListByWorkspaceComplete(ctx context.Context, resourceGroupName string, workspaceName string, maxResults *int32) (result batchai.FileServerListResultIterator, err error)
}

var _ FileServersClientAPI = (*batchai.FileServersClient)(nil)

// ClustersClientAPI contains the set of methods on the ClustersClient type.
type ClustersClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, workspaceName string, clusterName string, parameters batchai.ClusterCreateParameters) (result batchai.ClustersCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string, clusterName string) (result batchai.ClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string, clusterName string) (result batchai.Cluster, err error)
	ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string, maxResults *int32) (result batchai.ClusterListResultPage, err error)
	ListByWorkspaceComplete(ctx context.Context, resourceGroupName string, workspaceName string, maxResults *int32) (result batchai.ClusterListResultIterator, err error)
	ListRemoteLoginInformation(ctx context.Context, resourceGroupName string, workspaceName string, clusterName string) (result batchai.RemoteLoginInformationListResultPage, err error)
	ListRemoteLoginInformationComplete(ctx context.Context, resourceGroupName string, workspaceName string, clusterName string) (result batchai.RemoteLoginInformationListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, workspaceName string, clusterName string, parameters batchai.ClusterUpdateParameters) (result batchai.Cluster, err error)
}

var _ ClustersClientAPI = (*batchai.ClustersClient)(nil)
