// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.CodeAnalysis.PooledObjects;

internal partial class ArrayBuilder<T>
{
    /// <summary>
    /// struct enumerator used in foreach.
    /// </summary>
    internal struct Enumerator
    {
        private readonly ArrayBuilder<T> _builder;
        private int _index;

        public Enumerator(ArrayBuilder<T> builder)
        {
            _builder = builder;
            _index = -1;
        }

        public T Current
        {
            get
            {
                return _builder[_index];
            }
        }

        public bool MoveNext()
        {
            _index++;
            return _index < _builder.Count;
        }
    }
}