//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstokenstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTokenStyle(pub NSUInteger);
impl NSTokenStyle {
    #[doc(alias = "NSTokenStyleDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "NSTokenStyleNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "NSTokenStyleRounded")]
    pub const Rounded: Self = Self(2);
    #[doc(alias = "NSTokenStyleSquared")]
    pub const Squared: Self = Self(3);
    #[doc(alias = "NSTokenStylePlainSquared")]
    pub const PlainSquared: Self = Self(4);
}

unsafe impl Encode for NSTokenStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTokenStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstokenfieldcell?language=objc)
    #[unsafe(super(NSTextFieldCell, NSActionCell, NSCell, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(
        feature = "NSActionCell",
        feature = "NSCell",
        feature = "NSTextFieldCell"
    ))]
    pub struct NSTokenFieldCell;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSTokenFieldCell {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSTokenFieldCell {}
);

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
extern_conformance!(
    unsafe impl NSCoding for NSTokenFieldCell {}
);

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
extern_conformance!(
    unsafe impl NSCopying for NSTokenFieldCell {}
);

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
unsafe impl CopyingHelper for NSTokenFieldCell {
    type Result = Self;
}

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSTokenFieldCell {}
);

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell",
    feature = "NSUserInterfaceItemIdentification"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSTokenFieldCell {}
);

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
impl NSTokenFieldCell {
    extern_methods!(
        #[unsafe(method(tokenStyle))]
        #[unsafe(method_family = none)]
        pub fn tokenStyle(&self) -> NSTokenStyle;

        /// Setter for [`tokenStyle`][Self::tokenStyle].
        #[unsafe(method(setTokenStyle:))]
        #[unsafe(method_family = none)]
        pub fn setTokenStyle(&self, token_style: NSTokenStyle);

        #[unsafe(method(completionDelay))]
        #[unsafe(method_family = none)]
        pub fn completionDelay(&self) -> NSTimeInterval;

        /// Setter for [`completionDelay`][Self::completionDelay].
        #[unsafe(method(setCompletionDelay:))]
        #[unsafe(method_family = none)]
        pub fn setCompletionDelay(&self, completion_delay: NSTimeInterval);

        #[unsafe(method(defaultCompletionDelay))]
        #[unsafe(method_family = none)]
        pub fn defaultCompletionDelay(mtm: MainThreadMarker) -> NSTimeInterval;

        #[unsafe(method(tokenizingCharacterSet))]
        #[unsafe(method_family = none)]
        pub fn tokenizingCharacterSet(&self) -> Retained<NSCharacterSet>;

        /// Setter for [`tokenizingCharacterSet`][Self::tokenizingCharacterSet].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTokenizingCharacterSet:))]
        #[unsafe(method_family = none)]
        pub fn setTokenizingCharacterSet(&self, tokenizing_character_set: Option<&NSCharacterSet>);

        #[unsafe(method(defaultTokenizingCharacterSet))]
        #[unsafe(method_family = none)]
        pub fn defaultTokenizingCharacterSet(mtm: MainThreadMarker) -> Retained<NSCharacterSet>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSTokenFieldCellDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSTokenFieldCellDelegate>>);
    );
}

/// Methods declared on superclass `NSTextFieldCell`.
#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
impl NSTokenFieldCell {
    extern_methods!(
        #[unsafe(method(initTextCell:))]
        #[unsafe(method_family = init)]
        pub fn initTextCell(this: Allocated<Self>, string: &NSString) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(initImageCell:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initImageCell(
            this: Allocated<Self>,
            image: Option<&NSImage>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSCell`.
#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
impl NSTokenFieldCell {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSTextFieldCell"
))]
impl NSTokenFieldCell {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstokenfieldcelldelegate?language=objc)
    pub unsafe trait NSTokenFieldCellDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        /// Allows the delegate to provide an array of appropriate completions for the contents of the receiver
        ///
        /// Parameter `tokenFieldCell`: The token field cell where editing is occurring
        ///
        /// Parameter `substring`: The partial string that is being completed
        ///
        /// Parameter `tokenIndex`: The index of the token being completed
        ///
        /// Parameter `selectedIndex`: Optionally, you can return by reference an index into the returned array that specifies which of the completions should be initially selected. If none are to be selected, return by reference `-1`.
        ///
        /// Returns: An array of strings (`NSString`) that are possible completions
        ///
        /// If the delegate does not implement this method, no completions are provided
        ///
        /// # Safety
        ///
        /// `selected_index` must be a valid pointer.
        #[optional]
        #[unsafe(method(tokenFieldCell:completionsForSubstring:indexOfToken:indexOfSelectedItem:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_completionsForSubstring_indexOfToken_indexOfSelectedItem(
            &self,
            token_field_cell: &NSTokenFieldCell,
            substring: &NSString,
            token_index: NSInteger,
            selected_index: NonNull<NSInteger>,
        ) -> Retained<NSArray>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `tokens` generic should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:shouldAddObjects:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_shouldAddObjects_atIndex(
            &self,
            token_field_cell: &NSTokenFieldCell,
            tokens: &NSArray,
            index: NSUInteger,
        ) -> Retained<NSArray>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:displayStringForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_displayStringForRepresentedObject(
            &self,
            token_field_cell: &NSTokenFieldCell,
            represented_object: &AnyObject,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:editingStringForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_editingStringForRepresentedObject(
            &self,
            token_field_cell: &NSTokenFieldCell,
            represented_object: &AnyObject,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        #[optional]
        #[unsafe(method(tokenFieldCell:representedObjectForEditingString:))]
        #[unsafe(method_family = none)]
        fn tokenFieldCell_representedObjectForEditingString(
            &self,
            token_field_cell: &NSTokenFieldCell,
            editing_string: &NSString,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSPasteboard",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `objects` generic should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:writeRepresentedObjects:toPasteboard:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_writeRepresentedObjects_toPasteboard(
            &self,
            token_field_cell: &NSTokenFieldCell,
            objects: &NSArray,
            pboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSPasteboard",
            feature = "NSTextFieldCell"
        ))]
        #[optional]
        #[unsafe(method(tokenFieldCell:readFromPasteboard:))]
        #[unsafe(method_family = none)]
        fn tokenFieldCell_readFromPasteboard(
            &self,
            token_field_cell: &NSTokenFieldCell,
            pboard: &NSPasteboard,
        ) -> Option<Retained<NSArray>>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSMenu",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:menuForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_menuForRepresentedObject(
            &self,
            token_field_cell: &NSTokenFieldCell,
            represented_object: &AnyObject,
        ) -> Option<Retained<NSMenu>>;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:hasMenuForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_hasMenuForRepresentedObject(
            &self,
            token_field_cell: &NSTokenFieldCell,
            represented_object: &AnyObject,
        ) -> bool;

        #[cfg(all(
            feature = "NSActionCell",
            feature = "NSCell",
            feature = "NSTextFieldCell"
        ))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenFieldCell:styleForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenFieldCell_styleForRepresentedObject(
            &self,
            token_field_cell: &NSTokenFieldCell,
            represented_object: &AnyObject,
        ) -> NSTokenStyle;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefaulttokenstyle?language=objc)
#[deprecated]
pub static NSDefaultTokenStyle: NSTokenStyle = NSTokenStyle(NSTokenStyle::Default.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsplaintexttokenstyle?language=objc)
#[deprecated]
pub static NSPlainTextTokenStyle: NSTokenStyle = NSTokenStyle(NSTokenStyle::None.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsroundedtokenstyle?language=objc)
#[deprecated]
pub static NSRoundedTokenStyle: NSTokenStyle = NSTokenStyle(NSTokenStyle::Rounded.0);
