Minutes from 83rd OpenVDB TSC meeting, March 16th, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B, *Andre* P.

Additional Attendees: Johannes Meng (Intel), Robin Rowe (Cinepaint)
Bruce Chernaik (Intel), JT Nelson (Blender)

Agenda:

1) Confirm Quorum
2) Secretary
3) Forum
4) Website
5) VDB Unit test speeds
6) CMake multi config changes PR # 1003
7) VDB Points mem leak
8) Point statistics PR # 997
9) Header vs CMake defines
10) PR994 / Release 7.2.3
11) DynamicNodeManager and Const Trees (PR996)
12) AX and Active Tiles
13) Half Limits
14) Exrapolate SOP
15) Next Meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Nick Avramoussis.

3) Forum

RFE #1002 has been filed about possibly extending VDB tree structures with
custom allocators. Ken, has investigated such techniques in the past and used to
have an implementation, but was essentially unable to get better performance
than using a custom malloc (i.e. jemalloc). Jeff, opposed, such extensions
introduce a lot of complexity (e.g. the stl...) and have historically been
introduced due to limitations in malloc. Jeff, this technique is better suited
to custom hardware allocations (host vs device). Ken, nanovdb uses its own
structure now so this wouldn't be as useful. Summary, TSC would be interested to
see if an implementation can be constructed which demos significant improvements
over allocators such as jemalloc, but otherwise will most likely not be actively
targeted by the TSC.

4) Website

Ken has updated some logos. We should updated the about section to reference the
TSC.

5) VDB Unit test speeds

The VDB Unit tests take ~3.5 hours to run in Debug. 50% of this time is the
FastSweeping unit tests. The top three slowest tests are TestFastSweeping (1.5h),
TestGridTransformer (30min) and TestDiagnostics (25min). We should improve these.

6) CMake multi config changes PR # 1003

Nick, work to improve OpenVDB's CMake build system for generators that support
multiple configurations. Jeff, recently discovered this issue in Houdini where
release libs are linking against debug libs and conversely different CRTs on
Windows. Nick to finalize PR and merge.

7) VDB Points mem leak

Nick, discovered potential memory leak in VDB Points when delay loading if off.
Dan to investigate and confirm - suggested fix is a one liner which should
hopefully be applicable.

8) Point statistics PR # 997

Nick, point statistics PR is up which is a pre-requisite for the surfacing. Dan,
has commented, main comment to discuss is precision of intermediate arithmetic
on average/accumulates. All agreed that this should be done at the highest
applicable precision (double for floating point, 64bit ints otherwise). Nick to
address.

9) Header vs CMake defines

OpenVDB CMake build system adds a variety of compile time defines, as does the
FindOpenVDB.cmake module. Excluding these defines would otherwise cause build
failures. This, however, makes downstream software reliant on using the
FindOpenVDB.cmake module (i.e. downstream software has to build with cmake).
This is an unnecessary limitation and we should instead look to move some of
these defines to headers (PlatformConfig/BuildConfig etc). Nick to investigate.

10) PR994 / Release 7.2.3

Dan, looking to release 7.2.3, Jeff to approve and then can merge.

11) DynamicNodeManager and Const Trees (PR996)

Dan, updated the dynamic node manager to work with const trees. Observed a minor
performance improvement whilst doing so, but main instigation was to be able
to port existing const node manager methods (such as activeVoxelCount).

12) AX and Active Tiles

Dan, observed significant performance loss on heavily tiled VDB grids using AX.
This is due to the full expansion/pruning pre and post processing steps. A
better way would be to stream the tiled data and use better heuristics to avoid
this streaming. Nick, already have a roadmap for siggraph but will see if we can
look to add this too.

13) Half Limits

Dan, should we be including the half limits header in Types.h and what's the
correct name-spacing to use. Jeff, not sure, we should add a unit test to check
we don't run into ODR/name lookup issues.

14) Extrapolate SOP

Jeff to review.

15) Next Meeting

Next meeting is March 23rd, 2021. 1pm-2pm EST (GMT-4).
