#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Parche 1.0.1.0 no instalado"},
    {TR_NO_PATCH_MESSAGE,
        "Tu instalación de Caesar 3 no tiene el parche 1.0.1.0 instalado. "
        "Puedes descargar el parche en:\n"
        URL_PATCHES "\n"
        "Continúa bajo tu propio riesgo."},
    {TR_MISSING_FONTS_TITLE, "Faltan fuentes"},
    {TR_MISSING_FONTS_MESSAGE,
        "Tu instalación de Caesar 3 requiere archivos de fuente adicionales. "
        "Puedes descargar las fuentes requeridas para tu idioma en:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor no instalado"},
    {TR_NO_EDITOR_MESSAGE,
        "Tu instalación de Caesar 3 no contiene los archivos del editor. "
        "Puedes descargar los archivos requeridos en:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Directorio de idioma inválido"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "El directorio que has seleccionado no contiene un paquete de idioma válido. "
        "Por favor, comprueba el registro de errores."},
    {TR_BUILD_ALL_TEMPLES, "Todos"},
    {TR_BUTTON_OK, "Aceptar"},
    {TR_BUTTON_CANCEL, "Cancelar"},
    {TR_BUTTON_RESET_DEFAULTS, "Por defecto"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Atajos"},
    {TR_CONFIG_ARE_YOU_SURE, "¿Restablecer la configuración predeterminada?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Perderás todas tus configuraciones personalizadas."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Perderás todos tus atajos personalizados."},
    {TR_CONFIG_TITLE, "Opciones de configuración de Augustus"},
    {TR_CONFIG_HEADER_GENERAL, "Configuraciones generales"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Interfaz de usuario"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Dificultad"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Gestión de la ciudad"},
    {TR_CONFIG_LANGUAGE_LABEL, "Idioma:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(Por defecto)"},
    {TR_CONFIG_GAME_SPEED, "Velocidad de juego:"},
    {TR_CONFIG_VIDEO, "Opciones de video"},
    {TR_CONFIG_FULLSCREEN, "Pantalla completa"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Resolución en modo ventana:"},
    {TR_CONFIG_DISPLAY_SCALE, "Escala del monitor:"},
    {TR_CONFIG_CURSOR_SCALE, "Tamaño del cursor:"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Usar cursor alternativo"},
    {TR_CONFIG_AUDIO, "Opciones de audio"},
    {TR_CONFIG_VOLUME, "Volumen"},
    {TR_CONFIG_ENABLE_AUDIO, "Activar audio"},
    {TR_CONFIG_MUSIC, "Activar música"},
    {TR_CONFIG_SPEECH, "Activar diálogos"},
    {TR_CONFIG_EFFECTS, "Activar efectos de sonido"},
    {TR_CONFIG_CITY_SOUNDS, "Activar sonidos de ciudad"},
    {TR_CONFIG_SCROLL_SPEED, "Velocidad de desplazamiento:"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Reproducir vídeos al inicio"},
    {TR_CONFIG_SIDEBAR_INFO, "Mostrar información adicional en el panel de control"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Activar desplazamiento suave del mapa"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Desactivar desplazamiento en el borde de la ventana"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Desactivar clic derecho para desplazar el mapa"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Mejorar la retroalimentación visual al limpiar terreno"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Permitir construcción secuencial de templos"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Mostrar área cubierta por depósitos, fuentes y pozos al construir"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Mostrar medidas de construcción al arrastrar"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Resaltar legión bajo el cursor"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Activar barra militar lateral"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Corregir bug impidiendo inmigración en Muy Difícil"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Corregir bug creando fantasmas con 100 años"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Corregir cambio de Emperador y tiempo de supervivencia en misiones del editor"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Ver controles de ruta en Capas al hacer clic derecho en un edificio"},
    {TR_CONFIG_ENABLE_ZOOM, "Habilitar zoom (usa más RAM, puede ralentizar el juego)"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Arreglar columnas de puntuación incompletas con objetivos bajos"},
    {TR_CONFIG_GRANDFESTIVAL, "Super-Festivales permiten bendiciones extras de un dios"},
    {TR_CONFIG_DIFFICULTY, "Dificultad:"},
    {TR_CONFIG_GODS_EFFECTS, "Activar efectos de dioses"},
    {TR_CONFIG_JEALOUS_GODS, "Desactivar la envidia entre dioses"},
    {TR_CONFIG_GLOBAL_LABOUR, "Activar mano de obra global"},
    {TR_CONFIG_SCHOOL_WALKERS, "Extender el rango de los caminantes de los colegios"},
    {TR_CONFIG_RETIRE_AT_60, "Cambiar la edad de jubilación de 50 a 60 años"},
    {TR_CONFIG_FIXED_WORKERS, "Mano de obra fija - 38% de la población plebeya"},
    {TR_CONFIG_EXTRA_FORTS, "Permite construir 4 fuertes adicionales"},
    {TR_CONFIG_WOLVES_BLOCK, "Deshabilitar la construcción alrededor de lobos"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Bloquear los caminos no conectados de un granero"},
    {TR_CONFIG_MORE_STOCKPILE, "Las residencias reservan más bienes del mercado"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Las mercaderes que compran no distribuyen bienes"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Destruir edificios inmediatamente"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Los carreteros de graneros que obtienen bienes no necesitan caminos"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Doblar la capacidad de carreteros de graneros que obtienen bienes"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Permitir importar y exportar comida desde graneros"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Los centinelas de las torres no necesitan conexión a una barraca"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Granjas y dársenas solo distribuyen a graneros cercanos"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "No distribuir alimentos a graneros que obtienen bienes"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Todas las residencias se unen"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Una ruta de comercio abierta cuenta como suministro de un distinto tipo de vino"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Pozos de arcilla y Minas de hierro cobran dinero en vez de destruirse"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Permite construir múltiples barracas"},
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Los almacenes no aceptan bienes cuando se construyen"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Las residencias no se expanden hacia los jardines"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Los caminantes no acortan camino por las esquinas"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "El zoom no se pudo habilitar"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE,
        "Tu sistema no posee la capacidad gráfica para habilitar el zoom.\n"
        "El zoom no ha sido habilitado."},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Mostrar puntuación de prosperidad máxima obtenible"},
    {TR_HOTKEY_TITLE, "Configuración de atajos de teclado de Augustus"},
    {TR_HOTKEY_LABEL, "Principal"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Atajos de mapa"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Atajos de construcción"},
    {TR_HOTKEY_ARROW_UP, "Arriba"},
    {TR_HOTKEY_ARROW_DOWN, "Abajo"},
    {TR_HOTKEY_ARROW_LEFT, "Izquierda"},
    {TR_HOTKEY_ARROW_RIGHT, "Derecha"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Activar pantalla completa"},
    {TR_HOTKEY_CENTER_WINDOW, "Centrar pantalla"},
    {TR_HOTKEY_RESIZE_TO_640, "Redimensionar a 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Redimensionar a 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Redimensionar a 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Capturar pantalla"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Capturar ciudad completa"},
    {TR_HOTKEY_BUILD_CLONE, "Clonar edificio bajo el cursor"},
    {TR_HOTKEY_LOAD_FILE, "Cargar partida"},
    {TR_HOTKEY_SAVE_FILE, "Guardar partida"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Subir velocidad de juego"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Bajar velocidad de juego"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Activar pausa"},
    {TR_HOTKEY_CYCLE_LEGION, "Alternar entre legiones"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Rotar mapa a la izquierda"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Rotar mapa a la derecha"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Asesor laboral"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Asesor militar"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Asesor imperial"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Asesor de puntuación"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Asesor de comercio"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Asesor de población"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Asesor de sanidad"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Asesor de educación"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Asesor de entretenimiento"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Asesor de religión"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Asesor de finanzas"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Asesor jefe"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Asesor de vivienda"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Capa actual"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Mostrar capa contextual"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Capa de agua"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Capa de riesgo de fuego"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Capa de riesgo de daño"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Capa de criminalidad"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Capa de problemas"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotar edificio"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Rotación anterior de edificio"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Ir a atajo de mapa 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Ir a atajo de mapa 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Ir a atajo de mapa 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Ir a atajo de mapa 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Definir atajo de mapa 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Definir atajo de mapa 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Definir atajo de mapa 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Definir atajo de mapa 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Activar información de batalla"},
    {TR_HOTKEY_EDIT_TITLE, "Presiona la nueva tecla"},
    {TR_BUILDING_ROADBLOCK, "Control de carretera"},
    {TR_BUILDING_ROADBLOCK_DESC, "Los controles de carretera detienen a los ciudadanos ociosos."},
    {TR_BUILDING_ARCHITECT_GUILD, "Gremio de arquitectos"},
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Los arquitectos trabajan aquí sin cesar para construir monumentos a la gloria de Roma."},
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Confiere un epíteto al templo"},
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptuno"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Mercurio"},
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Marte"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus"},
    {TR_BUILDING_PANTHEON, "Panteón"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Templo magno de Ceres"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Templo magno de Neptuno"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Templo magno de Mercurio"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Templo magno de Marte"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Templo magno de Venus"},
    {TR_BUILDING_PANTHEON_DESC, "Panteón"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Los carreteros de las granjas son un 50% más rápidos."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Aumenta en +1 el rango de pozos y fuentes y +2 el de depósitos. Los servicios hidráulicos usan un 50% de trabajadores menos. Los barcos de comercio viajan un 25% más rápido."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Los comerciantes terrestres y marítimos tienen un 50% más de capacidad. Las caravanas de mercaderes son un 25% más rápidas."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Entrena soldados como una barraca. Se pueden construir 4 fuertes adicionales."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Jardines, estatuas y templos de la ciudad brillan con increíble belleza, aumentando su atractivo. Las residencias reservan más bienes y demoran más en disminuir de nivel."},
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Otorga acceso a todos los dioses. Celebra festivales anuales y reduce el costo por mantenimiento de iglesias y edificios culturales un 25%."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Los sacerdotes reducen el consumo de alimento en un 20%."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Los templos producen aurigas para el Hipódromo."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Los sacerdotes reducen el consumo de cerámica y muebles en un 20%."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Los templos generan alimentos en una cantidad proporcional al número de casas que cubren y lo entregan al puesto de suministro. El coste por mantenimiento de los fuertes se reduce un 25%"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "El Templo magno produce vino en una cantidad proporcional a la población con acceso a templos de Venus. Los templos lo recolectan y distribuyen a residencias y tabernas."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Los sacerdotes recolectan y distribuyen aceite y un tipo de alimento del disponible en la ciudad."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Los sacerdotes expanden la capacidad de las viviendas en un 5%. El Templo magno provee agua como si fuese un depósito."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Los sacerdotes reducen el consumo de aceite y vino en un 20%."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Los sacerdotes reducen el consumo de todos los bienes en un 10%."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Los sacerdotes proveen entretenimiento y hermosean las residencias, aumentando el atractivo del vecindario sin necesidad de decoraciones adicionales."},
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Todos los templos en la ciudad envían sacerdotes al Panteón, esparciendo la fé y bendiciones de sus dioses."},
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Las residencias con acceso al Panteón puede evolucionar un nivel adicional."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Templo de Ceres Fecunda"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Templo de Ceres Frugifera"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Templo de Neptunus Equester"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Templo de Neptunus Adiutor"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Templo de Mercurius Fortunus"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Templo de Mercurius Mercator"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Templo de Mars Ultor"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Templo de Mars Quirinus"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Templo de Venus Verticordia"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Templo de Venus Genetrix"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna"},
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Templo magno"},
    {TR_BUILDING_WORK_CAMP, "Campamento de trabajo"},
    {TR_BUILDING_WORK_CAMP_DESC, "Los trabajadores se reunen aquí para transportar los materiales necesarios a los sitios de construcción."},
    {TR_HEADER_HOUSING, "Vivienda"},
    {TR_ADVISOR_HOUSING_ROOM, "En la ciudad hay habitaciones para"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "No hay habitaciones disponibles en la ciudad."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Residencias demandando cerámica"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Residencias demandando muebles"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Residencias demandando aceite"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Residencias demandando vino"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Residencias totales:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Capacidad disponible:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Capacidad total:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Población - Vivienda"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Gráficos"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "La puntuación de prosperidad de las viviendas es"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "El porcentaje de tu población en villas y palacios es"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "El porcentaje de tu población en tiendas y tugurios es"},
    {TR_ADVISOR_AVERAGE_TAX, "La recaudación promedio de impuestos por residencia es"},
    {TR_ADVISOR_AVERAGE_AGE, "La edad promedio de tu población es"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "El porcentaje de tu población en la fuerza de trabajo es"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Nacimientos el año pasado:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Muertes el año pasado:"},
    {TR_ADVISOR_TOTAL_POPULATION, "residentes totales"},
    {TR_ADVISOR_IN_STORAGE, "en almacenamiento"},
    {TR_ADVISOR_FROM_GRANARIES, "en graneros"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Despachando desde graneros"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "¿Estás seguro(a)?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Seguir reservando recursos"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "La prosperidad máxima con este nivel de residencias es"},
    {TR_REQUIRED_RESOURCES, "Recursos entregados para la fase actual:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Construir templos magnos requiere material de un almacén, trabajadores de un campamento de trabajo y arquitectos de un gremio de arquitectos."},
    {TR_CONSTRUCTION_PHASE, "Fase de construcción:"},
    {TR_ADD_MODULE, "¿Rededicar templo?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epíteto conferido."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "La primera Ceres el terrón dividió con el corvo arado,\nla primera dio granos y alimentos suaves a las tierras,\nla primera dio sus leyes; Ceres todo esto regaló,\na ella de cantar yo he; ojalá tan sólo decir pudiera\ncanciones dignas de la diosa. Ciertamente digna es.\n-Ovidio, Metamorfosis, Libro V"},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Del mar la ira desaparece y, dejada su tricúspide arma\ncalma las aguas su regente, y al que sobre el profundo\nemerge y sus hombros con su innato múrice cubre,\nal azul Tritón llama, y en su concha sonante\nsoplar le ordena, y los oleajes y las corrientes ya\nrevocar, su señal dando.\n-Ovidio, Metamorfosis, Libro I"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Se pueden apresar los bueyes y las gordas ovejas,\nse pueden adquirir los trípodes y los tostados alazanes;\npero no es posible hacer volver el alma humana,\nuna vez ha salvado la barrera que forman los dientes.\n-Homero, La Iliada, Libro IX"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Trabajaban con afán en concluir un carro\ny unas veloces ruedas para Marte,\ncon que concita a los hombres y las ciudades.\n-Virgilio, La Eneida, Libro VIII"},
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Por Venus y con su tierna madre el volador Cupido,\ngoces cuán grandes sentí, cuán manifiesto deleite,\ncuán relajada hasta en las médulas he quedado\ncómo acordarse agrada.\n-Ovidio, Metamorfosis, Libro IX"},
    {TR_BUILDING_PANTHEON_QUOTE, "Abrese en tanto la morada del omnipotente Olimpo,\ny el padre de los dioses y rey de los hombres\nconvoca a concilio en la estrellada mansión,\ndesde donde abarca con la vista toda la tierra, y\nlos reales de los Troyanos y los pueblos latinos.\nToman asiento los dioses\nen una estancia abierta por ambos lados.\n-Virgilio, La Eneida, Libro X"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Los trabajadores construyen el podium que elevará el templo y proveerá una sólida fundación para hacer frente al paso del tiempo."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Los artesanos elaboran el portico, que contiene el altar de sacrificios del templo."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Los ingenieros elaboran la cella, la cámara que albergará las sagradas imágenes."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Ha comenzado el trabajo en el praecinctum del templo, donde los fieles se reunirán para las ceremonias públicas."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Con el templo casi completo, los sacerdotes se reunen para ejecutar los ritos de dedicación."},
    {TR_BUILDING_MENU_TREES, "Árboles"},
    {TR_BUILDING_MENU_PATHS, "Caminos"},
    {TR_BUILDING_MENU_PARKS, "Parques"},
    {TR_BUILDING_SMALL_POND, "Estanque pequeño"},
    {TR_BUILDING_LARGE_POND, "Estanque grande"},
    {TR_BUILDING_PINE_TREE, "Pino"},
    {TR_BUILDING_FIR_TREE, "Abeto"},
    {TR_BUILDING_OAK_TREE, "Roble"},
    {TR_BUILDING_ELM_TREE, "Olmo"},
    {TR_BUILDING_FIG_TREE, "Higuera"},
    {TR_BUILDING_PLUM_TREE, "Ciruelo"},
    {TR_BUILDING_PALM_TREE, "Palmera"},
    {TR_BUILDING_DATE_TREE, "Datilero"},
    {TR_BUILDING_PINE_PATH, "Camino de pinos"},
    {TR_BUILDING_FIR_PATH, "Camino de abetos"},
    {TR_BUILDING_OAK_PATH, "Camino de robles"},
    {TR_BUILDING_ELM_PATH, "Camino de olmos"},
    {TR_BUILDING_FIG_PATH, "Camino de higueras"},
    {TR_BUILDING_PLUM_PATH, "Camino de ciruelos"},
    {TR_BUILDING_PALM_PATH, "Camino de palmeras"},
    {TR_BUILDING_DATE_PATH, "Camino de datileros"},
    {TR_BUILDING_BLUE_PAVILION, "Pabellón"},
    {TR_BUILDING_RED_PAVILION, "Pabellón rojo"},
    {TR_BUILDING_ORANGE_PAVILION, "Pabellón naranja"},
    {TR_BUILDING_YELLOW_PAVILION, "Pabellón amarillo"},
    {TR_BUILDING_GREEN_PAVILION, "Pabellón verde"},
    {TR_BUILDING_SMALL_STATUE_ALT, "Estatua de la diosa"},
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Estatua del senador"},
    {TR_BUILDING_OBELISK, "Obelisco"},
    {TR_BUILDING_POND_DESC, "Depósitos llenan los estanques, que proveen agua para plantas y animales, y un fresco y relajante oasis para la gente. Todos los ciudadanos amarían vivir cerca de un estanque."},
    {TR_BUILDING_WINDOW_POND, "Estanque"},
    {TR_BUILDING_OBELISK_DESC, "Un prestigioso monumento, el trabajo de un antiguo rey del Nilo. Los egipcios no lo necesitaban."},
    {TR_ADVISOR_FINANCE_LEVIES, "Mantenimiento de edificios"},
    {TR_CONFIRM_DELETE_MONUMENT, "Demoliendo este monumento"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Selecciona el epíteto a conferir"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Conferir un epíteto dedicará permanentemente tu templo a un aspecto de su deidad, inbuyendo a los sacerdotes de poder divino."},
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/mes"},
    {TR_BUILDING_MESS_HALL, "Puesto de suministro"},
    {TR_BUILDING_MESS_HALL_DESC, "El puesto de suministro recolecta alimentos de los graneros de la ciudad para alimentar a los soldados de los fuertes. Un mal abastecimiento ralentizará el reclutamiento y dañará la moral."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Provisiones del mes pasado:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Los soldados están: "},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Bien alimentados"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Alimentados"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Hambrientos"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Muy hambrientos"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Famélicos"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "La variada dieta de tus soldados aumenta mucho su moral."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "La diversa y nutritiva dieta de la que gozan tus soldados aumenta mucho su moral."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "No tienes soldados que alimentar."},
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Meses de comida almacenados:"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instrucciones del puesto de suministro"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "La escasez de alimento en tu puesto de suministro ralentiza el reclutamiento."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "La escasez crítica de alimento en tu puesto de suministro estropea el reclutamiento."},
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "La reciente escasez de alimento disminuyó la moral"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "La reciente escasez de alimento disminuyó mucho la moral"},
    {TR_BUILDING_LEGION_STARVING, "Escasez de alimento"},
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "max"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importable"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportable"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "No hay compradores interesados"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "No hay vendedores disponibles"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Sin importar"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Sin exportar"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Abrir ruta comercial para importar"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Abrir ruta comercial para exportar"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Tus soldados tienen todo el alimento que necesitan."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Tus soldados necesitan más alimento."},
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "¡Tus soldados están famélicos!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Meses de comida almacenados en puestos de suministros:"},
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Soldados hambrientos"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Tu puesto de suministro tiene muy poca comida, y la moral de tus tropas mengua. Asegúrate de que tu puesto de suministros puede acceder a un granero bien surtido."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Tu ciudad perdió su puesto de suministros, y tus tropas tienen hambre. Construye un puesto de suministros inmediatamente."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Instrucciones del mercado"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Instrucciones del muelle"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instrucciones del templo"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instrucciones de la taberna"},
    {TR_WARNING_NO_MESS_HALL, "Debes construir primero un puesto de suministro para alimentar a tus tropas."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "Solo pueden construirse dos Templos magnos."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Templo magno completado"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Sacerdotes y fieles se congregan en el nuevo templo magno para los ritos de consagración. Tu gente ve asombrada la majestuosidad de tus obras, y tu deidad elegida te colma de favor."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Bendición de Mercurio"},
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Encantado por tu atención, Mercurio bendice tu industria, entregando materias primas a tus artesanos."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Capataz"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Transportista"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Arquitecto"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Intendente militar"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Sirviente del campo"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "El templo magno coordina a los sacerdotes de Ceres para ayudar distributendo comida y aceite a tus hambrientos ciudadanos."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "El templo magno permite la distribución de vino sagrado a tus ciudadanos por los sacerdotes de Venus ."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "El templo magno coordina la entrega de provisiones a tu puesto de suministros por los sacerdotes de Marte."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Templo de Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Templo de Neptuno"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Templo de Mercurio"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Templo de Marte"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Templo de Venus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Sacerdote"},
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Ciudades con comercio marítimo establecido:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "No hay rutas de comercio marítimas abiertas." },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Haré lo que pueda para aplacar a estos bárbaros. Estoy seguro de que dejarán de atacar la ciudad cuando haya hablado con ellos.\""},
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Festival anual"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Fieles acuden a los templos para la celebración de Cerealia, en honor a Ceres. Los granjeros ofrecen sacrificios a cambio de abundantes cosechas en los años venideros."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Hoy es el festival de Neptunalia, en honor a Neptuno. Los fieles construyen chozas de ramas y follaje y festejan bajo el calor abrasador del verano."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Comerciantes y mercaderes salen en masa a celebrar Mercuralia. Agua sagrada es rociada en barcos y almacenes, buscando la divina protección del dios Mercurio."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Ciudadanos se reunen en las afueras de la ciudad para la celebración de Equirria, buscando el favor de Marte. El aire se llena con el tronar de los cascos y el crujir de los carros mientras los fieles compiten en honor a su dios."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Los fieles se reunen para la celebración de Veneralia, día consagrado a Venus. Tus ciudadanos ruegan por buena fortuna en asuntos del corazón."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Borrar mensajes leídos"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Deshabilitar este edificio"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Habilitar este edificio"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Permitir a las mercaderes comprar aquí"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Permitir a las caravanas comerciar aquí"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Permitir a los barcos de comercio comerciar aquí"},
    {TR_BUILDING_LIGHTHOUSE, "Faro"},
    {TR_BUILDING_CARAVANSERAI, "Caravasar"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Las caravanas de mercaderes se detienen aquí para descansar y alimentar a sus animales. Las interrupciones al comercio terrestre duran la mitad."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Instrucciones del Caravasar"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Cimientos)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Los ingenieros sientan los cimientos de un refugio para los comerciantes."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Proveedor del caravasar" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Recolector del caravasar" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Política de comercio terrestre" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Sin política de comercio terrestre." },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Elige una política de comercio terrestre para tu ciudad. Puedes cambiarla en cualquier momento." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Política de exportación: Las caravanas de mercaderes pagan un 20% más por tus bienes, pero venden sus bienes un 10% más caros." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Política de importación: Las caravanas de mercaderes venden un 20% más baratos sus bienes, pero pagan por tus bienes un 10% menos." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Política de carga: Las caravanas de mercaderes pueden llevar 4 productos más, pero consumen un 20% más de comida en el Caravasar." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Cimientos)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestal)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Torre)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Cima)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Los arquitectos sientan sólidos cimientos para soportar el peso de la gran torre de piedra."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Albañiles construyen el pedestal que elevará la llama del faro por sobre el horizonte."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "La torre del faro se eleva cada día más, a medida que los albañiles cuidadosamente llevan a cabo su labor."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Arquitectos realizan toques finales al faro. Pronto brillará por kilómetros, guiando a los barcos a su destino."},
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Construir el faro requiere material de un almacén, trabajadores de un campamento de trabajo y arquitectos de un gremio de arquitectos."},
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "La luz de esta gran torre guía a los barcos desde los confines del mundo de forma segura a tu ciudad. Barcos pesqueros se mueven un 10% más rápido y las tormentas marinas duran la mitad."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Política de comercio marítima" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Sin política de comercio marítima." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Elige una política de comercio marítima para tu ciudad. Puedes cambiarla en cualquier momento." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Política de exportación: Los barcos de comercio pagan un 20% más por tus bienes, pero venden sus bienes un 10% más caros." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Política de importación: Los barcos de comercio venden un 20% más baratos sus bienes, pero pagan por tus bienes un 10% menos." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Política de carga: Los barcos de comercio pueden llevar 4 productos más, pero el Faro consume un 20% más de madera." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumentos"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "El faro, una enorme torre de piedra, se cierne sobre el horizonte. Que su baliza guíe a los barcos a su destino hasta el fin de los tiempos."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "El Panteón está completo. Se erige incomparable como monumento al asombroso poder de los dioses y del pueblo de Roma."},
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monumento finalizado"},
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Bendición de Neptuno"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Premiando la devoción de tu ciudad, Neptuno otorga viaje seguro a comerciantes por doce meses, durante los cuales tus exportaciones valdrán un 50% adicional."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Bendición de Venus"},
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Encantada por la alegre reverencia mostrada a ella, Venus otorga juventud, salud y felicidad a tu gente, aumentando la cantidad de tus trabajadores. El humor en tu ciudad se levanta ante la sonrisa de Venus."},
    {TR_BUILDING_MENU_STATUES, "Estatuas"},
    {TR_BUILDING_MENU_GOV_RES, "Mansión del gobernador"},
    {TR_OVERLAY_ROADS, "Caminos"},
    {TR_NO_EXTRA_ASSETS_TITLE, "Problema con los recursos adicionales"},
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Los recursos adicionales de Augustus no pudieron cargarse.\n"
        "Falta la carpeta 'assets' o está desactualizada.\n"
        "Asegúrate de tener la última versión de la carpeta 'assets', que puedes obtenerse desde GitHub."},
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "El faro debe ser construido cerca del agua."},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Esta casa tiene acceso a todos los dioses del Panteón"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "La abundante comida aumenta la moral"},
    {TR_BUILDING_LEGION_FOOD_STATUS, "Estado nutricional"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Permite a los intendentes militares obtener alimentos aquí"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "No puedes obtener los materiales necesarios"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Los templos magnos completados otorgan +6 de puntuación de cultura"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Desactiva la reaparición infinita de lobos"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Volver al menú principal"},
    {TR_LABEL_PAUSE_MENU, "Pausa"},
    {TR_OVERLAY_LEVY, "Mantenimiento"},
    {TR_TOOLTIP_OVERLAY_LEVY, " denarios pagados mensualmente en mantenimiento."},
    {TR_MAP_EDITOR_OPTIONS, "Configuración de escenario"},
    {TR_BUILDING_TAVERN, "Taberna" },
    {TR_BUILDING_GRAND_GARDEN, "Jardín magno" },
    {TR_BUILDING_TAVERN_DESC_1, "Esta taberna no tiene trabajadores; no puede abrir al público." },
    {TR_BUILDING_TAVERN_DESC_2, "Esta taberna no tiene vino; no puede abrir al público." },
    {TR_BUILDING_TAVERN_DESC_3, "Esta taberna proveerá entretenimiento mientras el vino siga fluyendo. El suministro de carne aumentaría su atractivo." },
    {TR_BUILDING_TAVERN_DESC_4, "El abundante vino y el olor a carne asada atraen a una animada multitud a esta taberna buscando juego, música y juerga." },
    {TR_FIGURE_TYPE_BARKEEP, "Cantinera" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Proveedora de la taberna" },
    {TR_OVERLAY_TAVERN, "Taberna" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Esta casa no tiene acceso a una taberna o a su taberna se le ha acabado el vino." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Esta casa no ha sido visitada por un cantinero desde hace mucho tiempo. Pronto perderá el acceso a la taberna. " },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Esta casa tiene acceso a una taberna con vino." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Esta casa tiene acceso a una taberna con vino y carne." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Esta casa ha sido visitada recientemente por un cantinero de una taberna con vino." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Esta casa ha sido visitada recientemente por un cantinero de una taberna con vino y carne. ¡Qué comience el jolgorio!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Los residentes detestan tu mera existencia."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Los residentes están muy enfadados contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Los residentes están enfadados contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Los residentes están muy disgustados contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Los residentes están disgustados contigoo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Los residentes están molestos contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Le eres indiferente a los residentes." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Los residentes están satisfechos contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Los residentes están muy satisfechos contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Los residentes te aprecian." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Los residentes te quieren." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Los residentes te idolatran, como a un dios." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Los residentes están molestos por los altos impuestos." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Los residentes están molestos por los bajos salarios." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Los residentes están molestos por la falta de empleo." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Los residentes están molestos por su pobre nivel de vida." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Los residentes apreciarían más entretenimiento." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Los residentes apreciarían una dieta más variada." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Los residentes apreciarían un vecindario más atractivo." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Los residentes están alegres por un evento reciente." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Los residentes están desanimados por un evento reciente." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tabernas" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Juegos" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Puedes patrocinar Grandes Juegos en tu Coliseo, pagando parte de tus ahorros y recursos de tu ciudad." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Celebrar juegos" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Los preparativos para los Grandes Juegos están en curso." },
    {TR_SELECT_GAMES_HEADER, "Juegos" },
    {TR_SELECT_GAMES_TEXT, "Se celebrarán juegos en el Coliseo, a expensas de tus ahorros y de los recursos de tu ciudad." },
    {TR_BUILDING_ARENA, "Arena" },
    {TR_BUILDING_HORSE_STATUE, "Estatua ecuestre" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Fuente de delfines" },
    {TR_BUILDING_HEDGE_DARK, "Seto verde" },
    {TR_BUILDING_HEDGE_LIGHT, "Seto brillante" },
    {TR_BUILDING_GARDEN_WALL, "Jardín mural" },
    {TR_BUILDING_LEGION_STATUE, "Estatua de legionario" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Columna de mármol" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hipogeo)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Cimientos)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcada)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galería)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Los trabajadores están excavando el hipogeo subterráneo: túneles y maquinaria de los que surgirán grandes espectáculos." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Los muros del Coliseo toman forma a medida que se colocan las gradas para plebeyos y emperadores." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Elegantes arcos se elevan hacia el cielo para sostener  en lo alto al imponente Coliseo." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "El Coliseo se extiende hacia el cielo, sus muros revestidos de estatuas y brillante mármol." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Pista)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Cimientos)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Gradas)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fachada)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Este enorme emplazamiento está siendo minuciosamente estudiado y despejado para un proyecto de escala sin precedentes." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Accesos y estructuras de apoyo están siendo construidas alrededor de la pista." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Los albañiles tallan decenas de miles de asientos de piedra." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Más que una simple pista, los artesanos elaboran un monumento digno de los dioses y del pueblo de Roma." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "La construcción de este monumento requiere material de un almacén, trabajadores de un campo de trabajo y arquitectos de un gremio de arquitectos." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Construcción en pausa." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenas" },
    {TR_BUILDING_INFO_TOURISM, "(viajeros)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "¡El Coliseo está terminado! ¡Que comiencen los juegos!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "El Hipódromo está terminado. Tus ciudadanos esperan ansiosos tu orden para que comiencen las carreras." },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Juegos inaugurales" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Las carreras comienzan" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Los juegos inaugurales de tu Coliseo han comenzado. A tu orden, este monumento será consagrado con la sangre de los valientes." },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Tu ciudad se vacía cuando multitudes acuden al Hipódromo para las carreras de carros inaugurales. El aire se llena de una ensordecedora ovación cuando se abren las puertas." },
    {TR_WINDOW_GAMES_OPTION_1, "Celebrar Juegos Navales" },
    {TR_WINDOW_GAMES_OPTION_2, "Celebrar Juegos Animales" },
    {TR_WINDOW_GAMES_OPTION_3, "Celebrar las Calendas de Enero" },
    {TR_WINDOW_GAMES_OPTION_4, "Celebrar Juegos Olímpicos" },
    {TR_WINDOW_GAMES_OPTION_5, "Celebrar Juegos Romanos" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "El Coliseo se inundará para recrear una gran batalla naval. La velocidad de movimiento de tus tropas y su fuerza en las batallas lejanas aumentará durante el próximo año." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "El Coliseo acogerá sangrientas cacerías de animales y ejecuciones a cargo de bestias salvajes, deleitando a la masa plebeya. El crimen, los disturbios y las revueltas serán reprimidos durante el siguiente año. Los gladiadores ayudarán a defender la ciudad de la próxima invasión." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "El Coliseo celebrará juegos en honor a los dioses el primer día del próximo año, implorando fortuna y prosperidad. Las cuotas comerciales se duplicarán el próximo año." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "El Hipódromo celebrará los Juegos Olímpicos. Tu ciudad acogerá a miles de visitantes, y si tus atletas honran bien a tu ciudad, ganarás un aumento permanente del turismo y del favor." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "El Coliseo celebrará los juegos romanos, con gente viajando a tu ciudad desde todo el imperio para competir. Un espectáculo tan grandioso te hará ganar el favor del emperador y del pueblo para el próximo año." },
    {TR_WINDOW_GAMES_COST, "Costo:" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(ahorros personales)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Insuficientes ahorros personales." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Insuficientes recursos almacenados." },
    {TR_WINDOW_GAMES_NO_VENUE, "El edificio no existe o no tiene trabajadores." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construcción)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Albañiles y arquitectos construyen esta sagrada estructura de reluciente mármol." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "La construcción de este templo requiere material de un almacén, trabajadores de un campo de trabajo y arquitectos de un gremio de arquitectos." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Agua de los depósitos de tu ciudad lentamente llena el Coliseo. Los carpinteros comienzan a ensamblar barcos de guerra en miniatura mientras los gladiadores se entrenan en combate acuático. ¡Pronto comenzarán los Juegos Navales!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "El Coliseo se ha convertido en un lago artificial, donde los gladiadores recrean grandes victorias marítimas Romanas. Sangre y agua se confunden mientras el público ruge su aprobación. ¡La Naumaquia ha comenzado! " },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Comienza un largo proceso de limpieza del Coliseo, que se drena y se prepara para su uso normal. Tu gente hablará de este gran espectáculo acuático durante años." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Extraños cargamentos aparecen en tu ciudad cuando mercaderes de lejanas tierras traen terroríficas bestias a las jaulas bajo el Coliseo. Pronto, un sangriento espectáculo deleitará a tu pueblo." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Criminales condenados y gladiadores buscando gloria se enfrentarán a la muerte en forma de dientes y garras. Con el ruido de las trompetas, ¡La Venatio comienza!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "La última de las bestias salvajes cae muerta sobre la arena del Coliseo, su sangre entremezclada con la de los condenados. Los Juegos Animales han llegado a su fin." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Celebraremos el año nuevo con unos gloriosos juegos en honor a los dioses. A cambio, pedimos fortuna, prosperidad y bendiciones en materia de comercio." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Los juegos comienzan al amanecer en las Calendas de Ianuirius. Los sacerdotes realizan sacrificios animales mientras los gladiadores atan sus brazos para morir buscando el favor divino."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Los augures indican que los dioses fueron complacidos por nuestros Grandes Juegos, y los sacrificios y reverencias que se les manifestaron. Podemos esperar un año muy provechoso."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Todas las miradas estarán puestas en tu ciudad cuando lleguen visitantes, competidores y dignatarios romanos de todo el mundo, atraídos por los Juegos olímpicos. Se necesitará al menos un año entero para completar todos los preparativos."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Por fin ha llegado el día. La llama sagrada es encendida, y las calles de tu ciudad quedan desiertas mientras los ciudadanos se agolpan en el gran Hipódromo. ¡Que comiencen los juegos!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "La llama sagrada se apaga, y los viajeros y ciudadanos regresan a sus hogares con cansada exultación. La gloria eterna es tuya por acoger con éxito esta antigua y sagrada celebración de la fuerza y el honor de los mortales." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Con el anuncio de los Juegos Romanos, gente de alejados rincones acuden a tu ciudad, muchos con la esperanza de ganar las próximas competiciones. Se necesitará al menos un año entero para completar todos los preparativos." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "La procesión solemne comienza, y con ella, los Juegos Romanos. Que el propio Júpiter seleccione a los campeones de las carreras, las luchas y otros concursos de resistencia y agilidad. El Coliseo se llena de ciudadanos a la espera de los juegos y de los habituales regalos de trigo y aceite de oliva. ¡Que comiencen los juegos!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "El último día de los Juegos Romanos llega a su fin. Rebosantes de emoción y con el estómago lleno, tus ciudadanos han saboreado la grandeza de la vida romana. ¡Gloria a los dioses, gloria a los victoriosos y gloria al gobernador!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Los Grandes Juegos"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Meses hasta que se puedan celebrar nuevos juegos: "},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Meses hasta los Juegos Navales:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Los Juegos Navales están en marcha. El chapoteo del agua, el crujido de los maderos y los gritos de guerra de los gladiadores se suman al rugido de la multitud." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Meses hasta los Juegos Animales:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Los Juegos Animales están en marcha. Hombro con hombro, la muchedumbre grita enronquecida mientras las fieras acechan su presa humana." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Meses hasta las Calendas:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Los Juegos de las Calendas están en marcha. El olor de los sacrificios animales y del incienso sobrepasan incluso al de la sangre y el sudor de la arena." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Meses hasta los Juegos Olímpicos:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Los Juegos Olímpicos están en marcha. El fuego sagrado arde día y noche mientras los atletas compiten por la gloria inmortal." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Meses hasta los Juegos Romanos:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Los Juegos Romanos están en marcha. Cada participante derrama sangre, sudor y lágrimas para demostrar que es el mejor romano." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Los Grandes Juegos continuarán por otros " }, // ...XX Days, 
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Los Grandes Juegos se celebraron recientemente." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "¡Los Grandes Juegos están en marcha! Su ciudad se llena de viajeros y juerga." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "La arena está cerrada. Los pájaros hacen nidos en los asientos vacíos." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Esta arena no alberga ni leones ni gladiadores, y ofrece poco entretenimiento." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Esta arena acoge a gladiadores y cacerías de animales, para deleite de los locales." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Los espectáculos habituales de gladiadores mantienen a la multitud entretenida, pero los leones exaltarían el espectáculo." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Bestias hambrientas merodean por la arena en busca de presas, pero la falta de gladiadores entrenados hace que los espectáculos sean breves." },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Esta casa no tiene acceso ni a una Arena ni al Coliseo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Esta casa tiene acceso a una Arena con un evento." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Esta casa tiene acceso a una Arena con dos evento." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Esta casa tiene acceso al Coliseo, con un evento." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Esta casa tiene acceso al Coliseo, con dos eventos." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Trabajadores en huelga" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Sin acceso al agua" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Esperando por los carreteros" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "No hay recursos disponibles" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Edificio inactivo" },
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Muchos edificios de este tipo. Los viajeros evitan este lugar." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Ingreso por viajeros este año:" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Tu Asesor comercial ordenó detener la producción de pescado."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tributos/intereses"},
    {TR_WINDOW_ADVISOR_TOURISM, "Misceláneos"},
    {TR_WINDOW_FIGURE_TOURIST, "Este viajero ha gastado: "},
    {TR_FIGURE_TYPE_TOURIST,  "Viajero"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Versión de guardado incompatible" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "La partida guardada que estás intentando cargar es para una versión más reciente de Augustus.\nActualiza Augustus a la versión más reciente." },
    {TR_BUILDING_COLONNADE, "Columnata" },
    {TR_BUILDING_LARARIUM, "Lararium" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Este pequeño santuario está dedicado a los espíritus ancestrales del pueblo romano. Aquí se pueden hacer pequeños sacrificios y oraciones."},
    {TR_BUILDING_WATCHTOWER, "Atalaya"},
    {TR_BUILDING_WATCHTOWER_DESC, "Arqueros en la crestería de esta torre montan guardia, mientras los vigilantes patrullan las calles." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Esta torre necesita un centinela de los barracones para defender la ciudad."},
    {TR_BUILDING_NYMPHAEUM, "Ninfeo"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Este gran templo está dedicado a las ninfas del agua, deidades menores de la primavera, el río y el mar. Promete belleza y abundancia a la tierra circundante y favor divino a la ciudad." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Mausoleo pequeño"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Este edificio es el lugar de descanso final de generaciones pasadas de orgullosas familias de tu ciudad, y la envidia de muchos entre los vivos." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Mausoleo grande"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Las paredes de mármol pulido y las estatuas de esta magnífica estructura reflejan las grandes hazañas de los patricios que se ganaron el privilegio de descansar aquí." },
    {TR_FIGURE_TYPE_WATCHMAN, "Vigilante" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Este templo recolectará comida para tu puesto de suministro, una vez lo construyas."},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Configurar acceso de prefectos e ingenieros" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Configurar acceso de sacerdotes" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Configurar acceso de mercaderes" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Configurar acceso de caminantes de entrenimiento" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Configurar acceso de caminantes de educacion" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Configurar acceso de caminantes de salud" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Configurar acceso de recaudadores" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Configurar acceso de ciudadanos" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Configurar acceso de misioneros" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Configurar acceso de vigilantes" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Atajo actualmente en uso"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Esta combinación de teclas está actualmente en uso por la siguiente acción:"},
    {TR_BUILDING_GARDEN_PATH, "Sendero de jardín" },
    {TR_BUTTON_GO_TO_SITE, "Ir al sitio" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Pausar construcción" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Retomar construcción" },
    {TR_RESOURCE_FISH, "Pescado" },
    {TR_WARNING_VARIANT_TOGGLE, "Presiona el botón de rotación para ver otras variantes"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Este colegio está en funcionamiento. El desarrollo local permitió a tus ciudadanos ampliar el edificio, proporcionando espacio para más niños."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Este teatro está en funcionamiento. El desarrollo local permitió a tus ciudadanos ampliar el edificio, dotándolo de más asientos." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Esta biblioteca está en funcionamiento. El desarrollo local permitió a tus ciudadanos ampliar el edificio, proporcionando pergaminos y espacios de lectura adicionales." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Este monumento no tiene acceso por carretera y no puede recibir materiales. Conecta una carretera a una de las baldosas centrales."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Debido al bajo humor de la ciudad, los plebeyos de este taller han declarado la secesión y se niegan a trabajar." },
    {TR_CITY_WARNING_SECESSION, "¡Los plebeyos se niegan a trabajar!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "¡Un almacén fue saqueado!" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "¡Un granero fue saqueado!" },
    {TR_CITY_WARNING_THEFT, "¡Los fondos de un foro o senado fueron robados!" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "¡Saqueos en la ciudad!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Un almacén o granero fueron saqueados por ciudadanos enfadados, robando sus mercancías. El bajo humor hace que estos incidentes sean más probables."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasiones" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasión en curso" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "No hay invasiones" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasión inminente" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Enemigo en camino" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Enemigo distantes" },
    {TR_SIDEBAR_EXTRA_GODS, "Dioses" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Ver todas" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Fuerza pequeña"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Fuerza mediana"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Fuerza grande"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Despachar"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Reservar"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "No reservar"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Ir a los gráficos de población" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Visitar al asesor de vivienda" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Este monumento dispone de todos los materiales necesarios para esta fase. Los trabajadores esperan que un hábil arquitecto del gremio de arquitectos supervise la construcción." },
    {TR_RETURN_ALL_TO_FORT, "Volver todos" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Información de los juegos" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Esta estatua se vería aún más espléndida con su fuente funcionando. Proporciónale acceso al agua." },
    {TR_OPTION_MENU_APPLY, "Aplicar" },
    {TR_OPTION_MENU_COST, "Esto costará" },
    {TR_FIGURE_TYPE_LOOTER, "Saqueador" },
    {TR_FIGURE_TYPE_ROBBER, "Ladrón" },
    {TR_OVERLAY_SENTIMENT, "Humor" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nadie" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Todos" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Selecciona una política de comercio terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Se requiere un Caravasar para definir una política de comercio terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Selecciona una política de comercio marítima"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Se requiere un Faro para definir una política de comercio marítima"},
    {TR_TOOLTIP_HOLD_GAME, "Celebrar los juegos"},
    {TR_TOOLTIP_NO_GAME, "No celebrar los juegos"},
    {TR_WARNING_NEARBY_WOLF, "No se puede construir tan cerca de lobos" },
    {TR_MARKET_TRADING, "Comerciando"},
    {TR_MARKET_NOT_TRADING, "No comerciando"},
    {TR_TEMPLE_DISTRIBUTING, "Distribuyendo"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "No distribuyendo"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Viviendas miserables y barrios marginales impiden la inmigración"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Farero"},
	{TR_WINDOW_GAMES_NO_WATER_ACCESS, "El Coliseo no tiene acceso a una red de agua proveniente de un depósito." },
    {TR_CITY_MESSAGE_SQUALOR, "Las viviendas miserables y los barrios marginales son un problema" },
    {TR_HOTKEY_COPY_SETTINGS, "Copiar la configuración del edificio" },
    {TR_HOTKEY_PASTE_SETTINGS, "Pegar la configuración del edificio" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lalarios en la ciudad" },
    {TR_WINDOW_RACE_BET_BUTTON, "Apostar por un caballo" },
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Carrera en progreso..." },
    {TR_WINDOW_RACE_BET_TITLE, "Hacer una apuesta por un caballo" },
    {TR_WINDOW_RACE_BET_AMOUNT, "Monto" },
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Apueste una cantidad de sus fondos personales en el equipo de carro de su elección y duplique su apuesta si su caballo gana. ¡Tus ganancias incluso se cuadriplicarán durante los Juegos del Coliseo!" },
    {TR_WARNING_BET_VICTORY, "Tu caballo ganó la carrera en el Hipódromo de tu ciudad" },
    {TR_WARNING_BET_DEFEAT, "Tu caballo perdió la carrera en el Hipódromo de tu ciudad" },
    {TR_PERSONAL_SAVINGS, "Ahorros :" },
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Apostar en el caballo azul" },
    {TR_WINDOW_RACE_BET_RED_HORSE, "Apostar en el caballo rojo" },
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Apostar en el caballo blanco" },
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Apostar en el caballo verde" },
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Sin un equipo completo de sacerdotes y asistentes, este templo no puede realizar todos los ritos y celebraciones sagrados. Hasta que eso cambie, no esperes el favor de los dioses." },
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "El Coliseo no tiene suficiente personal. Se necesitan más trabajadores para garantizar que todos sus ciudadanos disfruten de los juegos." },
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "El Hipódromo no tiene suficiente personal. Se necesitan más trabajadores para brindar un entretenimiento espectacular a todos sus ciudadanos." },
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "El faro no tiene suficiente personal y no puede mantener el fuego encendido. Los barcos luchan por encontrar el camino a los muelles de tu ciudad." },
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "El Caravasar no tiene suficiente personal y no puede mantener el apoyo a todas las caravanas mercantes que llegan a tu ciudad." },
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Muro de jardín techado" },
    {TR_BUILDING_GARDEN_WALL_GATE, "Puerta del jardín" },
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Esta pequeña puerta controla el movimiento de personas que entran y salen de los lugares más apartados de tu ciudad." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "El carretero está en camino a recoger las mercancías de otro almacén." },
    {TR_BUILDING_PALISADE, "Empalizada" },
    {TR_BUILDING_PALISADE_DESC, "Este banco de tierra, coronado por un alto muro de estacas de madera afiladas, mantendrá tu ciudad a salvo de invasores y animales hostiles." },
    {TR_OVERLAY_MOTHBALL, "Paralizada" },
    {TR_OVERLAY_ENEMY, "Enemigos" },
    {TR_BUILDING_TAVERN_DESC_5, "A tus ciudadanos les encanta visitar este establecimiento en su tiempo libre para socializar con buena comida y vino." },
    {TR_OVERLAY_WAREHOUSES, "Almacenes" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "El equipo azul, favorito de Neptuno. Estos son los más prometedores de los jóvenes aurigas de Roma que desean demostrar su valía." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "El equipo rojo, conocido como el equipo del auriga más exitoso en la historia de Roma, un ex remero y salvador de un cónsul romano." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "El equipo blanco, fundado por ex gladiadores. Llevan el combate en la sangre e incluso como hombres libres viven para el desafío." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "El equipo verde: descendientes de los jinetes 'Céleres' de la época del Reino de Roma. Todavía dicen ser los mejores de los mejores." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Reanudar la entrega de recursos" },
    {TR_CONFIG_VIDEO_SOUND, "Habilitar sonido de video" },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Esta torre necesita un centinela del cuartel antes de que pueda proteger nuestra ciudad." },
    {TR_CONFIG_INFINITE, "Infinito" },
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Número máximo de grandes templos por ciudad:" },
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Rotar al edificio anterior" },
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Detener recurso a talleres o graneros" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Habilitar el almacenamiento en un almacén" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Detener reserva" },
    {TR_CONFIG_DIGIT_SEPARATOR, "Separate digits"},
};

void translation_spanish(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
