package com.tipcj;

public interface TipcConfig {
	public static final int TIPC_WAIT_FOREVER   = ~0; /* timeout for permanent subscription */

	/**
	 * Application-accessible service types
	 */
	public static final int TIPC_NODE_STATE     = 0; /* node state service type */
	public static final int TIPC_TOP_SRV        = 1; /* topology server service type */
	public static final int TIPC_LINK_STATE     = 2; /* link state service type */
	public static final int TIPC_RESERVED_TYPES = 64; /* lowest user-allowed service type */

	/**
	 * Publication scopes when binding service / service range
	 */
	public static final int TIPC_CLUSTER_SCOPE   = 2; /* 0 can also be used */
	public static final int TIPC_NODE_SCOPE      = 3;

	/**
	 * Limiting values for messages
	 */
	public static final int TIPC_MAX_USER_MSG_SIZE = 66000;

	/**
	 * Message importance levels
	 */
	public static final int TIPC_LOW_IMPORTANCE       = 0;
	public static final int TIPC_MEDIUM_IMPORTANCE    = 1;
	public static final int TIPC_HIGH_IMPORTANCE      = 2;
	public static final int TIPC_CRITICAL_IMPORTANCE  = 3;

	/**
	 * Msg rejection/connection shutdown reasons
	 */
	public static final int TIPC_OK             =  0;
	public static final int TIPC_ERR_NO_NAME    =  1;
	public static final int TIPC_ERR_NO_PORT    =  2;
	public static final int TIPC_ERR_NO_NODE    =  3;
	public static final int TIPC_ERR_OVERLOAD   =  4;
	public static final int TIPC_CONN_SHUTDOWN  =  5;

	/**
	 * TIPC topology subscription service definitions
	 */
	public static final int TIPC_SUB_PORTS      = 0x01;    /* filter: evt at each match */
	public static final int TIPC_SUB_SERVICE    = 0x02;    /* filter: evt at first up/last down */
	public static final int TIPC_SUB_CANCEL     = 0x04;    /* filter: cancel a subscription */
}
