/* pwl.c generated by valac 0.56.18, the Vala compiler
 * generated from pwl.vala, do not modify */

/* libenchant: Personal word lists
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2025 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <stdio.h>
#include <sys/file.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <time.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include <gobject/gvaluecollector.h>

#define BOM ((gunichar) 0xfeff)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantPWLPrivate EnchantPWLPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecEnchantPWL ParamSpecEnchantPWL;

#define TYPE_ENCHANT_PROVIDER_DICT (enchant_provider_dict_get_type ())
#define ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDict))
#define ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))
#define IS_ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER_DICT))
#define IS_ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER_DICT))
#define ENCHANT_PROVIDER_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))

typedef struct _EnchantProviderDict EnchantProviderDict;
typedef struct _EnchantProviderDictClass EnchantProviderDictClass;
typedef struct _EnchantProviderDictPrivate EnchantProviderDictPrivate;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef gint (*DictCheck) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantProviderDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantProviderDict* me);
typedef gint (*DictIsWordCharacter) (EnchantProviderDict* me, guint32 uc_in, size_t n);

#define TYPE_ENCHANT_PWL_DICT (enchant_pwl_dict_get_type ())
#define ENCHANT_PWL_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL_DICT, EnchantPwlDict))
#define ENCHANT_PWL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL_DICT, EnchantPwlDictClass))
#define IS_ENCHANT_PWL_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL_DICT))
#define IS_ENCHANT_PWL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL_DICT))
#define ENCHANT_PWL_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL_DICT, EnchantPwlDictClass))

typedef struct _EnchantPwlDict EnchantPwlDict;
typedef struct _EnchantPwlDictClass EnchantPwlDictClass;
typedef struct _EnchantPwlDictPrivate EnchantPwlDictPrivate;

struct _EnchantPWL {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantPWLPrivate * priv;
	gchar* filename;
	time_t file_changed;
	GHashTable* words;
};

struct _EnchantPWLClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantPWL *self);
};

struct _ParamSpecEnchantPWL {
	GParamSpec parent_instance;
};

struct _EnchantProviderDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderDictPrivate * priv;
	void* user_data;
	EnchantProvider* provider;
	gchar* language_tag;
	gchar* error;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantProviderDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProviderDict *self);
};

struct _EnchantPwlDict {
	EnchantProviderDict parent_instance;
	EnchantPwlDictPrivate * priv;
};

struct _EnchantPwlDictClass {
	EnchantProviderDictClass parent_class;
};

static gpointer enchant_pwl_parent_class = NULL;
static gpointer enchant_pwl_dict_parent_class = NULL;

VALA_EXTERN void lock_file (FILE* f);
VALA_EXTERN void unlock_file (FILE* f);
VALA_EXTERN gchar* utf8_strtitle (const gchar* str);
VALA_EXTERN gboolean is_all_caps (const gchar* word);
VALA_EXTERN gboolean is_title_case (const gchar* word);
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
static void _g_free0_ (gpointer var);
VALA_EXTERN EnchantPWL* enchant_pwl_new (const gchar* filename);
VALA_EXTERN EnchantPWL* enchant_pwl_construct (GType object_type,
                                   const gchar* filename);
static void enchant_pwl_refresh_from_file (EnchantPWL* self);
static void enchant_pwl_add_to_table (EnchantPWL* self,
                               const gchar* word);
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gint enchant_pwl_check (EnchantPWL* self,
                        const gchar* word_buf,
                        ssize_t len);
static void enchant_pwl_finalize (EnchantPWL * obj);
static GType enchant_pwl_get_type_once (void);
VALA_EXTERN gpointer enchant_provider_dict_ref (gpointer instance);
VALA_EXTERN void enchant_provider_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider_dict (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider_dict (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_enchant_provider_dict (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider_dict (const GValue* value);
VALA_EXTERN GType enchant_provider_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProviderDict, enchant_provider_dict_unref)
VALA_EXTERN gint check_impl (EnchantProviderDict* me,
                 const gchar* word,
                 size_t len);
VALA_EXTERN gchar** suggest_impl (EnchantProviderDict* me,
                      const gchar* word,
                      size_t len,
                      size_t* result_length1);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN GType enchant_pwl_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPwlDict, enchant_provider_dict_unref)
VALA_EXTERN EnchantPwlDict* enchant_pwl_dict_new (void);
VALA_EXTERN EnchantPwlDict* enchant_pwl_dict_construct (GType object_type);
VALA_EXTERN EnchantProviderDict* enchant_provider_dict_new (EnchantProvider* provider,
                                                const gchar* tag);
VALA_EXTERN EnchantProviderDict* enchant_provider_dict_construct (GType object_type,
                                                      EnchantProvider* provider,
                                                      const gchar* tag);
static gint _check_impl_dict_check (EnchantProviderDict* me,
                             const gchar* word,
                             size_t len);
static gchar** _suggest_impl_dict_suggest (EnchantProviderDict* me,
                                    const gchar* word,
                                    size_t len,
                                    size_t* result_length1);
static GType enchant_pwl_dict_get_type_once (void);

void
lock_file (FILE* f)
{
#line 43 "pwl.vala"
	g_return_if_fail (f != NULL);
#line 44 "pwl.vala"
	flock (fileno (f), LOCK_EX);
#line 270 "pwl.c"
}

void
unlock_file (FILE* f)
{
#line 47 "pwl.vala"
	g_return_if_fail (f != NULL);
#line 48 "pwl.vala"
	flock (fileno (f), LOCK_UN);
#line 280 "pwl.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 294 "pwl.c"
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1122 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1122 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1123 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, str);
#line 1124 "glib-2.0.vapi"
	result = str;
#line 1124 "glib-2.0.vapi"
	return result;
#line 313 "pwl.c"
}

gchar*
utf8_strtitle (const gchar* str)
{
	gchar* upper_str = NULL;
	gchar* _tmp0_;
	gchar* lower_tail = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gunichar title_case_char = 0U;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
#line 51 "pwl.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 52 "pwl.vala"
	_tmp0_ = g_utf8_strup (str, (gssize) -1);
#line 52 "pwl.vala"
	upper_str = _tmp0_;
#line 53 "pwl.vala"
	_tmp1_ = g_utf8_next_char (upper_str);
#line 53 "pwl.vala"
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
#line 53 "pwl.vala"
	lower_tail = _tmp2_;
#line 54 "pwl.vala"
	title_case_char = g_unichar_totitle (string_get_char (upper_str, (glong) 0));
#line 55 "pwl.vala"
	_tmp3_ = g_unichar_to_string (title_case_char);
#line 55 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 55 "pwl.vala"
	_tmp5_ = g_strdup_printf ("%s%s", _tmp4_, lower_tail);
#line 55 "pwl.vala"
	_tmp6_ = _tmp5_;
#line 55 "pwl.vala"
	_g_free0 (_tmp4_);
#line 55 "pwl.vala"
	result = _tmp6_;
#line 55 "pwl.vala"
	_g_free0 (lower_tail);
#line 55 "pwl.vala"
	_g_free0 (upper_str);
#line 55 "pwl.vala"
	return result;
#line 362 "pwl.c"
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
#line 1302 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1303 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1304 "glib-2.0.vapi"
	if (_vala_c != ((gunichar) 0)) {
#line 378 "pwl.c"
		gchar* _tmp0_;
#line 1305 "glib-2.0.vapi"
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1305 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1306 "glib-2.0.vapi"
		result = TRUE;
#line 1306 "glib-2.0.vapi"
		if (c) {
#line 1306 "glib-2.0.vapi"
			*c = _vala_c;
#line 390 "pwl.c"
		}
#line 1306 "glib-2.0.vapi"
		return result;
#line 394 "pwl.c"
	} else {
#line 1308 "glib-2.0.vapi"
		result = FALSE;
#line 1308 "glib-2.0.vapi"
		if (c) {
#line 1308 "glib-2.0.vapi"
			*c = _vala_c;
#line 402 "pwl.c"
		}
#line 1308 "glib-2.0.vapi"
		return result;
#line 406 "pwl.c"
	}
}

gboolean
is_all_caps (const gchar* word)
{
	gboolean has_cap = FALSE;
	gunichar c = 0U;
	gboolean result;
#line 58 "pwl.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 59 "pwl.vala"
	has_cap = FALSE;
#line 420 "pwl.c"
	{
		gint i = 0;
#line 61 "pwl.vala"
		i = 0;
#line 425 "pwl.c"
		{
			gboolean _tmp0_ = FALSE;
#line 61 "pwl.vala"
			_tmp0_ = TRUE;
#line 61 "pwl.vala"
			while (TRUE) {
#line 432 "pwl.c"
				gunichar _tmp1_ = 0U;
				gboolean _tmp2_;
				GUnicodeType type = 0;
#line 61 "pwl.vala"
				if (!_tmp0_) {
#line 438 "pwl.c"
				}
#line 61 "pwl.vala"
				_tmp0_ = FALSE;
#line 61 "pwl.vala"
				_tmp2_ = string_get_next_char (word, &i, &_tmp1_);
#line 61 "pwl.vala"
				c = _tmp1_;
#line 61 "pwl.vala"
				if (!_tmp2_) {
#line 61 "pwl.vala"
					break;
#line 450 "pwl.c"
				}
#line 62 "pwl.vala"
				type = g_unichar_type (c);
#line 63 "pwl.vala"
				switch (type) {
#line 63 "pwl.vala"
					case G_UNICODE_UPPERCASE_LETTER:
#line 458 "pwl.c"
					{
#line 65 "pwl.vala"
						has_cap = TRUE;
#line 66 "pwl.vala"
						break;
#line 464 "pwl.c"
					}
#line 63 "pwl.vala"
					case G_UNICODE_TITLECASE_LETTER:
#line 63 "pwl.vala"
					case G_UNICODE_LOWERCASE_LETTER:
#line 470 "pwl.c"
					{
#line 69 "pwl.vala"
						result = FALSE;
#line 69 "pwl.vala"
						return result;
#line 476 "pwl.c"
					}
					default:
#line 63 "pwl.vala"
					case G_UNICODE_CONTROL:
#line 63 "pwl.vala"
					case G_UNICODE_FORMAT:
#line 63 "pwl.vala"
					case G_UNICODE_UNASSIGNED:
#line 63 "pwl.vala"
					case G_UNICODE_PRIVATE_USE:
#line 63 "pwl.vala"
					case G_UNICODE_SURROGATE:
#line 63 "pwl.vala"
					case G_UNICODE_MODIFIER_LETTER:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_LETTER:
#line 63 "pwl.vala"
					case G_UNICODE_SPACING_MARK:
#line 63 "pwl.vala"
					case G_UNICODE_ENCLOSING_MARK:
#line 63 "pwl.vala"
					case G_UNICODE_NON_SPACING_MARK:
#line 63 "pwl.vala"
					case G_UNICODE_DECIMAL_NUMBER:
#line 63 "pwl.vala"
					case G_UNICODE_LETTER_NUMBER:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_NUMBER:
#line 63 "pwl.vala"
					case G_UNICODE_CONNECT_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_DASH_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_CLOSE_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_FINAL_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_INITIAL_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_OPEN_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_CURRENCY_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_MODIFIER_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_MATH_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_LINE_SEPARATOR:
#line 63 "pwl.vala"
					case G_UNICODE_PARAGRAPH_SEPARATOR:
#line 63 "pwl.vala"
					case G_UNICODE_SPACE_SEPARATOR:
#line 533 "pwl.c"
					{
#line 99 "pwl.vala"
						break;
#line 537 "pwl.c"
					}
				}
			}
		}
	}
#line 103 "pwl.vala"
	result = has_cap;
#line 103 "pwl.vala"
	return result;
#line 547 "pwl.c"
}

gboolean
is_title_case (const gchar* word)
{
	gint i = 0;
	gunichar c = 0U;
	gunichar _tmp0_ = 0U;
	GUnicodeType type = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
#line 106 "pwl.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 107 "pwl.vala"
	i = 0;
#line 109 "pwl.vala"
	string_get_next_char (word, &i, &_tmp0_);
#line 109 "pwl.vala"
	c = _tmp0_;
#line 110 "pwl.vala"
	type = g_unichar_type (c);
#line 111 "pwl.vala"
	if (type != G_UNICODE_UPPERCASE_LETTER) {
#line 111 "pwl.vala"
		_tmp2_ = type != G_UNICODE_TITLECASE_LETTER;
#line 574 "pwl.c"
	} else {
#line 111 "pwl.vala"
		_tmp2_ = FALSE;
#line 578 "pwl.c"
	}
#line 111 "pwl.vala"
	if (_tmp2_) {
#line 111 "pwl.vala"
		_tmp1_ = TRUE;
#line 584 "pwl.c"
	} else {
#line 112 "pwl.vala"
		_tmp1_ = c != g_unichar_totitle (c);
#line 588 "pwl.c"
	}
#line 111 "pwl.vala"
	if (_tmp1_) {
#line 113 "pwl.vala"
		result = FALSE;
#line 113 "pwl.vala"
		return result;
#line 596 "pwl.c"
	}
#line 115 "pwl.vala"
	while (TRUE) {
#line 600 "pwl.c"
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
#line 115 "pwl.vala"
		_tmp4_ = string_get_next_char (word, &i, &_tmp3_);
#line 115 "pwl.vala"
		c = _tmp3_;
#line 115 "pwl.vala"
		if (!_tmp4_) {
#line 115 "pwl.vala"
			break;
#line 612 "pwl.c"
		}
#line 116 "pwl.vala"
		type = g_unichar_type (c);
#line 117 "pwl.vala"
		if (type == G_UNICODE_UPPERCASE_LETTER) {
#line 117 "pwl.vala"
			_tmp5_ = TRUE;
#line 620 "pwl.c"
		} else {
#line 117 "pwl.vala"
			_tmp5_ = type == G_UNICODE_TITLECASE_LETTER;
#line 624 "pwl.c"
		}
#line 117 "pwl.vala"
		if (_tmp5_) {
#line 118 "pwl.vala"
			result = FALSE;
#line 118 "pwl.vala"
			return result;
#line 632 "pwl.c"
		}
	}
#line 121 "pwl.vala"
	result = TRUE;
#line 121 "pwl.vala"
	return result;
#line 639 "pwl.c"
}

static void
_g_free0_ (gpointer var)
{
#line 127 "pwl.vala"
	var = (g_free (var), NULL);
#line 647 "pwl.c"
}

EnchantPWL*
enchant_pwl_construct (GType object_type,
                       const gchar* filename)
{
	EnchantPWL* self = NULL;
	gchar* _tmp0_;
#line 129 "pwl.vala"
	self = (EnchantPWL*) g_type_create_instance (object_type);
#line 130 "pwl.vala"
	_tmp0_ = g_strdup (filename);
#line 130 "pwl.vala"
	_g_free0 (self->filename);
#line 130 "pwl.vala"
	self->filename = _tmp0_;
#line 131 "pwl.vala"
	if (filename != NULL) {
#line 132 "pwl.vala"
		enchant_pwl_refresh_from_file (self);
#line 668 "pwl.c"
	}
#line 129 "pwl.vala"
	return self;
#line 672 "pwl.c"
}

EnchantPWL*
enchant_pwl_new (const gchar* filename)
{
#line 129 "pwl.vala"
	return enchant_pwl_construct (TYPE_ENCHANT_PWL, filename);
#line 680 "pwl.c"
}

static void
enchant_pwl_add_to_table (EnchantPWL* self,
                          const gchar* word)
{
	gchar* normalized_word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
#line 135 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 135 "pwl.vala"
	g_return_if_fail (word != NULL);
#line 136 "pwl.vala"
	_tmp0_ = g_utf8_normalize (word, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 136 "pwl.vala"
	normalized_word = _tmp0_;
#line 137 "pwl.vala"
	_tmp1_ = self->words;
#line 137 "pwl.vala"
	_tmp2_ = normalized_word;
#line 137 "pwl.vala"
	if (!g_hash_table_contains (_tmp1_, _tmp2_)) {
#line 705 "pwl.c"
		GHashTable* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 138 "pwl.vala"
		_tmp3_ = self->words;
#line 138 "pwl.vala"
		_tmp4_ = normalized_word;
#line 138 "pwl.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 138 "pwl.vala"
		_tmp6_ = g_strdup (word);
#line 138 "pwl.vala"
		g_hash_table_insert (_tmp3_, _tmp5_, _tmp6_);
#line 720 "pwl.c"
	}
#line 135 "pwl.vala"
	_g_free0 (normalized_word);
#line 724 "pwl.c"
}

void
enchant_pwl_add (EnchantPWL* self,
                 const gchar* word_buf,
                 ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 141 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 141 "pwl.vala"
	g_return_if_fail (word_buf != NULL);
#line 142 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 142 "pwl.vala"
	word = _tmp0_;
#line 144 "pwl.vala"
	enchant_pwl_refresh_from_file (self);
#line 145 "pwl.vala"
	_tmp1_ = word;
#line 145 "pwl.vala"
	enchant_pwl_add_to_table (self, _tmp1_);
#line 147 "pwl.vala"
	_tmp2_ = self->filename;
#line 147 "pwl.vala"
	if (_tmp2_ != NULL) {
#line 754 "pwl.c"
		FILE* f = NULL;
		const gchar* _tmp3_;
		FILE* _tmp4_;
		FILE* _tmp5_;
#line 148 "pwl.vala"
		_tmp3_ = self->filename;
#line 148 "pwl.vala"
		_tmp4_ = g_fopen (_tmp3_, "a+");
#line 148 "pwl.vala"
		f = _tmp4_;
#line 149 "pwl.vala"
		_tmp5_ = f;
#line 149 "pwl.vala"
		if (_tmp5_ != NULL) {
#line 769 "pwl.c"
			FILE* _tmp6_;
			struct stat stats = {0};
			const gchar* _tmp7_;
			struct stat _tmp8_ = {0};
			gint _tmp9_;
			FILE* _tmp11_;
			FILE* _tmp15_;
			const gchar* _tmp16_;
			FILE* _tmp18_;
#line 152 "pwl.vala"
			_tmp6_ = f;
#line 152 "pwl.vala"
			lock_file (_tmp6_);
#line 154 "pwl.vala"
			_tmp7_ = self->filename;
#line 154 "pwl.vala"
			_tmp9_ = stat (_tmp7_, &_tmp8_);
#line 154 "pwl.vala"
			stats = _tmp8_;
#line 154 "pwl.vala"
			if (_tmp9_ == 0) {
#line 791 "pwl.c"
				struct stat _tmp10_;
#line 155 "pwl.vala"
				_tmp10_ = stats;
#line 155 "pwl.vala"
				self->file_changed = _tmp10_.st_mtime;
#line 797 "pwl.c"
			}
#line 158 "pwl.vala"
			_tmp11_ = f;
#line 158 "pwl.vala"
			if (fseek (_tmp11_, (glong) -1, SEEK_END) == 0) {
#line 803 "pwl.c"
				gint c = 0;
				FILE* _tmp12_;
				FILE* _tmp13_;
#line 159 "pwl.vala"
				_tmp12_ = f;
#line 159 "pwl.vala"
				c = fgetc (_tmp12_);
#line 160 "pwl.vala"
				_tmp13_ = f;
#line 160 "pwl.vala"
				fseek (_tmp13_, (glong) 0, SEEK_CUR);
#line 161 "pwl.vala"
				if (c != ((gint) '\n')) {
#line 817 "pwl.c"
					FILE* _tmp14_;
#line 162 "pwl.vala"
					_tmp14_ = f;
#line 162 "pwl.vala"
					fputc ('\n', _tmp14_);
#line 823 "pwl.c"
				}
			}
#line 165 "pwl.vala"
			_tmp15_ = f;
#line 165 "pwl.vala"
			_tmp16_ = word;
#line 165 "pwl.vala"
			if (fputs (_tmp16_, _tmp15_) != EOF) {
#line 832 "pwl.c"
				FILE* _tmp17_;
#line 166 "pwl.vala"
				_tmp17_ = f;
#line 166 "pwl.vala"
				fputc ('\n', _tmp17_);
#line 838 "pwl.c"
			}
#line 167 "pwl.vala"
			_tmp18_ = f;
#line 167 "pwl.vala"
			unlock_file (_tmp18_);
#line 844 "pwl.c"
		}
#line 147 "pwl.vala"
		_fclose0 (f);
#line 848 "pwl.c"
	}
#line 141 "pwl.vala"
	_g_free0 (word);
#line 852 "pwl.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 876 "pwl.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 884 "pwl.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 890 "pwl.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1503 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1503 "glib-2.0.vapi"
	end = _tmp0_;
#line 1504 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1504 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1505 "glib-2.0.vapi"
		result = maxlen;
#line 1505 "glib-2.0.vapi"
		return result;
#line 914 "pwl.c"
	} else {
		gchar* _tmp2_;
#line 1507 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1507 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1507 "glib-2.0.vapi"
		return result;
#line 923 "pwl.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1514 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1516 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 942 "pwl.c"
	} else {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 946 "pwl.c"
	}
#line 1516 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1518 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 952 "pwl.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1520 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1520 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1520 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 962 "pwl.c"
	}
#line 1523 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1524 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 970 "pwl.c"
	} else {
#line 1527 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 974 "pwl.c"
	}
#line 1529 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1530 "glib-2.0.vapi"
		len = string_length - offset;
#line 980 "pwl.c"
	}
#line 1532 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1533 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1533 "glib-2.0.vapi"
	result = _tmp3_;
#line 1533 "glib-2.0.vapi"
	return result;
#line 990 "pwl.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 1007 "pwl.c"
}

void
enchant_pwl_remove (EnchantPWL* self,
                    const gchar* word_buf,
                    ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 172 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 172 "pwl.vala"
	g_return_if_fail (word_buf != NULL);
#line 174 "pwl.vala"
	if (enchant_pwl_check (self, word_buf, len) > 0) {
#line 175 "pwl.vala"
		return;
#line 1031 "pwl.c"
	}
#line 177 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 177 "pwl.vala"
	word = _tmp0_;
#line 178 "pwl.vala"
	_tmp1_ = self->words;
#line 178 "pwl.vala"
	_tmp2_ = word;
#line 178 "pwl.vala"
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 178 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 178 "pwl.vala"
	g_hash_table_remove (_tmp1_, _tmp4_);
#line 178 "pwl.vala"
	_g_free0 (_tmp4_);
#line 180 "pwl.vala"
	_tmp5_ = self->filename;
#line 180 "pwl.vala"
	if (_tmp5_ != NULL) {
#line 1053 "pwl.c"
		gchar* contents = NULL;
		gsize length = 0UL;
		FILE* f = NULL;
		const gchar* _tmp9_;
		FILE* _tmp10_;
		FILE* _tmp11_;
		{
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gsize _tmp8_ = 0UL;
#line 184 "pwl.vala"
			_tmp6_ = self->filename;
#line 184 "pwl.vala"
			g_file_get_contents (_tmp6_, &_tmp7_, &_tmp8_, &_inner_error0_);
#line 184 "pwl.vala"
			_g_free0 (contents);
#line 184 "pwl.vala"
			contents = _tmp7_;
#line 184 "pwl.vala"
			length = _tmp8_;
#line 184 "pwl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "pwl.vala"
				if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1078 "pwl.c"
					goto __catch0_g_file_error;
				}
#line 184 "pwl.vala"
				_g_free0 (contents);
#line 184 "pwl.vala"
				_g_free0 (word);
#line 184 "pwl.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 184 "pwl.vala"
				g_clear_error (&_inner_error0_);
#line 184 "pwl.vala"
				return;
#line 1091 "pwl.c"
			}
		}
		goto __finally0;
		__catch0_g_file_error:
		{
#line 183 "pwl.vala"
			g_clear_error (&_inner_error0_);
#line 186 "pwl.vala"
			_g_free0 (contents);
#line 186 "pwl.vala"
			_g_free0 (word);
#line 186 "pwl.vala"
			return;
#line 1105 "pwl.c"
		}
		__finally0:
#line 183 "pwl.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "pwl.vala"
			_g_free0 (contents);
#line 183 "pwl.vala"
			_g_free0 (word);
#line 183 "pwl.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 183 "pwl.vala"
			g_clear_error (&_inner_error0_);
#line 183 "pwl.vala"
			return;
#line 1120 "pwl.c"
		}
#line 189 "pwl.vala"
		_tmp9_ = self->filename;
#line 189 "pwl.vala"
		_tmp10_ = g_fopen (_tmp9_, "wb");
#line 189 "pwl.vala"
		f = _tmp10_;
#line 190 "pwl.vala"
		_tmp11_ = f;
#line 190 "pwl.vala"
		if (_tmp11_ != NULL) {
#line 1132 "pwl.c"
			FILE* _tmp12_;
			glong filestart = 0L;
			const gchar* _tmp13_;
			struct stat stats = {0};
			const gchar* _tmp60_;
			struct stat _tmp61_ = {0};
			gint _tmp62_;
			FILE* _tmp64_;
#line 191 "pwl.vala"
			_tmp12_ = f;
#line 191 "pwl.vala"
			lock_file (_tmp12_);
#line 192 "pwl.vala"
			filestart = (glong) 0;
#line 195 "pwl.vala"
			_tmp13_ = contents;
#line 195 "pwl.vala"
			if (BOM == string_get_char (_tmp13_, filestart)) {
#line 1151 "pwl.c"
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				FILE* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 196 "pwl.vala"
				_tmp14_ = contents;
#line 196 "pwl.vala"
				_tmp15_ = g_utf8_next_char (_tmp14_);
#line 196 "pwl.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 196 "pwl.vala"
				_g_free0 (contents);
#line 196 "pwl.vala"
				contents = _tmp16_;
#line 197 "pwl.vala"
				_tmp17_ = f;
#line 197 "pwl.vala"
				_tmp18_ = g_unichar_to_string (BOM);
#line 197 "pwl.vala"
				_tmp19_ = _tmp18_;
#line 197 "pwl.vala"
				fputs (_tmp19_, _tmp17_);
#line 197 "pwl.vala"
				_g_free0 (_tmp19_);
#line 1178 "pwl.c"
			}
			{
				gint start_index = 0;
#line 200 "pwl.vala"
				start_index = 0;
#line 1184 "pwl.c"
				{
					gboolean _tmp20_ = FALSE;
#line 200 "pwl.vala"
					_tmp20_ = TRUE;
#line 200 "pwl.vala"
					while (TRUE) {
#line 1191 "pwl.c"
						gint word_pos = 0;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
#line 200 "pwl.vala"
						if (!_tmp20_) {
#line 1197 "pwl.c"
						}
#line 200 "pwl.vala"
						_tmp20_ = FALSE;
#line 202 "pwl.vala"
						_tmp21_ = contents;
#line 202 "pwl.vala"
						_tmp22_ = word;
#line 202 "pwl.vala"
						word_pos = string_index_of (_tmp21_, _tmp22_, start_index);
#line 203 "pwl.vala"
						if (word_pos == -1) {
#line 1209 "pwl.c"
							FILE* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
#line 204 "pwl.vala"
							_tmp23_ = f;
#line 204 "pwl.vala"
							_tmp24_ = contents;
#line 204 "pwl.vala"
							_tmp25_ = string_substring (_tmp24_, (glong) start_index, (glong) -1);
#line 204 "pwl.vala"
							_tmp26_ = _tmp25_;
#line 204 "pwl.vala"
							fputs (_tmp26_, _tmp23_);
#line 204 "pwl.vala"
							_g_free0 (_tmp26_);
#line 205 "pwl.vala"
							break;
#line 1228 "pwl.c"
						} else {
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
#line 207 "pwl.vala"
							if (word_pos == 0) {
#line 207 "pwl.vala"
								_tmp29_ = TRUE;
#line 1237 "pwl.c"
							} else {
								const gchar* _tmp30_;
#line 207 "pwl.vala"
								_tmp30_ = contents;
#line 207 "pwl.vala"
								_tmp29_ = string_get (_tmp30_, (glong) (word_pos - 1)) == '\n';
#line 1244 "pwl.c"
							}
#line 207 "pwl.vala"
							if (_tmp29_) {
#line 207 "pwl.vala"
								_tmp28_ = TRUE;
#line 1250 "pwl.c"
							} else {
								const gchar* _tmp31_;
#line 207 "pwl.vala"
								_tmp31_ = contents;
#line 207 "pwl.vala"
								_tmp28_ = string_get (_tmp31_, (glong) (word_pos - 1)) == '\r';
#line 1257 "pwl.c"
							}
#line 207 "pwl.vala"
							if (_tmp28_) {
#line 1261 "pwl.c"
								gboolean _tmp32_ = FALSE;
								gboolean _tmp33_ = FALSE;
								const gchar* _tmp34_;
								gint _tmp35_;
								gint _tmp36_;
#line 208 "pwl.vala"
								_tmp34_ = contents;
#line 208 "pwl.vala"
								_tmp35_ = strlen (_tmp34_);
#line 208 "pwl.vala"
								_tmp36_ = _tmp35_;
#line 208 "pwl.vala"
								if (word_pos == _tmp36_) {
#line 208 "pwl.vala"
									_tmp33_ = TRUE;
#line 1277 "pwl.c"
								} else {
									const gchar* _tmp37_;
									const gchar* _tmp38_;
									gint _tmp39_;
									gint _tmp40_;
#line 208 "pwl.vala"
									_tmp37_ = contents;
#line 208 "pwl.vala"
									_tmp38_ = word;
#line 208 "pwl.vala"
									_tmp39_ = strlen (_tmp38_);
#line 208 "pwl.vala"
									_tmp40_ = _tmp39_;
#line 208 "pwl.vala"
									_tmp33_ = string_get (_tmp37_, (glong) (word_pos + _tmp40_)) == '\n';
#line 1293 "pwl.c"
								}
#line 208 "pwl.vala"
								if (_tmp33_) {
#line 208 "pwl.vala"
									_tmp32_ = TRUE;
#line 1299 "pwl.c"
								} else {
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									gint _tmp43_;
									gint _tmp44_;
#line 208 "pwl.vala"
									_tmp41_ = contents;
#line 208 "pwl.vala"
									_tmp42_ = word;
#line 208 "pwl.vala"
									_tmp43_ = strlen (_tmp42_);
#line 208 "pwl.vala"
									_tmp44_ = _tmp43_;
#line 208 "pwl.vala"
									_tmp32_ = string_get (_tmp41_, (glong) (word_pos + _tmp44_)) == '\r';
#line 1315 "pwl.c"
								}
#line 208 "pwl.vala"
								_tmp27_ = _tmp32_;
#line 1319 "pwl.c"
							} else {
#line 207 "pwl.vala"
								_tmp27_ = FALSE;
#line 1323 "pwl.c"
							}
#line 207 "pwl.vala"
							if (_tmp27_) {
#line 1327 "pwl.c"
								FILE* _tmp45_;
								const gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								const gchar* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
#line 209 "pwl.vala"
								_tmp45_ = f;
#line 209 "pwl.vala"
								_tmp46_ = contents;
#line 209 "pwl.vala"
								_tmp47_ = string_substring (_tmp46_, (glong) start_index, (glong) (word_pos - start_index));
#line 209 "pwl.vala"
								_tmp48_ = _tmp47_;
#line 209 "pwl.vala"
								fputs (_tmp48_, _tmp45_);
#line 209 "pwl.vala"
								_g_free0 (_tmp48_);
#line 210 "pwl.vala"
								_tmp49_ = word;
#line 210 "pwl.vala"
								_tmp50_ = strlen (_tmp49_);
#line 210 "pwl.vala"
								_tmp51_ = _tmp50_;
#line 210 "pwl.vala"
								start_index = word_pos + _tmp51_;
#line 211 "pwl.vala"
								while (TRUE) {
#line 1357 "pwl.c"
									gboolean _tmp52_ = FALSE;
									const gchar* _tmp53_;
									gint _tmp55_;
#line 211 "pwl.vala"
									_tmp53_ = contents;
#line 211 "pwl.vala"
									if (string_get (_tmp53_, (glong) start_index) == '\n') {
#line 211 "pwl.vala"
										_tmp52_ = TRUE;
#line 1367 "pwl.c"
									} else {
										const gchar* _tmp54_;
#line 211 "pwl.vala"
										_tmp54_ = contents;
#line 211 "pwl.vala"
										_tmp52_ = string_get (_tmp54_, (glong) start_index) == '\r';
#line 1374 "pwl.c"
									}
#line 211 "pwl.vala"
									if (!_tmp52_) {
#line 211 "pwl.vala"
										break;
#line 1380 "pwl.c"
									}
#line 212 "pwl.vala"
									start_index = start_index + 1;
#line 212 "pwl.vala"
									_tmp55_ = start_index;
#line 1386 "pwl.c"
								}
							} else {
								FILE* _tmp56_;
								const gchar* _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
#line 214 "pwl.vala"
								_tmp56_ = f;
#line 214 "pwl.vala"
								_tmp57_ = contents;
#line 214 "pwl.vala"
								_tmp58_ = string_substring (_tmp57_, (glong) start_index, (glong) ((word_pos - start_index) + 1));
#line 214 "pwl.vala"
								_tmp59_ = _tmp58_;
#line 214 "pwl.vala"
								fputs (_tmp59_, _tmp56_);
#line 214 "pwl.vala"
								_g_free0 (_tmp59_);
#line 215 "pwl.vala"
								start_index = word_pos + 1;
#line 1407 "pwl.c"
							}
						}
					}
				}
			}
#line 221 "pwl.vala"
			_tmp60_ = self->filename;
#line 221 "pwl.vala"
			_tmp62_ = stat (_tmp60_, &_tmp61_);
#line 221 "pwl.vala"
			stats = _tmp61_;
#line 221 "pwl.vala"
			if (_tmp62_ == 0) {
#line 1421 "pwl.c"
				struct stat _tmp63_;
#line 222 "pwl.vala"
				_tmp63_ = stats;
#line 222 "pwl.vala"
				self->file_changed = _tmp63_.st_mtime;
#line 1427 "pwl.c"
			}
#line 224 "pwl.vala"
			_tmp64_ = f;
#line 224 "pwl.vala"
			unlock_file (_tmp64_);
#line 1433 "pwl.c"
		}
#line 180 "pwl.vala"
		_fclose0 (f);
#line 180 "pwl.vala"
		_g_free0 (contents);
#line 1439 "pwl.c"
	}
#line 172 "pwl.vala"
	_g_free0 (word);
#line 1443 "pwl.c"
}

gint
enchant_pwl_check (EnchantPWL* self,
                   const gchar* word_buf,
                   ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean all_caps = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gint result;
#line 229 "pwl.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 229 "pwl.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 230 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 230 "pwl.vala"
	word = _tmp0_;
#line 231 "pwl.vala"
	enchant_pwl_refresh_from_file (self);
#line 233 "pwl.vala"
	_tmp1_ = self->words;
#line 233 "pwl.vala"
	_tmp2_ = word;
#line 233 "pwl.vala"
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 233 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 233 "pwl.vala"
	_tmp5_ = g_hash_table_contains (_tmp1_, _tmp4_);
#line 233 "pwl.vala"
	_g_free0 (_tmp4_);
#line 233 "pwl.vala"
	if (_tmp5_) {
#line 234 "pwl.vala"
		result = 0;
#line 234 "pwl.vala"
		_g_free0 (word);
#line 234 "pwl.vala"
		return result;
#line 1492 "pwl.c"
	}
#line 236 "pwl.vala"
	all_caps = FALSE;
#line 237 "pwl.vala"
	_tmp7_ = word;
#line 237 "pwl.vala"
	if (is_title_case (_tmp7_)) {
#line 237 "pwl.vala"
		_tmp6_ = TRUE;
#line 1502 "pwl.c"
	} else {
		const gchar* _tmp8_;
#line 237 "pwl.vala"
		_tmp8_ = word;
#line 237 "pwl.vala"
		all_caps = is_all_caps (_tmp8_);
#line 237 "pwl.vala"
		_tmp6_ = all_caps;
#line 1511 "pwl.c"
	}
#line 237 "pwl.vala"
	if (_tmp6_) {
#line 1515 "pwl.c"
		gchar* lower_case_word = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GHashTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
#line 238 "pwl.vala"
		_tmp9_ = word;
#line 238 "pwl.vala"
		_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
#line 238 "pwl.vala"
		lower_case_word = _tmp10_;
#line 239 "pwl.vala"
		_tmp11_ = self->words;
#line 239 "pwl.vala"
		_tmp12_ = lower_case_word;
#line 239 "pwl.vala"
		_tmp13_ = g_utf8_normalize (_tmp12_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 239 "pwl.vala"
		_tmp14_ = _tmp13_;
#line 239 "pwl.vala"
		_tmp15_ = g_hash_table_contains (_tmp11_, _tmp14_);
#line 239 "pwl.vala"
		_g_free0 (_tmp14_);
#line 239 "pwl.vala"
		if (_tmp15_) {
#line 240 "pwl.vala"
			result = 0;
#line 240 "pwl.vala"
			_g_free0 (lower_case_word);
#line 240 "pwl.vala"
			_g_free0 (word);
#line 240 "pwl.vala"
			return result;
#line 1552 "pwl.c"
		}
#line 242 "pwl.vala"
		if (all_caps) {
#line 1556 "pwl.c"
			gchar* title_case_word = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			GHashTable* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_;
#line 243 "pwl.vala"
			_tmp16_ = word;
#line 243 "pwl.vala"
			_tmp17_ = utf8_strtitle (_tmp16_);
#line 243 "pwl.vala"
			title_case_word = _tmp17_;
#line 244 "pwl.vala"
			_tmp18_ = self->words;
#line 244 "pwl.vala"
			_tmp19_ = title_case_word;
#line 244 "pwl.vala"
			_tmp20_ = g_utf8_normalize (_tmp19_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 244 "pwl.vala"
			_tmp21_ = _tmp20_;
#line 244 "pwl.vala"
			_tmp22_ = g_hash_table_contains (_tmp18_, _tmp21_);
#line 244 "pwl.vala"
			_g_free0 (_tmp21_);
#line 244 "pwl.vala"
			if (_tmp22_) {
#line 245 "pwl.vala"
				result = 0;
#line 245 "pwl.vala"
				_g_free0 (title_case_word);
#line 245 "pwl.vala"
				_g_free0 (lower_case_word);
#line 245 "pwl.vala"
				_g_free0 (word);
#line 245 "pwl.vala"
				return result;
#line 1595 "pwl.c"
			}
#line 242 "pwl.vala"
			_g_free0 (title_case_word);
#line 1599 "pwl.c"
		}
#line 237 "pwl.vala"
		_g_free0 (lower_case_word);
#line 1603 "pwl.c"
	}
#line 249 "pwl.vala"
	result = 1;
#line 249 "pwl.vala"
	_g_free0 (word);
#line 249 "pwl.vala"
	return result;
#line 1611 "pwl.c"
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
#line 4101 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 4103 "glib-2.0.vapi"
	ret = NULL;
#line 4104 "glib-2.0.vapi"
	while (TRUE) {
#line 1627 "pwl.c"
		GString* _tmp0_;
		GString* _tmp2_;
#line 4104 "glib-2.0.vapi"
		c = fgetc (self);
#line 4104 "glib-2.0.vapi"
		if (!(c != EOF)) {
#line 4104 "glib-2.0.vapi"
			break;
#line 1636 "pwl.c"
		}
#line 4105 "glib-2.0.vapi"
		_tmp0_ = ret;
#line 4105 "glib-2.0.vapi"
		if (_tmp0_ == NULL) {
#line 1642 "pwl.c"
			GString* _tmp1_;
#line 4106 "glib-2.0.vapi"
			_tmp1_ = g_string_new ("");
#line 4106 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 4106 "glib-2.0.vapi"
			ret = _tmp1_;
#line 1650 "pwl.c"
		}
#line 4108 "glib-2.0.vapi"
		if (c == ((gint) '\n')) {
#line 4109 "glib-2.0.vapi"
			break;
#line 1656 "pwl.c"
		}
#line 4111 "glib-2.0.vapi"
		_tmp2_ = ret;
#line 4111 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
#line 1662 "pwl.c"
	}
#line 4113 "glib-2.0.vapi"
	_tmp3_ = ret;
#line 4113 "glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4114 "glib-2.0.vapi"
		result = NULL;
#line 4114 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4114 "glib-2.0.vapi"
		return result;
#line 1674 "pwl.c"
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
#line 4116 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 4116 "glib-2.0.vapi"
		_tmp5_ = ((GString*) _tmp4_)->str;
#line 4116 "glib-2.0.vapi"
		((GString*) _tmp4_)->str = NULL;
#line 4116 "glib-2.0.vapi"
		result = _tmp5_;
#line 4116 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4116 "glib-2.0.vapi"
		return result;
#line 1690 "pwl.c"
	}
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1399 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1400 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1400 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1401 "glib-2.0.vapi"
	g_strchomp (_result_);
#line 1402 "glib-2.0.vapi"
	result = _result_;
#line 1402 "glib-2.0.vapi"
	return result;
#line 1712 "pwl.c"
}

static void
enchant_pwl_refresh_from_file (EnchantPWL* self)
{
	const gchar* _tmp0_;
	struct stat stats = {0};
	const gchar* _tmp1_;
	struct stat _tmp2_ = {0};
	gint _tmp3_;
	struct stat _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	FILE* f = NULL;
	const gchar* _tmp8_;
	FILE* _tmp9_;
	FILE* _tmp10_;
	struct stat _tmp11_;
	FILE* _tmp12_;
	gsize line_number = 0UL;
	gchar* line = NULL;
	FILE* _tmp31_;
#line 252 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 253 "pwl.vala"
	_tmp0_ = self->filename;
#line 253 "pwl.vala"
	if (_tmp0_ == NULL) {
#line 254 "pwl.vala"
		return;
#line 1744 "pwl.c"
	}
#line 257 "pwl.vala"
	_tmp1_ = self->filename;
#line 257 "pwl.vala"
	_tmp3_ = stat (_tmp1_, &_tmp2_);
#line 257 "pwl.vala"
	stats = _tmp2_;
#line 257 "pwl.vala"
	if (_tmp3_ == -1) {
#line 258 "pwl.vala"
		return;
#line 1756 "pwl.c"
	}
#line 259 "pwl.vala"
	_tmp4_ = stats;
#line 259 "pwl.vala"
	if (self->file_changed == _tmp4_.st_mtime) {
#line 260 "pwl.vala"
		return;
#line 1764 "pwl.c"
	}
#line 262 "pwl.vala"
	_tmp5_ = g_str_hash;
#line 262 "pwl.vala"
	_tmp6_ = g_str_equal;
#line 262 "pwl.vala"
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_free0_);
#line 262 "pwl.vala"
	_g_hash_table_unref0 (self->words);
#line 262 "pwl.vala"
	self->words = _tmp7_;
#line 264 "pwl.vala"
	_tmp8_ = self->filename;
#line 264 "pwl.vala"
	_tmp9_ = g_fopen (_tmp8_, "r");
#line 264 "pwl.vala"
	f = _tmp9_;
#line 265 "pwl.vala"
	_tmp10_ = f;
#line 265 "pwl.vala"
	if (_tmp10_ == NULL) {
#line 266 "pwl.vala"
		_fclose0 (f);
#line 266 "pwl.vala"
		return;
#line 1790 "pwl.c"
	}
#line 268 "pwl.vala"
	_tmp11_ = stats;
#line 268 "pwl.vala"
	self->file_changed = _tmp11_.st_mtime;
#line 269 "pwl.vala"
	_tmp12_ = f;
#line 269 "pwl.vala"
	lock_file (_tmp12_);
#line 271 "pwl.vala"
	line_number = (gsize) 1;
#line 1802 "pwl.c"
	{
		gboolean _tmp13_ = FALSE;
#line 273 "pwl.vala"
		_tmp13_ = TRUE;
#line 273 "pwl.vala"
		while (TRUE) {
#line 1809 "pwl.c"
			FILE* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			const gchar* _tmp26_;
#line 273 "pwl.vala"
			if (!_tmp13_) {
#line 1820 "pwl.c"
				gsize _tmp14_;
#line 273 "pwl.vala"
				line_number = line_number + 1;
#line 273 "pwl.vala"
				_tmp14_ = line_number;
#line 1826 "pwl.c"
			}
#line 273 "pwl.vala"
			_tmp13_ = FALSE;
#line 273 "pwl.vala"
			_tmp15_ = f;
#line 273 "pwl.vala"
			_tmp16_ = g_file_stream_read_line (_tmp15_);
#line 273 "pwl.vala"
			_g_free0 (line);
#line 273 "pwl.vala"
			line = _tmp16_;
#line 273 "pwl.vala"
			_tmp17_ = line;
#line 273 "pwl.vala"
			if (!(_tmp17_ != NULL)) {
#line 273 "pwl.vala"
				break;
#line 1844 "pwl.c"
			}
#line 274 "pwl.vala"
			if (line_number == ((gsize) 1)) {
#line 1848 "pwl.c"
				const gchar* _tmp19_;
#line 274 "pwl.vala"
				_tmp19_ = line;
#line 274 "pwl.vala"
				_tmp18_ = BOM == string_get_char (_tmp19_, (glong) 0);
#line 1854 "pwl.c"
			} else {
#line 274 "pwl.vala"
				_tmp18_ = FALSE;
#line 1858 "pwl.c"
			}
#line 274 "pwl.vala"
			if (_tmp18_) {
#line 1862 "pwl.c"
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
#line 275 "pwl.vala"
				_tmp20_ = line;
#line 275 "pwl.vala"
				_tmp21_ = g_utf8_next_char (_tmp20_);
#line 275 "pwl.vala"
				_tmp22_ = g_strdup (_tmp21_);
#line 275 "pwl.vala"
				_g_free0 (line);
#line 275 "pwl.vala"
				line = _tmp22_;
#line 1876 "pwl.c"
			}
#line 277 "pwl.vala"
			_tmp23_ = line;
#line 277 "pwl.vala"
			_tmp24_ = string_chomp (_tmp23_);
#line 277 "pwl.vala"
			_g_free0 (line);
#line 277 "pwl.vala"
			line = _tmp24_;
#line 278 "pwl.vala"
			_tmp26_ = line;
#line 278 "pwl.vala"
			if (string_get (_tmp26_, (glong) 0) != '\0') {
#line 1890 "pwl.c"
				const gchar* _tmp27_;
#line 278 "pwl.vala"
				_tmp27_ = line;
#line 278 "pwl.vala"
				_tmp25_ = string_get (_tmp27_, (glong) 0) != '#';
#line 1896 "pwl.c"
			} else {
#line 278 "pwl.vala"
				_tmp25_ = FALSE;
#line 1900 "pwl.c"
			}
#line 278 "pwl.vala"
			if (_tmp25_) {
#line 1904 "pwl.c"
				const gchar* _tmp28_;
#line 279 "pwl.vala"
				_tmp28_ = line;
#line 279 "pwl.vala"
				if (g_utf8_validate (_tmp28_, (gssize) -1, NULL)) {
#line 1910 "pwl.c"
					const gchar* _tmp29_;
#line 280 "pwl.vala"
					_tmp29_ = line;
#line 280 "pwl.vala"
					enchant_pwl_add_to_table (self, _tmp29_);
#line 1916 "pwl.c"
				} else {
					const gchar* _tmp30_;
#line 282 "pwl.vala"
					_tmp30_ = self->filename;
#line 282 "pwl.vala"
					g_warning ("pwl.vala:282: Bad UTF-8 sequence in %s at line:%zu", _tmp30_, line_number);
#line 1923 "pwl.c"
				}
			}
		}
	}
#line 286 "pwl.vala"
	_tmp31_ = f;
#line 286 "pwl.vala"
	unlock_file (_tmp31_);
#line 252 "pwl.vala"
	_g_free0 (line);
#line 252 "pwl.vala"
	_fclose0 (f);
#line 1936 "pwl.c"
}

static void
value_enchant_pwl_init (GValue* value)
{
#line 124 "pwl.vala"
	value->data[0].v_pointer = NULL;
#line 1944 "pwl.c"
}

static void
value_enchant_pwl_free_value (GValue* value)
{
#line 124 "pwl.vala"
	if (value->data[0].v_pointer) {
#line 124 "pwl.vala"
		enchant_pwl_unref (value->data[0].v_pointer);
#line 1954 "pwl.c"
	}
}

static void
value_enchant_pwl_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 124 "pwl.vala"
	if (src_value->data[0].v_pointer) {
#line 124 "pwl.vala"
		dest_value->data[0].v_pointer = enchant_pwl_ref (src_value->data[0].v_pointer);
#line 1966 "pwl.c"
	} else {
#line 124 "pwl.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1970 "pwl.c"
	}
}

static gpointer
value_enchant_pwl_peek_pointer (const GValue* value)
{
#line 124 "pwl.vala"
	return value->data[0].v_pointer;
#line 1979 "pwl.c"
}

static gchar*
value_enchant_pwl_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 124 "pwl.vala"
	if (collect_values[0].v_pointer) {
#line 1990 "pwl.c"
		EnchantPWL * object;
		object = collect_values[0].v_pointer;
#line 124 "pwl.vala"
		if (object->parent_instance.g_class == NULL) {
#line 124 "pwl.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1997 "pwl.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 124 "pwl.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2001 "pwl.c"
		}
#line 124 "pwl.vala"
		value->data[0].v_pointer = enchant_pwl_ref (object);
#line 2005 "pwl.c"
	} else {
#line 124 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2009 "pwl.c"
	}
#line 124 "pwl.vala"
	return NULL;
#line 2013 "pwl.c"
}

static gchar*
value_enchant_pwl_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	EnchantPWL ** object_p;
	object_p = collect_values[0].v_pointer;
#line 124 "pwl.vala"
	if (!object_p) {
#line 124 "pwl.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2028 "pwl.c"
	}
#line 124 "pwl.vala"
	if (!value->data[0].v_pointer) {
#line 124 "pwl.vala"
		*object_p = NULL;
#line 2034 "pwl.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 124 "pwl.vala"
		*object_p = value->data[0].v_pointer;
#line 2038 "pwl.c"
	} else {
#line 124 "pwl.vala"
		*object_p = enchant_pwl_ref (value->data[0].v_pointer);
#line 2042 "pwl.c"
	}
#line 124 "pwl.vala"
	return NULL;
#line 2046 "pwl.c"
}

GParamSpec*
param_spec_enchant_pwl (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecEnchantPWL* spec;
#line 124 "pwl.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_PWL), NULL);
#line 124 "pwl.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 124 "pwl.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 124 "pwl.vala"
	return G_PARAM_SPEC (spec);
#line 2065 "pwl.c"
}

gpointer
value_get_enchant_pwl (const GValue* value)
{
#line 124 "pwl.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL), NULL);
#line 124 "pwl.vala"
	return value->data[0].v_pointer;
#line 2075 "pwl.c"
}

void
value_set_enchant_pwl (GValue* value,
                       gpointer v_object)
{
	EnchantPWL * old;
#line 124 "pwl.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
	old = value->data[0].v_pointer;
#line 124 "pwl.vala"
	if (v_object) {
#line 124 "pwl.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 124 "pwl.vala"
		value->data[0].v_pointer = v_object;
#line 124 "pwl.vala"
		enchant_pwl_ref (value->data[0].v_pointer);
#line 2097 "pwl.c"
	} else {
#line 124 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2101 "pwl.c"
	}
#line 124 "pwl.vala"
	if (old) {
#line 124 "pwl.vala"
		enchant_pwl_unref (old);
#line 2107 "pwl.c"
	}
}

void
value_take_enchant_pwl (GValue* value,
                        gpointer v_object)
{
	EnchantPWL * old;
#line 124 "pwl.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
	old = value->data[0].v_pointer;
#line 124 "pwl.vala"
	if (v_object) {
#line 124 "pwl.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 124 "pwl.vala"
		value->data[0].v_pointer = v_object;
#line 2128 "pwl.c"
	} else {
#line 124 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2132 "pwl.c"
	}
#line 124 "pwl.vala"
	if (old) {
#line 124 "pwl.vala"
		enchant_pwl_unref (old);
#line 2138 "pwl.c"
	}
}

static void
enchant_pwl_class_init (EnchantPWLClass * klass,
                        gpointer klass_data)
{
#line 124 "pwl.vala"
	enchant_pwl_parent_class = g_type_class_peek_parent (klass);
#line 124 "pwl.vala"
	((EnchantPWLClass *) klass)->finalize = enchant_pwl_finalize;
#line 2150 "pwl.c"
}

static void
enchant_pwl_instance_init (EnchantPWL * self,
                           gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 126 "pwl.vala"
	self->file_changed = (time_t) 0;
#line 127 "pwl.vala"
	_tmp0_ = g_str_hash;
#line 127 "pwl.vala"
	_tmp1_ = g_str_equal;
#line 127 "pwl.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
#line 127 "pwl.vala"
	self->words = _tmp2_;
#line 124 "pwl.vala"
	self->ref_count = 1;
#line 2172 "pwl.c"
}

static void
enchant_pwl_finalize (EnchantPWL * obj)
{
	EnchantPWL * self;
#line 124 "pwl.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_PWL, EnchantPWL);
#line 124 "pwl.vala"
	g_signal_handlers_destroy (self);
#line 125 "pwl.vala"
	_g_free0 (self->filename);
#line 127 "pwl.vala"
	_g_hash_table_unref0 (self->words);
#line 2187 "pwl.c"
}

static GType
enchant_pwl_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_pwl_init, value_enchant_pwl_free_value, value_enchant_pwl_copy_value, value_enchant_pwl_peek_pointer, "p", value_enchant_pwl_collect_value, "p", value_enchant_pwl_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantPWLClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_pwl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantPWL), 0, (GInstanceInitFunc) enchant_pwl_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_pwl_type_id;
	enchant_pwl_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantPWL", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_pwl_type_id;
}

GType
enchant_pwl_get_type (void)
{
	static volatile gsize enchant_pwl_type_id__once = 0;
	if (g_once_init_enter (&enchant_pwl_type_id__once)) {
		GType enchant_pwl_type_id;
		enchant_pwl_type_id = enchant_pwl_get_type_once ();
		g_once_init_leave (&enchant_pwl_type_id__once, enchant_pwl_type_id);
	}
	return enchant_pwl_type_id__once;
}

gpointer
enchant_pwl_ref (gpointer instance)
{
	EnchantPWL * self;
	self = instance;
#line 124 "pwl.vala"
	g_atomic_int_inc (&self->ref_count);
#line 124 "pwl.vala"
	return instance;
#line 2222 "pwl.c"
}

void
enchant_pwl_unref (gpointer instance)
{
	EnchantPWL * self;
	self = instance;
#line 124 "pwl.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 124 "pwl.vala"
		ENCHANT_PWL_GET_CLASS (self)->finalize (self);
#line 124 "pwl.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2236 "pwl.c"
	}
}

gint
check_impl (EnchantProviderDict* me,
            const gchar* word,
            size_t len)
{
	gint result;
#line 290 "pwl.vala"
	g_return_val_if_fail (me != NULL, 0);
#line 290 "pwl.vala"
	g_return_val_if_fail (word != NULL, 0);
#line 291 "pwl.vala"
	result = 1;
#line 291 "pwl.vala"
	return result;
#line 2254 "pwl.c"
}

gchar**
suggest_impl (EnchantProviderDict* me,
              const gchar* word,
              size_t len,
              size_t* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** result;
#line 295 "pwl.vala"
	g_return_val_if_fail (me != NULL, NULL);
#line 295 "pwl.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 296 "pwl.vala"
	_tmp0_ = NULL;
#line 296 "pwl.vala"
	_tmp0__length1 = 0;
#line 296 "pwl.vala"
	if (result_length1) {
#line 296 "pwl.vala"
		*result_length1 = _tmp0__length1;
#line 2278 "pwl.c"
	}
#line 296 "pwl.vala"
	result = _tmp0_;
#line 296 "pwl.vala"
	return result;
#line 2284 "pwl.c"
}

static gint
_check_impl_dict_check (EnchantProviderDict* me,
                        const gchar* word,
                        size_t len)
{
	gint result;
	result = check_impl (me, word, len);
#line 302 "pwl.vala"
	return result;
#line 2296 "pwl.c"
}

static gchar**
_suggest_impl_dict_suggest (EnchantProviderDict* me,
                            const gchar* word,
                            size_t len,
                            size_t* result_length1)
{
	gchar** result;
	result = suggest_impl (me, word, len, result_length1);
#line 303 "pwl.vala"
	return result;
#line 2309 "pwl.c"
}

EnchantPwlDict*
enchant_pwl_dict_construct (GType object_type)
{
	EnchantPwlDict* self = NULL;
#line 301 "pwl.vala"
	self = (EnchantPwlDict*) enchant_provider_dict_construct (object_type, NULL, "Personal Wordlist");
#line 302 "pwl.vala"
	((EnchantProviderDict*) self)->check_method = _check_impl_dict_check;
#line 303 "pwl.vala"
	((EnchantProviderDict*) self)->suggest_method = _suggest_impl_dict_suggest;
#line 300 "pwl.vala"
	return self;
#line 2324 "pwl.c"
}

EnchantPwlDict*
enchant_pwl_dict_new (void)
{
#line 300 "pwl.vala"
	return enchant_pwl_dict_construct (TYPE_ENCHANT_PWL_DICT);
#line 2332 "pwl.c"
}

static void
enchant_pwl_dict_class_init (EnchantPwlDictClass * klass,
                             gpointer klass_data)
{
#line 299 "pwl.vala"
	enchant_pwl_dict_parent_class = g_type_class_peek_parent (klass);
#line 2341 "pwl.c"
}

static void
enchant_pwl_dict_instance_init (EnchantPwlDict * self,
                                gpointer klass)
{
}

static GType
enchant_pwl_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EnchantPwlDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_pwl_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantPwlDict), 0, (GInstanceInitFunc) enchant_pwl_dict_instance_init, NULL };
	GType enchant_pwl_dict_type_id;
	enchant_pwl_dict_type_id = g_type_register_static (TYPE_ENCHANT_PROVIDER_DICT, "EnchantPwlDict", &g_define_type_info, 0);
	return enchant_pwl_dict_type_id;
}

GType
enchant_pwl_dict_get_type (void)
{
	static volatile gsize enchant_pwl_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_pwl_dict_type_id__once)) {
		GType enchant_pwl_dict_type_id;
		enchant_pwl_dict_type_id = enchant_pwl_dict_get_type_once ();
		g_once_init_leave (&enchant_pwl_dict_type_id__once, enchant_pwl_dict_type_id);
	}
	return enchant_pwl_dict_type_id__once;
}

