/*****************************************************************************
 * ts_desciptions.c: es description strings
 *****************************************************************************
 * Copyright (C) 2004-2016 VLC authors and VideoLAN
 *                    2018 VideoLabs
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *****************************************************************************/
#ifndef TS_DESCRIPTIONS
#define TS_DESCRIPTIONS

/* Audio tracks descriptions */
#define DESC_CLEAN_EFFECTS                  N_("clean effects")
#define DESC_VISUAL_IMPAIRED_COMMENTS       N_("visual impaired commentary")

#define DESC_MAIN_AUDIO                     N_("Main audio")
#define DESC_AUDIO_DESC_VISUALLY_IMPAIRED   N_("Audio description for the visually impaired")
#define DESC_CLEAN_AUDIO_HEARING_IMPAIRED   N_("Clean audio for the hearing impaired")
#define DESC_SPOKEN_SUBTITLES_VISUAL_IMP    N_("Spoken subtitles for the visually impaired")

/* SPU tracks descriptions */
#define DESC_TELETEXT                       N_("Teletext")
#define DESC_TELETEXT_SUBTITLES             N_("Teletext subtitles")
#define DESC_TELETEXT_ADDTNL_INFO           N_("Teletext: additional information")
#define DESC_TELETEXT_SCHEDULE              N_("Teletext: program schedule")
#define DESC_TELETEXT_SUBS_HEARING_IMPAIRED N_("Teletext subtitles: hearing impaired")

#define DESC_SUBS_SAME_LANG                 N_("Same language dialogues")
#define DESC_SUBS_FOREIGN_LANG              N_("Foreign language dialogues")
#define DESC_SUBS_ALL_LANG                  N_("All dialogues")
#define DESC_SUBS_HEARING_IMPAIRED          N_("Description for the hearing impaired")
#define DESC_SUBS_AUDIO_DESCRIPTION_TRANS   N_("Transcripted audio description")
#define DESC_SUBS_COMMENTARY                N_("Commentary")

#endif
