/*
** Copyright (C) 2004 Andrew R. Baker <andrewb@snort.org>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __CONFIG_FILE_H__
#define __CONFIG_FILE_H__

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <sys/types.h>

#define CONFIG_PARSE_MAX_SIZE    8192

extern int file_line;
extern char *file_name;

typedef struct _ConfigFileVars
{
    char *hostname;
    char *interface;
    char *bpf_filter;
    char *class_file;
    char *sid_msg_file;
    char *gen_msg_file;
    u_int8_t daemon_flag;
    u_int8_t localtime_flag;
} ConfigFileVars;

int ConfigFile_Parse(char *filename, ConfigFileVars **cfvars);
int ConfigFileVars_Fprintf(ConfigFileVars *cfvars, FILE *stream);
int ConfigFileVars_Free(ConfigFileVars *cfvars);


#endif /* __CONFIG_FILE_H__ */
