/* 
** Copyright (C) 2001-2002 Andrewb R. Baker <andrewb@snort.org>
** Portions Copyright (C) 2003-2004 Sourcefire, Inc.
** 
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __SPOOL_H__
#define __SPOOL_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <sys/types.h>

#include "input-plugins/dp_plugbase.h"

#define N_READ_EOF     1
#define N_READ_PARTIAL 2
#define N_FILE_ERROR   3

#define STATE_OPENED        0
#define STATE_MAGIC_READ    1
#define STATE_HEADER_READ   2
#define STATE_RECORD_READ   3



typedef struct _Record
{
    void *data;
    u_int32_t dynamic;
} Record;

typedef struct _SpoolFileHandle
{
    int filedes;
    char *filepath;
    time_t timet;
    u_int32_t state;
    u_int32_t offset;
    u_int32_t magic;
    u_int32_t current_record;
    struct _DpFunctionalNode *dpfn;
    void *header;
    Record record;
} SpoolFileHandle;


int ProcessSpool(char *spool_dir, char *spoool_file, u_int32_t first_record, 
        time_t timet);
int DoOneShot(char *directory, char *base_filename);

#endif /* __SPOOL_H__ */


