// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new project service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for project service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ProjectServiceCreate(params *ProjectServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceCreateOK, error)

	ProjectServiceDelete(params *ProjectServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceDeleteOK, error)

	ProjectServiceGet(params *ProjectServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceGetOK, error)

	ProjectServiceGetIamPolicy(params *ProjectServiceGetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceGetIamPolicyOK, error)

	ProjectServiceGetProjectsCount(params *ProjectServiceGetProjectsCountParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceGetProjectsCountOK, error)

	ProjectServiceList(params *ProjectServiceListParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceListOK, error)

	ProjectServiceSetDescription(params *ProjectServiceSetDescriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceSetDescriptionOK, error)

	ProjectServiceSetIamPolicy(params *ProjectServiceSetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceSetIamPolicyOK, error)

	ProjectServiceSetName(params *ProjectServiceSetNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceSetNameOK, error)

	ProjectServiceTestIamPermissions(params *ProjectServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceTestIamPermissionsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ProjectServiceCreate creates creates a new project
*/
func (a *Client) ProjectServiceCreate(params *ProjectServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceCreateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_Create",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/projects",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceCreateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceDelete deletes updates the state of a project to d e l e t e d
*/
func (a *Client) ProjectServiceDelete(params *ProjectServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_Delete",
		Method:             "DELETE",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceGet gets retrieves the requested project by ID a not found status will be returned for projects in the d e l e t e d state
*/
func (a *Client) ProjectServiceGet(params *ProjectServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_Get",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceGetIamPolicy gets iam policy retrieves the user managed i a m policy for a project
*/
func (a *Client) ProjectServiceGetIamPolicy(params *ProjectServiceGetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceGetIamPolicyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceGetIamPolicyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_GetIamPolicy",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}/iam-policy",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceGetIamPolicyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceGetIamPolicyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceGetIamPolicyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceGetProjectsCount gets projects count returns the count of projects within a parent scope
*/
func (a *Client) ProjectServiceGetProjectsCount(params *ProjectServiceGetProjectsCountParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceGetProjectsCountOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceGetProjectsCountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_GetProjectsCount",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/projects/count",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceGetProjectsCountReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceGetProjectsCountOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceGetProjectsCountDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceList lists list the projects the caller has access to
*/
func (a *Client) ProjectServiceList(params *ProjectServiceListParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_List",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/projects",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceListReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceListDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceSetDescription sets description sets the requested project s description
*/
func (a *Client) ProjectServiceSetDescription(params *ProjectServiceSetDescriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceSetDescriptionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceSetDescriptionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_SetDescription",
		Method:             "PUT",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}/description",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceSetDescriptionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceSetDescriptionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceSetDescriptionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceSetIamPolicy sets iam policy sets the i a m policy for a project since this updates the full policy the policy takes an etag argument that should match with the current policy stored in the system this is to avoid concurrent writes erasing each other s data hence the client should always get the current policy that includes the etag modify the policy and then set the policy with the same etag if there is no existing policy the etag must be empty
*/
func (a *Client) ProjectServiceSetIamPolicy(params *ProjectServiceSetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceSetIamPolicyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceSetIamPolicyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_SetIamPolicy",
		Method:             "PUT",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}/iam-policy",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceSetIamPolicyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceSetIamPolicyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceSetIamPolicyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceSetName sets name sets the requested project s name
*/
func (a *Client) ProjectServiceSetName(params *ProjectServiceSetNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceSetNameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceSetNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_SetName",
		Method:             "PUT",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}/name",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceSetNameReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceSetNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceSetNameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProjectServiceTestIamPermissions tests iam permissions returns a subset of the request permissions the calling principal has for the project
*/
func (a *Client) ProjectServiceTestIamPermissions(params *ProjectServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProjectServiceTestIamPermissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProjectServiceTestIamPermissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProjectService_TestIamPermissions",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/projects/{id}/test-iam-permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProjectServiceTestIamPermissionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProjectServiceTestIamPermissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProjectServiceTestIamPermissionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
