/*-------------------------------------------------------------------------
 *
 * queryjumblefuncs.funcs.c
 *    Generated node infrastructure code
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/backend/nodes/gen_node_support.pl
 *
 *-------------------------------------------------------------------------
 */
#include "access/amapi.h"
#include "access/sdir.h"
#include "access/tableam.h"
#include "access/tsmapi.h"
#include "commands/event_trigger.h"
#include "commands/trigger.h"
#include "executor/tuptable.h"
#include "foreign/fdwapi.h"
#include "nodes/bitmapset.h"
#include "nodes/execnodes.h"
#include "nodes/extensible.h"
#include "nodes/lockoptions.h"
#include "nodes/miscnodes.h"
#include "nodes/nodes.h"
#include "nodes/parsenodes.h"
#include "nodes/pathnodes.h"
#include "nodes/plannodes.h"
#include "nodes/primnodes.h"
#include "nodes/replnodes.h"
#include "nodes/supportnodes.h"
#include "nodes/value.h"
#include "utils/rel.h"

static void
_jumbleAlias(JumbleState *jstate, Node *node)
{
	Alias *expr = (Alias *) node;

	JUMBLE_STRING(aliasname);
	JUMBLE_NODE(colnames);
}

static void
_jumbleRangeVar(JumbleState *jstate, Node *node)
{
	RangeVar *expr = (RangeVar *) node;

	JUMBLE_STRING(catalogname);
	JUMBLE_STRING(schemaname);
	JUMBLE_STRING(relname);
	JUMBLE_FIELD(inh);
	JUMBLE_FIELD(relpersistence);
	JUMBLE_NODE(alias);
}

static void
_jumbleTableFunc(JumbleState *jstate, Node *node)
{
	TableFunc *expr = (TableFunc *) node;

	JUMBLE_NODE(docexpr);
	JUMBLE_NODE(rowexpr);
	JUMBLE_NODE(colexprs);
}

static void
_jumbleIntoClause(JumbleState *jstate, Node *node)
{
	IntoClause *expr = (IntoClause *) node;

	JUMBLE_NODE(rel);
	JUMBLE_NODE(colNames);
	JUMBLE_STRING(accessMethod);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(onCommit);
	JUMBLE_STRING(tableSpaceName);
	JUMBLE_FIELD(skipData);
}

static void
_jumbleVar(JumbleState *jstate, Node *node)
{
	Var *expr = (Var *) node;

	JUMBLE_FIELD(varno);
	JUMBLE_FIELD(varattno);
	JUMBLE_FIELD(varlevelsup);
}

static void
_jumbleConst(JumbleState *jstate, Node *node)
{
	Const *expr = (Const *) node;

	JUMBLE_FIELD(consttype);
	JUMBLE_LOCATION(location);
}

static void
_jumbleParam(JumbleState *jstate, Node *node)
{
	Param *expr = (Param *) node;

	JUMBLE_FIELD(paramkind);
	JUMBLE_FIELD(paramid);
	JUMBLE_FIELD(paramtype);
}

static void
_jumbleAggref(JumbleState *jstate, Node *node)
{
	Aggref *expr = (Aggref *) node;

	JUMBLE_FIELD(aggfnoid);
	JUMBLE_NODE(aggdirectargs);
	JUMBLE_NODE(args);
	JUMBLE_NODE(aggorder);
	JUMBLE_NODE(aggdistinct);
	JUMBLE_NODE(aggfilter);
}

static void
_jumbleGroupingFunc(JumbleState *jstate, Node *node)
{
	GroupingFunc *expr = (GroupingFunc *) node;

	JUMBLE_NODE(refs);
	JUMBLE_FIELD(agglevelsup);
}

static void
_jumbleWindowFunc(JumbleState *jstate, Node *node)
{
	WindowFunc *expr = (WindowFunc *) node;

	JUMBLE_FIELD(winfnoid);
	JUMBLE_NODE(args);
	JUMBLE_NODE(aggfilter);
	JUMBLE_FIELD(winref);
}

static void
_jumbleSubscriptingRef(JumbleState *jstate, Node *node)
{
	SubscriptingRef *expr = (SubscriptingRef *) node;

	JUMBLE_NODE(refupperindexpr);
	JUMBLE_NODE(reflowerindexpr);
	JUMBLE_NODE(refexpr);
	JUMBLE_NODE(refassgnexpr);
}

static void
_jumbleFuncExpr(JumbleState *jstate, Node *node)
{
	FuncExpr *expr = (FuncExpr *) node;

	JUMBLE_FIELD(funcid);
	JUMBLE_NODE(args);
}

static void
_jumbleNamedArgExpr(JumbleState *jstate, Node *node)
{
	NamedArgExpr *expr = (NamedArgExpr *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(argnumber);
}

static void
_jumbleOpExpr(JumbleState *jstate, Node *node)
{
	OpExpr *expr = (OpExpr *) node;

	JUMBLE_FIELD(opno);
	JUMBLE_NODE(args);
}

static void
_jumbleDistinctExpr(JumbleState *jstate, Node *node)
{
	DistinctExpr *expr = (DistinctExpr *) node;

	JUMBLE_FIELD(opno);
	JUMBLE_NODE(args);
}

static void
_jumbleNullIfExpr(JumbleState *jstate, Node *node)
{
	NullIfExpr *expr = (NullIfExpr *) node;

	JUMBLE_FIELD(opno);
	JUMBLE_NODE(args);
}

static void
_jumbleScalarArrayOpExpr(JumbleState *jstate, Node *node)
{
	ScalarArrayOpExpr *expr = (ScalarArrayOpExpr *) node;

	JUMBLE_FIELD(opno);
	JUMBLE_FIELD(useOr);
	JUMBLE_NODE(args);
}

static void
_jumbleBoolExpr(JumbleState *jstate, Node *node)
{
	BoolExpr *expr = (BoolExpr *) node;

	JUMBLE_FIELD(boolop);
	JUMBLE_NODE(args);
}

static void
_jumbleSubLink(JumbleState *jstate, Node *node)
{
	SubLink *expr = (SubLink *) node;

	JUMBLE_FIELD(subLinkType);
	JUMBLE_FIELD(subLinkId);
	JUMBLE_NODE(testexpr);
	JUMBLE_NODE(subselect);
}

static void
_jumbleFieldSelect(JumbleState *jstate, Node *node)
{
	FieldSelect *expr = (FieldSelect *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(fieldnum);
}

static void
_jumbleFieldStore(JumbleState *jstate, Node *node)
{
	FieldStore *expr = (FieldStore *) node;

	JUMBLE_NODE(arg);
	JUMBLE_NODE(newvals);
}

static void
_jumbleRelabelType(JumbleState *jstate, Node *node)
{
	RelabelType *expr = (RelabelType *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(resulttype);
}

static void
_jumbleCoerceViaIO(JumbleState *jstate, Node *node)
{
	CoerceViaIO *expr = (CoerceViaIO *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(resulttype);
}

static void
_jumbleArrayCoerceExpr(JumbleState *jstate, Node *node)
{
	ArrayCoerceExpr *expr = (ArrayCoerceExpr *) node;

	JUMBLE_NODE(arg);
	JUMBLE_NODE(elemexpr);
	JUMBLE_FIELD(resulttype);
}

static void
_jumbleConvertRowtypeExpr(JumbleState *jstate, Node *node)
{
	ConvertRowtypeExpr *expr = (ConvertRowtypeExpr *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(resulttype);
}

static void
_jumbleCollateExpr(JumbleState *jstate, Node *node)
{
	CollateExpr *expr = (CollateExpr *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(collOid);
}

static void
_jumbleCaseExpr(JumbleState *jstate, Node *node)
{
	CaseExpr *expr = (CaseExpr *) node;

	JUMBLE_NODE(arg);
	JUMBLE_NODE(args);
	JUMBLE_NODE(defresult);
}

static void
_jumbleCaseWhen(JumbleState *jstate, Node *node)
{
	CaseWhen *expr = (CaseWhen *) node;

	JUMBLE_NODE(expr);
	JUMBLE_NODE(result);
}

static void
_jumbleCaseTestExpr(JumbleState *jstate, Node *node)
{
	CaseTestExpr *expr = (CaseTestExpr *) node;

	JUMBLE_FIELD(typeId);
}

static void
_jumbleArrayExpr(JumbleState *jstate, Node *node)
{
	ArrayExpr *expr = (ArrayExpr *) node;

	JUMBLE_NODE(elements);
}

static void
_jumbleRowExpr(JumbleState *jstate, Node *node)
{
	RowExpr *expr = (RowExpr *) node;

	JUMBLE_NODE(args);
}

static void
_jumbleRowCompareExpr(JumbleState *jstate, Node *node)
{
	RowCompareExpr *expr = (RowCompareExpr *) node;

	JUMBLE_FIELD(rctype);
	JUMBLE_NODE(largs);
	JUMBLE_NODE(rargs);
}

static void
_jumbleCoalesceExpr(JumbleState *jstate, Node *node)
{
	CoalesceExpr *expr = (CoalesceExpr *) node;

	JUMBLE_NODE(args);
}

static void
_jumbleMinMaxExpr(JumbleState *jstate, Node *node)
{
	MinMaxExpr *expr = (MinMaxExpr *) node;

	JUMBLE_FIELD(op);
	JUMBLE_NODE(args);
}

static void
_jumbleSQLValueFunction(JumbleState *jstate, Node *node)
{
	SQLValueFunction *expr = (SQLValueFunction *) node;

	JUMBLE_FIELD(op);
	JUMBLE_FIELD(typmod);
}

static void
_jumbleXmlExpr(JumbleState *jstate, Node *node)
{
	XmlExpr *expr = (XmlExpr *) node;

	JUMBLE_FIELD(op);
	JUMBLE_NODE(named_args);
	JUMBLE_NODE(args);
	JUMBLE_FIELD(indent);
}

static void
_jumbleJsonFormat(JumbleState *jstate, Node *node)
{
	JsonFormat *expr = (JsonFormat *) node;

	JUMBLE_FIELD(format_type);
	JUMBLE_FIELD(encoding);
}

static void
_jumbleJsonReturning(JumbleState *jstate, Node *node)
{
	JsonReturning *expr = (JsonReturning *) node;

	JUMBLE_NODE(format);
	JUMBLE_FIELD(typid);
	JUMBLE_FIELD(typmod);
}

static void
_jumbleJsonValueExpr(JumbleState *jstate, Node *node)
{
	JsonValueExpr *expr = (JsonValueExpr *) node;

	JUMBLE_NODE(raw_expr);
	JUMBLE_NODE(formatted_expr);
	JUMBLE_NODE(format);
}

static void
_jumbleJsonConstructorExpr(JumbleState *jstate, Node *node)
{
	JsonConstructorExpr *expr = (JsonConstructorExpr *) node;

	JUMBLE_FIELD(type);
	JUMBLE_NODE(args);
	JUMBLE_NODE(func);
	JUMBLE_NODE(coercion);
	JUMBLE_NODE(returning);
	JUMBLE_FIELD(absent_on_null);
	JUMBLE_FIELD(unique);
}

static void
_jumbleJsonIsPredicate(JumbleState *jstate, Node *node)
{
	JsonIsPredicate *expr = (JsonIsPredicate *) node;

	JUMBLE_NODE(expr);
	JUMBLE_NODE(format);
	JUMBLE_FIELD(item_type);
	JUMBLE_FIELD(unique_keys);
}

static void
_jumbleNullTest(JumbleState *jstate, Node *node)
{
	NullTest *expr = (NullTest *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(nulltesttype);
}

static void
_jumbleBooleanTest(JumbleState *jstate, Node *node)
{
	BooleanTest *expr = (BooleanTest *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(booltesttype);
}

static void
_jumbleCoerceToDomain(JumbleState *jstate, Node *node)
{
	CoerceToDomain *expr = (CoerceToDomain *) node;

	JUMBLE_NODE(arg);
	JUMBLE_FIELD(resulttype);
}

static void
_jumbleCoerceToDomainValue(JumbleState *jstate, Node *node)
{
	CoerceToDomainValue *expr = (CoerceToDomainValue *) node;

	JUMBLE_FIELD(typeId);
}

static void
_jumbleSetToDefault(JumbleState *jstate, Node *node)
{
	SetToDefault *expr = (SetToDefault *) node;

	JUMBLE_FIELD(typeId);
}

static void
_jumbleCurrentOfExpr(JumbleState *jstate, Node *node)
{
	CurrentOfExpr *expr = (CurrentOfExpr *) node;

	JUMBLE_FIELD(cvarno);
	JUMBLE_STRING(cursor_name);
	JUMBLE_FIELD(cursor_param);
}

static void
_jumbleNextValueExpr(JumbleState *jstate, Node *node)
{
	NextValueExpr *expr = (NextValueExpr *) node;

	JUMBLE_FIELD(seqid);
	JUMBLE_FIELD(typeId);
}

static void
_jumbleInferenceElem(JumbleState *jstate, Node *node)
{
	InferenceElem *expr = (InferenceElem *) node;

	JUMBLE_NODE(expr);
	JUMBLE_FIELD(infercollid);
	JUMBLE_FIELD(inferopclass);
}

static void
_jumbleTargetEntry(JumbleState *jstate, Node *node)
{
	TargetEntry *expr = (TargetEntry *) node;

	JUMBLE_NODE(expr);
	JUMBLE_FIELD(resno);
	JUMBLE_FIELD(ressortgroupref);
}

static void
_jumbleRangeTblRef(JumbleState *jstate, Node *node)
{
	RangeTblRef *expr = (RangeTblRef *) node;

	JUMBLE_FIELD(rtindex);
}

static void
_jumbleJoinExpr(JumbleState *jstate, Node *node)
{
	JoinExpr *expr = (JoinExpr *) node;

	JUMBLE_FIELD(jointype);
	JUMBLE_FIELD(isNatural);
	JUMBLE_NODE(larg);
	JUMBLE_NODE(rarg);
	JUMBLE_NODE(quals);
	JUMBLE_FIELD(rtindex);
}

static void
_jumbleFromExpr(JumbleState *jstate, Node *node)
{
	FromExpr *expr = (FromExpr *) node;

	JUMBLE_NODE(fromlist);
	JUMBLE_NODE(quals);
}

static void
_jumbleOnConflictExpr(JumbleState *jstate, Node *node)
{
	OnConflictExpr *expr = (OnConflictExpr *) node;

	JUMBLE_FIELD(action);
	JUMBLE_NODE(arbiterElems);
	JUMBLE_NODE(arbiterWhere);
	JUMBLE_FIELD(constraint);
	JUMBLE_NODE(onConflictSet);
	JUMBLE_NODE(onConflictWhere);
	JUMBLE_FIELD(exclRelIndex);
	JUMBLE_NODE(exclRelTlist);
}

static void
_jumbleQuery(JumbleState *jstate, Node *node)
{
	Query *expr = (Query *) node;

	JUMBLE_FIELD(commandType);
	JUMBLE_NODE(utilityStmt);
	JUMBLE_NODE(cteList);
	JUMBLE_NODE(rtable);
	JUMBLE_NODE(jointree);
	JUMBLE_NODE(mergeActionList);
	JUMBLE_NODE(targetList);
	JUMBLE_NODE(onConflict);
	JUMBLE_NODE(returningList);
	JUMBLE_NODE(groupClause);
	JUMBLE_FIELD(groupDistinct);
	JUMBLE_NODE(groupingSets);
	JUMBLE_NODE(havingQual);
	JUMBLE_NODE(windowClause);
	JUMBLE_NODE(distinctClause);
	JUMBLE_NODE(sortClause);
	JUMBLE_NODE(limitOffset);
	JUMBLE_NODE(limitCount);
	JUMBLE_FIELD(limitOption);
	JUMBLE_NODE(rowMarks);
	JUMBLE_NODE(setOperations);
}

static void
_jumbleTypeName(JumbleState *jstate, Node *node)
{
	TypeName *expr = (TypeName *) node;

	JUMBLE_NODE(names);
	JUMBLE_FIELD(typeOid);
	JUMBLE_FIELD(setof);
	JUMBLE_FIELD(pct_type);
	JUMBLE_NODE(typmods);
	JUMBLE_FIELD(typemod);
	JUMBLE_NODE(arrayBounds);
}

static void
_jumbleColumnRef(JumbleState *jstate, Node *node)
{
	ColumnRef *expr = (ColumnRef *) node;

	JUMBLE_NODE(fields);
}

static void
_jumbleParamRef(JumbleState *jstate, Node *node)
{
	ParamRef *expr = (ParamRef *) node;

	JUMBLE_FIELD(number);
}

static void
_jumbleA_Expr(JumbleState *jstate, Node *node)
{
	A_Expr *expr = (A_Expr *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_NODE(name);
	JUMBLE_NODE(lexpr);
	JUMBLE_NODE(rexpr);
}

static void
_jumbleTypeCast(JumbleState *jstate, Node *node)
{
	TypeCast *expr = (TypeCast *) node;

	JUMBLE_NODE(arg);
	JUMBLE_NODE(typeName);
}

static void
_jumbleCollateClause(JumbleState *jstate, Node *node)
{
	CollateClause *expr = (CollateClause *) node;

	JUMBLE_NODE(arg);
	JUMBLE_NODE(collname);
}

static void
_jumbleRoleSpec(JumbleState *jstate, Node *node)
{
	RoleSpec *expr = (RoleSpec *) node;

	JUMBLE_FIELD(roletype);
	JUMBLE_STRING(rolename);
}

static void
_jumbleFuncCall(JumbleState *jstate, Node *node)
{
	FuncCall *expr = (FuncCall *) node;

	JUMBLE_NODE(funcname);
	JUMBLE_NODE(args);
	JUMBLE_NODE(agg_order);
	JUMBLE_NODE(agg_filter);
	JUMBLE_NODE(over);
	JUMBLE_FIELD(agg_within_group);
	JUMBLE_FIELD(agg_star);
	JUMBLE_FIELD(agg_distinct);
	JUMBLE_FIELD(func_variadic);
	JUMBLE_FIELD(funcformat);
}

static void
_jumbleA_Star(JumbleState *jstate, Node *node)
{
	A_Star *expr = (A_Star *) node;

	(void) expr;
}

static void
_jumbleA_Indices(JumbleState *jstate, Node *node)
{
	A_Indices *expr = (A_Indices *) node;

	JUMBLE_FIELD(is_slice);
	JUMBLE_NODE(lidx);
	JUMBLE_NODE(uidx);
}

static void
_jumbleA_Indirection(JumbleState *jstate, Node *node)
{
	A_Indirection *expr = (A_Indirection *) node;

	JUMBLE_NODE(arg);
	JUMBLE_NODE(indirection);
}

static void
_jumbleA_ArrayExpr(JumbleState *jstate, Node *node)
{
	A_ArrayExpr *expr = (A_ArrayExpr *) node;

	JUMBLE_NODE(elements);
}

static void
_jumbleResTarget(JumbleState *jstate, Node *node)
{
	ResTarget *expr = (ResTarget *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(indirection);
	JUMBLE_NODE(val);
}

static void
_jumbleMultiAssignRef(JumbleState *jstate, Node *node)
{
	MultiAssignRef *expr = (MultiAssignRef *) node;

	JUMBLE_NODE(source);
	JUMBLE_FIELD(colno);
	JUMBLE_FIELD(ncolumns);
}

static void
_jumbleSortBy(JumbleState *jstate, Node *node)
{
	SortBy *expr = (SortBy *) node;

	JUMBLE_NODE(node);
	JUMBLE_FIELD(sortby_dir);
	JUMBLE_FIELD(sortby_nulls);
	JUMBLE_NODE(useOp);
}

static void
_jumbleWindowDef(JumbleState *jstate, Node *node)
{
	WindowDef *expr = (WindowDef *) node;

	JUMBLE_STRING(name);
	JUMBLE_STRING(refname);
	JUMBLE_NODE(partitionClause);
	JUMBLE_NODE(orderClause);
	JUMBLE_FIELD(frameOptions);
	JUMBLE_NODE(startOffset);
	JUMBLE_NODE(endOffset);
}

static void
_jumbleRangeSubselect(JumbleState *jstate, Node *node)
{
	RangeSubselect *expr = (RangeSubselect *) node;

	JUMBLE_FIELD(lateral);
	JUMBLE_NODE(subquery);
	JUMBLE_NODE(alias);
}

static void
_jumbleRangeFunction(JumbleState *jstate, Node *node)
{
	RangeFunction *expr = (RangeFunction *) node;

	JUMBLE_FIELD(lateral);
	JUMBLE_FIELD(ordinality);
	JUMBLE_FIELD(is_rowsfrom);
	JUMBLE_NODE(functions);
	JUMBLE_NODE(alias);
	JUMBLE_NODE(coldeflist);
}

static void
_jumbleRangeTableFunc(JumbleState *jstate, Node *node)
{
	RangeTableFunc *expr = (RangeTableFunc *) node;

	JUMBLE_FIELD(lateral);
	JUMBLE_NODE(docexpr);
	JUMBLE_NODE(rowexpr);
	JUMBLE_NODE(namespaces);
	JUMBLE_NODE(columns);
	JUMBLE_NODE(alias);
}

static void
_jumbleRangeTableFuncCol(JumbleState *jstate, Node *node)
{
	RangeTableFuncCol *expr = (RangeTableFuncCol *) node;

	JUMBLE_STRING(colname);
	JUMBLE_NODE(typeName);
	JUMBLE_FIELD(for_ordinality);
	JUMBLE_FIELD(is_not_null);
	JUMBLE_NODE(colexpr);
	JUMBLE_NODE(coldefexpr);
}

static void
_jumbleRangeTableSample(JumbleState *jstate, Node *node)
{
	RangeTableSample *expr = (RangeTableSample *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(method);
	JUMBLE_NODE(args);
	JUMBLE_NODE(repeatable);
}

static void
_jumbleColumnDef(JumbleState *jstate, Node *node)
{
	ColumnDef *expr = (ColumnDef *) node;

	JUMBLE_STRING(colname);
	JUMBLE_NODE(typeName);
	JUMBLE_STRING(compression);
	JUMBLE_FIELD(inhcount);
	JUMBLE_FIELD(is_local);
	JUMBLE_FIELD(is_not_null);
	JUMBLE_FIELD(is_from_type);
	JUMBLE_FIELD(storage);
	JUMBLE_STRING(storage_name);
	JUMBLE_NODE(raw_default);
	JUMBLE_NODE(cooked_default);
	JUMBLE_FIELD(identity);
	JUMBLE_NODE(identitySequence);
	JUMBLE_FIELD(generated);
	JUMBLE_NODE(collClause);
	JUMBLE_FIELD(collOid);
	JUMBLE_NODE(constraints);
	JUMBLE_NODE(fdwoptions);
}

static void
_jumbleTableLikeClause(JumbleState *jstate, Node *node)
{
	TableLikeClause *expr = (TableLikeClause *) node;

	JUMBLE_NODE(relation);
	JUMBLE_FIELD(options);
	JUMBLE_FIELD(relationOid);
}

static void
_jumbleIndexElem(JumbleState *jstate, Node *node)
{
	IndexElem *expr = (IndexElem *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(expr);
	JUMBLE_STRING(indexcolname);
	JUMBLE_NODE(collation);
	JUMBLE_NODE(opclass);
	JUMBLE_NODE(opclassopts);
	JUMBLE_FIELD(ordering);
	JUMBLE_FIELD(nulls_ordering);
}

static void
_jumbleDefElem(JumbleState *jstate, Node *node)
{
	DefElem *expr = (DefElem *) node;

	JUMBLE_STRING(defnamespace);
	JUMBLE_STRING(defname);
	JUMBLE_NODE(arg);
	JUMBLE_FIELD(defaction);
}

static void
_jumbleLockingClause(JumbleState *jstate, Node *node)
{
	LockingClause *expr = (LockingClause *) node;

	JUMBLE_NODE(lockedRels);
	JUMBLE_FIELD(strength);
	JUMBLE_FIELD(waitPolicy);
}

static void
_jumbleXmlSerialize(JumbleState *jstate, Node *node)
{
	XmlSerialize *expr = (XmlSerialize *) node;

	JUMBLE_FIELD(xmloption);
	JUMBLE_NODE(expr);
	JUMBLE_NODE(typeName);
	JUMBLE_FIELD(indent);
}

static void
_jumblePartitionElem(JumbleState *jstate, Node *node)
{
	PartitionElem *expr = (PartitionElem *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(expr);
	JUMBLE_NODE(collation);
	JUMBLE_NODE(opclass);
}

static void
_jumblePartitionSpec(JumbleState *jstate, Node *node)
{
	PartitionSpec *expr = (PartitionSpec *) node;

	JUMBLE_FIELD(strategy);
	JUMBLE_NODE(partParams);
}

static void
_jumblePartitionBoundSpec(JumbleState *jstate, Node *node)
{
	PartitionBoundSpec *expr = (PartitionBoundSpec *) node;

	JUMBLE_FIELD(strategy);
	JUMBLE_FIELD(is_default);
	JUMBLE_FIELD(modulus);
	JUMBLE_FIELD(remainder);
	JUMBLE_NODE(listdatums);
	JUMBLE_NODE(lowerdatums);
	JUMBLE_NODE(upperdatums);
}

static void
_jumblePartitionRangeDatum(JumbleState *jstate, Node *node)
{
	PartitionRangeDatum *expr = (PartitionRangeDatum *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_NODE(value);
}

static void
_jumblePartitionCmd(JumbleState *jstate, Node *node)
{
	PartitionCmd *expr = (PartitionCmd *) node;

	JUMBLE_NODE(name);
	JUMBLE_NODE(bound);
	JUMBLE_FIELD(concurrent);
}

static void
_jumbleRTEPermissionInfo(JumbleState *jstate, Node *node)
{
	RTEPermissionInfo *expr = (RTEPermissionInfo *) node;

	JUMBLE_FIELD(relid);
	JUMBLE_FIELD(inh);
	JUMBLE_FIELD(requiredPerms);
	JUMBLE_FIELD(checkAsUser);
	JUMBLE_NODE(selectedCols);
	JUMBLE_NODE(insertedCols);
	JUMBLE_NODE(updatedCols);
}

static void
_jumbleRangeTblFunction(JumbleState *jstate, Node *node)
{
	RangeTblFunction *expr = (RangeTblFunction *) node;

	JUMBLE_NODE(funcexpr);
}

static void
_jumbleTableSampleClause(JumbleState *jstate, Node *node)
{
	TableSampleClause *expr = (TableSampleClause *) node;

	JUMBLE_FIELD(tsmhandler);
	JUMBLE_NODE(args);
	JUMBLE_NODE(repeatable);
}

static void
_jumbleWithCheckOption(JumbleState *jstate, Node *node)
{
	WithCheckOption *expr = (WithCheckOption *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_STRING(relname);
	JUMBLE_STRING(polname);
	JUMBLE_NODE(qual);
	JUMBLE_FIELD(cascaded);
}

static void
_jumbleSortGroupClause(JumbleState *jstate, Node *node)
{
	SortGroupClause *expr = (SortGroupClause *) node;

	JUMBLE_FIELD(tleSortGroupRef);
	JUMBLE_FIELD(eqop);
	JUMBLE_FIELD(sortop);
	JUMBLE_FIELD(nulls_first);
}

static void
_jumbleGroupingSet(JumbleState *jstate, Node *node)
{
	GroupingSet *expr = (GroupingSet *) node;

	JUMBLE_NODE(content);
}

static void
_jumbleWindowClause(JumbleState *jstate, Node *node)
{
	WindowClause *expr = (WindowClause *) node;

	JUMBLE_NODE(partitionClause);
	JUMBLE_NODE(orderClause);
	JUMBLE_FIELD(frameOptions);
	JUMBLE_NODE(startOffset);
	JUMBLE_NODE(endOffset);
	JUMBLE_FIELD(winref);
}

static void
_jumbleRowMarkClause(JumbleState *jstate, Node *node)
{
	RowMarkClause *expr = (RowMarkClause *) node;

	JUMBLE_FIELD(rti);
	JUMBLE_FIELD(strength);
	JUMBLE_FIELD(waitPolicy);
	JUMBLE_FIELD(pushedDown);
}

static void
_jumbleWithClause(JumbleState *jstate, Node *node)
{
	WithClause *expr = (WithClause *) node;

	JUMBLE_NODE(ctes);
	JUMBLE_FIELD(recursive);
}

static void
_jumbleInferClause(JumbleState *jstate, Node *node)
{
	InferClause *expr = (InferClause *) node;

	JUMBLE_NODE(indexElems);
	JUMBLE_NODE(whereClause);
	JUMBLE_STRING(conname);
}

static void
_jumbleOnConflictClause(JumbleState *jstate, Node *node)
{
	OnConflictClause *expr = (OnConflictClause *) node;

	JUMBLE_FIELD(action);
	JUMBLE_NODE(infer);
	JUMBLE_NODE(targetList);
	JUMBLE_NODE(whereClause);
}

static void
_jumbleCTESearchClause(JumbleState *jstate, Node *node)
{
	CTESearchClause *expr = (CTESearchClause *) node;

	JUMBLE_NODE(search_col_list);
	JUMBLE_FIELD(search_breadth_first);
	JUMBLE_STRING(search_seq_column);
}

static void
_jumbleCTECycleClause(JumbleState *jstate, Node *node)
{
	CTECycleClause *expr = (CTECycleClause *) node;

	JUMBLE_NODE(cycle_col_list);
	JUMBLE_STRING(cycle_mark_column);
	JUMBLE_NODE(cycle_mark_value);
	JUMBLE_NODE(cycle_mark_default);
	JUMBLE_STRING(cycle_path_column);
	JUMBLE_FIELD(cycle_mark_type);
	JUMBLE_FIELD(cycle_mark_typmod);
	JUMBLE_FIELD(cycle_mark_collation);
	JUMBLE_FIELD(cycle_mark_neop);
}

static void
_jumbleCommonTableExpr(JumbleState *jstate, Node *node)
{
	CommonTableExpr *expr = (CommonTableExpr *) node;

	JUMBLE_STRING(ctename);
	JUMBLE_FIELD(ctematerialized);
	JUMBLE_NODE(ctequery);
}

static void
_jumbleMergeWhenClause(JumbleState *jstate, Node *node)
{
	MergeWhenClause *expr = (MergeWhenClause *) node;

	JUMBLE_FIELD(matched);
	JUMBLE_FIELD(commandType);
	JUMBLE_FIELD(override);
	JUMBLE_NODE(condition);
	JUMBLE_NODE(targetList);
	JUMBLE_NODE(values);
}

static void
_jumbleMergeAction(JumbleState *jstate, Node *node)
{
	MergeAction *expr = (MergeAction *) node;

	JUMBLE_FIELD(matched);
	JUMBLE_FIELD(commandType);
	JUMBLE_NODE(qual);
	JUMBLE_NODE(targetList);
}

static void
_jumbleTriggerTransition(JumbleState *jstate, Node *node)
{
	TriggerTransition *expr = (TriggerTransition *) node;

	JUMBLE_STRING(name);
	JUMBLE_FIELD(isNew);
	JUMBLE_FIELD(isTable);
}

static void
_jumbleJsonOutput(JumbleState *jstate, Node *node)
{
	JsonOutput *expr = (JsonOutput *) node;

	JUMBLE_NODE(typeName);
	JUMBLE_NODE(returning);
}

static void
_jumbleJsonKeyValue(JumbleState *jstate, Node *node)
{
	JsonKeyValue *expr = (JsonKeyValue *) node;

	JUMBLE_NODE(key);
	JUMBLE_NODE(value);
}

static void
_jumbleJsonObjectConstructor(JumbleState *jstate, Node *node)
{
	JsonObjectConstructor *expr = (JsonObjectConstructor *) node;

	JUMBLE_NODE(exprs);
	JUMBLE_NODE(output);
	JUMBLE_FIELD(absent_on_null);
	JUMBLE_FIELD(unique);
}

static void
_jumbleJsonArrayConstructor(JumbleState *jstate, Node *node)
{
	JsonArrayConstructor *expr = (JsonArrayConstructor *) node;

	JUMBLE_NODE(exprs);
	JUMBLE_NODE(output);
	JUMBLE_FIELD(absent_on_null);
}

static void
_jumbleJsonArrayQueryConstructor(JumbleState *jstate, Node *node)
{
	JsonArrayQueryConstructor *expr = (JsonArrayQueryConstructor *) node;

	JUMBLE_NODE(query);
	JUMBLE_NODE(output);
	JUMBLE_NODE(format);
	JUMBLE_FIELD(absent_on_null);
}

static void
_jumbleJsonAggConstructor(JumbleState *jstate, Node *node)
{
	JsonAggConstructor *expr = (JsonAggConstructor *) node;

	JUMBLE_NODE(output);
	JUMBLE_NODE(agg_filter);
	JUMBLE_NODE(agg_order);
	JUMBLE_NODE(over);
}

static void
_jumbleJsonObjectAgg(JumbleState *jstate, Node *node)
{
	JsonObjectAgg *expr = (JsonObjectAgg *) node;

	JUMBLE_NODE(constructor);
	JUMBLE_NODE(arg);
	JUMBLE_FIELD(absent_on_null);
	JUMBLE_FIELD(unique);
}

static void
_jumbleJsonArrayAgg(JumbleState *jstate, Node *node)
{
	JsonArrayAgg *expr = (JsonArrayAgg *) node;

	JUMBLE_NODE(constructor);
	JUMBLE_NODE(arg);
	JUMBLE_FIELD(absent_on_null);
}

static void
_jumbleInsertStmt(JumbleState *jstate, Node *node)
{
	InsertStmt *expr = (InsertStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(cols);
	JUMBLE_NODE(selectStmt);
	JUMBLE_NODE(onConflictClause);
	JUMBLE_NODE(returningList);
	JUMBLE_NODE(withClause);
	JUMBLE_FIELD(override);
}

static void
_jumbleDeleteStmt(JumbleState *jstate, Node *node)
{
	DeleteStmt *expr = (DeleteStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(usingClause);
	JUMBLE_NODE(whereClause);
	JUMBLE_NODE(returningList);
	JUMBLE_NODE(withClause);
}

static void
_jumbleUpdateStmt(JumbleState *jstate, Node *node)
{
	UpdateStmt *expr = (UpdateStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(targetList);
	JUMBLE_NODE(whereClause);
	JUMBLE_NODE(fromClause);
	JUMBLE_NODE(returningList);
	JUMBLE_NODE(withClause);
}

static void
_jumbleMergeStmt(JumbleState *jstate, Node *node)
{
	MergeStmt *expr = (MergeStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(sourceRelation);
	JUMBLE_NODE(joinCondition);
	JUMBLE_NODE(mergeWhenClauses);
	JUMBLE_NODE(withClause);
}

static void
_jumbleSelectStmt(JumbleState *jstate, Node *node)
{
	SelectStmt *expr = (SelectStmt *) node;

	JUMBLE_NODE(distinctClause);
	JUMBLE_NODE(intoClause);
	JUMBLE_NODE(targetList);
	JUMBLE_NODE(fromClause);
	JUMBLE_NODE(whereClause);
	JUMBLE_NODE(groupClause);
	JUMBLE_FIELD(groupDistinct);
	JUMBLE_NODE(havingClause);
	JUMBLE_NODE(windowClause);
	JUMBLE_NODE(valuesLists);
	JUMBLE_NODE(sortClause);
	JUMBLE_NODE(limitOffset);
	JUMBLE_NODE(limitCount);
	JUMBLE_FIELD(limitOption);
	JUMBLE_NODE(lockingClause);
	JUMBLE_NODE(withClause);
	JUMBLE_FIELD(op);
	JUMBLE_FIELD(all);
	JUMBLE_NODE(larg);
	JUMBLE_NODE(rarg);
}

static void
_jumbleSetOperationStmt(JumbleState *jstate, Node *node)
{
	SetOperationStmt *expr = (SetOperationStmt *) node;

	JUMBLE_FIELD(op);
	JUMBLE_FIELD(all);
	JUMBLE_NODE(larg);
	JUMBLE_NODE(rarg);
}

static void
_jumbleReturnStmt(JumbleState *jstate, Node *node)
{
	ReturnStmt *expr = (ReturnStmt *) node;

	JUMBLE_NODE(returnval);
}

static void
_jumblePLAssignStmt(JumbleState *jstate, Node *node)
{
	PLAssignStmt *expr = (PLAssignStmt *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(indirection);
	JUMBLE_FIELD(nnames);
	JUMBLE_NODE(val);
}

static void
_jumbleCreateSchemaStmt(JumbleState *jstate, Node *node)
{
	CreateSchemaStmt *expr = (CreateSchemaStmt *) node;

	JUMBLE_STRING(schemaname);
	JUMBLE_NODE(authrole);
	JUMBLE_NODE(schemaElts);
	JUMBLE_FIELD(if_not_exists);
}

static void
_jumbleAlterTableStmt(JumbleState *jstate, Node *node)
{
	AlterTableStmt *expr = (AlterTableStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(cmds);
	JUMBLE_FIELD(objtype);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleReplicaIdentityStmt(JumbleState *jstate, Node *node)
{
	ReplicaIdentityStmt *expr = (ReplicaIdentityStmt *) node;

	JUMBLE_FIELD(identity_type);
	JUMBLE_STRING(name);
}

static void
_jumbleAlterTableCmd(JumbleState *jstate, Node *node)
{
	AlterTableCmd *expr = (AlterTableCmd *) node;

	JUMBLE_FIELD(subtype);
	JUMBLE_STRING(name);
	JUMBLE_FIELD(num);
	JUMBLE_NODE(newowner);
	JUMBLE_NODE(def);
	JUMBLE_FIELD(behavior);
	JUMBLE_FIELD(missing_ok);
	JUMBLE_FIELD(recurse);
}

static void
_jumbleAlterCollationStmt(JumbleState *jstate, Node *node)
{
	AlterCollationStmt *expr = (AlterCollationStmt *) node;

	JUMBLE_NODE(collname);
}

static void
_jumbleAlterDomainStmt(JumbleState *jstate, Node *node)
{
	AlterDomainStmt *expr = (AlterDomainStmt *) node;

	JUMBLE_FIELD(subtype);
	JUMBLE_NODE(typeName);
	JUMBLE_STRING(name);
	JUMBLE_NODE(def);
	JUMBLE_FIELD(behavior);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleGrantStmt(JumbleState *jstate, Node *node)
{
	GrantStmt *expr = (GrantStmt *) node;

	JUMBLE_FIELD(is_grant);
	JUMBLE_FIELD(targtype);
	JUMBLE_FIELD(objtype);
	JUMBLE_NODE(objects);
	JUMBLE_NODE(privileges);
	JUMBLE_NODE(grantees);
	JUMBLE_FIELD(grant_option);
	JUMBLE_NODE(grantor);
	JUMBLE_FIELD(behavior);
}

static void
_jumbleObjectWithArgs(JumbleState *jstate, Node *node)
{
	ObjectWithArgs *expr = (ObjectWithArgs *) node;

	JUMBLE_NODE(objname);
	JUMBLE_NODE(objargs);
	JUMBLE_NODE(objfuncargs);
	JUMBLE_FIELD(args_unspecified);
}

static void
_jumbleAccessPriv(JumbleState *jstate, Node *node)
{
	AccessPriv *expr = (AccessPriv *) node;

	JUMBLE_STRING(priv_name);
	JUMBLE_NODE(cols);
}

static void
_jumbleGrantRoleStmt(JumbleState *jstate, Node *node)
{
	GrantRoleStmt *expr = (GrantRoleStmt *) node;

	JUMBLE_NODE(granted_roles);
	JUMBLE_NODE(grantee_roles);
	JUMBLE_FIELD(is_grant);
	JUMBLE_NODE(opt);
	JUMBLE_NODE(grantor);
	JUMBLE_FIELD(behavior);
}

static void
_jumbleAlterDefaultPrivilegesStmt(JumbleState *jstate, Node *node)
{
	AlterDefaultPrivilegesStmt *expr = (AlterDefaultPrivilegesStmt *) node;

	JUMBLE_NODE(options);
	JUMBLE_NODE(action);
}

static void
_jumbleCopyStmt(JumbleState *jstate, Node *node)
{
	CopyStmt *expr = (CopyStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(query);
	JUMBLE_NODE(attlist);
	JUMBLE_FIELD(is_from);
	JUMBLE_FIELD(is_program);
	JUMBLE_STRING(filename);
	JUMBLE_NODE(options);
	JUMBLE_NODE(whereClause);
}

static void
_jumbleVariableSetStmt(JumbleState *jstate, Node *node)
{
	VariableSetStmt *expr = (VariableSetStmt *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_STRING(name);
	JUMBLE_NODE(args);
	JUMBLE_FIELD(is_local);
}

static void
_jumbleVariableShowStmt(JumbleState *jstate, Node *node)
{
	VariableShowStmt *expr = (VariableShowStmt *) node;

	JUMBLE_STRING(name);
}

static void
_jumbleCreateStmt(JumbleState *jstate, Node *node)
{
	CreateStmt *expr = (CreateStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(tableElts);
	JUMBLE_NODE(inhRelations);
	JUMBLE_NODE(partbound);
	JUMBLE_NODE(partspec);
	JUMBLE_NODE(ofTypename);
	JUMBLE_NODE(constraints);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(oncommit);
	JUMBLE_STRING(tablespacename);
	JUMBLE_STRING(accessMethod);
	JUMBLE_FIELD(if_not_exists);
}

static void
_jumbleConstraint(JumbleState *jstate, Node *node)
{
	Constraint *expr = (Constraint *) node;

	JUMBLE_FIELD(contype);
	JUMBLE_STRING(conname);
	JUMBLE_FIELD(deferrable);
	JUMBLE_FIELD(initdeferred);
	JUMBLE_FIELD(is_no_inherit);
	JUMBLE_NODE(raw_expr);
	JUMBLE_STRING(cooked_expr);
	JUMBLE_FIELD(generated_when);
	JUMBLE_FIELD(nulls_not_distinct);
	JUMBLE_NODE(keys);
	JUMBLE_NODE(including);
	JUMBLE_NODE(exclusions);
	JUMBLE_NODE(options);
	JUMBLE_STRING(indexname);
	JUMBLE_STRING(indexspace);
	JUMBLE_FIELD(reset_default_tblspc);
	JUMBLE_STRING(access_method);
	JUMBLE_NODE(where_clause);
	JUMBLE_NODE(pktable);
	JUMBLE_NODE(fk_attrs);
	JUMBLE_NODE(pk_attrs);
	JUMBLE_FIELD(fk_matchtype);
	JUMBLE_FIELD(fk_upd_action);
	JUMBLE_FIELD(fk_del_action);
	JUMBLE_NODE(fk_del_set_cols);
	JUMBLE_NODE(old_conpfeqop);
	JUMBLE_FIELD(old_pktable_oid);
	JUMBLE_FIELD(skip_validation);
	JUMBLE_FIELD(initially_valid);
}

static void
_jumbleCreateTableSpaceStmt(JumbleState *jstate, Node *node)
{
	CreateTableSpaceStmt *expr = (CreateTableSpaceStmt *) node;

	JUMBLE_STRING(tablespacename);
	JUMBLE_NODE(owner);
	JUMBLE_STRING(location);
	JUMBLE_NODE(options);
}

static void
_jumbleDropTableSpaceStmt(JumbleState *jstate, Node *node)
{
	DropTableSpaceStmt *expr = (DropTableSpaceStmt *) node;

	JUMBLE_STRING(tablespacename);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleAlterTableSpaceOptionsStmt(JumbleState *jstate, Node *node)
{
	AlterTableSpaceOptionsStmt *expr = (AlterTableSpaceOptionsStmt *) node;

	JUMBLE_STRING(tablespacename);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(isReset);
}

static void
_jumbleAlterTableMoveAllStmt(JumbleState *jstate, Node *node)
{
	AlterTableMoveAllStmt *expr = (AlterTableMoveAllStmt *) node;

	JUMBLE_STRING(orig_tablespacename);
	JUMBLE_FIELD(objtype);
	JUMBLE_NODE(roles);
	JUMBLE_STRING(new_tablespacename);
	JUMBLE_FIELD(nowait);
}

static void
_jumbleCreateExtensionStmt(JumbleState *jstate, Node *node)
{
	CreateExtensionStmt *expr = (CreateExtensionStmt *) node;

	JUMBLE_STRING(extname);
	JUMBLE_FIELD(if_not_exists);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterExtensionStmt(JumbleState *jstate, Node *node)
{
	AlterExtensionStmt *expr = (AlterExtensionStmt *) node;

	JUMBLE_STRING(extname);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterExtensionContentsStmt(JumbleState *jstate, Node *node)
{
	AlterExtensionContentsStmt *expr = (AlterExtensionContentsStmt *) node;

	JUMBLE_STRING(extname);
	JUMBLE_FIELD(action);
	JUMBLE_FIELD(objtype);
	JUMBLE_NODE(object);
}

static void
_jumbleCreateFdwStmt(JumbleState *jstate, Node *node)
{
	CreateFdwStmt *expr = (CreateFdwStmt *) node;

	JUMBLE_STRING(fdwname);
	JUMBLE_NODE(func_options);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterFdwStmt(JumbleState *jstate, Node *node)
{
	AlterFdwStmt *expr = (AlterFdwStmt *) node;

	JUMBLE_STRING(fdwname);
	JUMBLE_NODE(func_options);
	JUMBLE_NODE(options);
}

static void
_jumbleCreateForeignServerStmt(JumbleState *jstate, Node *node)
{
	CreateForeignServerStmt *expr = (CreateForeignServerStmt *) node;

	JUMBLE_STRING(servername);
	JUMBLE_STRING(servertype);
	JUMBLE_STRING(version);
	JUMBLE_STRING(fdwname);
	JUMBLE_FIELD(if_not_exists);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterForeignServerStmt(JumbleState *jstate, Node *node)
{
	AlterForeignServerStmt *expr = (AlterForeignServerStmt *) node;

	JUMBLE_STRING(servername);
	JUMBLE_STRING(version);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(has_version);
}

static void
_jumbleCreateForeignTableStmt(JumbleState *jstate, Node *node)
{
	CreateForeignTableStmt *expr = (CreateForeignTableStmt *) node;

	JUMBLE_NODE(base.relation);
	JUMBLE_NODE(base.tableElts);
	JUMBLE_NODE(base.inhRelations);
	JUMBLE_NODE(base.partbound);
	JUMBLE_NODE(base.partspec);
	JUMBLE_NODE(base.ofTypename);
	JUMBLE_NODE(base.constraints);
	JUMBLE_NODE(base.options);
	JUMBLE_FIELD(base.oncommit);
	JUMBLE_STRING(base.tablespacename);
	JUMBLE_STRING(base.accessMethod);
	JUMBLE_FIELD(base.if_not_exists);
	JUMBLE_STRING(servername);
	JUMBLE_NODE(options);
}

static void
_jumbleCreateUserMappingStmt(JumbleState *jstate, Node *node)
{
	CreateUserMappingStmt *expr = (CreateUserMappingStmt *) node;

	JUMBLE_NODE(user);
	JUMBLE_STRING(servername);
	JUMBLE_FIELD(if_not_exists);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterUserMappingStmt(JumbleState *jstate, Node *node)
{
	AlterUserMappingStmt *expr = (AlterUserMappingStmt *) node;

	JUMBLE_NODE(user);
	JUMBLE_STRING(servername);
	JUMBLE_NODE(options);
}

static void
_jumbleDropUserMappingStmt(JumbleState *jstate, Node *node)
{
	DropUserMappingStmt *expr = (DropUserMappingStmt *) node;

	JUMBLE_NODE(user);
	JUMBLE_STRING(servername);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleImportForeignSchemaStmt(JumbleState *jstate, Node *node)
{
	ImportForeignSchemaStmt *expr = (ImportForeignSchemaStmt *) node;

	JUMBLE_STRING(server_name);
	JUMBLE_STRING(remote_schema);
	JUMBLE_STRING(local_schema);
	JUMBLE_FIELD(list_type);
	JUMBLE_NODE(table_list);
	JUMBLE_NODE(options);
}

static void
_jumbleCreatePolicyStmt(JumbleState *jstate, Node *node)
{
	CreatePolicyStmt *expr = (CreatePolicyStmt *) node;

	JUMBLE_STRING(policy_name);
	JUMBLE_NODE(table);
	JUMBLE_STRING(cmd_name);
	JUMBLE_FIELD(permissive);
	JUMBLE_NODE(roles);
	JUMBLE_NODE(qual);
	JUMBLE_NODE(with_check);
}

static void
_jumbleAlterPolicyStmt(JumbleState *jstate, Node *node)
{
	AlterPolicyStmt *expr = (AlterPolicyStmt *) node;

	JUMBLE_STRING(policy_name);
	JUMBLE_NODE(table);
	JUMBLE_NODE(roles);
	JUMBLE_NODE(qual);
	JUMBLE_NODE(with_check);
}

static void
_jumbleCreateAmStmt(JumbleState *jstate, Node *node)
{
	CreateAmStmt *expr = (CreateAmStmt *) node;

	JUMBLE_STRING(amname);
	JUMBLE_NODE(handler_name);
	JUMBLE_FIELD(amtype);
}

static void
_jumbleCreateTrigStmt(JumbleState *jstate, Node *node)
{
	CreateTrigStmt *expr = (CreateTrigStmt *) node;

	JUMBLE_FIELD(replace);
	JUMBLE_FIELD(isconstraint);
	JUMBLE_STRING(trigname);
	JUMBLE_NODE(relation);
	JUMBLE_NODE(funcname);
	JUMBLE_NODE(args);
	JUMBLE_FIELD(row);
	JUMBLE_FIELD(timing);
	JUMBLE_FIELD(events);
	JUMBLE_NODE(columns);
	JUMBLE_NODE(whenClause);
	JUMBLE_NODE(transitionRels);
	JUMBLE_FIELD(deferrable);
	JUMBLE_FIELD(initdeferred);
	JUMBLE_NODE(constrrel);
}

static void
_jumbleCreateEventTrigStmt(JumbleState *jstate, Node *node)
{
	CreateEventTrigStmt *expr = (CreateEventTrigStmt *) node;

	JUMBLE_STRING(trigname);
	JUMBLE_STRING(eventname);
	JUMBLE_NODE(whenclause);
	JUMBLE_NODE(funcname);
}

static void
_jumbleAlterEventTrigStmt(JumbleState *jstate, Node *node)
{
	AlterEventTrigStmt *expr = (AlterEventTrigStmt *) node;

	JUMBLE_STRING(trigname);
	JUMBLE_FIELD(tgenabled);
}

static void
_jumbleCreatePLangStmt(JumbleState *jstate, Node *node)
{
	CreatePLangStmt *expr = (CreatePLangStmt *) node;

	JUMBLE_FIELD(replace);
	JUMBLE_STRING(plname);
	JUMBLE_NODE(plhandler);
	JUMBLE_NODE(plinline);
	JUMBLE_NODE(plvalidator);
	JUMBLE_FIELD(pltrusted);
}

static void
_jumbleCreateRoleStmt(JumbleState *jstate, Node *node)
{
	CreateRoleStmt *expr = (CreateRoleStmt *) node;

	JUMBLE_FIELD(stmt_type);
	JUMBLE_STRING(role);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterRoleStmt(JumbleState *jstate, Node *node)
{
	AlterRoleStmt *expr = (AlterRoleStmt *) node;

	JUMBLE_NODE(role);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(action);
}

static void
_jumbleAlterRoleSetStmt(JumbleState *jstate, Node *node)
{
	AlterRoleSetStmt *expr = (AlterRoleSetStmt *) node;

	JUMBLE_NODE(role);
	JUMBLE_STRING(database);
	JUMBLE_NODE(setstmt);
}

static void
_jumbleDropRoleStmt(JumbleState *jstate, Node *node)
{
	DropRoleStmt *expr = (DropRoleStmt *) node;

	JUMBLE_NODE(roles);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleCreateSeqStmt(JumbleState *jstate, Node *node)
{
	CreateSeqStmt *expr = (CreateSeqStmt *) node;

	JUMBLE_NODE(sequence);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(ownerId);
	JUMBLE_FIELD(for_identity);
	JUMBLE_FIELD(if_not_exists);
}

static void
_jumbleAlterSeqStmt(JumbleState *jstate, Node *node)
{
	AlterSeqStmt *expr = (AlterSeqStmt *) node;

	JUMBLE_NODE(sequence);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(for_identity);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleDefineStmt(JumbleState *jstate, Node *node)
{
	DefineStmt *expr = (DefineStmt *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_FIELD(oldstyle);
	JUMBLE_NODE(defnames);
	JUMBLE_NODE(args);
	JUMBLE_NODE(definition);
	JUMBLE_FIELD(if_not_exists);
	JUMBLE_FIELD(replace);
}

static void
_jumbleCreateDomainStmt(JumbleState *jstate, Node *node)
{
	CreateDomainStmt *expr = (CreateDomainStmt *) node;

	JUMBLE_NODE(domainname);
	JUMBLE_NODE(typeName);
	JUMBLE_NODE(collClause);
	JUMBLE_NODE(constraints);
}

static void
_jumbleCreateOpClassStmt(JumbleState *jstate, Node *node)
{
	CreateOpClassStmt *expr = (CreateOpClassStmt *) node;

	JUMBLE_NODE(opclassname);
	JUMBLE_NODE(opfamilyname);
	JUMBLE_STRING(amname);
	JUMBLE_NODE(datatype);
	JUMBLE_NODE(items);
	JUMBLE_FIELD(isDefault);
}

static void
_jumbleCreateOpClassItem(JumbleState *jstate, Node *node)
{
	CreateOpClassItem *expr = (CreateOpClassItem *) node;

	JUMBLE_FIELD(itemtype);
	JUMBLE_NODE(name);
	JUMBLE_FIELD(number);
	JUMBLE_NODE(order_family);
	JUMBLE_NODE(class_args);
	JUMBLE_NODE(storedtype);
}

static void
_jumbleCreateOpFamilyStmt(JumbleState *jstate, Node *node)
{
	CreateOpFamilyStmt *expr = (CreateOpFamilyStmt *) node;

	JUMBLE_NODE(opfamilyname);
	JUMBLE_STRING(amname);
}

static void
_jumbleAlterOpFamilyStmt(JumbleState *jstate, Node *node)
{
	AlterOpFamilyStmt *expr = (AlterOpFamilyStmt *) node;

	JUMBLE_NODE(opfamilyname);
	JUMBLE_STRING(amname);
	JUMBLE_FIELD(isDrop);
	JUMBLE_NODE(items);
}

static void
_jumbleDropStmt(JumbleState *jstate, Node *node)
{
	DropStmt *expr = (DropStmt *) node;

	JUMBLE_NODE(objects);
	JUMBLE_FIELD(removeType);
	JUMBLE_FIELD(behavior);
	JUMBLE_FIELD(missing_ok);
	JUMBLE_FIELD(concurrent);
}

static void
_jumbleTruncateStmt(JumbleState *jstate, Node *node)
{
	TruncateStmt *expr = (TruncateStmt *) node;

	JUMBLE_NODE(relations);
	JUMBLE_FIELD(restart_seqs);
	JUMBLE_FIELD(behavior);
}

static void
_jumbleCommentStmt(JumbleState *jstate, Node *node)
{
	CommentStmt *expr = (CommentStmt *) node;

	JUMBLE_FIELD(objtype);
	JUMBLE_NODE(object);
	JUMBLE_STRING(comment);
}

static void
_jumbleSecLabelStmt(JumbleState *jstate, Node *node)
{
	SecLabelStmt *expr = (SecLabelStmt *) node;

	JUMBLE_FIELD(objtype);
	JUMBLE_NODE(object);
	JUMBLE_STRING(provider);
	JUMBLE_STRING(label);
}

static void
_jumbleDeclareCursorStmt(JumbleState *jstate, Node *node)
{
	DeclareCursorStmt *expr = (DeclareCursorStmt *) node;

	JUMBLE_STRING(portalname);
	JUMBLE_FIELD(options);
	JUMBLE_NODE(query);
}

static void
_jumbleClosePortalStmt(JumbleState *jstate, Node *node)
{
	ClosePortalStmt *expr = (ClosePortalStmt *) node;

	JUMBLE_STRING(portalname);
}

static void
_jumbleFetchStmt(JumbleState *jstate, Node *node)
{
	FetchStmt *expr = (FetchStmt *) node;

	JUMBLE_FIELD(direction);
	JUMBLE_FIELD(howMany);
	JUMBLE_STRING(portalname);
	JUMBLE_FIELD(ismove);
}

static void
_jumbleIndexStmt(JumbleState *jstate, Node *node)
{
	IndexStmt *expr = (IndexStmt *) node;

	JUMBLE_STRING(idxname);
	JUMBLE_NODE(relation);
	JUMBLE_STRING(accessMethod);
	JUMBLE_STRING(tableSpace);
	JUMBLE_NODE(indexParams);
	JUMBLE_NODE(indexIncludingParams);
	JUMBLE_NODE(options);
	JUMBLE_NODE(whereClause);
	JUMBLE_NODE(excludeOpNames);
	JUMBLE_STRING(idxcomment);
	JUMBLE_FIELD(indexOid);
	JUMBLE_FIELD(oldNumber);
	JUMBLE_FIELD(oldCreateSubid);
	JUMBLE_FIELD(oldFirstRelfilelocatorSubid);
	JUMBLE_FIELD(unique);
	JUMBLE_FIELD(nulls_not_distinct);
	JUMBLE_FIELD(primary);
	JUMBLE_FIELD(isconstraint);
	JUMBLE_FIELD(deferrable);
	JUMBLE_FIELD(initdeferred);
	JUMBLE_FIELD(transformed);
	JUMBLE_FIELD(concurrent);
	JUMBLE_FIELD(if_not_exists);
	JUMBLE_FIELD(reset_default_tblspc);
}

static void
_jumbleCreateStatsStmt(JumbleState *jstate, Node *node)
{
	CreateStatsStmt *expr = (CreateStatsStmt *) node;

	JUMBLE_NODE(defnames);
	JUMBLE_NODE(stat_types);
	JUMBLE_NODE(exprs);
	JUMBLE_NODE(relations);
	JUMBLE_STRING(stxcomment);
	JUMBLE_FIELD(transformed);
	JUMBLE_FIELD(if_not_exists);
}

static void
_jumbleStatsElem(JumbleState *jstate, Node *node)
{
	StatsElem *expr = (StatsElem *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(expr);
}

static void
_jumbleAlterStatsStmt(JumbleState *jstate, Node *node)
{
	AlterStatsStmt *expr = (AlterStatsStmt *) node;

	JUMBLE_NODE(defnames);
	JUMBLE_FIELD(stxstattarget);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleCreateFunctionStmt(JumbleState *jstate, Node *node)
{
	CreateFunctionStmt *expr = (CreateFunctionStmt *) node;

	JUMBLE_FIELD(is_procedure);
	JUMBLE_FIELD(replace);
	JUMBLE_NODE(funcname);
	JUMBLE_NODE(parameters);
	JUMBLE_NODE(returnType);
	JUMBLE_NODE(options);
	JUMBLE_NODE(sql_body);
}

static void
_jumbleFunctionParameter(JumbleState *jstate, Node *node)
{
	FunctionParameter *expr = (FunctionParameter *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(argType);
	JUMBLE_FIELD(mode);
	JUMBLE_NODE(defexpr);
}

static void
_jumbleAlterFunctionStmt(JumbleState *jstate, Node *node)
{
	AlterFunctionStmt *expr = (AlterFunctionStmt *) node;

	JUMBLE_FIELD(objtype);
	JUMBLE_NODE(func);
	JUMBLE_NODE(actions);
}

static void
_jumbleDoStmt(JumbleState *jstate, Node *node)
{
	DoStmt *expr = (DoStmt *) node;

	JUMBLE_NODE(args);
}

static void
_jumbleCallStmt(JumbleState *jstate, Node *node)
{
	CallStmt *expr = (CallStmt *) node;

	JUMBLE_NODE(funccall);
}

static void
_jumbleRenameStmt(JumbleState *jstate, Node *node)
{
	RenameStmt *expr = (RenameStmt *) node;

	JUMBLE_FIELD(renameType);
	JUMBLE_FIELD(relationType);
	JUMBLE_NODE(relation);
	JUMBLE_NODE(object);
	JUMBLE_STRING(subname);
	JUMBLE_STRING(newname);
	JUMBLE_FIELD(behavior);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleAlterObjectDependsStmt(JumbleState *jstate, Node *node)
{
	AlterObjectDependsStmt *expr = (AlterObjectDependsStmt *) node;

	JUMBLE_FIELD(objectType);
	JUMBLE_NODE(relation);
	JUMBLE_NODE(object);
	JUMBLE_NODE(extname);
	JUMBLE_FIELD(remove);
}

static void
_jumbleAlterObjectSchemaStmt(JumbleState *jstate, Node *node)
{
	AlterObjectSchemaStmt *expr = (AlterObjectSchemaStmt *) node;

	JUMBLE_FIELD(objectType);
	JUMBLE_NODE(relation);
	JUMBLE_NODE(object);
	JUMBLE_STRING(newschema);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumbleAlterOwnerStmt(JumbleState *jstate, Node *node)
{
	AlterOwnerStmt *expr = (AlterOwnerStmt *) node;

	JUMBLE_FIELD(objectType);
	JUMBLE_NODE(relation);
	JUMBLE_NODE(object);
	JUMBLE_NODE(newowner);
}

static void
_jumbleAlterOperatorStmt(JumbleState *jstate, Node *node)
{
	AlterOperatorStmt *expr = (AlterOperatorStmt *) node;

	JUMBLE_NODE(opername);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterTypeStmt(JumbleState *jstate, Node *node)
{
	AlterTypeStmt *expr = (AlterTypeStmt *) node;

	JUMBLE_NODE(typeName);
	JUMBLE_NODE(options);
}

static void
_jumbleRuleStmt(JumbleState *jstate, Node *node)
{
	RuleStmt *expr = (RuleStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_STRING(rulename);
	JUMBLE_NODE(whereClause);
	JUMBLE_FIELD(event);
	JUMBLE_FIELD(instead);
	JUMBLE_NODE(actions);
	JUMBLE_FIELD(replace);
}

static void
_jumbleNotifyStmt(JumbleState *jstate, Node *node)
{
	NotifyStmt *expr = (NotifyStmt *) node;

	JUMBLE_STRING(conditionname);
	JUMBLE_STRING(payload);
}

static void
_jumbleListenStmt(JumbleState *jstate, Node *node)
{
	ListenStmt *expr = (ListenStmt *) node;

	JUMBLE_STRING(conditionname);
}

static void
_jumbleUnlistenStmt(JumbleState *jstate, Node *node)
{
	UnlistenStmt *expr = (UnlistenStmt *) node;

	JUMBLE_STRING(conditionname);
}

static void
_jumbleTransactionStmt(JumbleState *jstate, Node *node)
{
	TransactionStmt *expr = (TransactionStmt *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_NODE(options);
	JUMBLE_STRING(savepoint_name);
	JUMBLE_STRING(gid);
	JUMBLE_FIELD(chain);
}

static void
_jumbleCompositeTypeStmt(JumbleState *jstate, Node *node)
{
	CompositeTypeStmt *expr = (CompositeTypeStmt *) node;

	JUMBLE_NODE(typevar);
	JUMBLE_NODE(coldeflist);
}

static void
_jumbleCreateEnumStmt(JumbleState *jstate, Node *node)
{
	CreateEnumStmt *expr = (CreateEnumStmt *) node;

	JUMBLE_NODE(typeName);
	JUMBLE_NODE(vals);
}

static void
_jumbleCreateRangeStmt(JumbleState *jstate, Node *node)
{
	CreateRangeStmt *expr = (CreateRangeStmt *) node;

	JUMBLE_NODE(typeName);
	JUMBLE_NODE(params);
}

static void
_jumbleAlterEnumStmt(JumbleState *jstate, Node *node)
{
	AlterEnumStmt *expr = (AlterEnumStmt *) node;

	JUMBLE_NODE(typeName);
	JUMBLE_STRING(oldVal);
	JUMBLE_STRING(newVal);
	JUMBLE_STRING(newValNeighbor);
	JUMBLE_FIELD(newValIsAfter);
	JUMBLE_FIELD(skipIfNewValExists);
}

static void
_jumbleViewStmt(JumbleState *jstate, Node *node)
{
	ViewStmt *expr = (ViewStmt *) node;

	JUMBLE_NODE(view);
	JUMBLE_NODE(aliases);
	JUMBLE_NODE(query);
	JUMBLE_FIELD(replace);
	JUMBLE_NODE(options);
	JUMBLE_FIELD(withCheckOption);
}

static void
_jumbleLoadStmt(JumbleState *jstate, Node *node)
{
	LoadStmt *expr = (LoadStmt *) node;

	JUMBLE_STRING(filename);
}

static void
_jumbleCreatedbStmt(JumbleState *jstate, Node *node)
{
	CreatedbStmt *expr = (CreatedbStmt *) node;

	JUMBLE_STRING(dbname);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterDatabaseStmt(JumbleState *jstate, Node *node)
{
	AlterDatabaseStmt *expr = (AlterDatabaseStmt *) node;

	JUMBLE_STRING(dbname);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterDatabaseRefreshCollStmt(JumbleState *jstate, Node *node)
{
	AlterDatabaseRefreshCollStmt *expr = (AlterDatabaseRefreshCollStmt *) node;

	JUMBLE_STRING(dbname);
}

static void
_jumbleAlterDatabaseSetStmt(JumbleState *jstate, Node *node)
{
	AlterDatabaseSetStmt *expr = (AlterDatabaseSetStmt *) node;

	JUMBLE_STRING(dbname);
	JUMBLE_NODE(setstmt);
}

static void
_jumbleDropdbStmt(JumbleState *jstate, Node *node)
{
	DropdbStmt *expr = (DropdbStmt *) node;

	JUMBLE_STRING(dbname);
	JUMBLE_FIELD(missing_ok);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterSystemStmt(JumbleState *jstate, Node *node)
{
	AlterSystemStmt *expr = (AlterSystemStmt *) node;

	JUMBLE_NODE(setstmt);
}

static void
_jumbleClusterStmt(JumbleState *jstate, Node *node)
{
	ClusterStmt *expr = (ClusterStmt *) node;

	JUMBLE_NODE(relation);
	JUMBLE_STRING(indexname);
	JUMBLE_NODE(params);
}

static void
_jumbleVacuumStmt(JumbleState *jstate, Node *node)
{
	VacuumStmt *expr = (VacuumStmt *) node;

	JUMBLE_NODE(options);
	JUMBLE_NODE(rels);
	JUMBLE_FIELD(is_vacuumcmd);
}

static void
_jumbleVacuumRelation(JumbleState *jstate, Node *node)
{
	VacuumRelation *expr = (VacuumRelation *) node;

	JUMBLE_NODE(relation);
	JUMBLE_FIELD(oid);
	JUMBLE_NODE(va_cols);
}

static void
_jumbleExplainStmt(JumbleState *jstate, Node *node)
{
	ExplainStmt *expr = (ExplainStmt *) node;

	JUMBLE_NODE(query);
	JUMBLE_NODE(options);
}

static void
_jumbleCreateTableAsStmt(JumbleState *jstate, Node *node)
{
	CreateTableAsStmt *expr = (CreateTableAsStmt *) node;

	JUMBLE_NODE(query);
	JUMBLE_NODE(into);
	JUMBLE_FIELD(objtype);
	JUMBLE_FIELD(is_select_into);
	JUMBLE_FIELD(if_not_exists);
}

static void
_jumbleRefreshMatViewStmt(JumbleState *jstate, Node *node)
{
	RefreshMatViewStmt *expr = (RefreshMatViewStmt *) node;

	JUMBLE_FIELD(concurrent);
	JUMBLE_FIELD(skipData);
	JUMBLE_NODE(relation);
}

static void
_jumbleCheckPointStmt(JumbleState *jstate, Node *node)
{
	CheckPointStmt *expr = (CheckPointStmt *) node;

	(void) expr;
}

static void
_jumbleDiscardStmt(JumbleState *jstate, Node *node)
{
	DiscardStmt *expr = (DiscardStmt *) node;

	JUMBLE_FIELD(target);
}

static void
_jumbleLockStmt(JumbleState *jstate, Node *node)
{
	LockStmt *expr = (LockStmt *) node;

	JUMBLE_NODE(relations);
	JUMBLE_FIELD(mode);
	JUMBLE_FIELD(nowait);
}

static void
_jumbleConstraintsSetStmt(JumbleState *jstate, Node *node)
{
	ConstraintsSetStmt *expr = (ConstraintsSetStmt *) node;

	JUMBLE_NODE(constraints);
	JUMBLE_FIELD(deferred);
}

static void
_jumbleReindexStmt(JumbleState *jstate, Node *node)
{
	ReindexStmt *expr = (ReindexStmt *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_NODE(relation);
	JUMBLE_STRING(name);
	JUMBLE_NODE(params);
}

static void
_jumbleCreateConversionStmt(JumbleState *jstate, Node *node)
{
	CreateConversionStmt *expr = (CreateConversionStmt *) node;

	JUMBLE_NODE(conversion_name);
	JUMBLE_STRING(for_encoding_name);
	JUMBLE_STRING(to_encoding_name);
	JUMBLE_NODE(func_name);
	JUMBLE_FIELD(def);
}

static void
_jumbleCreateCastStmt(JumbleState *jstate, Node *node)
{
	CreateCastStmt *expr = (CreateCastStmt *) node;

	JUMBLE_NODE(sourcetype);
	JUMBLE_NODE(targettype);
	JUMBLE_NODE(func);
	JUMBLE_FIELD(context);
	JUMBLE_FIELD(inout);
}

static void
_jumbleCreateTransformStmt(JumbleState *jstate, Node *node)
{
	CreateTransformStmt *expr = (CreateTransformStmt *) node;

	JUMBLE_FIELD(replace);
	JUMBLE_NODE(type_name);
	JUMBLE_STRING(lang);
	JUMBLE_NODE(fromsql);
	JUMBLE_NODE(tosql);
}

static void
_jumblePrepareStmt(JumbleState *jstate, Node *node)
{
	PrepareStmt *expr = (PrepareStmt *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(argtypes);
	JUMBLE_NODE(query);
}

static void
_jumbleExecuteStmt(JumbleState *jstate, Node *node)
{
	ExecuteStmt *expr = (ExecuteStmt *) node;

	JUMBLE_STRING(name);
	JUMBLE_NODE(params);
}

static void
_jumbleDeallocateStmt(JumbleState *jstate, Node *node)
{
	DeallocateStmt *expr = (DeallocateStmt *) node;

	JUMBLE_STRING(name);
}

static void
_jumbleDropOwnedStmt(JumbleState *jstate, Node *node)
{
	DropOwnedStmt *expr = (DropOwnedStmt *) node;

	JUMBLE_NODE(roles);
	JUMBLE_FIELD(behavior);
}

static void
_jumbleReassignOwnedStmt(JumbleState *jstate, Node *node)
{
	ReassignOwnedStmt *expr = (ReassignOwnedStmt *) node;

	JUMBLE_NODE(roles);
	JUMBLE_NODE(newrole);
}

static void
_jumbleAlterTSDictionaryStmt(JumbleState *jstate, Node *node)
{
	AlterTSDictionaryStmt *expr = (AlterTSDictionaryStmt *) node;

	JUMBLE_NODE(dictname);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterTSConfigurationStmt(JumbleState *jstate, Node *node)
{
	AlterTSConfigurationStmt *expr = (AlterTSConfigurationStmt *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_NODE(cfgname);
	JUMBLE_NODE(tokentype);
	JUMBLE_NODE(dicts);
	JUMBLE_FIELD(override);
	JUMBLE_FIELD(replace);
	JUMBLE_FIELD(missing_ok);
}

static void
_jumblePublicationTable(JumbleState *jstate, Node *node)
{
	PublicationTable *expr = (PublicationTable *) node;

	JUMBLE_NODE(relation);
	JUMBLE_NODE(whereClause);
	JUMBLE_NODE(columns);
}

static void
_jumblePublicationObjSpec(JumbleState *jstate, Node *node)
{
	PublicationObjSpec *expr = (PublicationObjSpec *) node;

	JUMBLE_FIELD(pubobjtype);
	JUMBLE_STRING(name);
	JUMBLE_NODE(pubtable);
}

static void
_jumbleCreatePublicationStmt(JumbleState *jstate, Node *node)
{
	CreatePublicationStmt *expr = (CreatePublicationStmt *) node;

	JUMBLE_STRING(pubname);
	JUMBLE_NODE(options);
	JUMBLE_NODE(pubobjects);
	JUMBLE_FIELD(for_all_tables);
}

static void
_jumbleAlterPublicationStmt(JumbleState *jstate, Node *node)
{
	AlterPublicationStmt *expr = (AlterPublicationStmt *) node;

	JUMBLE_STRING(pubname);
	JUMBLE_NODE(options);
	JUMBLE_NODE(pubobjects);
	JUMBLE_FIELD(for_all_tables);
	JUMBLE_FIELD(action);
}

static void
_jumbleCreateSubscriptionStmt(JumbleState *jstate, Node *node)
{
	CreateSubscriptionStmt *expr = (CreateSubscriptionStmt *) node;

	JUMBLE_STRING(subname);
	JUMBLE_STRING(conninfo);
	JUMBLE_NODE(publication);
	JUMBLE_NODE(options);
}

static void
_jumbleAlterSubscriptionStmt(JumbleState *jstate, Node *node)
{
	AlterSubscriptionStmt *expr = (AlterSubscriptionStmt *) node;

	JUMBLE_FIELD(kind);
	JUMBLE_STRING(subname);
	JUMBLE_STRING(conninfo);
	JUMBLE_NODE(publication);
	JUMBLE_NODE(options);
}

static void
_jumbleDropSubscriptionStmt(JumbleState *jstate, Node *node)
{
	DropSubscriptionStmt *expr = (DropSubscriptionStmt *) node;

	JUMBLE_STRING(subname);
	JUMBLE_FIELD(missing_ok);
	JUMBLE_FIELD(behavior);
}

static void
_jumbleExtensibleNode(JumbleState *jstate, Node *node)
{
	ExtensibleNode *expr = (ExtensibleNode *) node;

	JUMBLE_STRING(extnodename);
}

static void
_jumbleInteger(JumbleState *jstate, Node *node)
{
	Integer *expr = (Integer *) node;

	JUMBLE_FIELD(ival);
}

static void
_jumbleFloat(JumbleState *jstate, Node *node)
{
	Float *expr = (Float *) node;

	JUMBLE_STRING(fval);
}

static void
_jumbleBoolean(JumbleState *jstate, Node *node)
{
	Boolean *expr = (Boolean *) node;

	JUMBLE_FIELD(boolval);
}

static void
_jumbleString(JumbleState *jstate, Node *node)
{
	String *expr = (String *) node;

	JUMBLE_STRING(sval);
}

static void
_jumbleBitString(JumbleState *jstate, Node *node)
{
	BitString *expr = (BitString *) node;

	JUMBLE_STRING(bsval);
}
