/***********************************************************************
*
* psinfo.h
*
* psinfo: process info
*
* Copyright (C) 2008 Ward van Wanrooij <ward@ward.nu>
*
* This software may be distributed according to the terms of the GNU
* General Public License, version 2 or (at your option) any later
* version.
*
***********************************************************************/

/*
g general
m memory usage
p cpu usage
s signals
c privilege
i io
_ skipped

? = might not be defined in all kernels
*/

struct process_info {
	int pid;			//g stat: process id
	int ppid;			//g stat: process id of the parent process
	int pgrp;			//g stat: pgrp of the process
	int sid;			//g stat: session id
	int tty_nr;			//g stat: tty the process uses
	int tty_pgrp;			//_ stat: pgrp of the tty
	int num_threads;		//g stat: number of threads
	int exit_signal;		//_ stat: signal to send to parent thread on exit 
	int task_cpu;			//g stat: which CPU the task is scheduled on
	char tcomm[1024];		//g stat: filename of the executable
	char state;			//g stat: state (R is running, S is sleeping, D is sleeping in an uninterruptible wait, Z is zombie, T is traced or stopped)
	long unsigned min_flt;		//m stat: number of minor faults
	long unsigned cmin_flt;		//m stat: number of minor faults with child's
	long unsigned maj_flt;		//m stat: number of major faults
	long unsigned cmaj_flt;		//m stat: number of major faults with child's
	long unsigned utime;		//p rrstat: user mode jiffies
	long unsigned stime;		//p stat: kernel mode jiffies
	long unsigned gtime;		//p? stat: guest
	int has_gtime;
	long unsigned vsize;		//_ stat: virtual memory size
	long unsigned rlim;		//_ stat: current limit in bytes on the rss
	long unsigned start_code;	//_ stat: address above which program text can run
	long unsigned end_code;		//_ stat: address below which program text can run
	long unsigned start_stack;	//_ stat: address of the start of the stack
	long unsigned esp;		//_ stat: current value of ESP
	long unsigned eip;		//_ stat: current value of EIP
	long unsigned wchan;		//g stat: address where process went to sleep
	char wchan_decoded[1024];	//g? wchan: name of the kernel function in which the process is sleeping
	long nice;			//p stat:
	long cutime;			//p stat: user mode jiffies with child's
	long cstime;			//p stat: kernel mode jiffies with child's
	long cgtime;			//p? stat: guest
	long priority;			//p stat: priority level
	long rss;			//m stat: resident set memory size
	long long unsigned start_time;	//g stat: time the process started after system boot
	long long unsigned blkio_ticks;	//i? stat: time spent waiting for block IO
	int has_blkio_ticks;
	unsigned int rt_priority;	//p stat: realtime priority
	unsigned int policy;		//p stat: scheduling policy (man sched_setscheduler)
	unsigned int flags;		//g stat: task flags
	int vmsizep;			//_ statm: total program size (pages)
	int vmresidentp;		//_ statm: size of memory portions (pages)
	int vmsharedp;			//_ statm: number of pages that are shared
	int sleepavg;			//g status
	int tracerpid;			//g status
	int uid;			//c status: real user id
	int euid;			//c status: effective user id
	int suid;			//c status: saved user id
	int fsuid;			//c status: file system user id
	int gid;			//c status: real group id
	int egid;			//c status: effective group id
	int sgid;			//c status: saved group id
	int fsgid;			//c status: file system group id
	int fdsize;			//i status: size of file descriptor table
	long unsigned vmpeak;		//m? status: 
	int has_vmpeak;
	long unsigned vmsize;		//m status:
	long unsigned vmlck;		//m status:
	long unsigned vmhwm;		//m? status:
	int has_vmhwm;
	long unsigned vmrss;		//m status:
	long unsigned vmdata;		//m status:
	long unsigned vmstk;		//m status:
	long unsigned vmexe;		//m status:
	long unsigned vmlib;		//m status:
	long unsigned vmpte;		//m? status:
	int has_vmpte;
	long unsigned sigqsize;		//s? status: signal queue size
	int has_sigq;
	long unsigned sigqlim;		//s? status: signal queue limit
	long unsigned sigpending;	//s status: pending signals
	long unsigned sigshpending;	//s status: pending shared signals
	long unsigned sigblocked;	//s status: blocked signals
	long unsigned sigignored;	//s status: ignored signals
	long unsigned sigcaught;	//s status: caught signals        
	long unsigned capinh;		//c status: inheritable capabilities
	long unsigned capprm;		//c status: permitted capabilities
	long unsigned capeff;		//c status: effective capabilities
	long unsigned capbnd;		//c? status: capability bounding set
	int has_capbnd;
	char **argv;			//g cmdline: command line arguments
	char *cwd;			//g? cwd: current working directory
	char **env;			//g? environ: environment
	char *root;			//g? root: (ch)root directory
	char *exe;			//g? exe: executable
	int has_io;
	long long unsigned rchar;	//i? io: chars read
	long long unsigned wchar;	//i? io: chars written
	long long unsigned syscr;	//i? io: number of read syscalls
	long long unsigned syscw;	//i? io: number of write syscalls
	long long unsigned read_bytes;	//i? io: bytes read
	long long unsigned write_bytes;	//i? io: bytes written
	long long unsigned cancelled_write_bytes;	//i? io: bytes written cancelled
	int has_oom_score;
	int oom_score;				//m? oom_score: out-of-memory killer score
	int has_oom_adj;
	int oom_adj;				//m? oom_adj: out-ouf-memory killer adjustment
	int has_schedstat;
	long long unsigned run_ticks;	//_? schedstat: time spent on the cpu
	long long unsigned wait_ticks;	//_? schedstat: time spent waiting on a runqueue
	long long unsigned nran;	//p? schedstat: # of times run on this cpu
	int *threads;			//g task: pids of threads
};

int main(int argc, char **argv);

int parse_proc_io(FILE * f, struct process_info *p);
int parse_proc_oomscore(FILE * f, struct process_info *p);
int parse_proc_oomadj(FILE * f, struct process_info *p);
int parse_proc_schedstat(FILE * f, struct process_info *p);
int parse_proc_stat(FILE * f, struct process_info *p);
int parse_proc_statm(FILE * f, struct process_info *p);
int parse_proc_capbnd(FILE * f, struct process_info *p);
int parse_proc_status(FILE * f, struct process_info *p);
int parse_proc_wchan(FILE * f, struct process_info *p);

int parse_proc_arrayfile(char *name, char ***s);
int parse_proc_file(char *name, struct process_info *p, int (*process) (FILE * f, struct process_info * p));
int parse_proc_symlink(char *name, char **s);
int parse_proc_task(char *name, int **s);
int parse_proc(char *base, int pid, struct process_info *p);

int tty_dev_to_name(unsigned int major, unsigned int minor, char *buf, int bufsize);

void print_general(struct process_info *p);
void print_processflags(char *desc, long unsigned flags);
void print_cpu(struct process_info *p);
void print_io(struct process_info *p);
void print_memory(struct process_info *p);
void print_privilege(struct process_info *p);
void print_capability(char *desc, long unsigned cap);
void print_signal(struct process_info *p);
void print_sigset(char *desc, long unsigned sigset);
void print_help(void);

#define KERNEL_HZ sysconf(_SC_CLK_TCK)
