/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public abstract class SenderService
implements InferenceService {
    protected static final Set<TaskType> COMPLETION_ONLY = EnumSet.of(TaskType.COMPLETION, TaskType.ANY);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public SenderService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        Objects.requireNonNull(factory);
        this.sender = factory.createSender();
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    public Sender getSender() {
        return this.sender;
    }

    protected ServiceComponents getServiceComponents() {
        return this.serviceComponents;
    }

    public void infer(Model model, @Nullable String query, List<String> input, boolean stream, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        this.init();
        InferenceInputs inferenceInput = SenderService.createInput(model, input, query, stream);
        this.doInfer(model, inferenceInput, taskSettings, inputType, timeout, listener);
    }

    private static InferenceInputs createInput(Model model, List<String> input, @Nullable String query, boolean stream) {
        return switch (model.getTaskType()) {
            case TaskType.COMPLETION, TaskType.CHAT_COMPLETION -> new ChatCompletionInput(input, stream);
            case TaskType.RERANK -> new QueryAndDocsInputs(query, input, stream);
            case TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING -> new DocumentsOnlyInput(input, stream);
            default -> throw new ElasticsearchStatusException(Strings.format((String)"Invalid task type received when determining input type: [%s]", (Object[])new Object[]{model.getTaskType().toString()}), RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    public void unifiedCompletionInfer(Model model, UnifiedCompletionRequest request, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        this.init();
        this.doUnifiedCompletionInfer(model, new UnifiedChatInput(request, true), timeout, listener);
    }

    public void chunkedInfer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        this.init();
        this.doChunkedInfer(model, new DocumentsOnlyInput(input), taskSettings, inputType, timeout, listener);
    }

    protected abstract void doInfer(Model var1, InferenceInputs var2, Map<String, Object> var3, InputType var4, TimeValue var5, ActionListener<InferenceServiceResults> var6);

    protected abstract void doUnifiedCompletionInfer(Model var1, UnifiedChatInput var2, TimeValue var3, ActionListener<InferenceServiceResults> var4);

    protected abstract void doChunkedInfer(Model var1, DocumentsOnlyInput var2, Map<String, Object> var3, InputType var4, TimeValue var5, ActionListener<List<ChunkedInference>> var6);

    public void start(Model model, ActionListener<Boolean> listener) {
        this.init();
        this.doStart(model, listener);
    }

    public void start(Model model, @Nullable TimeValue unused, ActionListener<Boolean> listener) {
        this.start(model, listener);
    }

    protected void doStart(Model model, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    private void init() {
        this.sender.start();
    }

    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.sender);
    }
}

