/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.inference.results.ChunkedInferenceEmbeddingSparse;
import org.elasticsearch.xpack.core.inference.results.ChunkedInferenceError;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.elastic.ElasticInferenceServiceActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.ElasticInferenceServiceUnifiedCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elastic.DefaultModelConfig;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceExecutableActionModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationHandler;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationRequestHandler;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionModel;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceService
extends SenderService {
    public static final String NAME = "elastic";
    public static final String ELASTIC_INFERENCE_SERVICE_IDENTIFIER = "Elastic Inference Service";
    private static final EnumSet<TaskType> IMPLEMENTED_TASK_TYPES = EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.CHAT_COMPLETION);
    private static final String SERVICE_NAME = "Elastic";
    static final String DEFAULT_CHAT_COMPLETION_MODEL_ID_V1 = "rainbow-sprinkles";
    static final String DEFAULT_CHAT_COMPLETION_ENDPOINT_ID_V1 = Strings.format((String)".%s-elastic", (Object[])new Object[]{"rainbow-sprinkles"});
    private static final EnumSet<TaskType> SUPPORTED_INFERENCE_ACTION_TASK_TYPES = EnumSet.of(TaskType.SPARSE_EMBEDDING);
    private final ElasticInferenceServiceComponents elasticInferenceServiceComponents;
    private final ElasticInferenceServiceAuthorizationHandler authorizationHandler;

    public static String defaultEndpointId(String modelId) {
        return Strings.format((String)".%s-elastic", (Object[])new Object[]{modelId});
    }

    public ElasticInferenceService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, ElasticInferenceServiceSettings elasticInferenceServiceSettings, ModelRegistry modelRegistry, ElasticInferenceServiceAuthorizationRequestHandler authorizationRequestHandler) {
        super(factory, serviceComponents);
        this.elasticInferenceServiceComponents = new ElasticInferenceServiceComponents(elasticInferenceServiceSettings.getElasticInferenceServiceUrl());
        this.authorizationHandler = new ElasticInferenceServiceAuthorizationHandler(serviceComponents, modelRegistry, authorizationRequestHandler, ElasticInferenceService.initDefaultEndpoints(this.elasticInferenceServiceComponents), IMPLEMENTED_TASK_TYPES, this, this.getSender(), elasticInferenceServiceSettings);
    }

    private static Map<String, DefaultModelConfig> initDefaultEndpoints(ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        return Map.of(DEFAULT_CHAT_COMPLETION_MODEL_ID_V1, new DefaultModelConfig(new ElasticInferenceServiceCompletionModel(DEFAULT_CHAT_COMPLETION_ENDPOINT_ID_V1, TaskType.CHAT_COMPLETION, NAME, new ElasticInferenceServiceCompletionServiceSettings(DEFAULT_CHAT_COMPLETION_MODEL_ID_V1, null), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents), MinimalServiceSettings.chatCompletion()));
    }

    public void onNodeStarted() {
        this.authorizationHandler.init();
    }

    public void waitForFirstAuthorizationToComplete(TimeValue waitTime) {
        this.authorizationHandler.waitForAuthorizationToComplete(waitTime);
    }

    public Set<TaskType> supportedStreamingTasks() {
        return this.authorizationHandler.supportedStreamingTasks();
    }

    public List<InferenceService.DefaultConfigId> defaultConfigIds() {
        return this.authorizationHandler.defaultConfigIds();
    }

    public void defaultConfigs(ActionListener<List<Model>> defaultsListener) {
        this.authorizationHandler.defaultConfigs(defaultsListener);
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof ElasticInferenceServiceCompletionModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        TraceContext currentTraceInfo = this.getCurrentTraceInfo();
        ElasticInferenceServiceCompletionModel completionModel = (ElasticInferenceServiceCompletionModel)model;
        ElasticInferenceServiceCompletionModel overriddenModel = ElasticInferenceServiceCompletionModel.of(completionModel, inputs.getRequest());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(String.format(Locale.ROOT, "%s completions", ELASTIC_INFERENCE_SERVICE_IDENTIFIER));
        ElasticInferenceServiceUnifiedCompletionRequestManager requestManager = ElasticInferenceServiceUnifiedCompletionRequestManager.of(overriddenModel, this.getServiceComponents().threadPool(), currentTraceInfo);
        SenderExecutableAction action = new SenderExecutableAction(this.getSender(), requestManager, errorMessage);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!SUPPORTED_INFERENCE_ACTION_TASK_TYPES.contains(model.getTaskType())) {
            Object responseString = ServiceUtils.unsupportedTaskTypeForInference(model, SUPPORTED_INFERENCE_ACTION_TASK_TYPES);
            if (model.getTaskType() == TaskType.CHAT_COMPLETION) {
                responseString = (String)responseString + " " + ServiceUtils.useChatCompletionUrlMessage(model);
            }
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException((String)responseString, RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        if (!(model instanceof ElasticInferenceServiceExecutableActionModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        TraceContext currentTraceInfo = this.getCurrentTraceInfo();
        ElasticInferenceServiceExecutableActionModel elasticInferenceServiceModel = (ElasticInferenceServiceExecutableActionModel)model;
        ElasticInferenceServiceActionCreator actionCreator = new ElasticInferenceServiceActionCreator(this.getSender(), this.getServiceComponents(), currentTraceInfo, inputType);
        ExecutableAction action = elasticInferenceServiceModel.accept(actionCreator, taskSettings);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        ActionListener inferListener = listener.delegateFailureAndWrap((delegate, response) -> delegate.onResponse(ElasticInferenceService.translateToChunkedResults(inputs, response)));
        this.doInfer(model, inputs, taskSettings, inputType, timeout, (ActionListener<InferenceServiceResults>)inferListener);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ElasticInferenceServiceModel model = ElasticInferenceService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, this.elasticInferenceServiceComponents, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public InferenceServiceConfiguration getConfiguration() {
        return this.authorizationHandler.getConfiguration();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return this.authorizationHandler.supportedTaskTypes();
    }

    public boolean hideFromConfigurationApi() {
        return this.authorizationHandler.hideFromConfigurationApi();
    }

    private static ElasticInferenceServiceModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, ElasticInferenceServiceComponents eisServiceComponents, String failureMessage, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.SPARSE_EMBEDDING -> new ElasticInferenceServiceSparseEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, eisServiceComponents, context);
            case TaskType.CHAT_COMPLETION -> new ElasticInferenceServiceCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, eisServiceComponents, context);
            default -> throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    public Model parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    private ElasticInferenceServiceModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage) {
        return ElasticInferenceService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, secretSettings, this.elasticInferenceServiceComponents, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof ElasticInferenceServiceSparseEmbeddingsModel) {
            ElasticInferenceServiceSparseEmbeddingsModel embeddingsModel = (ElasticInferenceServiceSparseEmbeddingsModel)model;
            listener.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private static List<ChunkedInference> translateToChunkedResults(InferenceInputs inputs, InferenceServiceResults inferenceResults) {
        if (inferenceResults instanceof SparseEmbeddingResults) {
            SparseEmbeddingResults sparseEmbeddingResults = (SparseEmbeddingResults)inferenceResults;
            List<String> inputsAsList = DocumentsOnlyInput.of(inputs).getInputs();
            return ChunkedInferenceEmbeddingSparse.listOf(inputsAsList, (SparseEmbeddingResults)sparseEmbeddingResults);
        }
        if (inferenceResults instanceof ErrorInferenceResults) {
            ErrorInferenceResults error = (ErrorInferenceResults)inferenceResults;
            return List.of(new ChunkedInferenceError(error.getException()));
        }
        String expectedClass = Strings.format((String)"%s", (Object[])new Object[]{SparseEmbeddingResults.class.getSimpleName()});
        throw ResultUtils.createInvalidChunkedResultException((String)expectedClass, (String)inferenceResults.getWriteableName());
    }

    private ElasticInferenceServiceSparseEmbeddingsModel updateModelWithEmbeddingDetails(ElasticInferenceServiceSparseEmbeddingsModel model) {
        ElasticInferenceServiceSparseEmbeddingsServiceSettings serviceSettings = new ElasticInferenceServiceSparseEmbeddingsServiceSettings(model.getServiceSettings().modelId(), model.getServiceSettings().maxInputTokens(), model.getServiceSettings().rateLimitSettings());
        return new ElasticInferenceServiceSparseEmbeddingsModel(model, serviceSettings);
    }

    private TraceContext getCurrentTraceInfo() {
        ThreadPool threadPool = this.getServiceComponents().threadPool();
        String traceParent = threadPool.getThreadContext().getHeader("traceparent");
        String traceState = threadPool.getThreadContext().getHeader("tracestate");
        return new TraceContext(traceParent, traceState);
    }

    public static class Configuration {
        private final EnumSet<TaskType> enabledTaskTypes;
        private final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration;

        public Configuration(EnumSet<TaskType> enabledTaskTypes) {
            this.enabledTaskTypes = enabledTaskTypes;
            this.configuration = this.initConfiguration();
        }

        private LazyInitializable<InferenceServiceConfiguration, RuntimeException> initConfiguration() {
            return new LazyInitializable(() -> {
                HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
                configurationMap.put("model_id", new SettingsConfiguration.Builder(EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.CHAT_COMPLETION)).setDescription("The name of the model to use for the inference task.").setLabel("Model ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
                configurationMap.put("max_input_tokens", new SettingsConfiguration.Builder(EnumSet.of(TaskType.SPARSE_EMBEDDING)).setDescription("Allows you to specify the maximum number of tokens per input.").setLabel("Maximum Input Tokens").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build());
                configurationMap.putAll(RateLimitSettings.toSettingsConfiguration(EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.CHAT_COMPLETION)));
                return new InferenceServiceConfiguration.Builder().setService(ElasticInferenceService.NAME).setName(ElasticInferenceService.SERVICE_NAME).setTaskTypes(this.enabledTaskTypes).setConfigurations(configurationMap).build();
            });
        }

        public InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)this.configuration.getOrCompute();
        }
    }
}

