/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.PureQuadraticFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;

public final class ConvexObjectiveFunction
implements MultiaryFunction.TwiceDifferentiable<Double>,
MultiaryFunction.Quadratic<Double> {
    private final LinearFunction<Double> myLinear;
    private final PureQuadraticFunction<Double> myPureQuadratic;

    ConvexObjectiveFunction(PhysicalStore<Double> quadratic, PhysicalStore<Double> linear) {
        this.myPureQuadratic = PureQuadraticFunction.wrap(quadratic);
        this.myLinear = LinearFunction.wrap(linear);
        if (this.myPureQuadratic.arity() != this.myLinear.arity()) {
            throw new IllegalArgumentException("Must have the same arity!");
        }
    }

    @Override
    public int arity() {
        return this.myLinear.arity();
    }

    @Override
    public Double getConstant() {
        return this.myPureQuadratic.getConstant();
    }

    @Override
    public MatrixStore<Double> getGradient(Access1D<Double> point) {
        return this.myPureQuadratic.getGradient(point).subtract((Double)((Object)this.myLinear.getGradient(point)));
    }

    @Override
    public MatrixStore<Double> getHessian(Access1D<Double> point) {
        return this.myPureQuadratic.getHessian(point);
    }

    @Override
    public MatrixStore<Double> getLinearFactors() {
        return this.myLinear.getLinearFactors();
    }

    @Override
    public Double invoke(Access1D<Double> arg) {
        double quadratic = this.myPureQuadratic.invoke(arg);
        double linear = this.myLinear.invoke(arg);
        return quadratic - linear;
    }

    @Override
    public PhysicalStore<Double> linear() {
        return this.myLinear.linear();
    }

    @Override
    public PhysicalStore<Double> quadratic() {
        return this.myPureQuadratic.quadratic();
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myPureQuadratic.setConstant(constant);
    }
}

