/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;

public class ReplaceFunctionProcessor
implements Processor {
    private final Processor input;
    private final Processor pattern;
    private final Processor replacement;
    public static final String NAME = "srep";

    public ReplaceFunctionProcessor(Processor input, Processor pattern, Processor replacement) {
        this.input = input;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public ReplaceFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.pattern = (Processor)in.readNamedWriteable(Processor.class);
        this.replacement = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeNamedWriteable((NamedWriteable)this.pattern);
        out.writeNamedWriteable((NamedWriteable)this.replacement);
    }

    public Object process(Object input) {
        return ReplaceFunctionProcessor.doProcess(this.input().process(input), this.pattern().process(input), this.replacement().process(input));
    }

    public static Object doProcess(Object input, Object pattern, Object replacement) {
        if (input == null || pattern == null || replacement == null) {
            return null;
        }
        if (!(input instanceof String || input instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (!(pattern instanceof String || pattern instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", pattern);
        }
        if (!(replacement instanceof String || replacement instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", replacement);
        }
        String inputStr = input instanceof Character ? input.toString() : (String)input;
        String patternStr = pattern instanceof Character ? pattern.toString() : (String)pattern;
        String replacementStr = replacement instanceof Character ? replacement.toString() : (String)replacement;
        ReplaceFunctionProcessor.checkResultLength(inputStr, patternStr, replacementStr);
        return Strings.replace((String)inputStr, (String)patternStr, (String)replacementStr);
    }

    private static void checkResultLength(String input, String pattern, String replacement) {
        int patternLen = pattern.length();
        long matches = 0L;
        int i = input.indexOf(pattern);
        while (i >= 0) {
            ++matches;
            i = input.indexOf(pattern, i + patternLen);
        }
        StringProcessor.checkResultLength((long)input.length() + matches * (long)(replacement.length() - patternLen));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceFunctionProcessor other = (ReplaceFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.replacement(), other.replacement());
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.pattern(), this.replacement());
    }

    public Processor input() {
        return this.input;
    }

    public Processor pattern() {
        return this.pattern;
    }

    public Processor replacement() {
        return this.replacement;
    }

    public String getWriteableName() {
        return NAME;
    }
}

