/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppend;

public final class MvAppendBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field1;
    private final EvalOperator.ExpressionEvaluator field2;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvAppendBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
        this.source = source;
        this.field1 = field1;
        this.field2 = field2;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock field1Block = (BytesRefBlock)this.field1.eval(page);){
            BytesRefBlock bytesRefBlock;
            block12: {
                BytesRefBlock field2Block = (BytesRefBlock)this.field2.eval(page);
                try {
                    bytesRefBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                    if (field2Block == null) break block12;
                }
                catch (Throwable throwable) {
                    if (field2Block != null) {
                        try {
                            field2Block.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                field2Block.close();
            }
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock field1Block, BytesRefBlock field2Block) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!field1Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!field2Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                MvAppend.process(result, p, field1Block, field2Block);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "MvAppendBytesRefEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field1;
        private final EvalOperator.ExpressionEvaluator.Factory field2;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
            this.source = source;
            this.field1 = field1;
            this.field2 = field2;
        }

        public MvAppendBytesRefEvaluator get(DriverContext context) {
            return new MvAppendBytesRefEvaluator(this.source, this.field1.get(context), this.field2.get(context), context);
        }

        public String toString() {
            return "MvAppendBytesRefEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }
    }
}

