/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;

public final class MvSumLongEvaluator
extends AbstractMultivalueFunction.AbstractNullableEvaluator {
    private final Source source;
    private Warnings warnings;

    public MvSumLongEvaluator(Source source, EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
        this.source = source;
    }

    @Override
    public String name() {
        return "MvSum";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                try {
                    int first = v.getFirstValueIndex(p);
                    int end = first + valueCount;
                    long value = v.getLong(first);
                    for (int i = first + 1; i < end; ++i) {
                        long next = v.getLong(i);
                        value = MvSum.process(value, next);
                    }
                    long result = value;
                    builder.appendLong(result);
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    builder.appendNull();
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field) {
            this.source = source;
            this.field = field;
        }

        public MvSumLongEvaluator get(DriverContext context) {
            return new MvSumLongEvaluator(this.source, this.field.get(context), context);
        }

        public String toString() {
            return "MvSum[field=" + String.valueOf(this.field) + "]";
        }
    }
}

