/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.compute.EsqlRefCountingListener;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.ResponseHeadersCollector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.threadpool.ThreadPool;

final class ComputeListener
implements Releasable {
    private final EsqlRefCountingListener refs;
    private final List<DriverProfile> collectedProfiles;
    private final ResponseHeadersCollector responseHeaders;
    private final Runnable runOnFailure;

    ComputeListener(ThreadPool threadPool, Runnable runOnFailure, ActionListener<List<DriverProfile>> delegate) {
        this.runOnFailure = runOnFailure;
        this.responseHeaders = new ResponseHeadersCollector(threadPool.getThreadContext());
        this.collectedProfiles = Collections.synchronizedList(new ArrayList());
        this.refs = new EsqlRefCountingListener(delegate.delegateFailure((l, ignored) -> {
            this.responseHeaders.finish();
            delegate.onResponse(this.collectedProfiles.stream().toList());
        }));
    }

    ActionListener<Void> acquireAvoid() {
        ActionListener listener = ActionListener.assertAtLeastOnce((ActionListener)this.refs.acquire());
        return listener.delegateResponse((l, e) -> {
            try {
                this.runOnFailure.run();
            }
            finally {
                l.onFailure(e);
            }
        });
    }

    ActionListener<List<DriverProfile>> acquireCompute() {
        ActionListener<Void> delegate = this.acquireAvoid();
        return ActionListener.wrap(profiles -> {
            this.responseHeaders.collect();
            if (profiles != null && !profiles.isEmpty()) {
                this.collectedProfiles.addAll((Collection<DriverProfile>)profiles);
            }
            delegate.onResponse(null);
        }, e -> {
            this.responseHeaders.collect();
            delegate.onFailure(e);
        });
    }

    public void close() {
        this.refs.close();
    }
}

