/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneSlice;
import org.elasticsearch.compute.lucene.PartialLeafReaderContext;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.core.Nullable;

public final class LuceneSliceQueue {
    private static final int MAX_DOCS_PER_SLICE = 250000;
    private static final int MAX_SEGMENTS_PER_SLICE = 5;
    private final int totalSlices;
    private final Queue<LuceneSlice> slices;

    private LuceneSliceQueue(List<LuceneSlice> slices) {
        this.totalSlices = slices.size();
        this.slices = new ConcurrentLinkedQueue<LuceneSlice>(slices);
    }

    @Nullable
    public LuceneSlice nextSlice() {
        return this.slices.poll();
    }

    public int totalSlices() {
        return this.totalSlices;
    }

    public Iterable<LuceneSlice> getSlices() {
        return this.slices;
    }

    public static LuceneSliceQueue create(List<? extends ShardContext> contexts, Function<ShardContext, Weight> weightFunction, DataPartitioning dataPartitioning, int taskConcurrency) {
        ArrayList<LuceneSlice> slices = new ArrayList<LuceneSlice>();
        for (ShardContext shardContext : contexts) {
            List leafContexts = shardContext.searcher().getLeafContexts();
            List<List<PartialLeafReaderContext>> groups = switch (dataPartitioning) {
                default -> throw new MatchException(null, null);
                case DataPartitioning.SHARD -> Collections.singletonList(leafContexts.stream().map(PartialLeafReaderContext::new).toList());
                case DataPartitioning.SEGMENT -> LuceneSliceQueue.segmentSlices(leafContexts);
                case DataPartitioning.DOC -> LuceneSliceQueue.docSlices(shardContext.searcher().getIndexReader(), taskConcurrency);
            };
            Weight weight = weightFunction.apply(shardContext);
            for (List<PartialLeafReaderContext> group : groups) {
                if (group.isEmpty()) continue;
                slices.add(new LuceneSlice(shardContext, group, weight));
            }
        }
        return new LuceneSliceQueue(slices);
    }

    static List<List<PartialLeafReaderContext>> docSlices(IndexReader indexReader, int numSlices) {
        int totalDocCount = indexReader.maxDoc();
        int normalMaxDocsPerSlice = totalDocCount / numSlices;
        int extraDocsInFirstSlice = totalDocCount % numSlices;
        ArrayList<List<PartialLeafReaderContext>> slices = new ArrayList<List<PartialLeafReaderContext>>();
        int docsAllocatedInCurrentSlice = 0;
        ArrayList<PartialLeafReaderContext> currentSlice = null;
        int maxDocsPerSlice = normalMaxDocsPerSlice + extraDocsInFirstSlice;
        for (LeafReaderContext ctx : indexReader.leaves()) {
            int numDocsToUse;
            int numDocsInLeaf = ctx.reader().maxDoc();
            for (int minDoc = 0; minDoc < numDocsInLeaf && (numDocsToUse = Math.min(maxDocsPerSlice - docsAllocatedInCurrentSlice, numDocsInLeaf - minDoc)) > 0; minDoc += numDocsToUse) {
                if (currentSlice == null) {
                    currentSlice = new ArrayList<PartialLeafReaderContext>();
                }
                currentSlice.add(new PartialLeafReaderContext(ctx, minDoc, minDoc + numDocsToUse));
                if ((docsAllocatedInCurrentSlice += numDocsToUse) != maxDocsPerSlice) continue;
                slices.add(currentSlice);
                maxDocsPerSlice = normalMaxDocsPerSlice;
                currentSlice = null;
                docsAllocatedInCurrentSlice = 0;
            }
        }
        if (currentSlice != null) {
            slices.add(currentSlice);
        }
        if (numSlices < totalDocCount && slices.size() != numSlices) {
            throw new IllegalStateException("wrong number of slices, expected " + numSlices + " but got " + slices.size());
        }
        if (slices.stream().flatMapToInt(l -> l.stream().mapToInt(partialLeafReaderContext -> partialLeafReaderContext.maxDoc() - partialLeafReaderContext.minDoc())).sum() != totalDocCount) {
            throw new IllegalStateException("wrong doc count");
        }
        return slices;
    }

    static List<List<PartialLeafReaderContext>> segmentSlices(List<LeafReaderContext> leafContexts) {
        IndexSearcher.LeafSlice[] gs = IndexSearcher.slices(leafContexts, (int)250000, (int)5, (boolean)false);
        return Arrays.stream(gs).map(g -> Arrays.stream(g.partitions).map(PartialLeafReaderContext::new).toList()).toList();
    }
}

