/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.AbstractArray;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArray;
import org.elasticsearch.common.util.BigByteArray;
import org.elasticsearch.common.util.BigDoubleArray;
import org.elasticsearch.common.util.BigFloatArray;
import org.elasticsearch.common.util.BigIntArray;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.BigObjectArray;
import org.elasticsearch.common.util.BinarySearcher;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Streams;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class BigArrays {
    public static final BigArrays NON_RECYCLING_INSTANCE = new BigArrays(null, null, "request");
    @Nullable
    final PageCacheRecycler recycler;
    @Nullable
    private final CircuitBreakerService breakerService;
    @Nullable
    private final CircuitBreaker breaker;
    private final boolean checkBreaker;
    private final BigArrays circuitBreakingInstance;
    private final String breakerName;

    public static long overSize(long minTargetSize) {
        return BigArrays.overSize(minTargetSize, 2048, 1);
    }

    public static long overSize(long minTargetSize, int pageSize, int bytesPerElement) {
        long newSize;
        if (minTargetSize < 0L) {
            throw new IllegalArgumentException("minTargetSize must be >= 0");
        }
        if (pageSize < 0) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        if (bytesPerElement <= 0) {
            throw new IllegalArgumentException("bytesPerElement must be > 0");
        }
        if (minTargetSize < (long)pageSize) {
            newSize = Math.min(ArrayUtil.oversize((int)((int)minTargetSize), (int)bytesPerElement), pageSize);
        } else {
            long pages = (minTargetSize + (long)pageSize - 1L) / (long)pageSize;
            newSize = pages * (long)pageSize;
        }
        return newSize;
    }

    static boolean indexIsInt(long index) {
        return index == (long)((int)index);
    }

    public BigArrays(@Nullable PageCacheRecycler recycler, @Nullable CircuitBreakerService breakerService, String breakerName) {
        this(recycler, breakerService, breakerName, false);
    }

    protected BigArrays(@Nullable PageCacheRecycler recycler, @Nullable CircuitBreakerService breakerService, String breakerName, boolean checkBreaker) {
        this.checkBreaker = checkBreaker;
        this.recycler = recycler;
        this.breakerService = breakerService;
        this.breaker = breakerService != null ? breakerService.getBreaker(breakerName) : null;
        this.breakerName = breakerName;
        this.circuitBreakingInstance = checkBreaker ? this : new BigArrays(recycler, breakerService, breakerName, true);
    }

    void adjustBreaker(long delta, boolean isDataAlreadyCreated) {
        if (this.breaker != null) {
            if (this.checkBreaker) {
                if (delta > 0L) {
                    try {
                        this.breaker.addEstimateBytesAndMaybeBreak(delta, "<reused_arrays>");
                    }
                    catch (CircuitBreakingException e) {
                        if (isDataAlreadyCreated) {
                            this.breaker.addWithoutBreaking(delta);
                        }
                        throw e;
                    }
                } else {
                    this.breaker.addWithoutBreaking(delta);
                }
            } else {
                this.breaker.addWithoutBreaking(delta);
            }
        }
    }

    public BigArrays withCircuitBreaking() {
        return this.circuitBreakingInstance;
    }

    public BigArrays withBreakerService(CircuitBreakerService breakerService) {
        return new BigArrays(this.recycler, breakerService, this.breakerName, this.checkBreaker);
    }

    public CircuitBreakerService breakerService() {
        return this.circuitBreakingInstance.breakerService;
    }

    private <T extends AbstractBigArray> T resizeInPlace(T array, long newSize) {
        long oldMemSize = array.ramBytesUsed();
        long oldSize = array.size();
        assert (oldMemSize == array.ramBytesEstimated(oldSize)) : "ram bytes used should equal that which was previously estimated: ramBytesUsed=" + oldMemSize + ", ramBytesEstimated=" + array.ramBytesEstimated(oldSize);
        long estimatedIncreaseInBytes = array.ramBytesEstimated(newSize) - oldMemSize;
        this.adjustBreaker(estimatedIncreaseInBytes, false);
        array.resize(newSize);
        return array;
    }

    private <T extends BigArray> T validate(T array) {
        boolean success = false;
        try {
            this.adjustBreaker(array.ramBytesUsed(), true);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException(array);
            }
        }
        return array;
    }

    public ByteArray newByteArray(long size, boolean clearOnResize) {
        if (size > 16384L) {
            this.adjustBreaker(BigByteArray.estimateRamBytes(size), false);
            return new BigByteArray(size, this, clearOnResize);
        }
        if (size >= 8192L && this.recycler != null) {
            Recycler.V<byte[]> page = this.recycler.bytePage(clearOnResize);
            return this.validate(new ByteArrayWrapper(this, page.v(), size, page, clearOnResize));
        }
        return this.validate(new ByteArrayWrapper(this, new byte[(int)size], size, null, clearOnResize));
    }

    public ByteArray newByteArray(long size) {
        return this.newByteArray(size, true);
    }

    public ByteArray resize(ByteArray array, long size) {
        if (array instanceof BigByteArray) {
            return this.resizeInPlace((BigByteArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        ByteArray newArray = this.newByteArray(size, arr.clearOnResize);
        byte[] rawArray = ((ByteArrayWrapper)array).array;
        newArray.set(0L, rawArray, 0, (int)Math.min((long)rawArray.length, newArray.size()));
        arr.close();
        return newArray;
    }

    public ByteArray grow(ByteArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 16384, 1);
        return this.resize(array, newSize);
    }

    public static int hashCode(ByteArray array) {
        if (array == null) {
            return 0;
        }
        int hash = 1;
        for (long i = 0L; i < array.size(); ++i) {
            hash = 31 * hash + array.get(i);
        }
        return hash;
    }

    public static boolean equals(ByteArray array, ByteArray other) {
        if (array == other) {
            return true;
        }
        if (array.size() != other.size()) {
            return false;
        }
        for (long i = 0L; i < array.size(); ++i) {
            if (array.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public IntArray newIntArray(long size, boolean clearOnResize) {
        if (size > 4096L || size >= 2048L && this.recycler != null) {
            this.adjustBreaker(BigIntArray.estimateRamBytes(size), false);
            return new BigIntArray(size, this, clearOnResize);
        }
        return this.validate(new ByteArrayAsIntArrayWrapper(this, size, clearOnResize));
    }

    public IntArray newIntArray(long size) {
        return this.newIntArray(size, true);
    }

    public IntArray resize(IntArray array, long size) {
        if (array instanceof BigIntArray) {
            return this.resizeInPlace((BigIntArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        IntArray newArray = this.newIntArray(size, arr.clearOnResize);
        newArray.set(0L, ((ByteArrayAsIntArrayWrapper)arr).array, 0, (int)Math.min(size, array.size()));
        array.close();
        return newArray;
    }

    public IntArray grow(IntArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return this.resize(array, newSize);
    }

    public LongArray newLongArray(long size, boolean clearOnResize) {
        if (size > 2048L || size >= 1024L && this.recycler != null) {
            this.adjustBreaker(BigLongArray.estimateRamBytes(size), false);
            return new BigLongArray(size, this, clearOnResize);
        }
        return this.validate(new ByteArrayAsLongArrayWrapper(this, size, clearOnResize));
    }

    public LongArray newLongArray(long size) {
        return this.newLongArray(size, true);
    }

    public LongArray resize(LongArray array, long size) {
        if (array instanceof BigLongArray) {
            return this.resizeInPlace((BigLongArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        LongArray newArray = this.newLongArray(size, arr.clearOnResize);
        newArray.set(0L, ((ByteArrayAsLongArrayWrapper)arr).array, 0, (int)Math.min(size, array.size()));
        array.close();
        return newArray;
    }

    public LongArray grow(LongArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return this.resize(array, newSize);
    }

    public DoubleArray newDoubleArray(long size, boolean clearOnResize) {
        if (size > 2048L || size >= 1024L && this.recycler != null) {
            this.adjustBreaker(BigDoubleArray.estimateRamBytes(size), false);
            return new BigDoubleArray(size, this, clearOnResize);
        }
        return this.validate(new ByteArrayAsDoubleArrayWrapper(this, size, clearOnResize));
    }

    public DoubleArray newDoubleArray(long size) {
        return this.newDoubleArray(size, true);
    }

    public DoubleArray resize(DoubleArray array, long size) {
        if (array instanceof BigDoubleArray) {
            return this.resizeInPlace((BigDoubleArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        DoubleArray newArray = this.newDoubleArray(size, arr.clearOnResize);
        newArray.set(0L, ((ByteArrayAsDoubleArrayWrapper)arr).array, 0, (int)Math.min(size, array.size()));
        array.close();
        return newArray;
    }

    public DoubleArray grow(DoubleArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return this.resize(array, newSize);
    }

    public FloatArray newFloatArray(long size, boolean clearOnResize) {
        if (size > 4096L || size >= 2048L && this.recycler != null) {
            this.adjustBreaker(BigFloatArray.estimateRamBytes(size), false);
            return new BigFloatArray(size, this, clearOnResize);
        }
        return this.validate(new ByteArrayAsFloatArrayWrapper(this, size, clearOnResize));
    }

    public FloatArray newFloatArray(long size) {
        return this.newFloatArray(size, true);
    }

    public FloatArray resize(FloatArray array, long size) {
        if (array instanceof BigFloatArray) {
            return this.resizeInPlace((BigFloatArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        FloatArray newArray = this.newFloatArray(size, arr.clearOnResize);
        newArray.set(0L, ((ByteArrayAsFloatArrayWrapper)arr).array, 0, (int)Math.min(size, array.size()));
        arr.close();
        return newArray;
    }

    public FloatArray grow(FloatArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return this.resize(array, newSize);
    }

    public <T> ObjectArray<T> newObjectArray(long size) {
        if (size > (long)PageCacheRecycler.OBJECT_PAGE_SIZE) {
            this.adjustBreaker(BigObjectArray.estimateRamBytes(size), false);
            return new BigObjectArray(size, this);
        }
        if (size >= (long)(PageCacheRecycler.OBJECT_PAGE_SIZE / 2) && this.recycler != null) {
            Recycler.V<Object[]> page = this.recycler.objectPage();
            return this.validate(new ObjectArrayWrapper(this, page.v(), size, page));
        }
        return this.validate(new ObjectArrayWrapper(this, new Object[(int)size], size, null));
    }

    public <T> ObjectArray<T> resize(ObjectArray<T> array, long size) {
        if (array instanceof BigObjectArray) {
            return this.resizeInPlace((BigObjectArray)array, size);
        }
        ObjectArray<T> newArray = this.newObjectArray(size);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.close();
        return newArray;
    }

    public <T> ObjectArray<T> grow(ObjectArray<T> array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, PageCacheRecycler.OBJECT_PAGE_SIZE, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        return this.resize(array, newSize);
    }

    protected boolean shouldCheckBreaker() {
        return this.checkBreaker;
    }

    private static class ByteArrayWrapper
    extends AbstractArrayWrapper
    implements ByteArray {
        private final byte[] array;

        ByteArrayWrapper(BigArrays bigArrays, byte[] array, long size, Recycler.V<byte[]> releasable, boolean clearOnResize) {
            super(bigArrays, size, releasable, clearOnResize);
            this.array = array;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.array);
        }

        @Override
        public byte get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public void set(long index, byte value) {
            assert (BigArrays.indexIsInt(index));
            this.array[(int)index] = value;
        }

        @Override
        public boolean get(long index, int len, BytesRef ref) {
            assert (BigArrays.indexIsInt(index));
            ref.bytes = this.array;
            ref.offset = (int)index;
            ref.length = len;
            return false;
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (BigArrays.indexIsInt(index));
            System.arraycopy(buf, offset, this.array, (int)index, len);
        }

        @Override
        public void fill(long fromIndex, long toIndex, byte value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }

        @Override
        public BytesRefIterator iterator() {
            return new BytesRefIterator(){
                boolean visited = false;

                public BytesRef next() {
                    if (this.visited) {
                        return null;
                    }
                    this.visited = true;
                    return new BytesRef(array, 0, Math.toIntExact(this.size()));
                }
            };
        }

        @Override
        public void fillWith(InputStream in) throws IOException {
            Streams.readFully((InputStream)in, (byte[])this.array, (int)0, (int)Math.toIntExact(this.size()));
        }

        @Override
        public boolean hasArray() {
            return true;
        }

        @Override
        public byte[] array() {
            return this.array;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            int size = Math.toIntExact(this.size()) * 1;
            out.writeVInt(size);
            out.write(this.array, 0, size);
        }
    }

    private static class ByteArrayAsIntArrayWrapper
    extends AbstractArrayWrapper
    implements IntArray {
        final byte[] array;

        ByteArrayAsIntArrayWrapper(BigArrays bigArrays, long size, boolean clearOnResize) {
            super(bigArrays, size, null, clearOnResize);
            assert (size >= 0L && size <= 4096L);
            this.array = new byte[(int)size << 2];
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            int intSize = (int)this.size();
            out.writeVInt(intSize * 4);
            out.write(this.array, 0, intSize * 4);
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.array);
        }

        @Override
        public int get(long index) {
            assert (index >= 0L && index < this.size());
            return BigIntArray.VH_PLATFORM_NATIVE_INT.get(this.array, (int)index << 2);
        }

        @Override
        public int getAndSet(long index, int value) {
            assert (index >= 0L && index < this.size());
            int ret = BigIntArray.VH_PLATFORM_NATIVE_INT.get(this.array, (int)index << 2);
            BigIntArray.VH_PLATFORM_NATIVE_INT.set(this.array, (int)index << 2, value);
            return ret;
        }

        @Override
        public void set(long index, int value) {
            assert (index >= 0L && index < this.size());
            BigIntArray.VH_PLATFORM_NATIVE_INT.set(this.array, (int)index << 2, value);
        }

        @Override
        public int increment(long index, int inc) {
            assert (index >= 0L && index < this.size());
            int ret = BigIntArray.VH_PLATFORM_NATIVE_INT.get(this.array, (int)index << 2) + inc;
            BigIntArray.VH_PLATFORM_NATIVE_INT.set(this.array, (int)index << 2, ret);
            return ret;
        }

        @Override
        public void fill(long fromIndex, long toIndex, int value) {
            assert (fromIndex >= 0L && fromIndex <= toIndex);
            assert (toIndex >= 0L && toIndex <= this.size());
            BigIntArray.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }

        @Override
        public void fillWith(StreamInput in) throws IOException {
            int numBytes = in.readVInt();
            in.readBytes(this.array, 0, numBytes);
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (index >= 0L && index < this.size());
            System.arraycopy(buf, offset << 2, this.array, (int)index << 2, len << 2);
        }
    }

    private static class ByteArrayAsLongArrayWrapper
    extends AbstractArrayWrapper
    implements LongArray {
        private final byte[] array;

        ByteArrayAsLongArrayWrapper(BigArrays bigArrays, long size, boolean clearOnResize) {
            super(bigArrays, size, null, clearOnResize);
            assert (size >= 0L && size <= 2048L);
            this.array = new byte[(int)size << 3];
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.array);
        }

        @Override
        public long get(long index) {
            assert (index >= 0L && index < this.size());
            return BigLongArray.VH_PLATFORM_NATIVE_LONG.get(this.array, (int)index << 3);
        }

        @Override
        public long getAndSet(long index, long value) {
            assert (index >= 0L && index < this.size());
            long ret = BigLongArray.VH_PLATFORM_NATIVE_LONG.get(this.array, (int)index << 3);
            BigLongArray.VH_PLATFORM_NATIVE_LONG.set(this.array, (int)index << 3, value);
            return ret;
        }

        @Override
        public void set(long index, long value) {
            assert (index >= 0L && index < this.size());
            BigLongArray.VH_PLATFORM_NATIVE_LONG.set(this.array, (int)index << 3, value);
        }

        @Override
        public long increment(long index, long inc) {
            assert (index >= 0L && index < this.size());
            long ret = BigLongArray.VH_PLATFORM_NATIVE_LONG.get(this.array, (int)index << 3) + inc;
            BigLongArray.VH_PLATFORM_NATIVE_LONG.set(this.array, (int)index << 3, ret);
            return ret;
        }

        @Override
        public void fill(long fromIndex, long toIndex, long value) {
            assert (fromIndex >= 0L && fromIndex <= toIndex);
            assert (toIndex >= 0L && toIndex <= this.size());
            BigLongArray.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (index >= 0L && index < this.size());
            System.arraycopy(buf, offset << 3, this.array, (int)index << 3, len << 3);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            int size = Math.toIntExact(this.size()) * 8;
            out.writeVInt(size);
            out.write(this.array, 0, size);
        }

        @Override
        public void fillWith(StreamInput in) throws IOException {
            int len = in.readVInt();
            in.readBytes(this.array, 0, len);
        }
    }

    private static class ByteArrayAsDoubleArrayWrapper
    extends AbstractArrayWrapper
    implements DoubleArray {
        private final byte[] array;

        ByteArrayAsDoubleArrayWrapper(BigArrays bigArrays, long size, boolean clearOnResize) {
            super(bigArrays, size, null, clearOnResize);
            assert (size >= 0L && size <= 2048L);
            this.array = new byte[(int)size << 3];
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.array);
        }

        @Override
        public double get(long index) {
            assert (index >= 0L && index < this.size());
            return BigDoubleArray.VH_PLATFORM_NATIVE_DOUBLE.get(this.array, (int)index << 3);
        }

        @Override
        public void set(long index, double value) {
            assert (index >= 0L && index < this.size());
            BigDoubleArray.VH_PLATFORM_NATIVE_DOUBLE.set(this.array, (int)index << 3, value);
        }

        @Override
        public double increment(long index, double inc) {
            assert (index >= 0L && index < this.size());
            double ret = BigDoubleArray.VH_PLATFORM_NATIVE_DOUBLE.get(this.array, (int)index << 3) + inc;
            BigDoubleArray.VH_PLATFORM_NATIVE_DOUBLE.set(this.array, (int)index << 3, ret);
            return ret;
        }

        @Override
        public void fill(long fromIndex, long toIndex, double value) {
            assert (fromIndex >= 0L && fromIndex <= toIndex);
            assert (toIndex >= 0L && toIndex <= this.size());
            BigDoubleArray.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }

        @Override
        public void fillWith(StreamInput in) throws IOException {
            int numBytes = in.readVInt();
            in.readBytes(this.array, 0, numBytes);
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (index >= 0L && index < this.size());
            System.arraycopy(buf, offset << 3, this.array, (int)index << 3, len << 3);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            int size = (int)this.size();
            out.writeVInt(size * 8);
            out.write(this.array, 0, size * 8);
        }
    }

    private static class ByteArrayAsFloatArrayWrapper
    extends AbstractArrayWrapper
    implements FloatArray {
        private final byte[] array;

        ByteArrayAsFloatArrayWrapper(BigArrays bigArrays, long size, boolean clearOnResize) {
            super(bigArrays, size, null, clearOnResize);
            assert (size >= 0L && size <= 4096L);
            this.array = new byte[(int)size << 2];
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.array);
        }

        @Override
        public float get(long index) {
            assert (index >= 0L && index < this.size());
            return BigFloatArray.VH_PLATFORM_NATIVE_FLOAT.get(this.array, (int)index << 2);
        }

        @Override
        public void set(long index, float value) {
            assert (index >= 0L && index < this.size());
            BigFloatArray.VH_PLATFORM_NATIVE_FLOAT.set(this.array, (int)index << 2, value);
        }

        @Override
        public void fill(long fromIndex, long toIndex, float value) {
            assert (fromIndex >= 0L && fromIndex <= toIndex);
            assert (toIndex >= 0L && toIndex <= this.size());
            BigFloatArray.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (index >= 0L && index < this.size());
            System.arraycopy(buf, offset << 2, this.array, (int)index << 2, len << 2);
        }
    }

    private static class ObjectArrayWrapper<T>
    extends AbstractArrayWrapper
    implements ObjectArray<T> {
        private final Object[] array;

        ObjectArrayWrapper(BigArrays bigArrays, Object[] array, long size, Recycler.V<Object[]> releasable) {
            super(bigArrays, size, releasable, true);
            this.array = array;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * this.size()));
        }

        @Override
        public T get(long index) {
            assert (index >= 0L && index < this.size());
            return (T)this.array[(int)index];
        }

        @Override
        public void set(long index, T value) {
            assert (index >= 0L && index < this.size());
            this.array[(int)index] = value;
        }

        @Override
        public T getAndSet(long index, T value) {
            assert (index >= 0L && index < this.size());
            Object ret = this.array[(int)index];
            this.array[(int)index] = value;
            return (T)ret;
        }
    }

    public static class DoubleBinarySearcher
    extends BinarySearcher {
        DoubleArray array;
        double searchFor;

        public DoubleBinarySearcher(DoubleArray array) {
            this.array = array;
            this.searchFor = -2.147483648E9;
        }

        @Override
        protected int compare(int index) {
            assert (this.searchFor != -2.147483648E9);
            return Double.compare(this.array.get(index), this.searchFor);
        }

        @Override
        protected double distance(int index) {
            return Math.abs(this.array.get(index) - this.searchFor);
        }

        public int search(int from, int to, double searchFor) {
            this.searchFor = searchFor;
            return super.search(from, to);
        }
    }

    private static abstract class AbstractArrayWrapper
    extends AbstractArray
    implements BigArray {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ByteArrayWrapper.class);
        private final Releasable releasable;
        private final long size;

        AbstractArrayWrapper(BigArrays bigArrays, long size, Releasable releasable, boolean clearOnResize) {
            super(bigArrays, clearOnResize);
            this.releasable = releasable;
            this.size = size;
        }

        @Override
        public final long size() {
            return this.size;
        }

        @Override
        protected final void doClose() {
            Releasables.close((Releasable)this.releasable);
        }
    }
}

