/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.XFeatureField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SparseVectorFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "sparse_vector";
    static final String ERROR_MESSAGE_7X = "[sparse_vector] field type in old 7.x indices is allowed to contain [sparse_vector] fields, but they cannot be indexed or searched.";
    static final String ERROR_MESSAGE_8X = "The [sparse_vector] field type is not supported on indices created on versions 8.0 to 8.10.";
    static final IndexVersion PREVIOUS_SPARSE_VECTOR_INDEX_VERSION = IndexVersions.V_8_0_0;
    static final IndexVersion NEW_SPARSE_VECTOR_INDEX_VERSION = IndexVersions.NEW_SPARSE_VECTOR;
    static final IndexVersion SPARSE_VECTOR_IN_FIELD_NAMES_INDEX_VERSION = IndexVersions.SPARSE_VECTOR_IN_FIELD_NAMES_SUPPORT;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        if (c.indexVersionCreated().before(PREVIOUS_SPARSE_VECTOR_INDEX_VERSION)) {
            deprecationLogger.warn(DeprecationCategory.MAPPINGS, CONTENT_TYPE, ERROR_MESSAGE_7X, new Object[0]);
        } else if (c.indexVersionCreated().before(NEW_SPARSE_VECTOR_INDEX_VERSION)) {
            throw new IllegalArgumentException(ERROR_MESSAGE_8X);
        }
        return new Builder((String)n);
    }, SparseVectorFieldMapper.notInMultiFields("sparse_vector"));

    private static SparseVectorFieldMapper toType(FieldMapper in) {
        return (SparseVectorFieldMapper)in;
    }

    private SparseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams) {
        super(simpleName, mappedFieldType, builderParams);
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.fieldType().isStored()) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new SparseVectorSyntheticFieldLoader(this.fullPath(), this.leafName()));
        }
        return super.syntheticSourceSupport();
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    @Override
    public SparseVectorFieldType fieldType() {
        return (SparseVectorFieldType)super.fieldType();
    }

    @Override
    protected boolean supportsParsingObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.indexSettings().getIndexVersionCreated().before(PREVIOUS_SPARSE_VECTOR_INDEX_VERSION)) {
            throw new UnsupportedOperationException(ERROR_MESSAGE_7X);
        }
        if (context.indexSettings().getIndexVersionCreated().before(NEW_SPARSE_VECTOR_INDEX_VERSION)) {
            throw new UnsupportedOperationException(ERROR_MESSAGE_8X);
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[sparse_vector] fields must be json objects, expected a START_OBJECT but got: " + String.valueOf(context.parser().currentToken()));
        }
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        String feature = null;
        try {
            context.path().setWithinLeafObject(true);
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    feature = context.parser().currentName();
                } else if (token != XContentParser.Token.VALUE_NULL) {
                    if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                        String key = this.fullPath() + "\\." + feature.replace(".", "\\.");
                        float value = context.parser().floatValue(true);
                        IndexableField currentField = context.doc().getByKey(key);
                        if (currentField == null) {
                            context.doc().addWithKey(key, (IndexableField)new XFeatureField(this.fullPath(), feature, value, this.fieldType().isStored()));
                        } else if (currentField instanceof XFeatureField && ((XFeatureField)currentField).getFeatureValue() < value) {
                            ((XFeatureField)currentField).setFeatureValue(value);
                        }
                    } else {
                        throw new IllegalArgumentException("[sparse_vector] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + String.valueOf(token));
                    }
                }
                token = context.parser().nextToken();
            }
            if (context.indexSettings().getIndexVersionCreated().onOrAfter(SPARSE_VECTOR_IN_FIELD_NAMES_INDEX_VERSION)) {
                context.addToFieldNames(this.fieldType().name());
            }
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeaf);
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class SparseVectorFieldType
    extends MappedFieldType {
        public SparseVectorFieldType(String name, boolean isStored, Map<String, String> meta) {
            super(name, true, isStored, false, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
        }

        @Override
        public String typeName() {
            return SparseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[sparse_vector] fields do not support sorting, scripting or aggregating");
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (this.isStored()) {
                return new SparseVectorValueFetcher(this.name());
            }
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            return FeatureField.newLinearQuery((String)this.name(), (String)SparseVectorFieldType.indexedValueForSearch(value), (float)1.0f);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            if (context.getIndexSettings().getIndexVersionCreated().before(PREVIOUS_SPARSE_VECTOR_INDEX_VERSION)) {
                deprecationLogger.warn(DeprecationCategory.MAPPINGS, SparseVectorFieldMapper.CONTENT_TYPE, SparseVectorFieldMapper.ERROR_MESSAGE_7X, new Object[0]);
                return new MatchNoDocsQuery();
            }
            if (context.getIndexSettings().getIndexVersionCreated().before(SPARSE_VECTOR_IN_FIELD_NAMES_INDEX_VERSION)) {
                throw new IllegalArgumentException("[sparse_vector] fields do not support [exists] queries");
            }
            return super.existsQuery(context);
        }

        private static String indexedValueForSearch(Object value) {
            if (value instanceof BytesRef) {
                return ((BytesRef)value).utf8ToString();
            }
            return value.toString();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> SparseVectorFieldMapper.toType(m).fieldType().isStored(), false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        public Builder setStored(boolean value) {
            this.stored.setValue(value);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.stored, this.meta};
        }

        @Override
        public SparseVectorFieldMapper build(MapperBuilderContext context) {
            return new SparseVectorFieldMapper(this.leafName(), new SparseVectorFieldType(context.buildFullName(this.leafName()), this.stored.getValue(), this.meta.getValue()), this.builderParams(this, context));
        }
    }

    private static class SparseVectorSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private final String fullPath;
        private final String leafName;
        private TermsEnum termsDocEnum;

        private SparseVectorSyntheticFieldLoader(String fullPath, String leafName) {
            this.fullPath = fullPath;
            this.leafName = leafName;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(new Map.Entry[0]);
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            FieldInfo fieldInfos = leafReader.getFieldInfos().fieldInfo(this.fullPath);
            if (fieldInfos == null || !fieldInfos.hasTermVectors()) {
                return null;
            }
            return docId -> {
                Terms terms = leafReader.termVectors().get(docId, this.fullPath);
                if (terms == null) {
                    return false;
                }
                this.termsDocEnum = terms.iterator();
                if (this.termsDocEnum.next() == null) {
                    this.termsDocEnum = null;
                    return false;
                }
                return true;
            };
        }

        @Override
        public boolean hasValue() {
            return this.termsDocEnum != null;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            assert (this.termsDocEnum != null);
            PostingsEnum reuse = null;
            b.startObject(this.leafName);
            do {
                reuse = this.termsDocEnum.postings(reuse);
                reuse.nextDoc();
                b.field(this.termsDocEnum.term().utf8ToString(), XFeatureField.decodeFeatureValue(reuse.freq()));
            } while (this.termsDocEnum.next() != null);
            b.endObject();
        }

        @Override
        public String fieldName() {
            return this.leafName;
        }

        @Override
        public void reset() {
            this.termsDocEnum = null;
        }
    }

    private static class SparseVectorValueFetcher
    implements ValueFetcher {
        private final String fieldName;
        private TermVectors termVectors;

        private SparseVectorValueFetcher(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public void setNextReader(LeafReaderContext context) {
            try {
                this.termVectors = context.reader().termVectors();
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }

        @Override
        public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
            if (this.termVectors == null) {
                return List.of();
            }
            Terms terms = this.termVectors.get(doc, this.fieldName);
            if (terms == null) {
                return List.of();
            }
            TermsEnum termsEnum = terms.iterator();
            PostingsEnum postingsScratch = null;
            LinkedHashMap<String, Float> result = new LinkedHashMap<String, Float>();
            while (termsEnum.next() != null) {
                postingsScratch = termsEnum.postings(postingsScratch);
                postingsScratch.nextDoc();
                result.put(termsEnum.term().utf8ToString(), Float.valueOf(XFeatureField.decodeFeatureValue(postingsScratch.freq())));
                assert (postingsScratch.nextDoc() == Integer.MAX_VALUE);
            }
            return List.of(result);
        }

        @Override
        public StoredFieldsSpec storedFieldsSpec() {
            return StoredFieldsSpec.NO_REQUIREMENTS;
        }
    }
}

