/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.util.Map;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.PluginsLoader;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.readiness.ReadinessService;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportService;

class NodeServiceProvider {
    NodeServiceProvider() {
    }

    PluginsService newPluginService(Environment initialEnvironment, PluginsLoader pluginsLoader) {
        return new PluginsService(initialEnvironment.settings(), initialEnvironment.configDir(), pluginsLoader);
    }

    ScriptService newScriptService(PluginsService pluginsService, Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts, LongSupplier timeProvider) {
        return new ScriptService(settings, engines, contexts, timeProvider);
    }

    ClusterInfoService newClusterInfoService(PluginsService pluginsService, Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        InternalClusterInfoService service = new InternalClusterInfoService(settings, clusterService, threadPool, client);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addListener(service);
        }
        return service;
    }

    PageCacheRecycler newPageCacheRecycler(PluginsService pluginsService, Settings settings) {
        return new PageCacheRecycler(settings);
    }

    BigArrays newBigArrays(PluginsService pluginsService, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    TransportService newTransportService(PluginsService pluginsService, Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings, TaskManager taskManager, Tracer tracer) {
        return new TransportService(settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskManager, tracer);
    }

    HttpServerTransport newHttpTransport(PluginsService pluginsService, NetworkModule networkModule) {
        return networkModule.getHttpServerTransportSupplier().get();
    }

    SearchService newSearchService(PluginsService pluginsService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase, CircuitBreakerService circuitBreakerService, ExecutorSelector executorSelector, Tracer tracer) {
        return new SearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, fetchPhase, circuitBreakerService, executorSelector, tracer);
    }

    void processRecoverySettings(PluginsService pluginsService, ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    ReadinessService newReadinessService(PluginsService pluginsService, ClusterService clusterService, Environment environment) {
        return new ReadinessService(clusterService, environment);
    }
}

