/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.BytesRefStreamOutput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ImmutableTransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public final class HashBasedTransactionStore
extends TransactionStore {
    private static final Logger logger = LogManager.getLogger(HashBasedTransactionStore.class);
    private static final int INITIAL_ITEM_CAPACITY = 2048;
    private static final int INITIAL_TRANSACTION_CAPACITY = 2048;
    private static final int CAPACITY_INCREMENT = 2048;
    private final BytesRefStreamOutput scratchItemBytesStreamOutput = new BytesRefStreamOutput();
    private final BytesRefStreamOutput scratchTransactionBytesStreamOutput = new BytesRefStreamOutput();
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(HashBasedTransactionStore.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(BytesStreamOutput.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(BytesRefHash.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(LongArray.class);
    private BytesRefHash items;
    private LongArray itemCounts;
    private long totalItemCount;
    private BytesRefHash transactions;
    private LongArray transactionCounts;
    private long totalTransactionCount;
    private long filteredTransactionCount;

    public HashBasedTransactionStore(BigArrays bigArrays) {
        super(bigArrays);
        boolean success = false;
        try {
            this.items = new BytesRefHash(2048L, bigArrays);
            this.itemCounts = bigArrays.newLongArray(2048L, true);
            this.transactions = new BytesRefHash(2048L, bigArrays);
            this.transactionCounts = bigArrays.newLongArray(2048L, true);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashBasedTransactionStore(StreamInput in, BigArrays bigArrays) throws IOException {
        super(bigArrays);
        boolean success = false;
        BytesRefArray itemsArray = null;
        BytesRefArray transactionsArray = null;
        try {
            itemsArray = new BytesRefArray(in, bigArrays);
            this.items = new BytesRefHash(itemsArray, bigArrays);
            itemsArray = null;
            long itemCountsSize = in.readVLong();
            this.itemCounts = bigArrays.newLongArray(itemCountsSize, true);
            int i = 0;
            while ((long)i < itemCountsSize) {
                this.itemCounts.set((long)i, in.readVLong());
                ++i;
            }
            this.totalItemCount = in.readVLong();
            transactionsArray = new BytesRefArray(in, bigArrays);
            this.transactions = new BytesRefHash(transactionsArray, bigArrays);
            transactionsArray = null;
            long transactionsCountsSize = in.readVLong();
            this.transactionCounts = bigArrays.newLongArray(transactionsCountsSize, true);
            int i2 = 0;
            while ((long)i2 < transactionsCountsSize) {
                this.transactionCounts.set((long)i2, in.readVLong());
                ++i2;
            }
            this.totalTransactionCount = in.readVLong();
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            try (Releasable releasable = Releasables.wrap((Releasable[])new Releasable[]{itemsArray, transactionsArray});){
                this.close();
                throw throwable;
            }
        }
        try (Releasable releasable = Releasables.wrap((Releasable[])new Releasable[]{itemsArray, transactionsArray});){
            this.close();
            return;
        }
    }

    public void add(Stream<Tuple<ItemSetMapReduceValueSource.Field, List<Object>>> keyValues) {
        this.scratchTransactionBytesStreamOutput.reset();
        keyValues.forEach(fieldAndValues -> ((List)fieldAndValues.v2()).stream().sorted().forEach(fieldValue -> {
            try {
                this.scratchItemBytesStreamOutput.reset();
                this.scratchItemBytesStreamOutput.writeVInt(((ItemSetMapReduceValueSource.Field)fieldAndValues.v1()).getId());
                this.scratchItemBytesStreamOutput.writeGenericValue(fieldValue);
                long id = this.items.add(this.scratchItemBytesStreamOutput.get());
                if (id < 0L) {
                    id = -1L * (id + 1L);
                }
                if (id >= this.itemCounts.size()) {
                    logger.trace("Resizing array for item counts");
                    this.itemCounts = this.bigArrays.resize(this.itemCounts, this.itemCounts.size() + 2048L);
                }
                this.itemCounts.increment(id, 1L);
                ++this.totalItemCount;
                this.scratchTransactionBytesStreamOutput.writeVLong(id);
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to add items", (Throwable)e);
            }
        }));
        long id = this.transactions.add(this.scratchTransactionBytesStreamOutput.get());
        ++this.totalTransactionCount;
        if (id < 0L) {
            id = -1L * (id + 1L);
        }
        if (id >= this.transactionCounts.size()) {
            this.transactionCounts = this.bigArrays.resize(this.transactionCounts, this.transactionCounts.size() + 2048L);
        }
        this.transactionCounts.increment(id, 1L);
    }

    public void addFilteredTransaction() {
        ++this.filteredTransactionCount;
        ++this.totalTransactionCount;
    }

    @Override
    public long getTotalItemCount() {
        return this.totalItemCount;
    }

    @Override
    public long getTotalTransactionCount() {
        return this.totalTransactionCount;
    }

    @Override
    public long getFilteredTransactionCount() {
        return this.filteredTransactionCount;
    }

    @Override
    public BytesRefArray getItems() {
        return this.items.getBytesRefs();
    }

    @Override
    public LongArray getItemCounts() {
        return this.itemCounts;
    }

    @Override
    public BytesRefArray getTransactions() {
        return this.transactions.getBytesRefs();
    }

    @Override
    public LongArray getTransactionCounts() {
        return this.transactionCounts;
    }

    public void merge(TransactionStore other) throws IOException {
        long oldCount;
        long newId;
        long oldId;
        int i = 0;
        while ((long)i < other.getItems().size()) {
            oldId = i;
            if (oldId >= 0L) {
                other.getItems().get(oldId, this.scratchBytesRef);
                newId = this.items.add(this.scratchBytesRef);
                oldCount = other.getItemCounts().get(oldId);
                if (newId < 0L) {
                    newId = -1L * (newId + 1L);
                } else if (newId >= this.itemCounts.size()) {
                    this.itemCounts = this.bigArrays.resize(this.itemCounts, this.itemCounts.size() + 2048L);
                }
                other.getItemCounts().set(oldId, newId);
                this.itemCounts.increment(newId, oldCount);
            }
            ++i;
        }
        i = 0;
        while ((long)i < other.getTransactions().size()) {
            oldId = i;
            if (oldId >= 0L) {
                other.getTransactions().get(oldId, this.scratchBytesRef);
                this.scratchByteArrayStreamInput.reset(this.scratchBytesRef.bytes, this.scratchBytesRef.offset, this.scratchBytesRef.length);
                this.scratchTransactionBytesStreamOutput.reset();
                while (this.scratchByteArrayStreamInput.available() > 0) {
                    long item = this.scratchByteArrayStreamInput.readVLong();
                    this.scratchTransactionBytesStreamOutput.writeVLong(other.getItemCounts().get(item));
                }
                newId = this.transactions.add(this.scratchTransactionBytesStreamOutput.get());
                if (newId < 0L) {
                    newId = -1L * (newId + 1L);
                } else if (newId >= this.transactionCounts.size()) {
                    this.transactionCounts = this.bigArrays.resize(this.transactionCounts, this.transactionCounts.size() + 2048L);
                }
                oldCount = other.getTransactionCounts().get(oldId);
                this.transactionCounts.increment(newId, oldCount);
            }
            ++i;
        }
        this.totalItemCount += other.getTotalItemCount();
        this.totalTransactionCount += other.getTotalTransactionCount();
        this.filteredTransactionCount += other.getFilteredTransactionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(double minSupport) throws IOException {
        long minCount = (long)(minSupport * (double)this.totalTransactionCount);
        logger.trace("prune items and transactions, using min count: {}", (Object)minCount);
        BytesRefHash prunedItems = null;
        LongArray prunedItemCounts = null;
        BytesRefHash prunedTransactions = null;
        LongArray prunedTransactionCounts = null;
        try {
            prunedItems = new BytesRefHash(this.items.capacity() >> 3, this.bigArrays);
            prunedItemCounts = this.bigArrays.newLongArray(this.items.capacity() >> 3, true);
            int i = 0;
            while ((long)i < this.items.capacity()) {
                long id = this.items.id((long)i);
                if (id >= 0L) {
                    this.items.get(id, this.scratchBytesRef);
                    long count = this.itemCounts.get(id);
                    if (count > minCount) {
                        long newId = prunedItems.add(this.scratchBytesRef);
                        assert (newId >= 0L) : "found illegal duplicate bytesRef";
                        if (newId >= prunedItemCounts.size()) {
                            prunedItemCounts = this.bigArrays.resize(prunedItemCounts, prunedItemCounts.size() + 2048L);
                        }
                        prunedItemCounts.set(newId, count);
                        this.itemCounts.set(id, newId);
                    } else {
                        this.itemCounts.set(id, -1L);
                    }
                }
                ++i;
            }
            logger.trace("Pruned items, before: {}, after: {}", (Object)this.items.size(), (Object)prunedItems.size());
            prunedTransactions = new BytesRefHash(this.transactions.capacity() >> 3, this.bigArrays);
            prunedTransactionCounts = this.bigArrays.newLongArray(this.transactions.capacity() >> 3, true);
            ArrayList<Long> itemBuffer = new ArrayList<Long>();
            int i2 = 0;
            while ((long)i2 < this.transactions.capacity()) {
                long id = this.transactions.id((long)i2);
                if (id >= 0L) {
                    this.transactions.get(id, this.scratchBytesRef);
                    this.scratchByteArrayStreamInput.reset(this.scratchBytesRef.bytes, this.scratchBytesRef.offset, this.scratchBytesRef.length);
                    itemBuffer.clear();
                    while (this.scratchByteArrayStreamInput.available() > 0) {
                        long item = this.itemCounts.get(this.scratchByteArrayStreamInput.readVLong());
                        if (item < 0L) continue;
                        itemBuffer.add(item);
                    }
                    if (itemBuffer.size() > 0) {
                        Collections.sort(itemBuffer, HashBasedTransactionStore.compareItems(prunedItemCounts));
                        this.scratchTransactionBytesStreamOutput.reset();
                        for (Long l : itemBuffer) {
                            this.scratchTransactionBytesStreamOutput.writeVLong(l.longValue());
                        }
                        long newId = prunedTransactions.add(this.scratchTransactionBytesStreamOutput.get());
                        long count = this.transactionCounts.get(id);
                        if (newId < 0L) {
                            newId = -1L * (newId + 1L);
                        } else if (newId >= prunedTransactionCounts.size()) {
                            prunedTransactionCounts = this.bigArrays.resize(prunedTransactionCounts, prunedTransactionCounts.size() + 2048L);
                        }
                        prunedTransactionCounts.increment(newId, count);
                    }
                }
                ++i2;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Pruned transactions, before: {}, after: {}", (Object)this.transactions.size(), (Object)prunedTransactions.size());
                long bytesBeforePruning = this.items.ramBytesUsed() + this.itemCounts.ramBytesUsed() + this.transactions.ramBytesUsed() + this.transactionCounts.ramBytesUsed();
                long bytesAfterPruning = prunedItems.ramBytesUsed() + prunedItemCounts.ramBytesUsed() + prunedTransactions.ramBytesUsed() + prunedTransactionCounts.ramBytesUsed();
                logger.trace("Pruned item and transactions, memory reclaimed: {}, size of transaction store after pruning: {}", (Object)RamUsageEstimator.humanReadableUnits((long)(bytesBeforePruning - bytesAfterPruning)), (Object)RamUsageEstimator.humanReadableUnits((long)bytesAfterPruning));
            }
            this.items.close();
            this.itemCounts.close();
            this.transactions.close();
            this.transactionCounts.close();
            this.items = prunedItems;
            prunedItems = null;
            this.itemCounts = prunedItemCounts;
            prunedItemCounts = null;
            this.transactions = prunedTransactions;
            prunedTransactions = null;
            this.transactionCounts = prunedTransactionCounts;
            prunedTransactionCounts = null;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{prunedItems, prunedItemCounts, prunedTransactions, prunedTransactionCounts});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{prunedItems, prunedItemCounts, prunedTransactions, prunedTransactionCounts});
    }

    public ImmutableTransactionStore createImmutableTransactionStore() {
        ImmutableTransactionStore immutableTransactionStore = new ImmutableTransactionStore(this.bigArrays, this.items.takeBytesRefsOwnership(), this.itemCounts, this.totalItemCount, this.transactions.takeBytesRefsOwnership(), this.transactionCounts, this.totalTransactionCount, this.filteredTransactionCount);
        this.items = null;
        this.transactions = null;
        this.itemCounts = null;
        this.transactionCounts = null;
        return immutableTransactionStore;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.items.getBytesRefs().writeTo(out);
        long itemCountsSize = this.items.size();
        long transactionCountsSize = this.transactions.size();
        out.writeVLong(itemCountsSize);
        int i = 0;
        while ((long)i < itemCountsSize) {
            out.writeVLong(this.itemCounts.get((long)i));
            ++i;
        }
        out.writeVLong(this.totalItemCount);
        this.transactions.getBytesRefs().writeTo(out);
        out.writeVLong(transactionCountsSize);
        i = 0;
        while ((long)i < transactionCountsSize) {
            out.writeVLong(this.transactionCounts.get((long)i));
            ++i;
        }
        out.writeVLong(this.totalTransactionCount);
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.items, this.itemCounts, this.transactions, this.transactionCounts});
        this.items = null;
        this.itemCounts = null;
        this.transactions = null;
        this.transactionCounts = null;
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + BASE_RAM_BYTES_USED + this.scratchItemBytesStreamOutput.ramBytesUsed() + this.scratchTransactionBytesStreamOutput.ramBytesUsed() + (long)this.scratchBytesRef.length + (long)this.scratchByteArrayStreamInput.length() + this.items.ramBytesUsed() + this.itemCounts.ramBytesUsed() + this.transactions.ramBytesUsed() + this.transactionCounts.ramBytesUsed();
    }
}

