/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorSyncInfo;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorLastSyncStatsAction {
    public static final String NAME = "cluster:admin/xpack/connector/update_last_sync_stats";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/update_last_sync_stats");

    private UpdateConnectorLastSyncStatsAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final ConnectorSyncInfo syncInfo;
        @Nullable
        private final Object syncCursor;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_last_sync_stats_request", false, (args, connectorId) -> {
            int i = 0;
            return new Builder().setConnectorId((String)connectorId).setSyncInfo(new ConnectorSyncInfo.Builder().setLastAccessControlSyncError((String)args[i++]).setLastAccessControlSyncScheduledAt((Instant)args[i++]).setLastAccessControlSyncStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setLastDeletedDocumentCount((Long)args[i++]).setLastIncrementalSyncScheduledAt((Instant)args[i++]).setLastIndexedDocumentCount((Long)args[i++]).setLastSyncError((String)args[i++]).setLastSyncScheduledAt((Instant)args[i++]).setLastSyncStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setLastSynced((Instant)args[i++]).build()).setSyncCursor(args[i]).build();
        });

        private Request(String connectorId, ConnectorSyncInfo syncInfo, Object syncCursor) {
            this.connectorId = connectorId;
            this.syncInfo = syncInfo;
            this.syncCursor = syncCursor;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.syncInfo = (ConnectorSyncInfo)in.readOptionalWriteable(ConnectorSyncInfo::new);
            this.syncCursor = in.readGenericValue();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ConnectorSyncInfo getSyncInfo() {
            return this.syncInfo;
        }

        public Object getSyncCursor() {
            return this.syncCursor;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.syncInfo.toXContent(builder, params);
            if (this.syncCursor != null) {
                builder.field(Connector.SYNC_CURSOR_FIELD.getPreferredName(), this.syncCursor);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalWriteable((Writeable)this.syncInfo);
            out.writeGenericValue(this.syncCursor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.syncInfo, request.syncInfo) && Objects.equals(this.syncCursor, request.syncCursor);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.syncInfo, this.syncCursor);
        }

        static {
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_ERROR);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConnectorSyncStatus.connectorSyncStatus(p.text()), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_STATUS_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_DELETED_DOCUMENT_COUNT_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_INDEXED_DOCUMENT_COUNT_FIELD);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_SYNC_ERROR_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConnectorSyncStatus.connectorSyncStatus(p.text()), ConnectorSyncInfo.LAST_SYNC_STATUS_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_SYNCED_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_SYNCED_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), null, Connector.SYNC_CURSOR_FIELD);
        }

        public static class Builder {
            private String connectorId;
            private ConnectorSyncInfo syncInfo;
            private Object syncCursor;

            public Builder setConnectorId(String connectorId) {
                this.connectorId = connectorId;
                return this;
            }

            public Builder setSyncInfo(ConnectorSyncInfo syncInfo) {
                this.syncInfo = syncInfo;
                return this;
            }

            public Builder setSyncCursor(Object syncCursor) {
                this.syncCursor = syncCursor;
                return this;
            }

            public Request build() {
                return new Request(this.connectorId, this.syncInfo, this.syncCursor);
            }
        }
    }
}

