/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class ReindexMetrics {
    public static final String REINDEX_TIME_HISTOGRAM = "es.reindex.duration.histogram";
    private final LongHistogram reindexTimeSecsHistogram;

    public ReindexMetrics(MeterRegistry meterRegistry) {
        this(meterRegistry.registerLongHistogram(REINDEX_TIME_HISTOGRAM, "Time to reindex by search", "seconds"));
    }

    private ReindexMetrics(LongHistogram reindexTimeSecsHistogram) {
        this.reindexTimeSecsHistogram = reindexTimeSecsHistogram;
    }

    public long recordTookTime(long tookTime) {
        this.reindexTimeSecsHistogram.record(tookTime);
        return tookTime;
    }
}

