/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class OperationRequestAccessLogMessage
extends OperationAccessLogMessage {
    private static final long serialVersionUID = -8942685623238040482L;
    @Nullable
    private final Boolean usingAdminSessionWorkerThread;
    @NotNull
    private final List<String> requestControlOIDs;
    @Nullable
    private final String intermediateClientRequest = this.getNamedValue("via");
    @Nullable
    private final String operationPurpose = this.getNamedValue("opPurpose");
    @Nullable
    private final String requesterDN = this.getNamedValue("requesterDN");
    @Nullable
    private final String requesterIP = this.getNamedValue("requesterIP");

    protected OperationRequestAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.usingAdminSessionWorkerThread = this.getNamedValueAsBoolean("usingAdminSessionWorkerThread");
        String controlStr = this.getNamedValue("requestControls");
        if (controlStr == null) {
            this.requestControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.requestControlOIDs = Collections.unmodifiableList(controlList);
        }
    }

    @Nullable
    public final String getRequesterDN() {
        return this.requesterDN;
    }

    @Nullable
    public final String getRequesterIPAddress() {
        return this.requesterIP;
    }

    @Nullable
    public final String getIntermediateClientRequest() {
        return this.intermediateClientRequest;
    }

    @Nullable
    public final String getOperationPurpose() {
        return this.operationPurpose;
    }

    @NotNull
    public final List<String> getRequestControlOIDs() {
        return this.requestControlOIDs;
    }

    @Nullable
    public final Boolean usingAdminSessionWorkerThread() {
        return this.usingAdminSessionWorkerThread;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.REQUEST;
    }
}

