// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Game_timer.h"




// ***************
// * CONSTRUCTOR *
// ***************
GameTimer::GameTimer()
{
    // This doesn't really need setting, but anyway:
    num_ticks_on_pause = 0; 
    
    start_time = SDL_GetTicks();
    
    running = true;

} // GameTimer::GameTimer

// **************
// * DESTRUCTOR *
// **************
GameTimer::~GameTimer()
{
    // ...
    
} // GameTimer::~GameTimer




// ********************
// * MEMBER FUNCTIONS *
// ********************

// **************************************************

bool GameTimer::pause()
{
    if (running)
    {
        num_ticks_on_pause = SDL_GetTicks() - start_time;
        running = false;
    } 
    else
    {
        start_time = SDL_GetTicks() - num_ticks_on_pause;
        running = true;
    } // if ... else
    
    return running;

} // GameTimer::pause

// **************************************************

int GameTimer::get_time() const
{
    return ((running) ? (SDL_GetTicks() - start_time) : num_ticks_on_pause);

} // GameTimer::time

// **************************************************

void GameTimer::resume()
{
    if (!running)
    {
        start_time = SDL_GetTicks() - num_ticks_on_pause;
        running = true;
    } // if

} // GameTimer::resume 

// **************************************************       
