/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.Combiners;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.WatchMode;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileWatcherUpdater
implements FileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileWatcherUpdater.class);
    protected final FileWatcherProbeRegistry probeRegistry;
    protected final WatchableHierarchies watchableHierarchies;
    private final MovedDirectoryHandler movedDirectoryHandler;
    protected FileHierarchySet watchedFiles = FileHierarchySet.empty();
    private ImmutableSet<File> probedHierarchies = ImmutableSet.of();

    public AbstractFileWatcherUpdater(FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies, MovedDirectoryHandler movedDirectoryHandler) {
        this.probeRegistry = probeRegistry;
        this.watchableHierarchies = watchableHierarchies;
        this.movedDirectoryHandler = movedDirectoryHandler;
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy, SnapshotHierarchy root) {
        this.watchableHierarchies.registerWatchableHierarchy(watchableHierarchy, root);
        this.probeRegistry.registerProbe(watchableHierarchy);
        this.update(root);
    }

    @Override
    public final SnapshotHierarchy updateVfsOnBuildStarted(SnapshotHierarchy root, WatchMode watchMode, List<File> unsupportedFileSystems) {
        SnapshotHierarchy newRoot = this.watchableHierarchies.removeUnwatchableContentOnBuildStart(root, this.createInvalidator(), watchMode, unsupportedFileSystems);
        if (root != (newRoot = this.invalidateMovedDirectoriesOnBuildStarted(newRoot))) {
            this.update(newRoot);
        }
        return newRoot;
    }

    @CheckReturnValue
    private SnapshotHierarchy invalidateMovedDirectoriesOnBuildStarted(SnapshotHierarchy root) {
        SnapshotHierarchy newRoot = root;
        WatchableHierarchies.Invalidator invalidator = this.createInvalidator();
        for (File movedDirectory : this.movedDirectoryHandler.stopWatchingMovedDirectories(root)) {
            LOGGER.info("Dropping VFS state for moved directory {}", (Object)movedDirectory.getAbsolutePath());
            newRoot = invalidator.invalidate(movedDirectory.getAbsolutePath(), newRoot);
        }
        return newRoot;
    }

    @Override
    public void virtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> removedSnapshots, Collection<FileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        boolean contentsChanged = this.handleVirtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, root);
        if (contentsChanged) {
            this.update(root);
        }
    }

    protected abstract boolean handleVirtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> var1, Collection<FileSystemLocationSnapshot> var2, SnapshotHierarchy var3);

    @Override
    public SnapshotHierarchy updateVfsBeforeBuildFinished(SnapshotHierarchy root, int maximumNumberOfWatchedHierarchies, List<File> unsupportedFileSystems) {
        SnapshotHierarchy newRoot = this.watchableHierarchies.removeUnwatchableContentBeforeBuildFinished(root, arg_0 -> ((FileHierarchySet)this.watchedFiles).contains(arg_0), maximumNumberOfWatchedHierarchies, unsupportedFileSystems, this.createInvalidator());
        if (root != newRoot) {
            this.update(newRoot);
        }
        return newRoot;
    }

    @Override
    public SnapshotHierarchy updateVfsBeforeAfterFinished(SnapshotHierarchy root) {
        SnapshotHierarchy newRoot = WatchableHierarchies.removeUnwatchableContentAfterBuildFinished(root, this.createInvalidator());
        if (root != newRoot) {
            this.update(newRoot);
        }
        return newRoot;
    }

    @Override
    public FileHierarchySet getWatchedFiles() {
        return this.watchedFiles;
    }

    @Override
    public void triggerWatchProbe(String path) {
        this.probeRegistry.triggerWatchProbe(path);
    }

    protected abstract WatchableHierarchies.Invalidator createInvalidator();

    private void update(SnapshotHierarchy root) {
        FileHierarchySet oldWatchedFiles = this.watchedFiles;
        this.watchedFiles = AbstractFileWatcherUpdater.resolveWatchedFiles(this.watchableHierarchies, root);
        if (!this.watchedFiles.equals(oldWatchedFiles)) {
            this.updateWatchesOnChangedWatchedFiles(this.watchedFiles);
        }
        ImmutableSet<File> oldProbedHierarchies = this.probedHierarchies;
        this.probedHierarchies = (ImmutableSet)this.watchableHierarchies.stream().filter(arg_0 -> ((FileHierarchySet)this.watchedFiles).contains(arg_0)).collect(ImmutableSet.toImmutableSet());
        if (oldProbedHierarchies.equals(this.probedHierarchies)) {
            return;
        }
        oldProbedHierarchies.stream().filter(oldProbedHierarchy -> !this.probedHierarchies.contains(oldProbedHierarchy)).forEach(probedHierarchy -> {
            File probeDirectory = this.probeRegistry.getProbeDirectory((File)probedHierarchy);
            this.probeRegistry.disarmWatchProbe((File)probedHierarchy);
            this.stopWatchingProbeDirectory(probeDirectory);
        });
        this.probedHierarchies.stream().filter(newProbedHierarchy -> !oldProbedHierarchies.contains(newProbedHierarchy)).forEach(probedHierarchy -> {
            File probeDirectory = this.probeRegistry.getProbeDirectory((File)probedHierarchy);
            probeDirectory.mkdirs();
            this.startWatchingProbeDirectory(probeDirectory);
            this.probeRegistry.armWatchProbe((File)probedHierarchy);
        });
    }

    protected abstract void updateWatchesOnChangedWatchedFiles(FileHierarchySet var1);

    protected abstract void startWatchingProbeDirectory(File var1);

    protected abstract void stopWatchingProbeDirectory(File var1);

    @VisibleForTesting
    static FileHierarchySet resolveWatchedFiles(WatchableHierarchies watchableHierarchies, SnapshotHierarchy vfsRoot) {
        return watchableHierarchies.stream().map(File::getPath).filter(watchableHierarchy -> AbstractFileWatcherUpdater.hasWatchableContent(vfsRoot.rootSnapshotsUnder(watchableHierarchy), watchableHierarchies)).reduce(FileHierarchySet.empty(), FileHierarchySet::plus, Combiners.nonCombining());
    }

    private static boolean hasWatchableContent(Stream<FileSystemLocationSnapshot> snapshots, WatchableHierarchies watchableHierarchies) {
        return snapshots.anyMatch(snapshot -> !AbstractFileWatcherUpdater.isMissing(snapshot) && !watchableHierarchies.ignoredForWatching((FileSystemLocationSnapshot)snapshot));
    }

    private static boolean isMissing(FileSystemLocationSnapshot snapshot) {
        return snapshot.getType() == FileType.Missing && snapshot.getAccessType() == FileMetadata.AccessType.DIRECT;
    }

    public static interface MovedDirectoryHandler {
        public Collection<File> stopWatchingMovedDirectories(SnapshotHierarchy var1);
    }
}

