/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.Base64;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.zkgroup.groupsend.GroupSendFullToken;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.groupsv2.GroupSendEndorsements;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00182\u00020\u0001:\u0006\u0013\u0014\u0015\u0016\u0017\u0018B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0000H&J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u0082\u0001\u0004\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "", "<init>", "()V", "senderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "getSenderCertificate", "()Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "headerName", "", "getHeaderName", "()Ljava/lang/String;", "headerValue", "getHeaderValue", "header", "getHeader", "switchToFallback", "applyHeader", "", "IndividualGroupSendTokenFirst", "IndividualUnidentifiedAccessFirst", "GroupGroupSendToken", "StorySendNoop", "CreateGroupSendToken", "Companion", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$GroupGroupSendToken;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$IndividualGroupSendTokenFirst;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$IndividualUnidentifiedAccessFirst;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$StorySendNoop;", "signal-service-java"})
public abstract class SealedSenderAccess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @Nullable
    public static final SealedSenderAccess NONE;

    private SealedSenderAccess() {
    }

    @NotNull
    public abstract SenderCertificate getSenderCertificate();

    @NotNull
    public abstract String getHeaderName();

    @NotNull
    public abstract String getHeaderValue();

    @NotNull
    public final String getHeader() {
        return this.getHeaderName() + ":" + this.getHeaderValue();
    }

    @Nullable
    public abstract SealedSenderAccess switchToFallback();

    public boolean applyHeader() {
        return true;
    }

    @JvmStatic
    @Nullable
    public static final SealedSenderAccess forIndividualWithGroupFallback(@Nullable UnidentifiedAccess unidentifiedAccess, @Nullable SenderCertificate senderCertificate, @Nullable CreateGroupSendToken createGroupSendToken) {
        return Companion.forIndividualWithGroupFallback(unidentifiedAccess, senderCertificate, createGroupSendToken);
    }

    @JvmStatic
    @Nullable
    public static final SealedSenderAccess forIndividual(@Nullable UnidentifiedAccess unidentifiedAccess) {
        return Companion.forIndividual(unidentifiedAccess);
    }

    @JvmStatic
    @NotNull
    public static final List<SealedSenderAccess> forFanOutGroupSend(@Nullable List<GroupSendFullToken> groupSendTokens, @Nullable SenderCertificate senderCertificate, @NotNull List<? extends UnidentifiedAccess> unidentifiedAccesses) {
        return Companion.forFanOutGroupSend(groupSendTokens, senderCertificate, unidentifiedAccesses);
    }

    @JvmStatic
    @NotNull
    public static final SealedSenderAccess forGroupSend(@Nullable SenderCertificate senderCertificate, @Nullable GroupSendEndorsements groupSendEndorsements, boolean forStory) {
        return Companion.forGroupSend(senderCertificate, groupSendEndorsements, forStory);
    }

    @JvmStatic
    public static final boolean isUnrestrictedForStory(@Nullable SealedSenderAccess sealedSenderAccess) {
        return Companion.isUnrestrictedForStory(sealedSenderAccess);
    }

    public /* synthetic */ SealedSenderAccess(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J<\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000fH\u0007J$\u0010\u0013\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$Companion;", "", "<init>", "()V", "NONE", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "forIndividualWithGroupFallback", "unidentifiedAccess", "Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;", "senderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "createGroupSendToken", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$CreateGroupSendToken;", "forIndividual", "forFanOutGroupSend", "", "groupSendTokens", "Lorg/signal/libsignal/zkgroup/groupsend/GroupSendFullToken;", "unidentifiedAccesses", "forGroupSend", "groupSendEndorsements", "Lorg/whispersystems/signalservice/api/groupsv2/GroupSendEndorsements;", "forStory", "", "isUnrestrictedForStory", "sealedSenderAccess", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nSealedSenderAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SealedSenderAccess.kt\norg/whispersystems/signalservice/api/crypto/SealedSenderAccess$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n1563#3:181\n1634#3,3:182\n1563#3:185\n1634#3,3:186\n*S KotlinDebug\n*F\n+ 1 SealedSenderAccess.kt\norg/whispersystems/signalservice/api/crypto/SealedSenderAccess$Companion\n*L\n142#1:181\n142#1:182,3\n149#1:185\n149#1:186,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SealedSenderAccess forIndividualWithGroupFallback(@Nullable UnidentifiedAccess unidentifiedAccess, @Nullable SenderCertificate senderCertificate, @Nullable CreateGroupSendToken createGroupSendToken) {
            GroupSendFullToken groupSendToken;
            if (unidentifiedAccess != null) {
                return new IndividualUnidentifiedAccessFirst(unidentifiedAccess, createGroupSendToken);
            }
            CreateGroupSendToken createGroupSendToken2 = createGroupSendToken;
            Object object = groupSendToken = createGroupSendToken2 != null ? createGroupSendToken2.create() : null;
            if (groupSendToken != null && senderCertificate != null) {
                return new IndividualGroupSendTokenFirst(groupSendToken, senderCertificate, null, 4, null);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final SealedSenderAccess forIndividual(@Nullable UnidentifiedAccess unidentifiedAccess) {
            IndividualUnidentifiedAccessFirst individualUnidentifiedAccessFirst;
            UnidentifiedAccess unidentifiedAccess2 = unidentifiedAccess;
            if (unidentifiedAccess2 != null) {
                UnidentifiedAccess it = unidentifiedAccess2;
                boolean bl = false;
                individualUnidentifiedAccessFirst = new IndividualUnidentifiedAccessFirst(it, null, 2, null);
            } else {
                individualUnidentifiedAccessFirst = null;
            }
            return individualUnidentifiedAccessFirst;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<SealedSenderAccess> forFanOutGroupSend(@Nullable List<GroupSendFullToken> groupSendTokens, @Nullable SenderCertificate senderCertificate, @NotNull List<? extends UnidentifiedAccess> unidentifiedAccesses) {
            Intrinsics.checkNotNullParameter(unidentifiedAccesses, (String)"unidentifiedAccesses");
            if (groupSendTokens == null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = unidentifiedAccesses;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void a;
                    UnidentifiedAccess unidentifiedAccess = (UnidentifiedAccess)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Companion.forIndividual((UnidentifiedAccess)a));
                }
                return (List)destination$iv$iv;
            }
            if (!(groupSendTokens.size() == unidentifiedAccesses.size())) {
                String $i$f$map = "Failed requirement.";
                throw new IllegalArgumentException($i$f$map.toString());
            }
            Iterable $this$map$iv = CollectionsKt.zip((Iterable)groupSendTokens, (Iterable)unidentifiedAccesses);
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GroupSendFullToken token = (GroupSendFullToken)pair.component1();
                UnidentifiedAccess unidentifiedAccess = (UnidentifiedAccess)pair.component2();
                collection.add(unidentifiedAccess != null ? (SealedSenderAccess)new IndividualUnidentifiedAccessFirst(unidentifiedAccess, () -> Companion.forFanOutGroupSend$lambda$3$lambda$2(token)) : (token != null && senderCertificate != null ? (SealedSenderAccess)new IndividualGroupSendTokenFirst(token, senderCertificate, null, 4, null) : null));
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final SealedSenderAccess forGroupSend(@Nullable SenderCertificate senderCertificate, @Nullable GroupSendEndorsements groupSendEndorsements, boolean forStory) {
            if (forStory) {
                SenderCertificate senderCertificate2 = senderCertificate;
                Intrinsics.checkNotNull((Object)senderCertificate2);
                return new StorySendNoop(senderCertificate2);
            }
            GroupSendEndorsements groupSendEndorsements2 = groupSendEndorsements;
            Intrinsics.checkNotNull((Object)groupSendEndorsements2);
            return new GroupGroupSendToken(groupSendEndorsements2);
        }

        @JvmStatic
        public final boolean isUnrestrictedForStory(@Nullable SealedSenderAccess sealedSenderAccess) {
            boolean bl;
            SealedSenderAccess sealedSenderAccess2 = sealedSenderAccess;
            if (sealedSenderAccess2 instanceof IndividualGroupSendTokenFirst) {
                UnidentifiedAccess unidentifiedAccess = ((IndividualGroupSendTokenFirst)sealedSenderAccess).getUnidentifiedAccess();
                bl = unidentifiedAccess != null ? unidentifiedAccess.isUnrestrictedForStory() : false;
            } else {
                bl = sealedSenderAccess2 instanceof IndividualUnidentifiedAccessFirst ? ((IndividualUnidentifiedAccessFirst)sealedSenderAccess).getUnidentifiedAccess().isUnrestrictedForStory() : false;
            }
            return bl;
        }

        private static final GroupSendFullToken forFanOutGroupSend$lambda$3$lambda$2(GroupSendFullToken $token) {
            return $token;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$CreateGroupSendToken;", "", "create", "Lorg/signal/libsignal/zkgroup/groupsend/GroupSendFullToken;", "signal-service-java"})
    public static interface CreateGroupSendToken {
        @Nullable
        public GroupSendFullToken create();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$GroupGroupSendToken;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "groupSendEndorsements", "Lorg/whispersystems/signalservice/api/groupsv2/GroupSendEndorsements;", "<init>", "(Lorg/whispersystems/signalservice/api/groupsv2/GroupSendEndorsements;)V", "headerName", "", "getHeaderName", "()Ljava/lang/String;", "headerValue", "getHeaderValue", "headerValue$delegate", "Lkotlin/Lazy;", "senderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "getSenderCertificate", "()Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "switchToFallback", "signal-service-java"})
    public static final class GroupGroupSendToken
    extends SealedSenderAccess {
        @NotNull
        private final GroupSendEndorsements groupSendEndorsements;
        @NotNull
        private final String headerName;
        @NotNull
        private final Lazy headerValue$delegate;

        public GroupGroupSendToken(@NotNull GroupSendEndorsements groupSendEndorsements) {
            Intrinsics.checkNotNullParameter((Object)groupSendEndorsements, (String)"groupSendEndorsements");
            super(null);
            this.groupSendEndorsements = groupSendEndorsements;
            this.headerName = "Group-Send-Token";
            this.headerValue$delegate = LazyKt.lazy(() -> GroupGroupSendToken.headerValue_delegate$lambda$0(this));
        }

        @Override
        @NotNull
        public String getHeaderName() {
            return this.headerName;
        }

        @Override
        @NotNull
        public String getHeaderValue() {
            Lazy lazy = this.headerValue$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @NotNull
        public SenderCertificate getSenderCertificate() {
            return this.groupSendEndorsements.getSealedSenderCertificate();
        }

        @Override
        @Nullable
        public SealedSenderAccess switchToFallback() {
            return null;
        }

        private static final String headerValue_delegate$lambda$0(GroupGroupSendToken this$0) {
            return Base64.encodeWithPadding$default((byte[])this$0.groupSendEndorsements.serialize(), (int)0, (int)0, (int)6, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$IndividualGroupSendTokenFirst;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "groupSendToken", "Lorg/signal/libsignal/zkgroup/groupsend/GroupSendFullToken;", "senderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "unidentifiedAccess", "Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;", "<init>", "(Lorg/signal/libsignal/zkgroup/groupsend/GroupSendFullToken;Lorg/signal/libsignal/metadata/certificate/SenderCertificate;Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;)V", "getSenderCertificate", "()Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "getUnidentifiedAccess", "()Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;", "headerName", "", "getHeaderName", "()Ljava/lang/String;", "headerValue", "getHeaderValue", "headerValue$delegate", "Lkotlin/Lazy;", "switchToFallback", "signal-service-java"})
    public static final class IndividualGroupSendTokenFirst
    extends SealedSenderAccess {
        @NotNull
        private final GroupSendFullToken groupSendToken;
        @NotNull
        private final SenderCertificate senderCertificate;
        @Nullable
        private final UnidentifiedAccess unidentifiedAccess;
        @NotNull
        private final String headerName;
        @NotNull
        private final Lazy headerValue$delegate;

        public IndividualGroupSendTokenFirst(@NotNull GroupSendFullToken groupSendToken, @NotNull SenderCertificate senderCertificate, @Nullable UnidentifiedAccess unidentifiedAccess) {
            Intrinsics.checkNotNullParameter((Object)groupSendToken, (String)"groupSendToken");
            Intrinsics.checkNotNullParameter((Object)senderCertificate, (String)"senderCertificate");
            super(null);
            this.groupSendToken = groupSendToken;
            this.senderCertificate = senderCertificate;
            this.unidentifiedAccess = unidentifiedAccess;
            this.headerName = "Group-Send-Token";
            this.headerValue$delegate = LazyKt.lazy(() -> IndividualGroupSendTokenFirst.headerValue_delegate$lambda$0(this));
        }

        public /* synthetic */ IndividualGroupSendTokenFirst(GroupSendFullToken groupSendFullToken, SenderCertificate senderCertificate, UnidentifiedAccess unidentifiedAccess, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                unidentifiedAccess = null;
            }
            this(groupSendFullToken, senderCertificate, unidentifiedAccess);
        }

        @Override
        @NotNull
        public SenderCertificate getSenderCertificate() {
            return this.senderCertificate;
        }

        @Nullable
        public final UnidentifiedAccess getUnidentifiedAccess() {
            return this.unidentifiedAccess;
        }

        @Override
        @NotNull
        public String getHeaderName() {
            return this.headerName;
        }

        @Override
        @NotNull
        public String getHeaderValue() {
            Lazy lazy = this.headerValue$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @Nullable
        public SealedSenderAccess switchToFallback() {
            return this.unidentifiedAccess != null ? (SealedSenderAccess)new IndividualUnidentifiedAccessFirst(this.unidentifiedAccess, null, 2, null) : null;
        }

        private static final String headerValue_delegate$lambda$0(IndividualGroupSendTokenFirst this$0) {
            byte[] byArray = this$0.groupSendToken.serialize();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
            return Base64.encodeWithPadding$default((byte[])byArray, (int)0, (int)0, (int)6, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$IndividualUnidentifiedAccessFirst;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "unidentifiedAccess", "Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;", "createGroupSendToken", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$CreateGroupSendToken;", "<init>", "(Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$CreateGroupSendToken;)V", "getUnidentifiedAccess", "()Lorg/whispersystems/signalservice/api/crypto/UnidentifiedAccess;", "senderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "getSenderCertificate", "()Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "headerName", "", "getHeaderName", "()Ljava/lang/String;", "headerValue", "getHeaderValue", "headerValue$delegate", "Lkotlin/Lazy;", "switchToFallback", "signal-service-java"})
    public static final class IndividualUnidentifiedAccessFirst
    extends SealedSenderAccess {
        @NotNull
        private final UnidentifiedAccess unidentifiedAccess;
        @Nullable
        private final CreateGroupSendToken createGroupSendToken;
        @NotNull
        private final String headerName;
        @NotNull
        private final Lazy headerValue$delegate;

        public IndividualUnidentifiedAccessFirst(@NotNull UnidentifiedAccess unidentifiedAccess, @Nullable CreateGroupSendToken createGroupSendToken) {
            Intrinsics.checkNotNullParameter((Object)unidentifiedAccess, (String)"unidentifiedAccess");
            super(null);
            this.unidentifiedAccess = unidentifiedAccess;
            this.createGroupSendToken = createGroupSendToken;
            this.headerName = "Unidentified-Access-Key";
            this.headerValue$delegate = LazyKt.lazy(() -> IndividualUnidentifiedAccessFirst.headerValue_delegate$lambda$0(this));
        }

        public /* synthetic */ IndividualUnidentifiedAccessFirst(UnidentifiedAccess unidentifiedAccess, CreateGroupSendToken createGroupSendToken, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                createGroupSendToken = null;
            }
            this(unidentifiedAccess, createGroupSendToken);
        }

        @NotNull
        public final UnidentifiedAccess getUnidentifiedAccess() {
            return this.unidentifiedAccess;
        }

        @Override
        @NotNull
        public SenderCertificate getSenderCertificate() {
            SenderCertificate senderCertificate = this.unidentifiedAccess.getUnidentifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)senderCertificate, (String)"getUnidentifiedCertificate(...)");
            return senderCertificate;
        }

        @Override
        @NotNull
        public String getHeaderName() {
            return this.headerName;
        }

        @Override
        @NotNull
        public String getHeaderValue() {
            Lazy lazy = this.headerValue$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @Nullable
        public SealedSenderAccess switchToFallback() {
            CreateGroupSendToken createGroupSendToken = this.createGroupSendToken;
            GroupSendFullToken groupSendToken = createGroupSendToken != null ? createGroupSendToken.create() : null;
            return groupSendToken != null ? (SealedSenderAccess)new IndividualGroupSendTokenFirst(groupSendToken, this.getSenderCertificate(), null, 4, null) : null;
        }

        private static final String headerValue_delegate$lambda$0(IndividualUnidentifiedAccessFirst this$0) {
            byte[] byArray = this$0.unidentifiedAccess.getUnidentifiedAccessKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getUnidentifiedAccessKey(...)");
            return Base64.encodeWithPadding$default((byte[])byArray, (int)0, (int)0, (int)6, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess$StorySendNoop;", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "senderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "<init>", "(Lorg/signal/libsignal/metadata/certificate/SenderCertificate;)V", "getSenderCertificate", "()Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "headerName", "", "getHeaderName", "()Ljava/lang/String;", "headerValue", "getHeaderValue", "switchToFallback", "applyHeader", "", "signal-service-java"})
    public static final class StorySendNoop
    extends SealedSenderAccess {
        @NotNull
        private final SenderCertificate senderCertificate;
        @NotNull
        private final String headerName;
        @NotNull
        private final String headerValue;

        public StorySendNoop(@NotNull SenderCertificate senderCertificate) {
            Intrinsics.checkNotNullParameter((Object)senderCertificate, (String)"senderCertificate");
            super(null);
            this.senderCertificate = senderCertificate;
            this.headerName = "";
            this.headerValue = "";
        }

        @Override
        @NotNull
        public SenderCertificate getSenderCertificate() {
            return this.senderCertificate;
        }

        @Override
        @NotNull
        public String getHeaderName() {
            return this.headerName;
        }

        @Override
        @NotNull
        public String getHeaderValue() {
            return this.headerValue;
        }

        @Override
        @Nullable
        public SealedSenderAccess switchToFallback() {
            return null;
        }

        @Override
        public boolean applyHeader() {
            return false;
        }
    }
}

