/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;
import net.sf.clipsrules.jni.examples.ide.DialogFrame;
import net.sf.clipsrules.jni.examples.ide.TextFrame;

public class TextMenu
extends JMenu
implements MenuListener {
    private TextFrame textFrame = null;
    private CLIPSIDE ide = null;
    private JMenuItem jmiLoadSelection;
    private JMenuItem jmiBatchSelection;
    private JMenuItem jmiLoadBuffer;
    private JMenuItem jmiBalance;
    private JMenuItem jmiComment;
    private JMenuItem jmiUncomment;
    private LoadSelectionAction loadSelectionAction;
    private BatchSelectionAction batchSelectionAction;
    private LoadBufferAction loadBufferAction;
    private BalanceAction balanceAction;
    private CommentAction commentAction;
    private UncommentAction uncommentAction;

    TextMenu(CLIPSIDE cLIPSIDE, TextFrame textFrame) {
        super("Text");
        this.ide = cLIPSIDE;
        this.addMenuListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(75, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(75, 192);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(66, 128);
        this.loadSelectionAction = new LoadSelectionAction("Load Selection");
        this.batchSelectionAction = new BatchSelectionAction("Batch Selection");
        this.loadBufferAction = new LoadBufferAction("Load Buffer");
        this.balanceAction = new BalanceAction("Balance");
        this.commentAction = new CommentAction("Comment");
        this.uncommentAction = new UncommentAction("Uncomment");
        this.jmiLoadSelection = new JMenuItem(this.loadSelectionAction);
        if (textFrame == null) {
            this.jmiLoadSelection.setAccelerator(keyStroke);
        }
        this.add(this.jmiLoadSelection);
        this.jmiBatchSelection = new JMenuItem(this.batchSelectionAction);
        if (textFrame == null) {
            this.jmiBatchSelection.setAccelerator(keyStroke2);
        }
        this.add(this.jmiBatchSelection);
        this.jmiLoadBuffer = new JMenuItem(this.loadBufferAction);
        this.add(this.jmiLoadBuffer);
        this.addSeparator();
        this.jmiBalance = new JMenuItem(this.balanceAction);
        if (textFrame == null) {
            this.jmiBalance.setAccelerator(keyStroke3);
        }
        this.add(this.jmiBalance);
        this.jmiComment = new JMenuItem(this.commentAction);
        this.add(this.jmiComment);
        this.jmiUncomment = new JMenuItem(this.uncommentAction);
        this.add(this.jmiUncomment);
        this.textFrame = textFrame;
    }

    public void setTextFrame(TextFrame textFrame) {
        this.textFrame = textFrame;
    }

    private void loadSelection() {
        if (this.textFrame == null) {
            return;
        }
        Environment environment = this.ide.getEnvironment();
        DialogFrame dialogFrame = this.ide.getDialogWindow();
        if (dialogFrame.isExecuting()) {
            return;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        String string = jTextArea.getSelectedText();
        if (string == null) {
            return;
        }
        this.ide.selectDialogWindow();
        environment.flushInputBuffer();
        environment.print("stdout", "Loading Selection...\n");
        environment.loadFromStringWithOutput(string);
        environment.printPrompt();
    }

    private void batchSelection() {
        if (this.textFrame == null) {
            return;
        }
        Environment environment = this.ide.getEnvironment();
        DialogFrame dialogFrame = this.ide.getDialogWindow();
        if (dialogFrame.isExecuting()) {
            return;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        String string = jTextArea.getSelectedText();
        if (string == null) {
            return;
        }
        this.ide.selectDialogWindow();
        environment.openStringBatch("batchtext", string, false);
        this.ide.executeBatch();
    }

    private void loadBuffer() {
        if (this.textFrame == null) {
            return;
        }
        Environment environment = this.ide.getEnvironment();
        DialogFrame dialogFrame = this.ide.getDialogWindow();
        if (dialogFrame.isExecuting()) {
            return;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        String string = jTextArea.getText();
        this.ide.selectDialogWindow();
        environment.flushInputBuffer();
        environment.print("stdout", "Loading Buffer...\n");
        environment.loadFromStringWithOutput(string);
        environment.printPrompt();
    }

    private void balance() {
        if (this.textFrame == null) {
            return;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        String string = jTextArea.getText();
        if (string.length() == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int n = jTextArea.getSelectionStart();
        int n2 = jTextArea.getSelectionEnd();
        int n3 = string.length();
        if (n == n2) {
            if (n < n3 && string.charAt(n) == '(') {
                this.balanceIt(string, n, n + 1, 1, 0, n3);
            } else if (n > 0 && string.charAt(n - 1) == ')') {
                if (n < 2) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.balanceIt(string, n - 2, n, 0, -1, n3);
            } else {
                this.balanceIt(string, n - 1, n2, 0, 0, n3);
            }
        } else {
            char c;
            int n4;
            int n5 = 0;
            int n6 = 0;
            for (n4 = n; n4 < n2; ++n4) {
                c = string.charAt(n4);
                if (c == '(') {
                    ++n5;
                } else if (c == ')') {
                    --n5;
                }
                if (n5 >= n6) continue;
                n6 = n5;
            }
            n5 = 0;
            int n7 = 0;
            boolean bl = false;
            n4 = n2 - 1;
            while (!bl) {
                c = string.charAt(n4);
                if (c == '(') {
                    ++n5;
                } else if (c == ')') {
                    --n5;
                }
                if (n5 > n7) {
                    n7 = n5;
                }
                if (n4 == n) {
                    bl = true;
                    continue;
                }
                --n4;
            }
            this.balanceIt(string, n == 0 ? 0 : n - 1, n2, n6, n7, n3);
        }
    }

    private void balanceIt(String string, int n, int n2, int n3, int n4, int n5) {
        char c;
        boolean bl = false;
        while (n3 <= 0) {
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            c = string.charAt(n);
            if (c == '(') {
                ++n3;
            } else if (c == ')') {
                --n3;
            }
            if (n3 > 0) continue;
            if (n > 0) {
                --n;
                continue;
            }
            bl = true;
        }
        while (n4 >= 0) {
            if (n2 >= n5) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            c = string.charAt(n2);
            if (c == '(') {
                ++n4;
            } else if (c == ')') {
                --n4;
            }
            ++n2;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        jTextArea.setCaretPosition(n);
        jTextArea.moveCaretPosition(n2);
    }

    private void comment() {
        StringBuilder stringBuilder;
        int n;
        int n2;
        int n3;
        if (this.textFrame == null) {
            return;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        int n4 = jTextArea.getSelectionStart();
        int n5 = jTextArea.getSelectionEnd();
        try {
            n3 = jTextArea.getLineOfOffset(n4);
            int n6 = jTextArea.getLineOfOffset(n5);
            n2 = jTextArea.getLineStartOffset(n3);
            n = jTextArea.getLineEndOffset(n6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            String string = jTextArea.getText(n2, n - n2);
            stringBuilder = new StringBuilder(string);
            for (int i = n6; i >= n3; --i) {
                int n7 = jTextArea.getLineStartOffset(i) - n2;
                stringBuilder.insert(n7, ';');
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        jTextArea.replaceRange(stringBuilder.toString(), n2, n);
        jTextArea.setCaretPosition(n2);
        jTextArea.moveCaretPosition(n2 + stringBuilder.length() - 1);
    }

    private void uncomment() {
        StringBuilder stringBuilder;
        int n;
        int n2;
        int n3;
        if (this.textFrame == null) {
            return;
        }
        JTextArea jTextArea = this.textFrame.getTextArea();
        int n4 = jTextArea.getSelectionStart();
        int n5 = jTextArea.getSelectionEnd();
        try {
            n3 = jTextArea.getLineOfOffset(n4);
            int n6 = jTextArea.getLineOfOffset(n5);
            n2 = jTextArea.getLineStartOffset(n3);
            n = jTextArea.getLineEndOffset(n6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            String string = jTextArea.getText(n2, n - n2);
            stringBuilder = new StringBuilder(string);
            for (int i = n6; i >= n3; --i) {
                int n7 = jTextArea.getLineStartOffset(i) - n2;
                if (stringBuilder.charAt(n7) != ';') continue;
                stringBuilder.deleteCharAt(n7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (stringBuilder.length() == n - n2) {
            return;
        }
        jTextArea.replaceRange(stringBuilder.toString(), n2, n);
        jTextArea.setCaretPosition(n2);
        jTextArea.moveCaretPosition(n2 + stringBuilder.length() - 1);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        DialogFrame dialogFrame = this.ide.getDialogWindow();
        if (this.textFrame == null) {
            this.jmiLoadSelection.setEnabled(false);
            this.jmiBatchSelection.setEnabled(false);
            this.jmiLoadBuffer.setEnabled(false);
            this.jmiBalance.setEnabled(false);
            this.jmiComment.setEnabled(false);
            this.jmiUncomment.setEnabled(false);
            return;
        }
        if (this.textFrame.hasSelection()) {
            if (dialogFrame.isExecuting()) {
                this.jmiLoadSelection.setEnabled(false);
                this.jmiBatchSelection.setEnabled(false);
            } else {
                this.jmiLoadSelection.setEnabled(true);
                this.jmiBatchSelection.setEnabled(true);
            }
        } else {
            this.jmiLoadSelection.setEnabled(false);
            this.jmiBatchSelection.setEnabled(false);
        }
        if (dialogFrame.isExecuting()) {
            this.jmiLoadBuffer.setEnabled(false);
        } else {
            this.jmiLoadBuffer.setEnabled(true);
        }
        this.jmiBalance.setEnabled(true);
        this.jmiComment.setEnabled(true);
        this.jmiUncomment.setEnabled(true);
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    class UncommentAction
    extends AbstractAction {
        public UncommentAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextMenu.this.uncomment();
        }
    }

    class CommentAction
    extends AbstractAction {
        public CommentAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextMenu.this.comment();
        }
    }

    class BalanceAction
    extends AbstractAction {
        public BalanceAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextMenu.this.balance();
        }
    }

    class LoadBufferAction
    extends AbstractAction {
        public LoadBufferAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextMenu.this.loadBuffer();
        }
    }

    class BatchSelectionAction
    extends AbstractAction {
        public BatchSelectionAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextMenu.this.batchSelection();
        }
    }

    class LoadSelectionAction
    extends AbstractAction {
        public LoadSelectionAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextMenu.this.loadSelection();
        }
    }
}

