macro(configure_sdl2_sound _NAME_TARGET _ONLY_DEFINES)
    set(PREVIOUS_INVOCATION ${CONFIGURE_SDL2_SOUND_INVOKED_PREVIOUSLY})
    find_package(PkgConfig REQUIRED)
    pkg_check_modules(SDL2 QUIET IMPORTED_TARGET sdl2)
    pkg_check_modules(SDL2_MIXER QUIET IMPORTED_TARGET SDL2_mixer>=2.0.0)
    if(SDL2_FOUND AND SDL2_MIXER_FOUND)
        if(NOT _ONLY_DEFINES)
            include(PkgConfigHelpers)
            angband_pkgconfig_select_target(SDL2       SDL2_SELECTED)
            angband_pkgconfig_select_target(SDL2_MIXER SDL2_MIXER_SELECTED)
            target_link_libraries(${_NAME_TARGET} PRIVATE ${SDL2_SELECTED} ${SDL2_MIXER_SELECTED})
        endif()
        target_compile_definitions(${_NAME_TARGET} PRIVATE SOUND_SDL2 SOUND)
        if(NOT PREVIOUS_INVOCATION)
            message(STATUS "Support for sound with SDL2 - Ready")
        endif()
        set(CONFIGURE_SDL2_SOUND_INVOKED_PREVIOUSLY YES CACHE
            INTERNAL "Mark if CONFIGURE_SDL_SOUND called successfully" FORCE)
    else()
        message(FATAL_ERROR "Support for sound with SDL2 - Failed")
    endif()
endmacro()
