#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <glib.h>
#include <stdio.h>
#include <netdb.h>
#include "pop_common.h"
#include "pop_client.h"

int main(int argc, char *argv[])
{
  struct hostent *he;
  struct in_addr **paddr;
  struct sockaddr_in clientsocket;
  gint sfd,i; /* Socket file descriptor */
  gchar *message, *text;
  socklen_t ssize;

  /****************
   Validate arguments
  ******************/
  if(argc<3) client_print_use();
  if((he = gethostbyname(argv[1]))==NULL) printquit("Could not resolve hostname.-");
  paddr = (struct in_addr **)he->h_addr_list;

  /***************
   Establish connection
  *****************/
  if((sfd=socket(PF_INET, SOCK_STREAM,0))<0) errquit("Establishing socket ");
  memset(&clientsocket,0,sizeof(clientsocket));
  clientsocket.sin_family = AF_INET;
  clientsocket.sin_port   = htons(CP_PORT);
  if(!(inet_aton(inet_ntoa(**paddr) ,&clientsocket.sin_addr)))perror("Address failed");
  if(inet_ntoa(**paddr),connect(sfd,(struct sockaddr *)&clientsocket,(socklen_t)sizeof(clientsocket))<0) perror("Connect failed ");
  
  /*****************
    Send message
  ******************/

  text=argv[2];
  for(i=2;i<argc-1;i++)
    {
      argv[i][strlen(argv[i])]=' ';
    }
  
  message = g_strdup_printf ("MSG:%s",text);/*Prepare the message*/
  
  write(sfd,message ,strlen(message)+1);/*Send the message*/

  /*clean up*/
  g_free(message);
  close(sfd);
}

void client_print_use(void)
{
  printf("usage:\n\tcpop_client host message\n\n");
  exit(0);
}
