/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpObserveLayer
extends AbstractLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpObserveLayer.class);
    private static final Integer CANCEL = 1;

    public TcpObserveLayer(Configuration config) {
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (CANCEL.equals(request.getOptions().getObserve())) {
            // empty if block
        }
        this.lower().sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        response.setType(CoAP.Type.CON);
        ObserveRelation relation = exchange.getRelation();
        ObserveRelation.State state = ObserveRelation.onResponse(relation, response);
        if (relation != null) {
            if (state == ObserveRelation.State.CANCELED && exchange.isComplete()) {
                LOGGER.debug("drop notification {}, relation was canceled!", (Object)response);
                response.setCanceled(true);
                return;
            }
            relation.onSend(response);
        }
        this.lower().sendResponse(exchange, response);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (response.getOptions().hasObserve() && exchange.getRequest().isCanceled()) {
            LOGGER.debug("ignoring notification for canceled TCP Exchange");
        } else {
            this.upper().receiveResponse(exchange, response);
        }
    }
}

