// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddStorageSystem = "AddStorageSystem"

// AddStorageSystemRequest generates a "aws/request.Request" representing the
// client's request for the AddStorageSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddStorageSystem for more information on using the AddStorageSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddStorageSystemRequest method.
//	req, resp := client.AddStorageSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/AddStorageSystem
func (c *DataSync) AddStorageSystemRequest(input *AddStorageSystemInput) (req *request.Request, output *AddStorageSystemOutput) {
	op := &request.Operation{
		Name:       opAddStorageSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddStorageSystemInput{}
	}

	output = &AddStorageSystemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AddStorageSystem API operation for AWS DataSync.
//
// Creates an Amazon Web Services resource for an on-premises storage system
// that you want DataSync Discovery to collect information about.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation AddStorageSystem for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/AddStorageSystem
func (c *DataSync) AddStorageSystem(input *AddStorageSystemInput) (*AddStorageSystemOutput, error) {
	req, out := c.AddStorageSystemRequest(input)
	return out, req.Send()
}

// AddStorageSystemWithContext is the same as AddStorageSystem with the addition of
// the ability to pass a context and additional request options.
//
// See AddStorageSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) AddStorageSystemWithContext(ctx aws.Context, input *AddStorageSystemInput, opts ...request.Option) (*AddStorageSystemOutput, error) {
	req, out := c.AddStorageSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelTaskExecution = "CancelTaskExecution"

// CancelTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelTaskExecution for more information on using the CancelTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelTaskExecutionRequest method.
//	req, resp := client.CancelTaskExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution
func (c *DataSync) CancelTaskExecutionRequest(input *CancelTaskExecutionInput) (req *request.Request, output *CancelTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelTaskExecutionInput{}
	}

	output = &CancelTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelTaskExecution API operation for AWS DataSync.
//
// Stops an DataSync task execution that's in progress. The transfer of some
// files are abruptly interrupted. File contents that're transferred to the
// destination might be incomplete or inconsistent with the source files.
//
// However, if you start a new task execution using the same task and allow
// it to finish, file content on the destination will be complete and consistent.
// This applies to other unexpected failures that interrupt a task execution.
// In all of these cases, DataSync successfully completes the transfer when
// you start the next task execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CancelTaskExecution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution
func (c *DataSync) CancelTaskExecution(input *CancelTaskExecutionInput) (*CancelTaskExecutionOutput, error) {
	req, out := c.CancelTaskExecutionRequest(input)
	return out, req.Send()
}

// CancelTaskExecutionWithContext is the same as CancelTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CancelTaskExecutionWithContext(ctx aws.Context, input *CancelTaskExecutionInput, opts ...request.Option) (*CancelTaskExecutionOutput, error) {
	req, out := c.CancelTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgent = "CreateAgent"

// CreateAgentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgent for more information on using the CreateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentRequest method.
//	req, resp := client.CreateAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent
func (c *DataSync) CreateAgentRequest(input *CreateAgentInput) (req *request.Request, output *CreateAgentOutput) {
	op := &request.Operation{
		Name:       opCreateAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAgentInput{}
	}

	output = &CreateAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgent API operation for AWS DataSync.
//
// Activates an DataSync agent that you have deployed in your storage environment.
// The activation process associates your agent with your account. In the activation
// process, you specify information such as the Amazon Web Services Region that
// you want to activate the agent in. You activate the agent in the Amazon Web
// Services Region where your target locations (in Amazon S3 or Amazon EFS)
// reside. Your tasks are created in this Amazon Web Services Region.
//
// You can activate the agent in a VPC (virtual private cloud) or provide the
// agent access to a VPC endpoint so you can run tasks without going over the
// public internet.
//
// You can use an agent for more than one location. If a task uses multiple
// agents, all of them need to have status AVAILABLE for the task to run. If
// you use multiple agents for a source location, the status of all the agents
// must be AVAILABLE for the task to run.
//
// Agents are automatically updated by Amazon Web Services on a regular basis,
// using a mechanism that ensures minimal interruption to your tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateAgent for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent
func (c *DataSync) CreateAgent(input *CreateAgentInput) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	return out, req.Send()
}

// CreateAgentWithContext is the same as CreateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateAgentWithContext(ctx aws.Context, input *CreateAgentInput, opts ...request.Option) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationEfs = "CreateLocationEfs"

// CreateLocationEfsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationEfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationEfs for more information on using the CreateLocationEfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationEfsRequest method.
//	req, resp := client.CreateLocationEfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs
func (c *DataSync) CreateLocationEfsRequest(input *CreateLocationEfsInput) (req *request.Request, output *CreateLocationEfsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationEfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationEfsInput{}
	}

	output = &CreateLocationEfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationEfs API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon EFS file system that DataSync can access
// for a transfer. For more information, see Creating a location for Amazon
// EFS (https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationEfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs
func (c *DataSync) CreateLocationEfs(input *CreateLocationEfsInput) (*CreateLocationEfsOutput, error) {
	req, out := c.CreateLocationEfsRequest(input)
	return out, req.Send()
}

// CreateLocationEfsWithContext is the same as CreateLocationEfs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationEfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationEfsWithContext(ctx aws.Context, input *CreateLocationEfsInput, opts ...request.Option) (*CreateLocationEfsOutput, error) {
	req, out := c.CreateLocationEfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationFsxLustre = "CreateLocationFsxLustre"

// CreateLocationFsxLustreRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationFsxLustre operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationFsxLustre for more information on using the CreateLocationFsxLustre
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationFsxLustreRequest method.
//	req, resp := client.CreateLocationFsxLustreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxLustre
func (c *DataSync) CreateLocationFsxLustreRequest(input *CreateLocationFsxLustreInput) (req *request.Request, output *CreateLocationFsxLustreOutput) {
	op := &request.Operation{
		Name:       opCreateLocationFsxLustre,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationFsxLustreInput{}
	}

	output = &CreateLocationFsxLustreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationFsxLustre API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon FSx for Lustre file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationFsxLustre for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxLustre
func (c *DataSync) CreateLocationFsxLustre(input *CreateLocationFsxLustreInput) (*CreateLocationFsxLustreOutput, error) {
	req, out := c.CreateLocationFsxLustreRequest(input)
	return out, req.Send()
}

// CreateLocationFsxLustreWithContext is the same as CreateLocationFsxLustre with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationFsxLustre for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationFsxLustreWithContext(ctx aws.Context, input *CreateLocationFsxLustreInput, opts ...request.Option) (*CreateLocationFsxLustreOutput, error) {
	req, out := c.CreateLocationFsxLustreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationFsxOntap = "CreateLocationFsxOntap"

// CreateLocationFsxOntapRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationFsxOntap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationFsxOntap for more information on using the CreateLocationFsxOntap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationFsxOntapRequest method.
//	req, resp := client.CreateLocationFsxOntapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOntap
func (c *DataSync) CreateLocationFsxOntapRequest(input *CreateLocationFsxOntapInput) (req *request.Request, output *CreateLocationFsxOntapOutput) {
	op := &request.Operation{
		Name:       opCreateLocationFsxOntap,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationFsxOntapInput{}
	}

	output = &CreateLocationFsxOntapOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationFsxOntap API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon FSx for NetApp ONTAP file system that DataSync
// can access for a transfer. For more information, see Creating a location
// for FSx for ONTAP (https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationFsxOntap for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOntap
func (c *DataSync) CreateLocationFsxOntap(input *CreateLocationFsxOntapInput) (*CreateLocationFsxOntapOutput, error) {
	req, out := c.CreateLocationFsxOntapRequest(input)
	return out, req.Send()
}

// CreateLocationFsxOntapWithContext is the same as CreateLocationFsxOntap with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationFsxOntap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationFsxOntapWithContext(ctx aws.Context, input *CreateLocationFsxOntapInput, opts ...request.Option) (*CreateLocationFsxOntapOutput, error) {
	req, out := c.CreateLocationFsxOntapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationFsxOpenZfs = "CreateLocationFsxOpenZfs"

// CreateLocationFsxOpenZfsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationFsxOpenZfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationFsxOpenZfs for more information on using the CreateLocationFsxOpenZfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationFsxOpenZfsRequest method.
//	req, resp := client.CreateLocationFsxOpenZfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOpenZfs
func (c *DataSync) CreateLocationFsxOpenZfsRequest(input *CreateLocationFsxOpenZfsInput) (req *request.Request, output *CreateLocationFsxOpenZfsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationFsxOpenZfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationFsxOpenZfsInput{}
	}

	output = &CreateLocationFsxOpenZfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationFsxOpenZfs API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon FSx for OpenZFS file system that DataSync
// can access for a transfer. For more information, see Creating a location
// for FSx for OpenZFS (https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html).
//
// Request parameters related to SMB aren't supported with the CreateLocationFsxOpenZfs
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationFsxOpenZfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOpenZfs
func (c *DataSync) CreateLocationFsxOpenZfs(input *CreateLocationFsxOpenZfsInput) (*CreateLocationFsxOpenZfsOutput, error) {
	req, out := c.CreateLocationFsxOpenZfsRequest(input)
	return out, req.Send()
}

// CreateLocationFsxOpenZfsWithContext is the same as CreateLocationFsxOpenZfs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationFsxOpenZfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationFsxOpenZfsWithContext(ctx aws.Context, input *CreateLocationFsxOpenZfsInput, opts ...request.Option) (*CreateLocationFsxOpenZfsOutput, error) {
	req, out := c.CreateLocationFsxOpenZfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationFsxWindows = "CreateLocationFsxWindows"

// CreateLocationFsxWindowsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationFsxWindows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationFsxWindows for more information on using the CreateLocationFsxWindows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationFsxWindowsRequest method.
//	req, resp := client.CreateLocationFsxWindowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows
func (c *DataSync) CreateLocationFsxWindowsRequest(input *CreateLocationFsxWindowsInput) (req *request.Request, output *CreateLocationFsxWindowsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationFsxWindows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationFsxWindowsInput{}
	}

	output = &CreateLocationFsxWindowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationFsxWindows API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon FSx for Windows File Server file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationFsxWindows for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows
func (c *DataSync) CreateLocationFsxWindows(input *CreateLocationFsxWindowsInput) (*CreateLocationFsxWindowsOutput, error) {
	req, out := c.CreateLocationFsxWindowsRequest(input)
	return out, req.Send()
}

// CreateLocationFsxWindowsWithContext is the same as CreateLocationFsxWindows with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationFsxWindows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationFsxWindowsWithContext(ctx aws.Context, input *CreateLocationFsxWindowsInput, opts ...request.Option) (*CreateLocationFsxWindowsOutput, error) {
	req, out := c.CreateLocationFsxWindowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationHdfs = "CreateLocationHdfs"

// CreateLocationHdfsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationHdfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationHdfs for more information on using the CreateLocationHdfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationHdfsRequest method.
//	req, resp := client.CreateLocationHdfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationHdfs
func (c *DataSync) CreateLocationHdfsRequest(input *CreateLocationHdfsInput) (req *request.Request, output *CreateLocationHdfsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationHdfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationHdfsInput{}
	}

	output = &CreateLocationHdfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationHdfs API operation for AWS DataSync.
//
// Creates an endpoint for a Hadoop Distributed File System (HDFS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationHdfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationHdfs
func (c *DataSync) CreateLocationHdfs(input *CreateLocationHdfsInput) (*CreateLocationHdfsOutput, error) {
	req, out := c.CreateLocationHdfsRequest(input)
	return out, req.Send()
}

// CreateLocationHdfsWithContext is the same as CreateLocationHdfs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationHdfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationHdfsWithContext(ctx aws.Context, input *CreateLocationHdfsInput, opts ...request.Option) (*CreateLocationHdfsOutput, error) {
	req, out := c.CreateLocationHdfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationNfs = "CreateLocationNfs"

// CreateLocationNfsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationNfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationNfs for more information on using the CreateLocationNfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationNfsRequest method.
//	req, resp := client.CreateLocationNfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs
func (c *DataSync) CreateLocationNfsRequest(input *CreateLocationNfsInput) (req *request.Request, output *CreateLocationNfsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationNfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationNfsInput{}
	}

	output = &CreateLocationNfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationNfs API operation for AWS DataSync.
//
// Defines a file system on a Network File System (NFS) server that can be read
// from or written to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationNfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs
func (c *DataSync) CreateLocationNfs(input *CreateLocationNfsInput) (*CreateLocationNfsOutput, error) {
	req, out := c.CreateLocationNfsRequest(input)
	return out, req.Send()
}

// CreateLocationNfsWithContext is the same as CreateLocationNfs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationNfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationNfsWithContext(ctx aws.Context, input *CreateLocationNfsInput, opts ...request.Option) (*CreateLocationNfsOutput, error) {
	req, out := c.CreateLocationNfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationObjectStorage = "CreateLocationObjectStorage"

// CreateLocationObjectStorageRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationObjectStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationObjectStorage for more information on using the CreateLocationObjectStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationObjectStorageRequest method.
//	req, resp := client.CreateLocationObjectStorageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage
func (c *DataSync) CreateLocationObjectStorageRequest(input *CreateLocationObjectStorageInput) (req *request.Request, output *CreateLocationObjectStorageOutput) {
	op := &request.Operation{
		Name:       opCreateLocationObjectStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationObjectStorageInput{}
	}

	output = &CreateLocationObjectStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationObjectStorage API operation for AWS DataSync.
//
// Creates an endpoint for an object storage system that DataSync can access
// for a transfer. For more information, see Creating a location for object
// storage (https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationObjectStorage for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage
func (c *DataSync) CreateLocationObjectStorage(input *CreateLocationObjectStorageInput) (*CreateLocationObjectStorageOutput, error) {
	req, out := c.CreateLocationObjectStorageRequest(input)
	return out, req.Send()
}

// CreateLocationObjectStorageWithContext is the same as CreateLocationObjectStorage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationObjectStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationObjectStorageWithContext(ctx aws.Context, input *CreateLocationObjectStorageInput, opts ...request.Option) (*CreateLocationObjectStorageOutput, error) {
	req, out := c.CreateLocationObjectStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationS3 = "CreateLocationS3"

// CreateLocationS3Request generates a "aws/request.Request" representing the
// client's request for the CreateLocationS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationS3 for more information on using the CreateLocationS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationS3Request method.
//	req, resp := client.CreateLocationS3Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3
func (c *DataSync) CreateLocationS3Request(input *CreateLocationS3Input) (req *request.Request, output *CreateLocationS3Output) {
	op := &request.Operation{
		Name:       opCreateLocationS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationS3Input{}
	}

	output = &CreateLocationS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationS3 API operation for AWS DataSync.
//
// A location is an endpoint for an Amazon S3 bucket. DataSync can use the location
// as a source or destination for copying data.
//
// Before you create your location, make sure that you read the following sections:
//
//   - Storage class considerations with Amazon S3 locations (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
//
//   - Evaluating S3 request costs when using DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests)
//
// For more information, see Creating an Amazon S3 location (https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationS3 for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3
func (c *DataSync) CreateLocationS3(input *CreateLocationS3Input) (*CreateLocationS3Output, error) {
	req, out := c.CreateLocationS3Request(input)
	return out, req.Send()
}

// CreateLocationS3WithContext is the same as CreateLocationS3 with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationS3WithContext(ctx aws.Context, input *CreateLocationS3Input, opts ...request.Option) (*CreateLocationS3Output, error) {
	req, out := c.CreateLocationS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationSmb = "CreateLocationSmb"

// CreateLocationSmbRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationSmb operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationSmb for more information on using the CreateLocationSmb
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationSmbRequest method.
//	req, resp := client.CreateLocationSmbRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb
func (c *DataSync) CreateLocationSmbRequest(input *CreateLocationSmbInput) (req *request.Request, output *CreateLocationSmbOutput) {
	op := &request.Operation{
		Name:       opCreateLocationSmb,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationSmbInput{}
	}

	output = &CreateLocationSmbOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationSmb API operation for AWS DataSync.
//
// Creates an endpoint for a Server Message Block (SMB) file server that DataSync
// can access for a transfer. For more information, see Creating an SMB location
// (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationSmb for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb
func (c *DataSync) CreateLocationSmb(input *CreateLocationSmbInput) (*CreateLocationSmbOutput, error) {
	req, out := c.CreateLocationSmbRequest(input)
	return out, req.Send()
}

// CreateLocationSmbWithContext is the same as CreateLocationSmb with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationSmb for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationSmbWithContext(ctx aws.Context, input *CreateLocationSmbInput, opts ...request.Option) (*CreateLocationSmbOutput, error) {
	req, out := c.CreateLocationSmbRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTask = "CreateTask"

// CreateTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTask for more information on using the CreateTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTaskRequest method.
//	req, resp := client.CreateTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask
func (c *DataSync) CreateTaskRequest(input *CreateTaskInput) (req *request.Request, output *CreateTaskOutput) {
	op := &request.Operation{
		Name:       opCreateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTaskInput{}
	}

	output = &CreateTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTask API operation for AWS DataSync.
//
// Configures a task, which defines where and how DataSync transfers your data.
//
// A task includes a source location, a destination location, and the preferences
// for how and when you want to transfer your data (such as bandwidth limits,
// scheduling, among other options).
//
// If you're planning to transfer data to or from an Amazon S3 location, review
// how DataSync can affect your S3 request charges (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests)
// and the DataSync pricing page (http://aws.amazon.com/datasync/pricing/) before
// you begin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateTask for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask
func (c *DataSync) CreateTask(input *CreateTaskInput) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	return out, req.Send()
}

// CreateTaskWithContext is the same as CreateTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateTaskWithContext(ctx aws.Context, input *CreateTaskInput, opts ...request.Option) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgent = "DeleteAgent"

// DeleteAgentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgent for more information on using the DeleteAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentRequest method.
//	req, resp := client.DeleteAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent
func (c *DataSync) DeleteAgentRequest(input *DeleteAgentInput) (req *request.Request, output *DeleteAgentOutput) {
	op := &request.Operation{
		Name:       opDeleteAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAgentInput{}
	}

	output = &DeleteAgentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAgent API operation for AWS DataSync.
//
// Deletes an agent. To specify which agent to delete, use the Amazon Resource
// Name (ARN) of the agent in your request. The operation disassociates the
// agent from your Amazon Web Services account. However, it doesn't delete the
// agent virtual machine (VM) from your on-premises environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DeleteAgent for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent
func (c *DataSync) DeleteAgent(input *DeleteAgentInput) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	return out, req.Send()
}

// DeleteAgentWithContext is the same as DeleteAgent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DeleteAgentWithContext(ctx aws.Context, input *DeleteAgentInput, opts ...request.Option) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocation = "DeleteLocation"

// DeleteLocationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocation for more information on using the DeleteLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLocationRequest method.
//	req, resp := client.DeleteLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation
func (c *DataSync) DeleteLocationRequest(input *DeleteLocationInput) (req *request.Request, output *DeleteLocationOutput) {
	op := &request.Operation{
		Name:       opDeleteLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocationInput{}
	}

	output = &DeleteLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLocation API operation for AWS DataSync.
//
// Deletes the configuration of a location used by DataSync.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DeleteLocation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation
func (c *DataSync) DeleteLocation(input *DeleteLocationInput) (*DeleteLocationOutput, error) {
	req, out := c.DeleteLocationRequest(input)
	return out, req.Send()
}

// DeleteLocationWithContext is the same as DeleteLocation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DeleteLocationWithContext(ctx aws.Context, input *DeleteLocationInput, opts ...request.Option) (*DeleteLocationOutput, error) {
	req, out := c.DeleteLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTask = "DeleteTask"

// DeleteTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTask for more information on using the DeleteTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTaskRequest method.
//	req, resp := client.DeleteTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask
func (c *DataSync) DeleteTaskRequest(input *DeleteTaskInput) (req *request.Request, output *DeleteTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTaskInput{}
	}

	output = &DeleteTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTask API operation for AWS DataSync.
//
// Deletes an DataSync task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DeleteTask for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask
func (c *DataSync) DeleteTask(input *DeleteTaskInput) (*DeleteTaskOutput, error) {
	req, out := c.DeleteTaskRequest(input)
	return out, req.Send()
}

// DeleteTaskWithContext is the same as DeleteTask with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DeleteTaskWithContext(ctx aws.Context, input *DeleteTaskInput, opts ...request.Option) (*DeleteTaskOutput, error) {
	req, out := c.DeleteTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAgent = "DescribeAgent"

// DescribeAgentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgent for more information on using the DescribeAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAgentRequest method.
//	req, resp := client.DescribeAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent
func (c *DataSync) DescribeAgentRequest(input *DescribeAgentInput) (req *request.Request, output *DescribeAgentOutput) {
	op := &request.Operation{
		Name:       opDescribeAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentInput{}
	}

	output = &DescribeAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgent API operation for AWS DataSync.
//
// Returns metadata about an DataSync agent, such as its name, endpoint type,
// and status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeAgent for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent
func (c *DataSync) DescribeAgent(input *DescribeAgentInput) (*DescribeAgentOutput, error) {
	req, out := c.DescribeAgentRequest(input)
	return out, req.Send()
}

// DescribeAgentWithContext is the same as DescribeAgent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeAgentWithContext(ctx aws.Context, input *DescribeAgentInput, opts ...request.Option) (*DescribeAgentOutput, error) {
	req, out := c.DescribeAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDiscoveryJob = "DescribeDiscoveryJob"

// DescribeDiscoveryJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDiscoveryJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDiscoveryJob for more information on using the DescribeDiscoveryJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDiscoveryJobRequest method.
//	req, resp := client.DescribeDiscoveryJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeDiscoveryJob
func (c *DataSync) DescribeDiscoveryJobRequest(input *DescribeDiscoveryJobInput) (req *request.Request, output *DescribeDiscoveryJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDiscoveryJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDiscoveryJobInput{}
	}

	output = &DescribeDiscoveryJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeDiscoveryJob API operation for AWS DataSync.
//
// Returns information about a DataSync discovery job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeDiscoveryJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeDiscoveryJob
func (c *DataSync) DescribeDiscoveryJob(input *DescribeDiscoveryJobInput) (*DescribeDiscoveryJobOutput, error) {
	req, out := c.DescribeDiscoveryJobRequest(input)
	return out, req.Send()
}

// DescribeDiscoveryJobWithContext is the same as DescribeDiscoveryJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDiscoveryJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeDiscoveryJobWithContext(ctx aws.Context, input *DescribeDiscoveryJobInput, opts ...request.Option) (*DescribeDiscoveryJobOutput, error) {
	req, out := c.DescribeDiscoveryJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationEfs = "DescribeLocationEfs"

// DescribeLocationEfsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationEfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationEfs for more information on using the DescribeLocationEfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationEfsRequest method.
//	req, resp := client.DescribeLocationEfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs
func (c *DataSync) DescribeLocationEfsRequest(input *DescribeLocationEfsInput) (req *request.Request, output *DescribeLocationEfsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationEfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationEfsInput{}
	}

	output = &DescribeLocationEfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationEfs API operation for AWS DataSync.
//
// Returns metadata about your DataSync location for an Amazon EFS file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationEfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs
func (c *DataSync) DescribeLocationEfs(input *DescribeLocationEfsInput) (*DescribeLocationEfsOutput, error) {
	req, out := c.DescribeLocationEfsRequest(input)
	return out, req.Send()
}

// DescribeLocationEfsWithContext is the same as DescribeLocationEfs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationEfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationEfsWithContext(ctx aws.Context, input *DescribeLocationEfsInput, opts ...request.Option) (*DescribeLocationEfsOutput, error) {
	req, out := c.DescribeLocationEfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationFsxLustre = "DescribeLocationFsxLustre"

// DescribeLocationFsxLustreRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationFsxLustre operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationFsxLustre for more information on using the DescribeLocationFsxLustre
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationFsxLustreRequest method.
//	req, resp := client.DescribeLocationFsxLustreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxLustre
func (c *DataSync) DescribeLocationFsxLustreRequest(input *DescribeLocationFsxLustreInput) (req *request.Request, output *DescribeLocationFsxLustreOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationFsxLustre,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationFsxLustreInput{}
	}

	output = &DescribeLocationFsxLustreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationFsxLustre API operation for AWS DataSync.
//
// Provides details about how an DataSync location for an Amazon FSx for Lustre
// file system is configured.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationFsxLustre for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxLustre
func (c *DataSync) DescribeLocationFsxLustre(input *DescribeLocationFsxLustreInput) (*DescribeLocationFsxLustreOutput, error) {
	req, out := c.DescribeLocationFsxLustreRequest(input)
	return out, req.Send()
}

// DescribeLocationFsxLustreWithContext is the same as DescribeLocationFsxLustre with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationFsxLustre for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationFsxLustreWithContext(ctx aws.Context, input *DescribeLocationFsxLustreInput, opts ...request.Option) (*DescribeLocationFsxLustreOutput, error) {
	req, out := c.DescribeLocationFsxLustreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationFsxOntap = "DescribeLocationFsxOntap"

// DescribeLocationFsxOntapRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationFsxOntap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationFsxOntap for more information on using the DescribeLocationFsxOntap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationFsxOntapRequest method.
//	req, resp := client.DescribeLocationFsxOntapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOntap
func (c *DataSync) DescribeLocationFsxOntapRequest(input *DescribeLocationFsxOntapInput) (req *request.Request, output *DescribeLocationFsxOntapOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationFsxOntap,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationFsxOntapInput{}
	}

	output = &DescribeLocationFsxOntapOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationFsxOntap API operation for AWS DataSync.
//
// Provides details about how an DataSync location for an Amazon FSx for NetApp
// ONTAP file system is configured.
//
// If your location uses SMB, the DescribeLocationFsxOntap operation doesn't
// actually return a Password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationFsxOntap for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOntap
func (c *DataSync) DescribeLocationFsxOntap(input *DescribeLocationFsxOntapInput) (*DescribeLocationFsxOntapOutput, error) {
	req, out := c.DescribeLocationFsxOntapRequest(input)
	return out, req.Send()
}

// DescribeLocationFsxOntapWithContext is the same as DescribeLocationFsxOntap with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationFsxOntap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationFsxOntapWithContext(ctx aws.Context, input *DescribeLocationFsxOntapInput, opts ...request.Option) (*DescribeLocationFsxOntapOutput, error) {
	req, out := c.DescribeLocationFsxOntapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationFsxOpenZfs = "DescribeLocationFsxOpenZfs"

// DescribeLocationFsxOpenZfsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationFsxOpenZfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationFsxOpenZfs for more information on using the DescribeLocationFsxOpenZfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationFsxOpenZfsRequest method.
//	req, resp := client.DescribeLocationFsxOpenZfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOpenZfs
func (c *DataSync) DescribeLocationFsxOpenZfsRequest(input *DescribeLocationFsxOpenZfsInput) (req *request.Request, output *DescribeLocationFsxOpenZfsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationFsxOpenZfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationFsxOpenZfsInput{}
	}

	output = &DescribeLocationFsxOpenZfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationFsxOpenZfs API operation for AWS DataSync.
//
// Provides details about how an DataSync location for an Amazon FSx for OpenZFS
// file system is configured.
//
// Response elements related to SMB aren't supported with the DescribeLocationFsxOpenZfs
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationFsxOpenZfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOpenZfs
func (c *DataSync) DescribeLocationFsxOpenZfs(input *DescribeLocationFsxOpenZfsInput) (*DescribeLocationFsxOpenZfsOutput, error) {
	req, out := c.DescribeLocationFsxOpenZfsRequest(input)
	return out, req.Send()
}

// DescribeLocationFsxOpenZfsWithContext is the same as DescribeLocationFsxOpenZfs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationFsxOpenZfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationFsxOpenZfsWithContext(ctx aws.Context, input *DescribeLocationFsxOpenZfsInput, opts ...request.Option) (*DescribeLocationFsxOpenZfsOutput, error) {
	req, out := c.DescribeLocationFsxOpenZfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationFsxWindows = "DescribeLocationFsxWindows"

// DescribeLocationFsxWindowsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationFsxWindows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationFsxWindows for more information on using the DescribeLocationFsxWindows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationFsxWindowsRequest method.
//	req, resp := client.DescribeLocationFsxWindowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows
func (c *DataSync) DescribeLocationFsxWindowsRequest(input *DescribeLocationFsxWindowsInput) (req *request.Request, output *DescribeLocationFsxWindowsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationFsxWindows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationFsxWindowsInput{}
	}

	output = &DescribeLocationFsxWindowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationFsxWindows API operation for AWS DataSync.
//
// Returns metadata about an Amazon FSx for Windows File Server location, such
// as information about its path.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationFsxWindows for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows
func (c *DataSync) DescribeLocationFsxWindows(input *DescribeLocationFsxWindowsInput) (*DescribeLocationFsxWindowsOutput, error) {
	req, out := c.DescribeLocationFsxWindowsRequest(input)
	return out, req.Send()
}

// DescribeLocationFsxWindowsWithContext is the same as DescribeLocationFsxWindows with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationFsxWindows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationFsxWindowsWithContext(ctx aws.Context, input *DescribeLocationFsxWindowsInput, opts ...request.Option) (*DescribeLocationFsxWindowsOutput, error) {
	req, out := c.DescribeLocationFsxWindowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationHdfs = "DescribeLocationHdfs"

// DescribeLocationHdfsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationHdfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationHdfs for more information on using the DescribeLocationHdfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationHdfsRequest method.
//	req, resp := client.DescribeLocationHdfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationHdfs
func (c *DataSync) DescribeLocationHdfsRequest(input *DescribeLocationHdfsInput) (req *request.Request, output *DescribeLocationHdfsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationHdfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationHdfsInput{}
	}

	output = &DescribeLocationHdfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationHdfs API operation for AWS DataSync.
//
// Returns metadata, such as the authentication information about the Hadoop
// Distributed File System (HDFS) location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationHdfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationHdfs
func (c *DataSync) DescribeLocationHdfs(input *DescribeLocationHdfsInput) (*DescribeLocationHdfsOutput, error) {
	req, out := c.DescribeLocationHdfsRequest(input)
	return out, req.Send()
}

// DescribeLocationHdfsWithContext is the same as DescribeLocationHdfs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationHdfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationHdfsWithContext(ctx aws.Context, input *DescribeLocationHdfsInput, opts ...request.Option) (*DescribeLocationHdfsOutput, error) {
	req, out := c.DescribeLocationHdfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationNfs = "DescribeLocationNfs"

// DescribeLocationNfsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationNfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationNfs for more information on using the DescribeLocationNfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationNfsRequest method.
//	req, resp := client.DescribeLocationNfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs
func (c *DataSync) DescribeLocationNfsRequest(input *DescribeLocationNfsInput) (req *request.Request, output *DescribeLocationNfsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationNfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationNfsInput{}
	}

	output = &DescribeLocationNfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationNfs API operation for AWS DataSync.
//
// Returns metadata, such as the path information, about an NFS location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationNfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs
func (c *DataSync) DescribeLocationNfs(input *DescribeLocationNfsInput) (*DescribeLocationNfsOutput, error) {
	req, out := c.DescribeLocationNfsRequest(input)
	return out, req.Send()
}

// DescribeLocationNfsWithContext is the same as DescribeLocationNfs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationNfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationNfsWithContext(ctx aws.Context, input *DescribeLocationNfsInput, opts ...request.Option) (*DescribeLocationNfsOutput, error) {
	req, out := c.DescribeLocationNfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationObjectStorage = "DescribeLocationObjectStorage"

// DescribeLocationObjectStorageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationObjectStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationObjectStorage for more information on using the DescribeLocationObjectStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationObjectStorageRequest method.
//	req, resp := client.DescribeLocationObjectStorageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage
func (c *DataSync) DescribeLocationObjectStorageRequest(input *DescribeLocationObjectStorageInput) (req *request.Request, output *DescribeLocationObjectStorageOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationObjectStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationObjectStorageInput{}
	}

	output = &DescribeLocationObjectStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationObjectStorage API operation for AWS DataSync.
//
// Returns metadata about your DataSync location for an object storage system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationObjectStorage for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage
func (c *DataSync) DescribeLocationObjectStorage(input *DescribeLocationObjectStorageInput) (*DescribeLocationObjectStorageOutput, error) {
	req, out := c.DescribeLocationObjectStorageRequest(input)
	return out, req.Send()
}

// DescribeLocationObjectStorageWithContext is the same as DescribeLocationObjectStorage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationObjectStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationObjectStorageWithContext(ctx aws.Context, input *DescribeLocationObjectStorageInput, opts ...request.Option) (*DescribeLocationObjectStorageOutput, error) {
	req, out := c.DescribeLocationObjectStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationS3 = "DescribeLocationS3"

// DescribeLocationS3Request generates a "aws/request.Request" representing the
// client's request for the DescribeLocationS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationS3 for more information on using the DescribeLocationS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationS3Request method.
//	req, resp := client.DescribeLocationS3Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3
func (c *DataSync) DescribeLocationS3Request(input *DescribeLocationS3Input) (req *request.Request, output *DescribeLocationS3Output) {
	op := &request.Operation{
		Name:       opDescribeLocationS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationS3Input{}
	}

	output = &DescribeLocationS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationS3 API operation for AWS DataSync.
//
// Returns metadata, such as bucket name, about an Amazon S3 bucket location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationS3 for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3
func (c *DataSync) DescribeLocationS3(input *DescribeLocationS3Input) (*DescribeLocationS3Output, error) {
	req, out := c.DescribeLocationS3Request(input)
	return out, req.Send()
}

// DescribeLocationS3WithContext is the same as DescribeLocationS3 with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationS3WithContext(ctx aws.Context, input *DescribeLocationS3Input, opts ...request.Option) (*DescribeLocationS3Output, error) {
	req, out := c.DescribeLocationS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationSmb = "DescribeLocationSmb"

// DescribeLocationSmbRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationSmb operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationSmb for more information on using the DescribeLocationSmb
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLocationSmbRequest method.
//	req, resp := client.DescribeLocationSmbRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb
func (c *DataSync) DescribeLocationSmbRequest(input *DescribeLocationSmbInput) (req *request.Request, output *DescribeLocationSmbOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationSmb,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationSmbInput{}
	}

	output = &DescribeLocationSmbOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationSmb API operation for AWS DataSync.
//
// Returns metadata, such as the path and user information about an SMB location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationSmb for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb
func (c *DataSync) DescribeLocationSmb(input *DescribeLocationSmbInput) (*DescribeLocationSmbOutput, error) {
	req, out := c.DescribeLocationSmbRequest(input)
	return out, req.Send()
}

// DescribeLocationSmbWithContext is the same as DescribeLocationSmb with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationSmb for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationSmbWithContext(ctx aws.Context, input *DescribeLocationSmbInput, opts ...request.Option) (*DescribeLocationSmbOutput, error) {
	req, out := c.DescribeLocationSmbRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStorageSystem = "DescribeStorageSystem"

// DescribeStorageSystemRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorageSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStorageSystem for more information on using the DescribeStorageSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStorageSystemRequest method.
//	req, resp := client.DescribeStorageSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystem
func (c *DataSync) DescribeStorageSystemRequest(input *DescribeStorageSystemInput) (req *request.Request, output *DescribeStorageSystemOutput) {
	op := &request.Operation{
		Name:       opDescribeStorageSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStorageSystemInput{}
	}

	output = &DescribeStorageSystemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeStorageSystem API operation for AWS DataSync.
//
// Returns information about an on-premises storage system that you're using
// with DataSync Discovery.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeStorageSystem for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystem
func (c *DataSync) DescribeStorageSystem(input *DescribeStorageSystemInput) (*DescribeStorageSystemOutput, error) {
	req, out := c.DescribeStorageSystemRequest(input)
	return out, req.Send()
}

// DescribeStorageSystemWithContext is the same as DescribeStorageSystem with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorageSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeStorageSystemWithContext(ctx aws.Context, input *DescribeStorageSystemInput, opts ...request.Option) (*DescribeStorageSystemOutput, error) {
	req, out := c.DescribeStorageSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStorageSystemResourceMetrics = "DescribeStorageSystemResourceMetrics"

// DescribeStorageSystemResourceMetricsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorageSystemResourceMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStorageSystemResourceMetrics for more information on using the DescribeStorageSystemResourceMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStorageSystemResourceMetricsRequest method.
//	req, resp := client.DescribeStorageSystemResourceMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResourceMetrics
func (c *DataSync) DescribeStorageSystemResourceMetricsRequest(input *DescribeStorageSystemResourceMetricsInput) (req *request.Request, output *DescribeStorageSystemResourceMetricsOutput) {
	op := &request.Operation{
		Name:       opDescribeStorageSystemResourceMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStorageSystemResourceMetricsInput{}
	}

	output = &DescribeStorageSystemResourceMetricsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeStorageSystemResourceMetrics API operation for AWS DataSync.
//
// Returns information, including performance data and capacity usage, which
// DataSync Discovery collects about a specific resource in your-premises storage
// system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeStorageSystemResourceMetrics for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResourceMetrics
func (c *DataSync) DescribeStorageSystemResourceMetrics(input *DescribeStorageSystemResourceMetricsInput) (*DescribeStorageSystemResourceMetricsOutput, error) {
	req, out := c.DescribeStorageSystemResourceMetricsRequest(input)
	return out, req.Send()
}

// DescribeStorageSystemResourceMetricsWithContext is the same as DescribeStorageSystemResourceMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorageSystemResourceMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeStorageSystemResourceMetricsWithContext(ctx aws.Context, input *DescribeStorageSystemResourceMetricsInput, opts ...request.Option) (*DescribeStorageSystemResourceMetricsOutput, error) {
	req, out := c.DescribeStorageSystemResourceMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStorageSystemResourceMetricsPages iterates over the pages of a DescribeStorageSystemResourceMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStorageSystemResourceMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStorageSystemResourceMetrics operation.
//	pageNum := 0
//	err := client.DescribeStorageSystemResourceMetricsPages(params,
//	    func(page *datasync.DescribeStorageSystemResourceMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) DescribeStorageSystemResourceMetricsPages(input *DescribeStorageSystemResourceMetricsInput, fn func(*DescribeStorageSystemResourceMetricsOutput, bool) bool) error {
	return c.DescribeStorageSystemResourceMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStorageSystemResourceMetricsPagesWithContext same as DescribeStorageSystemResourceMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeStorageSystemResourceMetricsPagesWithContext(ctx aws.Context, input *DescribeStorageSystemResourceMetricsInput, fn func(*DescribeStorageSystemResourceMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStorageSystemResourceMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStorageSystemResourceMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStorageSystemResourceMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStorageSystemResources = "DescribeStorageSystemResources"

// DescribeStorageSystemResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorageSystemResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStorageSystemResources for more information on using the DescribeStorageSystemResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStorageSystemResourcesRequest method.
//	req, resp := client.DescribeStorageSystemResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResources
func (c *DataSync) DescribeStorageSystemResourcesRequest(input *DescribeStorageSystemResourcesInput) (req *request.Request, output *DescribeStorageSystemResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeStorageSystemResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStorageSystemResourcesInput{}
	}

	output = &DescribeStorageSystemResourcesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeStorageSystemResources API operation for AWS DataSync.
//
// Returns information that DataSync Discovery collects about resources in your
// on-premises storage system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeStorageSystemResources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResources
func (c *DataSync) DescribeStorageSystemResources(input *DescribeStorageSystemResourcesInput) (*DescribeStorageSystemResourcesOutput, error) {
	req, out := c.DescribeStorageSystemResourcesRequest(input)
	return out, req.Send()
}

// DescribeStorageSystemResourcesWithContext is the same as DescribeStorageSystemResources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorageSystemResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeStorageSystemResourcesWithContext(ctx aws.Context, input *DescribeStorageSystemResourcesInput, opts ...request.Option) (*DescribeStorageSystemResourcesOutput, error) {
	req, out := c.DescribeStorageSystemResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStorageSystemResourcesPages iterates over the pages of a DescribeStorageSystemResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStorageSystemResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStorageSystemResources operation.
//	pageNum := 0
//	err := client.DescribeStorageSystemResourcesPages(params,
//	    func(page *datasync.DescribeStorageSystemResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) DescribeStorageSystemResourcesPages(input *DescribeStorageSystemResourcesInput, fn func(*DescribeStorageSystemResourcesOutput, bool) bool) error {
	return c.DescribeStorageSystemResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStorageSystemResourcesPagesWithContext same as DescribeStorageSystemResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeStorageSystemResourcesPagesWithContext(ctx aws.Context, input *DescribeStorageSystemResourcesInput, fn func(*DescribeStorageSystemResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStorageSystemResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStorageSystemResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStorageSystemResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTask = "DescribeTask"

// DescribeTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTask for more information on using the DescribeTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTaskRequest method.
//	req, resp := client.DescribeTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask
func (c *DataSync) DescribeTaskRequest(input *DescribeTaskInput) (req *request.Request, output *DescribeTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskInput{}
	}

	output = &DescribeTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTask API operation for AWS DataSync.
//
// Returns metadata about a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeTask for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask
func (c *DataSync) DescribeTask(input *DescribeTaskInput) (*DescribeTaskOutput, error) {
	req, out := c.DescribeTaskRequest(input)
	return out, req.Send()
}

// DescribeTaskWithContext is the same as DescribeTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeTaskWithContext(ctx aws.Context, input *DescribeTaskInput, opts ...request.Option) (*DescribeTaskOutput, error) {
	req, out := c.DescribeTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTaskExecution = "DescribeTaskExecution"

// DescribeTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTaskExecution for more information on using the DescribeTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTaskExecutionRequest method.
//	req, resp := client.DescribeTaskExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution
func (c *DataSync) DescribeTaskExecutionRequest(input *DescribeTaskExecutionInput) (req *request.Request, output *DescribeTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskExecutionInput{}
	}

	output = &DescribeTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTaskExecution API operation for AWS DataSync.
//
// Returns detailed metadata about a task that is being executed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeTaskExecution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution
func (c *DataSync) DescribeTaskExecution(input *DescribeTaskExecutionInput) (*DescribeTaskExecutionOutput, error) {
	req, out := c.DescribeTaskExecutionRequest(input)
	return out, req.Send()
}

// DescribeTaskExecutionWithContext is the same as DescribeTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeTaskExecutionWithContext(ctx aws.Context, input *DescribeTaskExecutionInput, opts ...request.Option) (*DescribeTaskExecutionOutput, error) {
	req, out := c.DescribeTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateRecommendations = "GenerateRecommendations"

// GenerateRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GenerateRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateRecommendations for more information on using the GenerateRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateRecommendationsRequest method.
//	req, resp := client.GenerateRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/GenerateRecommendations
func (c *DataSync) GenerateRecommendationsRequest(input *GenerateRecommendationsInput) (req *request.Request, output *GenerateRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGenerateRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateRecommendationsInput{}
	}

	output = &GenerateRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GenerateRecommendations API operation for AWS DataSync.
//
// Creates recommendations about where to migrate your data to in Amazon Web
// Services. Recommendations are generated based on information that DataSync
// Discovery collects about your on-premises storage system's resources. For
// more information, see Recommendations provided by DataSync Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
//
// Once generated, you can view your recommendations by using the DescribeStorageSystemResources
// (https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeStorageSystemResources.html)
// operation.
//
// If your discovery job completes successfully (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table),
// you don't need to use this operation. DataSync Discovery generates the recommendations
// for you automatically.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation GenerateRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/GenerateRecommendations
func (c *DataSync) GenerateRecommendations(input *GenerateRecommendationsInput) (*GenerateRecommendationsOutput, error) {
	req, out := c.GenerateRecommendationsRequest(input)
	return out, req.Send()
}

// GenerateRecommendationsWithContext is the same as GenerateRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) GenerateRecommendationsWithContext(ctx aws.Context, input *GenerateRecommendationsInput, opts ...request.Option) (*GenerateRecommendationsOutput, error) {
	req, out := c.GenerateRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAgents = "ListAgents"

// ListAgentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgents for more information on using the ListAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentsRequest method.
//	req, resp := client.ListAgentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents
func (c *DataSync) ListAgentsRequest(input *ListAgentsInput) (req *request.Request, output *ListAgentsOutput) {
	op := &request.Operation{
		Name:       opListAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentsInput{}
	}

	output = &ListAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgents API operation for AWS DataSync.
//
// Returns a list of DataSync agents that belong to an Amazon Web Services account
// in the Amazon Web Services Region specified in the request.
//
// With pagination, you can reduce the number of agents returned in a response.
// If you get a truncated list of agents in a response, the response contains
// a marker that you can specify in your next request to fetch the next page
// of agents.
//
// ListAgents is eventually consistent. This means the result of running the
// operation might not reflect that you just created or deleted an agent. For
// example, if you create an agent with CreateAgent (https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html)
// and then immediately run ListAgents, that agent might not show up in the
// list right away. In situations like this, you can always confirm whether
// an agent has been created (or deleted) by using DescribeAgent (https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListAgents for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents
func (c *DataSync) ListAgents(input *ListAgentsInput) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	return out, req.Send()
}

// ListAgentsWithContext is the same as ListAgents with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListAgentsWithContext(ctx aws.Context, input *ListAgentsInput, opts ...request.Option) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentsPages iterates over the pages of a ListAgents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgents operation.
//	pageNum := 0
//	err := client.ListAgentsPages(params,
//	    func(page *datasync.ListAgentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListAgentsPages(input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool) error {
	return c.ListAgentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentsPagesWithContext same as ListAgentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListAgentsPagesWithContext(ctx aws.Context, input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDiscoveryJobs = "ListDiscoveryJobs"

// ListDiscoveryJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoveryJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoveryJobs for more information on using the ListDiscoveryJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDiscoveryJobsRequest method.
//	req, resp := client.ListDiscoveryJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListDiscoveryJobs
func (c *DataSync) ListDiscoveryJobsRequest(input *ListDiscoveryJobsInput) (req *request.Request, output *ListDiscoveryJobsOutput) {
	op := &request.Operation{
		Name:       opListDiscoveryJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDiscoveryJobsInput{}
	}

	output = &ListDiscoveryJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListDiscoveryJobs API operation for AWS DataSync.
//
// Provides a list of the existing discovery jobs in the Amazon Web Services
// Region and Amazon Web Services account where you're using DataSync Discovery.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListDiscoveryJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListDiscoveryJobs
func (c *DataSync) ListDiscoveryJobs(input *ListDiscoveryJobsInput) (*ListDiscoveryJobsOutput, error) {
	req, out := c.ListDiscoveryJobsRequest(input)
	return out, req.Send()
}

// ListDiscoveryJobsWithContext is the same as ListDiscoveryJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoveryJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListDiscoveryJobsWithContext(ctx aws.Context, input *ListDiscoveryJobsInput, opts ...request.Option) (*ListDiscoveryJobsOutput, error) {
	req, out := c.ListDiscoveryJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDiscoveryJobsPages iterates over the pages of a ListDiscoveryJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDiscoveryJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDiscoveryJobs operation.
//	pageNum := 0
//	err := client.ListDiscoveryJobsPages(params,
//	    func(page *datasync.ListDiscoveryJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListDiscoveryJobsPages(input *ListDiscoveryJobsInput, fn func(*ListDiscoveryJobsOutput, bool) bool) error {
	return c.ListDiscoveryJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDiscoveryJobsPagesWithContext same as ListDiscoveryJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListDiscoveryJobsPagesWithContext(ctx aws.Context, input *ListDiscoveryJobsInput, fn func(*ListDiscoveryJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDiscoveryJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDiscoveryJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDiscoveryJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLocations = "ListLocations"

// ListLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLocations for more information on using the ListLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLocationsRequest method.
//	req, resp := client.ListLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations
func (c *DataSync) ListLocationsRequest(input *ListLocationsInput) (req *request.Request, output *ListLocationsOutput) {
	op := &request.Operation{
		Name:       opListLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLocationsInput{}
	}

	output = &ListLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLocations API operation for AWS DataSync.
//
// Returns a list of source and destination locations.
//
// If you have more locations than are returned in a response (that is, the
// response returns only a truncated list of your agents), the response contains
// a token that you can specify in your next request to fetch the next page
// of locations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListLocations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations
func (c *DataSync) ListLocations(input *ListLocationsInput) (*ListLocationsOutput, error) {
	req, out := c.ListLocationsRequest(input)
	return out, req.Send()
}

// ListLocationsWithContext is the same as ListLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListLocationsWithContext(ctx aws.Context, input *ListLocationsInput, opts ...request.Option) (*ListLocationsOutput, error) {
	req, out := c.ListLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLocationsPages iterates over the pages of a ListLocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLocations operation.
//	pageNum := 0
//	err := client.ListLocationsPages(params,
//	    func(page *datasync.ListLocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListLocationsPages(input *ListLocationsInput, fn func(*ListLocationsOutput, bool) bool) error {
	return c.ListLocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLocationsPagesWithContext same as ListLocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListLocationsPagesWithContext(ctx aws.Context, input *ListLocationsInput, fn func(*ListLocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageSystems = "ListStorageSystems"

// ListStorageSystemsRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageSystems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageSystems for more information on using the ListStorageSystems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStorageSystemsRequest method.
//	req, resp := client.ListStorageSystemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListStorageSystems
func (c *DataSync) ListStorageSystemsRequest(input *ListStorageSystemsInput) (req *request.Request, output *ListStorageSystemsOutput) {
	op := &request.Operation{
		Name:       opListStorageSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStorageSystemsInput{}
	}

	output = &ListStorageSystemsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStorageSystems API operation for AWS DataSync.
//
// Lists the on-premises storage systems that you're using with DataSync Discovery.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListStorageSystems for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListStorageSystems
func (c *DataSync) ListStorageSystems(input *ListStorageSystemsInput) (*ListStorageSystemsOutput, error) {
	req, out := c.ListStorageSystemsRequest(input)
	return out, req.Send()
}

// ListStorageSystemsWithContext is the same as ListStorageSystems with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageSystems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListStorageSystemsWithContext(ctx aws.Context, input *ListStorageSystemsInput, opts ...request.Option) (*ListStorageSystemsOutput, error) {
	req, out := c.ListStorageSystemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStorageSystemsPages iterates over the pages of a ListStorageSystems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStorageSystems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStorageSystems operation.
//	pageNum := 0
//	err := client.ListStorageSystemsPages(params,
//	    func(page *datasync.ListStorageSystemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListStorageSystemsPages(input *ListStorageSystemsInput, fn func(*ListStorageSystemsOutput, bool) bool) error {
	return c.ListStorageSystemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStorageSystemsPagesWithContext same as ListStorageSystemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListStorageSystemsPagesWithContext(ctx aws.Context, input *ListStorageSystemsInput, fn func(*ListStorageSystemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStorageSystemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStorageSystemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStorageSystemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource
func (c *DataSync) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS DataSync.
//
// Returns all the tags associated with an Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource
func (c *DataSync) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *datasync.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTaskExecutions = "ListTaskExecutions"

// ListTaskExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTaskExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTaskExecutions for more information on using the ListTaskExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTaskExecutionsRequest method.
//	req, resp := client.ListTaskExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions
func (c *DataSync) ListTaskExecutionsRequest(input *ListTaskExecutionsInput) (req *request.Request, output *ListTaskExecutionsOutput) {
	op := &request.Operation{
		Name:       opListTaskExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTaskExecutionsInput{}
	}

	output = &ListTaskExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTaskExecutions API operation for AWS DataSync.
//
// Returns a list of executed tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListTaskExecutions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions
func (c *DataSync) ListTaskExecutions(input *ListTaskExecutionsInput) (*ListTaskExecutionsOutput, error) {
	req, out := c.ListTaskExecutionsRequest(input)
	return out, req.Send()
}

// ListTaskExecutionsWithContext is the same as ListTaskExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTaskExecutionsWithContext(ctx aws.Context, input *ListTaskExecutionsInput, opts ...request.Option) (*ListTaskExecutionsOutput, error) {
	req, out := c.ListTaskExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTaskExecutionsPages iterates over the pages of a ListTaskExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTaskExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTaskExecutions operation.
//	pageNum := 0
//	err := client.ListTaskExecutionsPages(params,
//	    func(page *datasync.ListTaskExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListTaskExecutionsPages(input *ListTaskExecutionsInput, fn func(*ListTaskExecutionsOutput, bool) bool) error {
	return c.ListTaskExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTaskExecutionsPagesWithContext same as ListTaskExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTaskExecutionsPagesWithContext(ctx aws.Context, input *ListTaskExecutionsInput, fn func(*ListTaskExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTaskExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTaskExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTaskExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTasksRequest method.
//	req, resp := client.ListTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks
func (c *DataSync) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTasks API operation for AWS DataSync.
//
// Returns a list of the DataSync tasks you created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListTasks for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks
func (c *DataSync) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTasksWithContext(ctx aws.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTasksPages iterates over the pages of a ListTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTasks operation.
//	pageNum := 0
//	err := client.ListTasksPages(params,
//	    func(page *datasync.ListTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataSync) ListTasksPages(input *ListTasksInput, fn func(*ListTasksOutput, bool) bool) error {
	return c.ListTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTasksPagesWithContext same as ListTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTasksPagesWithContext(ctx aws.Context, input *ListTasksInput, fn func(*ListTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRemoveStorageSystem = "RemoveStorageSystem"

// RemoveStorageSystemRequest generates a "aws/request.Request" representing the
// client's request for the RemoveStorageSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveStorageSystem for more information on using the RemoveStorageSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveStorageSystemRequest method.
//	req, resp := client.RemoveStorageSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/RemoveStorageSystem
func (c *DataSync) RemoveStorageSystemRequest(input *RemoveStorageSystemInput) (req *request.Request, output *RemoveStorageSystemOutput) {
	op := &request.Operation{
		Name:       opRemoveStorageSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveStorageSystemInput{}
	}

	output = &RemoveStorageSystemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// RemoveStorageSystem API operation for AWS DataSync.
//
// Permanently removes a storage system resource from DataSync Discovery, including
// the associated discovery jobs, collected data, and recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation RemoveStorageSystem for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/RemoveStorageSystem
func (c *DataSync) RemoveStorageSystem(input *RemoveStorageSystemInput) (*RemoveStorageSystemOutput, error) {
	req, out := c.RemoveStorageSystemRequest(input)
	return out, req.Send()
}

// RemoveStorageSystemWithContext is the same as RemoveStorageSystem with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveStorageSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) RemoveStorageSystemWithContext(ctx aws.Context, input *RemoveStorageSystemInput, opts ...request.Option) (*RemoveStorageSystemOutput, error) {
	req, out := c.RemoveStorageSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDiscoveryJob = "StartDiscoveryJob"

// StartDiscoveryJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDiscoveryJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDiscoveryJob for more information on using the StartDiscoveryJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDiscoveryJobRequest method.
//	req, resp := client.StartDiscoveryJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartDiscoveryJob
func (c *DataSync) StartDiscoveryJobRequest(input *StartDiscoveryJobInput) (req *request.Request, output *StartDiscoveryJobOutput) {
	op := &request.Operation{
		Name:       opStartDiscoveryJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDiscoveryJobInput{}
	}

	output = &StartDiscoveryJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartDiscoveryJob API operation for AWS DataSync.
//
// Runs a DataSync discovery job on your on-premises storage system. If you
// haven't added the storage system to DataSync Discovery yet, do this first
// by using the AddStorageSystem (https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation StartDiscoveryJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartDiscoveryJob
func (c *DataSync) StartDiscoveryJob(input *StartDiscoveryJobInput) (*StartDiscoveryJobOutput, error) {
	req, out := c.StartDiscoveryJobRequest(input)
	return out, req.Send()
}

// StartDiscoveryJobWithContext is the same as StartDiscoveryJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDiscoveryJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) StartDiscoveryJobWithContext(ctx aws.Context, input *StartDiscoveryJobInput, opts ...request.Option) (*StartDiscoveryJobOutput, error) {
	req, out := c.StartDiscoveryJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTaskExecution = "StartTaskExecution"

// StartTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTaskExecution for more information on using the StartTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTaskExecutionRequest method.
//	req, resp := client.StartTaskExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution
func (c *DataSync) StartTaskExecutionRequest(input *StartTaskExecutionInput) (req *request.Request, output *StartTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opStartTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTaskExecutionInput{}
	}

	output = &StartTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTaskExecution API operation for AWS DataSync.
//
// Starts an DataSync task. For each task, you can only run one task execution
// at a time.
//
// There are several phases to a task execution. For more information, see Task
// execution statuses (https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses).
//
// If you're planning to transfer data to or from an Amazon S3 location, review
// how DataSync can affect your S3 request charges (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests)
// and the DataSync pricing page (http://aws.amazon.com/datasync/pricing/) before
// you begin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation StartTaskExecution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution
func (c *DataSync) StartTaskExecution(input *StartTaskExecutionInput) (*StartTaskExecutionOutput, error) {
	req, out := c.StartTaskExecutionRequest(input)
	return out, req.Send()
}

// StartTaskExecutionWithContext is the same as StartTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) StartTaskExecutionWithContext(ctx aws.Context, input *StartTaskExecutionInput, opts ...request.Option) (*StartTaskExecutionOutput, error) {
	req, out := c.StartTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDiscoveryJob = "StopDiscoveryJob"

// StopDiscoveryJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDiscoveryJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDiscoveryJob for more information on using the StopDiscoveryJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopDiscoveryJobRequest method.
//	req, resp := client.StopDiscoveryJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StopDiscoveryJob
func (c *DataSync) StopDiscoveryJobRequest(input *StopDiscoveryJobInput) (req *request.Request, output *StopDiscoveryJobOutput) {
	op := &request.Operation{
		Name:       opStopDiscoveryJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDiscoveryJobInput{}
	}

	output = &StopDiscoveryJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StopDiscoveryJob API operation for AWS DataSync.
//
// Stops a running DataSync discovery job.
//
// You can stop a discovery job anytime. A job that's stopped before it's scheduled
// to end likely will provide you some information about your on-premises storage
// system resources. To get recommendations for a stopped job, you must use
// the GenerateRecommendations (https://docs.aws.amazon.com/datasync/latest/userguide/API_GenerateRecommendations.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation StopDiscoveryJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StopDiscoveryJob
func (c *DataSync) StopDiscoveryJob(input *StopDiscoveryJobInput) (*StopDiscoveryJobOutput, error) {
	req, out := c.StopDiscoveryJobRequest(input)
	return out, req.Send()
}

// StopDiscoveryJobWithContext is the same as StopDiscoveryJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDiscoveryJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) StopDiscoveryJobWithContext(ctx aws.Context, input *StopDiscoveryJobInput, opts ...request.Option) (*StopDiscoveryJobOutput, error) {
	req, out := c.StopDiscoveryJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource
func (c *DataSync) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS DataSync.
//
// Applies a tag to an Amazon Web Services resource. Tags are key-value pairs
// that can help you manage, filter, and search for your resources.
//
// These include DataSync resources, such as locations, tasks, and task executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource
func (c *DataSync) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource
func (c *DataSync) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS DataSync.
//
// Removes tags from an Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource
func (c *DataSync) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgent = "UpdateAgent"

// UpdateAgentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgent for more information on using the UpdateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentRequest method.
//	req, resp := client.UpdateAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent
func (c *DataSync) UpdateAgentRequest(input *UpdateAgentInput) (req *request.Request, output *UpdateAgentOutput) {
	op := &request.Operation{
		Name:       opUpdateAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAgentInput{}
	}

	output = &UpdateAgentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAgent API operation for AWS DataSync.
//
// Updates the name of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateAgent for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent
func (c *DataSync) UpdateAgent(input *UpdateAgentInput) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	return out, req.Send()
}

// UpdateAgentWithContext is the same as UpdateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateAgentWithContext(ctx aws.Context, input *UpdateAgentInput, opts ...request.Option) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDiscoveryJob = "UpdateDiscoveryJob"

// UpdateDiscoveryJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDiscoveryJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDiscoveryJob for more information on using the UpdateDiscoveryJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDiscoveryJobRequest method.
//	req, resp := client.UpdateDiscoveryJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateDiscoveryJob
func (c *DataSync) UpdateDiscoveryJobRequest(input *UpdateDiscoveryJobInput) (req *request.Request, output *UpdateDiscoveryJobOutput) {
	op := &request.Operation{
		Name:       opUpdateDiscoveryJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDiscoveryJobInput{}
	}

	output = &UpdateDiscoveryJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateDiscoveryJob API operation for AWS DataSync.
//
// Edits a DataSync discovery job configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateDiscoveryJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateDiscoveryJob
func (c *DataSync) UpdateDiscoveryJob(input *UpdateDiscoveryJobInput) (*UpdateDiscoveryJobOutput, error) {
	req, out := c.UpdateDiscoveryJobRequest(input)
	return out, req.Send()
}

// UpdateDiscoveryJobWithContext is the same as UpdateDiscoveryJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDiscoveryJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateDiscoveryJobWithContext(ctx aws.Context, input *UpdateDiscoveryJobInput, opts ...request.Option) (*UpdateDiscoveryJobOutput, error) {
	req, out := c.UpdateDiscoveryJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLocationHdfs = "UpdateLocationHdfs"

// UpdateLocationHdfsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLocationHdfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLocationHdfs for more information on using the UpdateLocationHdfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLocationHdfsRequest method.
//	req, resp := client.UpdateLocationHdfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationHdfs
func (c *DataSync) UpdateLocationHdfsRequest(input *UpdateLocationHdfsInput) (req *request.Request, output *UpdateLocationHdfsOutput) {
	op := &request.Operation{
		Name:       opUpdateLocationHdfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLocationHdfsInput{}
	}

	output = &UpdateLocationHdfsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLocationHdfs API operation for AWS DataSync.
//
// Updates some parameters of a previously created location for a Hadoop Distributed
// File System cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateLocationHdfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationHdfs
func (c *DataSync) UpdateLocationHdfs(input *UpdateLocationHdfsInput) (*UpdateLocationHdfsOutput, error) {
	req, out := c.UpdateLocationHdfsRequest(input)
	return out, req.Send()
}

// UpdateLocationHdfsWithContext is the same as UpdateLocationHdfs with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLocationHdfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateLocationHdfsWithContext(ctx aws.Context, input *UpdateLocationHdfsInput, opts ...request.Option) (*UpdateLocationHdfsOutput, error) {
	req, out := c.UpdateLocationHdfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLocationNfs = "UpdateLocationNfs"

// UpdateLocationNfsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLocationNfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLocationNfs for more information on using the UpdateLocationNfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLocationNfsRequest method.
//	req, resp := client.UpdateLocationNfsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationNfs
func (c *DataSync) UpdateLocationNfsRequest(input *UpdateLocationNfsInput) (req *request.Request, output *UpdateLocationNfsOutput) {
	op := &request.Operation{
		Name:       opUpdateLocationNfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLocationNfsInput{}
	}

	output = &UpdateLocationNfsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLocationNfs API operation for AWS DataSync.
//
// Updates some of the parameters of a previously created location for Network
// File System (NFS) access. For information about creating an NFS location,
// see Creating a location for NFS (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateLocationNfs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationNfs
func (c *DataSync) UpdateLocationNfs(input *UpdateLocationNfsInput) (*UpdateLocationNfsOutput, error) {
	req, out := c.UpdateLocationNfsRequest(input)
	return out, req.Send()
}

// UpdateLocationNfsWithContext is the same as UpdateLocationNfs with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLocationNfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateLocationNfsWithContext(ctx aws.Context, input *UpdateLocationNfsInput, opts ...request.Option) (*UpdateLocationNfsOutput, error) {
	req, out := c.UpdateLocationNfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLocationObjectStorage = "UpdateLocationObjectStorage"

// UpdateLocationObjectStorageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLocationObjectStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLocationObjectStorage for more information on using the UpdateLocationObjectStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLocationObjectStorageRequest method.
//	req, resp := client.UpdateLocationObjectStorageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationObjectStorage
func (c *DataSync) UpdateLocationObjectStorageRequest(input *UpdateLocationObjectStorageInput) (req *request.Request, output *UpdateLocationObjectStorageOutput) {
	op := &request.Operation{
		Name:       opUpdateLocationObjectStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLocationObjectStorageInput{}
	}

	output = &UpdateLocationObjectStorageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLocationObjectStorage API operation for AWS DataSync.
//
// Updates some parameters of an existing object storage location that DataSync
// accesses for a transfer. For information about creating a self-managed object
// storage location, see Creating a location for object storage (https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateLocationObjectStorage for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationObjectStorage
func (c *DataSync) UpdateLocationObjectStorage(input *UpdateLocationObjectStorageInput) (*UpdateLocationObjectStorageOutput, error) {
	req, out := c.UpdateLocationObjectStorageRequest(input)
	return out, req.Send()
}

// UpdateLocationObjectStorageWithContext is the same as UpdateLocationObjectStorage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLocationObjectStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateLocationObjectStorageWithContext(ctx aws.Context, input *UpdateLocationObjectStorageInput, opts ...request.Option) (*UpdateLocationObjectStorageOutput, error) {
	req, out := c.UpdateLocationObjectStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLocationSmb = "UpdateLocationSmb"

// UpdateLocationSmbRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLocationSmb operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLocationSmb for more information on using the UpdateLocationSmb
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLocationSmbRequest method.
//	req, resp := client.UpdateLocationSmbRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationSmb
func (c *DataSync) UpdateLocationSmbRequest(input *UpdateLocationSmbInput) (req *request.Request, output *UpdateLocationSmbOutput) {
	op := &request.Operation{
		Name:       opUpdateLocationSmb,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLocationSmbInput{}
	}

	output = &UpdateLocationSmbOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLocationSmb API operation for AWS DataSync.
//
// Updates some of the parameters of a previously created location for Server
// Message Block (SMB) file system access. For information about creating an
// SMB location, see Creating a location for SMB (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateLocationSmb for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationSmb
func (c *DataSync) UpdateLocationSmb(input *UpdateLocationSmbInput) (*UpdateLocationSmbOutput, error) {
	req, out := c.UpdateLocationSmbRequest(input)
	return out, req.Send()
}

// UpdateLocationSmbWithContext is the same as UpdateLocationSmb with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLocationSmb for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateLocationSmbWithContext(ctx aws.Context, input *UpdateLocationSmbInput, opts ...request.Option) (*UpdateLocationSmbOutput, error) {
	req, out := c.UpdateLocationSmbRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStorageSystem = "UpdateStorageSystem"

// UpdateStorageSystemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStorageSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStorageSystem for more information on using the UpdateStorageSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStorageSystemRequest method.
//	req, resp := client.UpdateStorageSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateStorageSystem
func (c *DataSync) UpdateStorageSystemRequest(input *UpdateStorageSystemInput) (req *request.Request, output *UpdateStorageSystemOutput) {
	op := &request.Operation{
		Name:       opUpdateStorageSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStorageSystemInput{}
	}

	output = &UpdateStorageSystemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("discovery-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateStorageSystem API operation for AWS DataSync.
//
// Modifies some configurations of an on-premises storage system resource that
// you're using with DataSync Discovery.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateStorageSystem for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateStorageSystem
func (c *DataSync) UpdateStorageSystem(input *UpdateStorageSystemInput) (*UpdateStorageSystemOutput, error) {
	req, out := c.UpdateStorageSystemRequest(input)
	return out, req.Send()
}

// UpdateStorageSystemWithContext is the same as UpdateStorageSystem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStorageSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateStorageSystemWithContext(ctx aws.Context, input *UpdateStorageSystemInput, opts ...request.Option) (*UpdateStorageSystemOutput, error) {
	req, out := c.UpdateStorageSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTask = "UpdateTask"

// UpdateTaskRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTask for more information on using the UpdateTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTaskRequest method.
//	req, resp := client.UpdateTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask
func (c *DataSync) UpdateTaskRequest(input *UpdateTaskInput) (req *request.Request, output *UpdateTaskOutput) {
	op := &request.Operation{
		Name:       opUpdateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTaskInput{}
	}

	output = &UpdateTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTask API operation for AWS DataSync.
//
// Updates the metadata associated with a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateTask for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask
func (c *DataSync) UpdateTask(input *UpdateTaskInput) (*UpdateTaskOutput, error) {
	req, out := c.UpdateTaskRequest(input)
	return out, req.Send()
}

// UpdateTaskWithContext is the same as UpdateTask with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateTaskWithContext(ctx aws.Context, input *UpdateTaskInput, opts ...request.Option) (*UpdateTaskOutput, error) {
	req, out := c.UpdateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTaskExecution = "UpdateTaskExecution"

// UpdateTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTaskExecution for more information on using the UpdateTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTaskExecutionRequest method.
//	req, resp := client.UpdateTaskExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTaskExecution
func (c *DataSync) UpdateTaskExecutionRequest(input *UpdateTaskExecutionInput) (req *request.Request, output *UpdateTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opUpdateTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTaskExecutionInput{}
	}

	output = &UpdateTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTaskExecution API operation for AWS DataSync.
//
// Modifies a running DataSync task.
//
// Currently, the only Option that you can modify with UpdateTaskExecution is
// BytesPerSecond (https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond)
// , which throttles bandwidth for a running or queued task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateTaskExecution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     This exception is thrown when the client submits a malformed request.
//
//   - InternalException
//     This exception is thrown when an error occurs in the DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTaskExecution
func (c *DataSync) UpdateTaskExecution(input *UpdateTaskExecutionInput) (*UpdateTaskExecutionOutput, error) {
	req, out := c.UpdateTaskExecutionRequest(input)
	return out, req.Send()
}

// UpdateTaskExecutionWithContext is the same as UpdateTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateTaskExecutionWithContext(ctx aws.Context, input *UpdateTaskExecutionInput, opts ...request.Option) (*UpdateTaskExecutionOutput, error) {
	req, out := c.UpdateTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddStorageSystemInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects
	// to and reads from your on-premises storage system's management interface.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`

	// Specifies a client token to make sure requests with this API operation are
	// idempotent. If you don't specify a client token, DataSync generates one for
	// you automatically.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging
	// discovery job events.
	CloudWatchLogGroupArn *string `type:"string"`

	// Specifies the user name and password for accessing your on-premises storage
	// system's management interface.
	//
	// Credentials is a required field
	Credentials *Credentials `type:"structure" required:"true"`

	// Specifies a familiar name for your on-premises storage system.
	Name *string `min:"1" type:"string"`

	// Specifies the server name and network port required to connect with the management
	// interface of your on-premises storage system.
	//
	// ServerConfiguration is a required field
	ServerConfiguration *DiscoveryServerConfiguration `type:"structure" required:"true"`

	// Specifies the type of on-premises storage system that you want DataSync Discovery
	// to collect information about.
	//
	// DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS)
	// and All Flash FAS (AFF) systems running ONTAP 9.7 or later.
	//
	// SystemType is a required field
	SystemType *string `type:"string" required:"true" enum:"DiscoverySystemType"`

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// on-premises storage system.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddStorageSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddStorageSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddStorageSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddStorageSystemInput"}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServerConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerConfiguration"))
	}
	if s.SystemType == nil {
		invalidParams.Add(request.NewErrParamRequired("SystemType"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerConfiguration != nil {
		if err := s.ServerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *AddStorageSystemInput) SetAgentArns(v []*string) *AddStorageSystemInput {
	s.AgentArns = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AddStorageSystemInput) SetClientToken(v string) *AddStorageSystemInput {
	s.ClientToken = &v
	return s
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *AddStorageSystemInput) SetCloudWatchLogGroupArn(v string) *AddStorageSystemInput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *AddStorageSystemInput) SetCredentials(v *Credentials) *AddStorageSystemInput {
	s.Credentials = v
	return s
}

// SetName sets the Name field's value.
func (s *AddStorageSystemInput) SetName(v string) *AddStorageSystemInput {
	s.Name = &v
	return s
}

// SetServerConfiguration sets the ServerConfiguration field's value.
func (s *AddStorageSystemInput) SetServerConfiguration(v *DiscoveryServerConfiguration) *AddStorageSystemInput {
	s.ServerConfiguration = v
	return s
}

// SetSystemType sets the SystemType field's value.
func (s *AddStorageSystemInput) SetSystemType(v string) *AddStorageSystemInput {
	s.SystemType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddStorageSystemInput) SetTags(v []*TagListEntry) *AddStorageSystemInput {
	s.Tags = v
	return s
}

type AddStorageSystemOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the on-premises storage system that you can use with DataSync
	// Discovery.
	//
	// StorageSystemArn is a required field
	StorageSystemArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddStorageSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddStorageSystemOutput) GoString() string {
	return s.String()
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *AddStorageSystemOutput) SetStorageSystemArn(v string) *AddStorageSystemOutput {
	s.StorageSystemArn = &v
	return s
}

// Represents a single entry in a list (or array) of DataSync agents when you
// call the ListAgents (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html)
// operation.
type AgentListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a DataSync agent.
	AgentArn *string `type:"string"`

	// The name of an agent.
	Name *string `min:"1" type:"string"`

	// The status of an agent. For more information, see DataSync agent statuses
	// (https://docs.aws.amazon.com/datasync/latest/userguide/understand-agent-statuses.html).
	Status *string `type:"string" enum:"AgentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentListEntry) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *AgentListEntry) SetAgentArn(v string) *AgentListEntry {
	s.AgentArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AgentListEntry) SetName(v string) *AgentListEntry {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AgentListEntry) SetStatus(v string) *AgentListEntry {
	s.Status = &v
	return s
}

// CancelTaskExecutionRequest
type CancelTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution to stop.
	//
	// TaskExecutionArn is a required field
	TaskExecutionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelTaskExecutionInput"}
	if s.TaskExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskExecutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *CancelTaskExecutionInput) SetTaskExecutionArn(v string) *CancelTaskExecutionInput {
	s.TaskExecutionArn = &v
	return s
}

type CancelTaskExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTaskExecutionOutput) GoString() string {
	return s.String()
}

// The storage capacity of an on-premises storage system resource (for example,
// a volume).
type Capacity struct {
	_ struct{} `type:"structure"`

	// The amount of space that's being used in a storage system resource without
	// accounting for compression or deduplication.
	LogicalUsed *int64 `type:"long"`

	// The total amount of space available in a storage system resource.
	Provisioned *int64 `type:"long"`

	// The amount of space that's being used in a storage system resource.
	Used *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) GoString() string {
	return s.String()
}

// SetLogicalUsed sets the LogicalUsed field's value.
func (s *Capacity) SetLogicalUsed(v int64) *Capacity {
	s.LogicalUsed = &v
	return s
}

// SetProvisioned sets the Provisioned field's value.
func (s *Capacity) SetProvisioned(v int64) *Capacity {
	s.Provisioned = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *Capacity) SetUsed(v int64) *Capacity {
	s.Used = &v
	return s
}

// CreateAgentRequest
type CreateAgentInput struct {
	_ struct{} `type:"structure"`

	// Your agent activation key. You can get the activation key either by sending
	// an HTTP GET request with redirects that enable you to get the agent IP address
	// (port 80). Alternatively, you can get it from the DataSync console.
	//
	// The redirect URL returned in the response provides you the activation key
	// for your agent in the query string parameter activationKey. It might also
	// include other activation-related parameters; however, these are merely defaults.
	// The arguments you pass to this API call determine the actual configuration
	// of your agent.
	//
	// For more information, see Activating an Agent in the DataSync User Guide.
	//
	// ActivationKey is a required field
	ActivationKey *string `type:"string" required:"true"`

	// The name you configured for your agent. This value is a text reference that
	// is used to identify the agent in the console.
	AgentName *string `min:"1" type:"string"`

	// The ARNs of the security groups used to protect your data transfer task subnets.
	// See SecurityGroupArns (https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns).
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The Amazon Resource Names (ARNs) of the subnets in which DataSync will create
	// elastic network interfaces for each data transfer task. The agent that runs
	// a task must be private. When you start a task that is associated with an
	// agent created in a VPC, or one that has access to an IP address in a VPC,
	// then the task is also private. In this case, DataSync creates four network
	// interfaces for each task in your subnet. For a data transfer to work, the
	// agent must be able to route to all these four network interfaces.
	SubnetArns []*string `min:"1" type:"list"`

	// The key-value pair that represents the tag that you want to associate with
	// the agent. The value can be an empty string. This value helps you manage,
	// filter, and search for your agents.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @.
	Tags []*TagListEntry `type:"list"`

	// The ID of the VPC (virtual private cloud) endpoint that the agent has access
	// to. This is the client-side VPC endpoint, also called a PrivateLink. If you
	// don't have a PrivateLink VPC endpoint, see Creating a VPC Endpoint Service
	// Configuration (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service)
	// in the Amazon VPC User Guide.
	//
	// VPC endpoint ID looks like this: vpce-01234d5aff67890e1.
	VpcEndpointId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentInput"}
	if s.ActivationKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationKey"))
	}
	if s.AgentName != nil && len(*s.AgentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentName", 1))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.SubnetArns != nil && len(s.SubnetArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetArns", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationKey sets the ActivationKey field's value.
func (s *CreateAgentInput) SetActivationKey(v string) *CreateAgentInput {
	s.ActivationKey = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *CreateAgentInput) SetAgentName(v string) *CreateAgentInput {
	s.AgentName = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateAgentInput) SetSecurityGroupArns(v []*string) *CreateAgentInput {
	s.SecurityGroupArns = v
	return s
}

// SetSubnetArns sets the SubnetArns field's value.
func (s *CreateAgentInput) SetSubnetArns(v []*string) *CreateAgentInput {
	s.SubnetArns = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentInput) SetTags(v []*TagListEntry) *CreateAgentInput {
	s.Tags = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *CreateAgentInput) SetVpcEndpointId(v string) *CreateAgentInput {
	s.VpcEndpointId = &v
	return s
}

// CreateAgentResponse
type CreateAgentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent. Use the ListAgents operation
	// to return a list of agents for your account and Amazon Web Services Region.
	AgentArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentOutput) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *CreateAgentOutput) SetAgentArn(v string) *CreateAgentOutput {
	s.AgentArn = &v
	return s
}

// CreateLocationEfsRequest
type CreateLocationEfsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the access point that DataSync
	// uses to access the Amazon EFS file system.
	AccessPointArn *string `type:"string"`

	// Specifies the subnet and security groups DataSync uses to access your Amazon
	// EFS file system.
	//
	// Ec2Config is a required field
	Ec2Config *Ec2Config `type:"structure" required:"true"`

	// Specifies the ARN for the Amazon EFS file system.
	//
	// EfsFilesystemArn is a required field
	EfsFilesystemArn *string `type:"string" required:"true"`

	// Specifies an Identity and Access Management (IAM) role that DataSync assumes
	// when mounting the Amazon EFS file system.
	FileSystemAccessRoleArn *string `type:"string"`

	// Specifies whether you want DataSync to use Transport Layer Security (TLS)
	// 1.2 encryption when it copies data to or from the Amazon EFS file system.
	//
	// If you specify an access point using AccessPointArn or an IAM role using
	// FileSystemAccessRoleArn, you must set this parameter to TLS1_2.
	InTransitEncryption *string `type:"string" enum:"EfsInTransitEncryption"`

	// Specifies a mount path for your Amazon EFS file system. This is where DataSync
	// reads or writes data (depending on if this is a source or destination location).
	// By default, DataSync uses the root directory, but you can also include subdirectories.
	//
	// You must specify a value with forward slashes (for example, /path/to/folder).
	Subdirectory *string `type:"string"`

	// Specifies the key-value pair that represents a tag that you want to add to
	// the resource. The value can be an empty string. This value helps you manage,
	// filter, and search for your resources. We recommend that you create a name
	// tag for your location.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationEfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationEfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationEfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationEfsInput"}
	if s.Ec2Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2Config"))
	}
	if s.EfsFilesystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EfsFilesystemArn"))
	}
	if s.Ec2Config != nil {
		if err := s.Ec2Config.Validate(); err != nil {
			invalidParams.AddNested("Ec2Config", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *CreateLocationEfsInput) SetAccessPointArn(v string) *CreateLocationEfsInput {
	s.AccessPointArn = &v
	return s
}

// SetEc2Config sets the Ec2Config field's value.
func (s *CreateLocationEfsInput) SetEc2Config(v *Ec2Config) *CreateLocationEfsInput {
	s.Ec2Config = v
	return s
}

// SetEfsFilesystemArn sets the EfsFilesystemArn field's value.
func (s *CreateLocationEfsInput) SetEfsFilesystemArn(v string) *CreateLocationEfsInput {
	s.EfsFilesystemArn = &v
	return s
}

// SetFileSystemAccessRoleArn sets the FileSystemAccessRoleArn field's value.
func (s *CreateLocationEfsInput) SetFileSystemAccessRoleArn(v string) *CreateLocationEfsInput {
	s.FileSystemAccessRoleArn = &v
	return s
}

// SetInTransitEncryption sets the InTransitEncryption field's value.
func (s *CreateLocationEfsInput) SetInTransitEncryption(v string) *CreateLocationEfsInput {
	s.InTransitEncryption = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationEfsInput) SetSubdirectory(v string) *CreateLocationEfsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationEfsInput) SetTags(v []*TagListEntry) *CreateLocationEfsInput {
	s.Tags = v
	return s
}

// CreateLocationEfs
type CreateLocationEfsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon EFS file system location that
	// you create.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationEfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationEfsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationEfsOutput) SetLocationArn(v string) *CreateLocationEfsOutput {
	s.LocationArn = &v
	return s
}

type CreateLocationFsxLustreInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the FSx for Lustre file system.
	//
	// FsxFilesystemArn is a required field
	FsxFilesystemArn *string `type:"string" required:"true"`

	// The Amazon Resource Names (ARNs) of the security groups that are used to
	// configure the FSx for Lustre file system.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// A subdirectory in the location's path. This subdirectory in the FSx for Lustre
	// file system is used to read data from the FSx for Lustre source location
	// or write data to the FSx for Lustre destination.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents a tag that you want to add to the resource.
	// The value can be an empty string. This value helps you manage, filter, and
	// search for your resources. We recommend that you create a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxLustreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxLustreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationFsxLustreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationFsxLustreInput"}
	if s.FsxFilesystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FsxFilesystemArn"))
	}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFsxFilesystemArn sets the FsxFilesystemArn field's value.
func (s *CreateLocationFsxLustreInput) SetFsxFilesystemArn(v string) *CreateLocationFsxLustreInput {
	s.FsxFilesystemArn = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateLocationFsxLustreInput) SetSecurityGroupArns(v []*string) *CreateLocationFsxLustreInput {
	s.SecurityGroupArns = v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationFsxLustreInput) SetSubdirectory(v string) *CreateLocationFsxLustreInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationFsxLustreInput) SetTags(v []*TagListEntry) *CreateLocationFsxLustreInput {
	s.Tags = v
	return s
}

type CreateLocationFsxLustreOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for Lustre file system location
	// that's created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxLustreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxLustreOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationFsxLustreOutput) SetLocationArn(v string) *CreateLocationFsxLustreOutput {
	s.LocationArn = &v
	return s
}

type CreateLocationFsxOntapInput struct {
	_ struct{} `type:"structure"`

	// Specifies the data transfer protocol that DataSync uses to access your Amazon
	// FSx file system.
	//
	// Protocol is a required field
	Protocol *FsxProtocol `type:"structure" required:"true"`

	// Specifies the Amazon EC2 security groups that provide access to your file
	// system's preferred subnet.
	//
	// The security groups must allow outbound traffic on the following ports (depending
	// on the protocol you use):
	//
	//    * Network File System (NFS): TCP ports 111, 635, and 2049
	//
	//    * Server Message Block (SMB): TCP port 445
	//
	// Your file system's security groups must also allow inbound traffic on the
	// same ports.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// Specifies the ARN of the storage virtual machine (SVM) in your file system
	// where you want to copy data to or from.
	//
	// StorageVirtualMachineArn is a required field
	StorageVirtualMachineArn *string `type:"string" required:"true"`

	// Specifies a path to the file share in the SVM where you'll copy your data.
	//
	// You can specify a junction path (also known as a mount point), qtree path
	// (for NFS file shares), or share name (for SMB file shares). For example,
	// your mount path might be /vol1, /vol1/tree1, or /share1.
	//
	// Don't specify a junction path in the SVM's root volume. For more information,
	// see Managing FSx for ONTAP storage virtual machines (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html)
	// in the Amazon FSx for NetApp ONTAP User Guide.
	Subdirectory *string `type:"string"`

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOntapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOntapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationFsxOntapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationFsxOntapInput"}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.StorageVirtualMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageVirtualMachineArn"))
	}
	if s.Protocol != nil {
		if err := s.Protocol.Validate(); err != nil {
			invalidParams.AddNested("Protocol", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProtocol sets the Protocol field's value.
func (s *CreateLocationFsxOntapInput) SetProtocol(v *FsxProtocol) *CreateLocationFsxOntapInput {
	s.Protocol = v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateLocationFsxOntapInput) SetSecurityGroupArns(v []*string) *CreateLocationFsxOntapInput {
	s.SecurityGroupArns = v
	return s
}

// SetStorageVirtualMachineArn sets the StorageVirtualMachineArn field's value.
func (s *CreateLocationFsxOntapInput) SetStorageVirtualMachineArn(v string) *CreateLocationFsxOntapInput {
	s.StorageVirtualMachineArn = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationFsxOntapInput) SetSubdirectory(v string) *CreateLocationFsxOntapInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationFsxOntapInput) SetTags(v []*TagListEntry) *CreateLocationFsxOntapInput {
	s.Tags = v
	return s
}

type CreateLocationFsxOntapOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the FSx for ONTAP file system location that you create.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOntapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOntapOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationFsxOntapOutput) SetLocationArn(v string) *CreateLocationFsxOntapOutput {
	s.LocationArn = &v
	return s
}

type CreateLocationFsxOpenZfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for OpenZFS file system.
	//
	// FsxFilesystemArn is a required field
	FsxFilesystemArn *string `type:"string" required:"true"`

	// The type of protocol that DataSync uses to access your file system.
	//
	// Protocol is a required field
	Protocol *FsxProtocol `type:"structure" required:"true"`

	// The ARNs of the security groups that are used to configure the FSx for OpenZFS
	// file system.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// A subdirectory in the location's path that must begin with /fsx. DataSync
	// uses this subdirectory to read or write data (depending on whether the file
	// system is a source or destination location).
	Subdirectory *string `type:"string"`

	// The key-value pair that represents a tag that you want to add to the resource.
	// The value can be an empty string. This value helps you manage, filter, and
	// search for your resources. We recommend that you create a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOpenZfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOpenZfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationFsxOpenZfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationFsxOpenZfsInput"}
	if s.FsxFilesystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FsxFilesystemArn"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.Protocol != nil {
		if err := s.Protocol.Validate(); err != nil {
			invalidParams.AddNested("Protocol", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFsxFilesystemArn sets the FsxFilesystemArn field's value.
func (s *CreateLocationFsxOpenZfsInput) SetFsxFilesystemArn(v string) *CreateLocationFsxOpenZfsInput {
	s.FsxFilesystemArn = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateLocationFsxOpenZfsInput) SetProtocol(v *FsxProtocol) *CreateLocationFsxOpenZfsInput {
	s.Protocol = v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateLocationFsxOpenZfsInput) SetSecurityGroupArns(v []*string) *CreateLocationFsxOpenZfsInput {
	s.SecurityGroupArns = v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationFsxOpenZfsInput) SetSubdirectory(v string) *CreateLocationFsxOpenZfsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationFsxOpenZfsInput) SetTags(v []*TagListEntry) *CreateLocationFsxOpenZfsInput {
	s.Tags = v
	return s
}

type CreateLocationFsxOpenZfsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the FSx for OpenZFS file system location that you created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOpenZfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxOpenZfsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationFsxOpenZfsOutput) SetLocationArn(v string) *CreateLocationFsxOpenZfsOutput {
	s.LocationArn = &v
	return s
}

type CreateLocationFsxWindowsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the Windows domain that the FSx for Windows File Server
	// belongs to.
	Domain *string `type:"string"`

	// Specifies the Amazon Resource Name (ARN) for the FSx for Windows File Server
	// file system.
	//
	// FsxFilesystemArn is a required field
	FsxFilesystemArn *string `type:"string" required:"true"`

	// Specifies the password of the user who has the permissions to access files
	// and folders in the file system.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLocationFsxWindowsInput's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// Specifies the ARNs of the security groups that provide access to your file
	// system's preferred subnet.
	//
	// If you choose a security group that doesn't allow connections from within
	// itself, do one of the following:
	//
	//    * Configure the security group to allow it to communicate within itself.
	//
	//    * Choose a different security group that can communicate with the mount
	//    target's security group.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// Specifies a mount path for your file system using forward slashes. This is
	// where DataSync reads or writes data (depending on if this is a source or
	// destination location).
	Subdirectory *string `type:"string"`

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`

	// Specifies the user who has the permissions to access files and folders in
	// the file system.
	//
	// For information about choosing a user name that ensures sufficient permissions
	// to files, folders, and metadata, see user (create-fsx-location.html#FSxWuser).
	//
	// User is a required field
	User *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxWindowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxWindowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationFsxWindowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationFsxWindowsInput"}
	if s.FsxFilesystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FsxFilesystemArn"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CreateLocationFsxWindowsInput) SetDomain(v string) *CreateLocationFsxWindowsInput {
	s.Domain = &v
	return s
}

// SetFsxFilesystemArn sets the FsxFilesystemArn field's value.
func (s *CreateLocationFsxWindowsInput) SetFsxFilesystemArn(v string) *CreateLocationFsxWindowsInput {
	s.FsxFilesystemArn = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateLocationFsxWindowsInput) SetPassword(v string) *CreateLocationFsxWindowsInput {
	s.Password = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateLocationFsxWindowsInput) SetSecurityGroupArns(v []*string) *CreateLocationFsxWindowsInput {
	s.SecurityGroupArns = v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationFsxWindowsInput) SetSubdirectory(v string) *CreateLocationFsxWindowsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationFsxWindowsInput) SetTags(v []*TagListEntry) *CreateLocationFsxWindowsInput {
	s.Tags = v
	return s
}

// SetUser sets the User field's value.
func (s *CreateLocationFsxWindowsInput) SetUser(v string) *CreateLocationFsxWindowsInput {
	s.User = &v
	return s
}

type CreateLocationFsxWindowsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the FSx for Windows File Server file system location you created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxWindowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationFsxWindowsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationFsxWindowsOutput) SetLocationArn(v string) *CreateLocationFsxWindowsOutput {
	s.LocationArn = &v
	return s
}

type CreateLocationHdfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the agents that are used to connect to
	// the HDFS cluster.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`

	// The type of authentication used to determine the identity of the user.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"HdfsAuthenticationType"`

	// The size of data blocks to write into the HDFS cluster. The block size must
	// be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
	BlockSize *int64 `min:"1.048576e+06" type:"integer"`

	// The Kerberos key table (keytab) that contains mappings between the defined
	// Kerberos principal and the encrypted keys. You can load the keytab from a
	// file by providing the file's address. If you're using the CLI, it performs
	// base64 encoding for you. Otherwise, provide the base64-encoded text.
	//
	// If KERBEROS is specified for AuthenticationType, this parameter is required.
	// KerberosKeytab is automatically base64 encoded/decoded by the SDK.
	KerberosKeytab []byte `type:"blob"`

	// The krb5.conf file that contains the Kerberos configuration information.
	// You can load the krb5.conf file by providing the file's address. If you're
	// using the CLI, it performs the base64 encoding for you. Otherwise, provide
	// the base64-encoded text.
	//
	// If KERBEROS is specified for AuthenticationType, this parameter is required.
	// KerberosKrb5Conf is automatically base64 encoded/decoded by the SDK.
	KerberosKrb5Conf []byte `type:"blob"`

	// The Kerberos principal with access to the files and folders on the HDFS cluster.
	//
	// If KERBEROS is specified for AuthenticationType, this parameter is required.
	KerberosPrincipal *string `min:"1" type:"string"`

	// The URI of the HDFS cluster's Key Management Server (KMS).
	KmsKeyProviderUri *string `min:"1" type:"string"`

	// The NameNode that manages the HDFS namespace. The NameNode performs operations
	// such as opening, closing, and renaming files and directories. The NameNode
	// contains the information to map blocks of data to the DataNodes. You can
	// use only one NameNode.
	//
	// NameNodes is a required field
	NameNodes []*HdfsNameNode `min:"1" type:"list" required:"true"`

	// The Quality of Protection (QOP) configuration specifies the Remote Procedure
	// Call (RPC) and data transfer protection settings configured on the Hadoop
	// Distributed File System (HDFS) cluster. If QopConfiguration isn't specified,
	// RpcProtection and DataTransferProtection default to PRIVACY. If you set RpcProtection
	// or DataTransferProtection, the other parameter assumes the same value.
	QopConfiguration *QopConfiguration `type:"structure"`

	// The number of DataNodes to replicate the data to when writing to the HDFS
	// cluster. By default, data is replicated to three DataNodes.
	ReplicationFactor *int64 `min:"1" type:"integer"`

	// The user name used to identify the client on the host operating system.
	//
	// If SIMPLE is specified for AuthenticationType, this parameter is required.
	SimpleUser *string `min:"1" type:"string"`

	// A subdirectory in the HDFS cluster. This subdirectory is used to read data
	// from or write data to the HDFS cluster. If the subdirectory isn't specified,
	// it will default to /.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationHdfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationHdfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationHdfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationHdfsInput"}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.BlockSize != nil && *s.BlockSize < 1.048576e+06 {
		invalidParams.Add(request.NewErrParamMinValue("BlockSize", 1.048576e+06))
	}
	if s.KerberosPrincipal != nil && len(*s.KerberosPrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KerberosPrincipal", 1))
	}
	if s.KmsKeyProviderUri != nil && len(*s.KmsKeyProviderUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyProviderUri", 1))
	}
	if s.NameNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NameNodes"))
	}
	if s.NameNodes != nil && len(s.NameNodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameNodes", 1))
	}
	if s.ReplicationFactor != nil && *s.ReplicationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReplicationFactor", 1))
	}
	if s.SimpleUser != nil && len(*s.SimpleUser) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SimpleUser", 1))
	}
	if s.NameNodes != nil {
		for i, v := range s.NameNodes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NameNodes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *CreateLocationHdfsInput) SetAgentArns(v []*string) *CreateLocationHdfsInput {
	s.AgentArns = v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *CreateLocationHdfsInput) SetAuthenticationType(v string) *CreateLocationHdfsInput {
	s.AuthenticationType = &v
	return s
}

// SetBlockSize sets the BlockSize field's value.
func (s *CreateLocationHdfsInput) SetBlockSize(v int64) *CreateLocationHdfsInput {
	s.BlockSize = &v
	return s
}

// SetKerberosKeytab sets the KerberosKeytab field's value.
func (s *CreateLocationHdfsInput) SetKerberosKeytab(v []byte) *CreateLocationHdfsInput {
	s.KerberosKeytab = v
	return s
}

// SetKerberosKrb5Conf sets the KerberosKrb5Conf field's value.
func (s *CreateLocationHdfsInput) SetKerberosKrb5Conf(v []byte) *CreateLocationHdfsInput {
	s.KerberosKrb5Conf = v
	return s
}

// SetKerberosPrincipal sets the KerberosPrincipal field's value.
func (s *CreateLocationHdfsInput) SetKerberosPrincipal(v string) *CreateLocationHdfsInput {
	s.KerberosPrincipal = &v
	return s
}

// SetKmsKeyProviderUri sets the KmsKeyProviderUri field's value.
func (s *CreateLocationHdfsInput) SetKmsKeyProviderUri(v string) *CreateLocationHdfsInput {
	s.KmsKeyProviderUri = &v
	return s
}

// SetNameNodes sets the NameNodes field's value.
func (s *CreateLocationHdfsInput) SetNameNodes(v []*HdfsNameNode) *CreateLocationHdfsInput {
	s.NameNodes = v
	return s
}

// SetQopConfiguration sets the QopConfiguration field's value.
func (s *CreateLocationHdfsInput) SetQopConfiguration(v *QopConfiguration) *CreateLocationHdfsInput {
	s.QopConfiguration = v
	return s
}

// SetReplicationFactor sets the ReplicationFactor field's value.
func (s *CreateLocationHdfsInput) SetReplicationFactor(v int64) *CreateLocationHdfsInput {
	s.ReplicationFactor = &v
	return s
}

// SetSimpleUser sets the SimpleUser field's value.
func (s *CreateLocationHdfsInput) SetSimpleUser(v string) *CreateLocationHdfsInput {
	s.SimpleUser = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationHdfsInput) SetSubdirectory(v string) *CreateLocationHdfsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationHdfsInput) SetTags(v []*TagListEntry) *CreateLocationHdfsInput {
	s.Tags = v
	return s
}

type CreateLocationHdfsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the source HDFS cluster location that's created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationHdfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationHdfsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationHdfsOutput) SetLocationArn(v string) *CreateLocationHdfsOutput {
	s.LocationArn = &v
	return s
}

// CreateLocationNfsRequest
type CreateLocationNfsInput struct {
	_ struct{} `type:"structure"`

	// The NFS mount options that DataSync can use to mount your NFS share.
	MountOptions *NfsMountOptions `type:"structure"`

	// Contains a list of Amazon Resource Names (ARNs) of agents that are used to
	// connect to an NFS server.
	//
	// If you are copying data to or from your Snowcone device, see NFS Server on
	// Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// OnPremConfig is a required field
	OnPremConfig *OnPremConfig `type:"structure" required:"true"`

	// The name of the NFS server. This value is the IP address or Domain Name Service
	// (DNS) name of the NFS server. An agent that is installed on-premises uses
	// this hostname to mount the NFS server in a network.
	//
	// If you are copying data to or from your Snowcone device, see NFS Server on
	// Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// This name must either be DNS-compliant or must be an IP version 4 (IPv4)
	// address.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// The subdirectory in the NFS file system that is used to read data from the
	// NFS source location or write data to the NFS destination. The NFS path should
	// be a path that's exported by the NFS server, or a subdirectory of that path.
	// The path should be such that it can be mounted by other NFS clients in your
	// network.
	//
	// To see all the paths exported by your NFS server, run "showmount -e nfs-server-name"
	// from an NFS client that has access to your server. You can specify any directory
	// that appears in the results, and any subdirectory of that directory. Ensure
	// that the NFS export is accessible without Kerberos authentication.
	//
	// To transfer all the data in the folder you specified, DataSync needs to have
	// permissions to read all the data. To ensure this, either configure the NFS
	// export with no_root_squash, or ensure that the permissions for all of the
	// files that you want DataSync allow read access for all users. Doing either
	// enables the agent to read the files. For the agent to access directories,
	// you must additionally enable all execute access.
	//
	// If you are copying data to or from your Snowcone device, see NFS Server on
	// Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// For information about NFS export configuration, see 18.7. The /etc/exports
	// Configuration File in the Red Hat Enterprise Linux documentation.
	//
	// Subdirectory is a required field
	Subdirectory *string `type:"string" required:"true"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationNfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationNfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationNfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationNfsInput"}
	if s.OnPremConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OnPremConfig"))
	}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.Subdirectory == nil {
		invalidParams.Add(request.NewErrParamRequired("Subdirectory"))
	}
	if s.OnPremConfig != nil {
		if err := s.OnPremConfig.Validate(); err != nil {
			invalidParams.AddNested("OnPremConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMountOptions sets the MountOptions field's value.
func (s *CreateLocationNfsInput) SetMountOptions(v *NfsMountOptions) *CreateLocationNfsInput {
	s.MountOptions = v
	return s
}

// SetOnPremConfig sets the OnPremConfig field's value.
func (s *CreateLocationNfsInput) SetOnPremConfig(v *OnPremConfig) *CreateLocationNfsInput {
	s.OnPremConfig = v
	return s
}

// SetServerHostname sets the ServerHostname field's value.
func (s *CreateLocationNfsInput) SetServerHostname(v string) *CreateLocationNfsInput {
	s.ServerHostname = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationNfsInput) SetSubdirectory(v string) *CreateLocationNfsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationNfsInput) SetTags(v []*TagListEntry) *CreateLocationNfsInput {
	s.Tags = v
	return s
}

// CreateLocationNfsResponse
type CreateLocationNfsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source NFS file system location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationNfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationNfsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationNfsOutput) SetLocationArn(v string) *CreateLocationNfsOutput {
	s.LocationArn = &v
	return s
}

// CreateLocationObjectStorageRequest
type CreateLocationObjectStorageInput struct {
	_ struct{} `type:"structure"`

	// Specifies the access key (for example, a user name) if credentials are required
	// to authenticate with the object storage server.
	AccessKey *string `min:"1" type:"string"`

	// Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can
	// securely connect with your location.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`

	// Specifies the name of the object storage bucket involved in the transfer.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Specifies the secret key (for example, a password) if credentials are required
	// to authenticate with the object storage server.
	//
	// SecretKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLocationObjectStorageInput's
	// String and GoString methods.
	SecretKey *string `min:"1" type:"string" sensitive:"true"`

	// Specifies a certificate to authenticate with an object storage system that
	// uses a private or self-signed certificate authority (CA). You must specify
	// a Base64-encoded .pem file (for example, file:///home/user/.ssh/storage_sys_certificate.pem).
	// The certificate can be up to 32768 bytes (before Base64 encoding).
	//
	// To use this parameter, configure ServerProtocol to HTTPS.
	// ServerCertificate is automatically base64 encoded/decoded by the SDK.
	ServerCertificate []byte `type:"blob"`

	// Specifies the domain name or IP address of the object storage server. A DataSync
	// agent uses this hostname to mount the object storage server in a network.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// Specifies the port that your object storage server accepts inbound network
	// traffic on (for example, port 443).
	ServerPort *int64 `min:"1" type:"integer"`

	// Specifies the protocol that your object storage server uses to communicate.
	ServerProtocol *string `type:"string" enum:"ObjectStorageServerProtocol"`

	// Specifies the object prefix for your object storage server. If this is a
	// source location, DataSync only copies objects with this prefix. If this is
	// a destination location, DataSync writes all objects with this prefix.
	Subdirectory *string `type:"string"`

	// Specifies the key-value pair that represents a tag that you want to add to
	// the resource. Tags can help you manage, filter, and search for your resources.
	// We recommend creating a name tag for your location.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationObjectStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationObjectStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationObjectStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationObjectStorageInput"}
	if s.AccessKey != nil && len(*s.AccessKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKey", 1))
	}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.SecretKey != nil && len(*s.SecretKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretKey", 1))
	}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.ServerPort != nil && *s.ServerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ServerPort", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *CreateLocationObjectStorageInput) SetAccessKey(v string) *CreateLocationObjectStorageInput {
	s.AccessKey = &v
	return s
}

// SetAgentArns sets the AgentArns field's value.
func (s *CreateLocationObjectStorageInput) SetAgentArns(v []*string) *CreateLocationObjectStorageInput {
	s.AgentArns = v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *CreateLocationObjectStorageInput) SetBucketName(v string) *CreateLocationObjectStorageInput {
	s.BucketName = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *CreateLocationObjectStorageInput) SetSecretKey(v string) *CreateLocationObjectStorageInput {
	s.SecretKey = &v
	return s
}

// SetServerCertificate sets the ServerCertificate field's value.
func (s *CreateLocationObjectStorageInput) SetServerCertificate(v []byte) *CreateLocationObjectStorageInput {
	s.ServerCertificate = v
	return s
}

// SetServerHostname sets the ServerHostname field's value.
func (s *CreateLocationObjectStorageInput) SetServerHostname(v string) *CreateLocationObjectStorageInput {
	s.ServerHostname = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *CreateLocationObjectStorageInput) SetServerPort(v int64) *CreateLocationObjectStorageInput {
	s.ServerPort = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *CreateLocationObjectStorageInput) SetServerProtocol(v string) *CreateLocationObjectStorageInput {
	s.ServerProtocol = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationObjectStorageInput) SetSubdirectory(v string) *CreateLocationObjectStorageInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationObjectStorageInput) SetTags(v []*TagListEntry) *CreateLocationObjectStorageInput {
	s.Tags = v
	return s
}

// CreateLocationObjectStorageResponse
type CreateLocationObjectStorageOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the object storage system location that you create.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationObjectStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationObjectStorageOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationObjectStorageOutput) SetLocationArn(v string) *CreateLocationObjectStorageOutput {
	s.LocationArn = &v
	return s
}

// CreateLocationS3Request
type CreateLocationS3Input struct {
	_ struct{} `type:"structure"`

	// If you're using DataSync on an Amazon Web Services Outpost, specify the Amazon
	// Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For
	// more information about launching a DataSync agent on an Amazon Web Services
	// Outpost, see Deploy your DataSync agent on Outposts (https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
	AgentArns []*string `min:"1" type:"list"`

	// The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services
	// Outpost, this must be an access point ARN.
	//
	// S3BucketArn is a required field
	S3BucketArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role used to access an Amazon S3 bucket.
	//
	// For detailed information about using such a role, see Creating a Location
	// for Amazon S3 in the DataSync User Guide.
	//
	// S3Config is a required field
	S3Config *S3Config `type:"structure" required:"true"`

	// The Amazon S3 storage class that you want to store your files in when this
	// location is used as a task destination. For buckets in Amazon Web Services
	// Regions, the storage class defaults to Standard. For buckets on Outposts,
	// the storage class defaults to Amazon Web Services S3 Outposts.
	//
	// For more information about S3 storage classes, see Amazon S3 Storage Classes
	// (http://aws.amazon.com/s3/storage-classes/). Some storage classes have behaviors
	// that can affect your S3 storage cost. For detailed information, see Considerations
	// when working with S3 storage classes in DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	S3StorageClass *string `type:"string" enum:"S3StorageClass"`

	// A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is
	// used to read data from the S3 source location or write data to the S3 destination.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationS3Input"}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.S3BucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketArn"))
	}
	if s.S3Config == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Config"))
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *CreateLocationS3Input) SetAgentArns(v []*string) *CreateLocationS3Input {
	s.AgentArns = v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *CreateLocationS3Input) SetS3BucketArn(v string) *CreateLocationS3Input {
	s.S3BucketArn = &v
	return s
}

// SetS3Config sets the S3Config field's value.
func (s *CreateLocationS3Input) SetS3Config(v *S3Config) *CreateLocationS3Input {
	s.S3Config = v
	return s
}

// SetS3StorageClass sets the S3StorageClass field's value.
func (s *CreateLocationS3Input) SetS3StorageClass(v string) *CreateLocationS3Input {
	s.S3StorageClass = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationS3Input) SetSubdirectory(v string) *CreateLocationS3Input {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationS3Input) SetTags(v []*TagListEntry) *CreateLocationS3Input {
	s.Tags = v
	return s
}

// CreateLocationS3Response
type CreateLocationS3Output struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationS3Output) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationS3Output) SetLocationArn(v string) *CreateLocationS3Output {
	s.LocationArn = &v
	return s
}

// CreateLocationSmbRequest
type CreateLocationSmbInput struct {
	_ struct{} `type:"structure"`

	// Specifies the DataSync agent (or agents) which you want to connect to your
	// SMB file server. You specify an agent by using its Amazon Resource Name (ARN).
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`

	// Specifies the Windows domain name that your SMB file server belongs to.
	//
	// For more information, see required permissions (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions)
	// for SMB locations.
	Domain *string `type:"string"`

	// Specifies the version of the SMB protocol that DataSync uses to access your
	// SMB file server.
	MountOptions *SmbMountOptions `type:"structure"`

	// Specifies the password of the user who can mount your SMB file server and
	// has permission to access the files and folders involved in your transfer.
	//
	// For more information, see required permissions (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions)
	// for SMB locations.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLocationSmbInput's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// Specifies the Domain Name Service (DNS) name or IP address of the SMB file
	// server that your DataSync agent will mount.
	//
	// You can't specify an IP version 6 (IPv6) address.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// Specifies the name of the share exported by your SMB file server where DataSync
	// will read or write data. You can include a subdirectory in the share path
	// (for example, /path/to/subdirectory). Make sure that other SMB clients in
	// your network can also mount this path.
	//
	// To copy all data in the specified subdirectory, DataSync must be able to
	// mount the SMB share and access all of its data. For more information, see
	// required permissions (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions)
	// for SMB locations.
	//
	// Subdirectory is a required field
	Subdirectory *string `type:"string" required:"true"`

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`

	// Specifies the user name that can mount your SMB file server and has permission
	// to access the files and folders involved in your transfer.
	//
	// For information about choosing a user with the right level of access for
	// your transfer, see required permissions (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions)
	// for SMB locations.
	//
	// User is a required field
	User *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationSmbInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationSmbInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationSmbInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationSmbInput"}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.Subdirectory == nil {
		invalidParams.Add(request.NewErrParamRequired("Subdirectory"))
	}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *CreateLocationSmbInput) SetAgentArns(v []*string) *CreateLocationSmbInput {
	s.AgentArns = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateLocationSmbInput) SetDomain(v string) *CreateLocationSmbInput {
	s.Domain = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *CreateLocationSmbInput) SetMountOptions(v *SmbMountOptions) *CreateLocationSmbInput {
	s.MountOptions = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateLocationSmbInput) SetPassword(v string) *CreateLocationSmbInput {
	s.Password = &v
	return s
}

// SetServerHostname sets the ServerHostname field's value.
func (s *CreateLocationSmbInput) SetServerHostname(v string) *CreateLocationSmbInput {
	s.ServerHostname = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationSmbInput) SetSubdirectory(v string) *CreateLocationSmbInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationSmbInput) SetTags(v []*TagListEntry) *CreateLocationSmbInput {
	s.Tags = v
	return s
}

// SetUser sets the User field's value.
func (s *CreateLocationSmbInput) SetUser(v string) *CreateLocationSmbInput {
	s.User = &v
	return s
}

// CreateLocationSmbResponse
type CreateLocationSmbOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SMB location that you created.
	LocationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationSmbOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationSmbOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationSmbOutput) SetLocationArn(v string) *CreateLocationSmbOutput {
	s.LocationArn = &v
	return s
}

// CreateTaskRequest
type CreateTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is
	// used to monitor and log events in the task.
	CloudWatchLogGroupArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's
	// location.
	//
	// DestinationLocationArn is a required field
	DestinationLocationArn *string `type:"string" required:"true"`

	// Specifies a list of filter rules that exclude specific data during your transfer.
	// For more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Excludes []*FilterRule `type:"list"`

	// Specifies a list of filter rules that include specific data during your transfer.
	// For more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Includes []*FilterRule `type:"list"`

	// The name of a task. This value is a text reference that is used to identify
	// the task in the console.
	Name *string `min:"1" type:"string"`

	// Specifies the configuration options for a task. Some options include preserving
	// file or object metadata and verifying data integrity.
	//
	// You can also override these options before starting an individual run of
	// a task (also known as a task execution). For more information, see StartTaskExecution
	// (https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
	Options *Options `type:"structure"`

	// Specifies a schedule used to periodically transfer files from a source to
	// a destination location. The schedule should be specified in UTC time. For
	// more information, see Scheduling your task (https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
	Schedule *TaskSchedule `type:"structure"`

	// The Amazon Resource Name (ARN) of the source location for the task.
	//
	// SourceLocationArn is a required field
	SourceLocationArn *string `type:"string" required:"true"`

	// Specifies the tags that you want to apply to the Amazon Resource Name (ARN)
	// representing the task.
	//
	// Tags are key-value pairs that help you manage, filter, and search for your
	// DataSync resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskInput"}
	if s.DestinationLocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationLocationArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceLocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationArn"))
	}
	if s.Options != nil {
		if err := s.Options.Validate(); err != nil {
			invalidParams.AddNested("Options", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *CreateTaskInput) SetCloudWatchLogGroupArn(v string) *CreateTaskInput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetDestinationLocationArn sets the DestinationLocationArn field's value.
func (s *CreateTaskInput) SetDestinationLocationArn(v string) *CreateTaskInput {
	s.DestinationLocationArn = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *CreateTaskInput) SetExcludes(v []*FilterRule) *CreateTaskInput {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *CreateTaskInput) SetIncludes(v []*FilterRule) *CreateTaskInput {
	s.Includes = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTaskInput) SetName(v string) *CreateTaskInput {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CreateTaskInput) SetOptions(v *Options) *CreateTaskInput {
	s.Options = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateTaskInput) SetSchedule(v *TaskSchedule) *CreateTaskInput {
	s.Schedule = v
	return s
}

// SetSourceLocationArn sets the SourceLocationArn field's value.
func (s *CreateTaskInput) SetSourceLocationArn(v string) *CreateTaskInput {
	s.SourceLocationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTaskInput) SetTags(v []*TagListEntry) *CreateTaskInput {
	s.Tags = v
	return s
}

// CreateTaskResponse
type CreateTaskOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskOutput) GoString() string {
	return s.String()
}

// SetTaskArn sets the TaskArn field's value.
func (s *CreateTaskOutput) SetTaskArn(v string) *CreateTaskOutput {
	s.TaskArn = &v
	return s
}

// The credentials that provide DataSync Discovery read access to your on-premises
// storage system's management interface.
//
// DataSync Discovery stores these credentials in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
// For more information, see Accessing your on-premises storage system (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html).
type Credentials struct {
	_ struct{} `type:"structure"`

	// Specifies the password for your storage system's management interface.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credentials's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// Specifies the user name for your storage system's management interface.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credentials's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Credentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Credentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *Credentials) SetPassword(v string) *Credentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Credentials) SetUsername(v string) *Credentials {
	s.Username = &v
	return s
}

// DeleteAgentRequest
type DeleteAgentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent to delete. Use the ListAgents
	// operation to return a list of agents for your account and Amazon Web Services
	// Region.
	//
	// AgentArn is a required field
	AgentArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentInput"}
	if s.AgentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArn sets the AgentArn field's value.
func (s *DeleteAgentInput) SetAgentArn(v string) *DeleteAgentInput {
	s.AgentArn = &v
	return s
}

type DeleteAgentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentOutput) GoString() string {
	return s.String()
}

// DeleteLocation
type DeleteLocationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the location to delete.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLocationInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DeleteLocationInput) SetLocationArn(v string) *DeleteLocationInput {
	s.LocationArn = &v
	return s
}

type DeleteLocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationOutput) GoString() string {
	return s.String()
}

// DeleteTask
type DeleteTaskInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the task that you want to delete.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTaskInput"}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskArn sets the TaskArn field's value.
func (s *DeleteTaskInput) SetTaskArn(v string) *DeleteTaskInput {
	s.TaskArn = &v
	return s
}

type DeleteTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskOutput) GoString() string {
	return s.String()
}

// DescribeAgent
type DescribeAgentInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the DataSync agent to describe.
	//
	// AgentArn is a required field
	AgentArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAgentInput"}
	if s.AgentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArn sets the AgentArn field's value.
func (s *DescribeAgentInput) SetAgentArn(v string) *DescribeAgentInput {
	s.AgentArn = &v
	return s
}

// DescribeAgentResponse
type DescribeAgentOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the agent.
	AgentArn *string `type:"string"`

	// The time that the agent was activated (that is, created in your account).
	CreationTime *time.Time `type:"timestamp"`

	// The type of endpoint that your agent is connected to. If the endpoint is
	// a VPC endpoint, the agent is not accessible over the public internet.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// The time that the agent last connected to DataSync.
	LastConnectionTime *time.Time `type:"timestamp"`

	// The name of the agent.
	Name *string `min:"1" type:"string"`

	// The subnet and the security group that DataSync used to access a VPC endpoint.
	PrivateLinkConfig *PrivateLinkConfig `type:"structure"`

	// The status of the agent. If the status is ONLINE, then the agent is configured
	// properly and is available to use. The Running status is the normal running
	// status for an agent. If the status is OFFLINE, the agent's VM is turned off
	// or the agent is in an unhealthy state. When the issue that caused the unhealthy
	// state is resolved, the agent returns to ONLINE status.
	Status *string `type:"string" enum:"AgentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgentOutput) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *DescribeAgentOutput) SetAgentArn(v string) *DescribeAgentOutput {
	s.AgentArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeAgentOutput) SetCreationTime(v time.Time) *DescribeAgentOutput {
	s.CreationTime = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribeAgentOutput) SetEndpointType(v string) *DescribeAgentOutput {
	s.EndpointType = &v
	return s
}

// SetLastConnectionTime sets the LastConnectionTime field's value.
func (s *DescribeAgentOutput) SetLastConnectionTime(v time.Time) *DescribeAgentOutput {
	s.LastConnectionTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeAgentOutput) SetName(v string) *DescribeAgentOutput {
	s.Name = &v
	return s
}

// SetPrivateLinkConfig sets the PrivateLinkConfig field's value.
func (s *DescribeAgentOutput) SetPrivateLinkConfig(v *PrivateLinkConfig) *DescribeAgentOutput {
	s.PrivateLinkConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAgentOutput) SetStatus(v string) *DescribeAgentOutput {
	s.Status = &v
	return s
}

type DescribeDiscoveryJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the discovery job that you want
	// information about.
	//
	// DiscoveryJobArn is a required field
	DiscoveryJobArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscoveryJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscoveryJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDiscoveryJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDiscoveryJobInput"}
	if s.DiscoveryJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *DescribeDiscoveryJobInput) SetDiscoveryJobArn(v string) *DescribeDiscoveryJobInput {
	s.DiscoveryJobArn = &v
	return s
}

type DescribeDiscoveryJobOutput struct {
	_ struct{} `type:"structure"`

	// The number of minutes that the discovery job runs.
	CollectionDurationMinutes *int64 `min:"60" type:"integer"`

	// The ARN of the discovery job.
	DiscoveryJobArn *string `type:"string"`

	// The time when the discovery job ended.
	JobEndTime *time.Time `type:"timestamp"`

	// The time when the discovery job started.
	JobStartTime *time.Time `type:"timestamp"`

	// Indicates the status of a discovery job. For more information, see Discovery
	// job statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table).
	Status *string `type:"string" enum:"DiscoveryJobStatus"`

	// The ARN of the on-premises storage system you're running the discovery job
	// on.
	StorageSystemArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscoveryJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscoveryJobOutput) GoString() string {
	return s.String()
}

// SetCollectionDurationMinutes sets the CollectionDurationMinutes field's value.
func (s *DescribeDiscoveryJobOutput) SetCollectionDurationMinutes(v int64) *DescribeDiscoveryJobOutput {
	s.CollectionDurationMinutes = &v
	return s
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *DescribeDiscoveryJobOutput) SetDiscoveryJobArn(v string) *DescribeDiscoveryJobOutput {
	s.DiscoveryJobArn = &v
	return s
}

// SetJobEndTime sets the JobEndTime field's value.
func (s *DescribeDiscoveryJobOutput) SetJobEndTime(v time.Time) *DescribeDiscoveryJobOutput {
	s.JobEndTime = &v
	return s
}

// SetJobStartTime sets the JobStartTime field's value.
func (s *DescribeDiscoveryJobOutput) SetJobStartTime(v time.Time) *DescribeDiscoveryJobOutput {
	s.JobStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDiscoveryJobOutput) SetStatus(v string) *DescribeDiscoveryJobOutput {
	s.Status = &v
	return s
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *DescribeDiscoveryJobOutput) SetStorageSystemArn(v string) *DescribeDiscoveryJobOutput {
	s.StorageSystemArn = &v
	return s
}

// DescribeLocationEfsRequest
type DescribeLocationEfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon EFS file system location that
	// you want information about.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationEfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationEfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationEfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationEfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationEfsInput) SetLocationArn(v string) *DescribeLocationEfsInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationEfsResponse
type DescribeLocationEfsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point that DataSync uses to access the Amazon EFS file
	// system.
	AccessPointArn *string `type:"string"`

	// The time that the location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The subnet and security groups that DataSync uses to access your Amazon EFS
	// file system.
	Ec2Config *Ec2Config `type:"structure"`

	// The Identity and Access Management (IAM) role that DataSync assumes when
	// mounting the Amazon EFS file system.
	FileSystemAccessRoleArn *string `type:"string"`

	// Describes whether DataSync uses Transport Layer Security (TLS) encryption
	// when copying data to or from the Amazon EFS file system.
	InTransitEncryption *string `type:"string" enum:"EfsInTransitEncryption"`

	// The ARN of the Amazon EFS file system location.
	LocationArn *string `type:"string"`

	// The URL of the Amazon EFS file system location.
	LocationUri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationEfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationEfsOutput) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *DescribeLocationEfsOutput) SetAccessPointArn(v string) *DescribeLocationEfsOutput {
	s.AccessPointArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationEfsOutput) SetCreationTime(v time.Time) *DescribeLocationEfsOutput {
	s.CreationTime = &v
	return s
}

// SetEc2Config sets the Ec2Config field's value.
func (s *DescribeLocationEfsOutput) SetEc2Config(v *Ec2Config) *DescribeLocationEfsOutput {
	s.Ec2Config = v
	return s
}

// SetFileSystemAccessRoleArn sets the FileSystemAccessRoleArn field's value.
func (s *DescribeLocationEfsOutput) SetFileSystemAccessRoleArn(v string) *DescribeLocationEfsOutput {
	s.FileSystemAccessRoleArn = &v
	return s
}

// SetInTransitEncryption sets the InTransitEncryption field's value.
func (s *DescribeLocationEfsOutput) SetInTransitEncryption(v string) *DescribeLocationEfsOutput {
	s.InTransitEncryption = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationEfsOutput) SetLocationArn(v string) *DescribeLocationEfsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationEfsOutput) SetLocationUri(v string) *DescribeLocationEfsOutput {
	s.LocationUri = &v
	return s
}

type DescribeLocationFsxLustreInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for Lustre location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxLustreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxLustreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationFsxLustreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationFsxLustreInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxLustreInput) SetLocationArn(v string) *DescribeLocationFsxLustreInput {
	s.LocationArn = &v
	return s
}

type DescribeLocationFsxLustreOutput struct {
	_ struct{} `type:"structure"`

	// The time that the FSx for Lustre location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.
	LocationArn *string `type:"string"`

	// The URI of the FSx for Lustre location that was described.
	LocationUri *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the security groups that are configured
	// for the FSx for Lustre file system.
	SecurityGroupArns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxLustreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxLustreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationFsxLustreOutput) SetCreationTime(v time.Time) *DescribeLocationFsxLustreOutput {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxLustreOutput) SetLocationArn(v string) *DescribeLocationFsxLustreOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationFsxLustreOutput) SetLocationUri(v string) *DescribeLocationFsxLustreOutput {
	s.LocationUri = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *DescribeLocationFsxLustreOutput) SetSecurityGroupArns(v []*string) *DescribeLocationFsxLustreOutput {
	s.SecurityGroupArns = v
	return s
}

type DescribeLocationFsxOntapInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP file system
	// location that you want information about.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOntapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOntapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationFsxOntapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationFsxOntapInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxOntapInput) SetLocationArn(v string) *DescribeLocationFsxOntapInput {
	s.LocationArn = &v
	return s
}

type DescribeLocationFsxOntapOutput struct {
	_ struct{} `type:"structure"`

	// The time that the location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The ARN of the FSx for ONTAP file system.
	FsxFilesystemArn *string `type:"string"`

	// The ARN of the FSx for ONTAP file system location.
	LocationArn *string `type:"string"`

	// The uniform resource identifier (URI) of the FSx for ONTAP file system location.
	LocationUri *string `type:"string"`

	// Specifies the data transfer protocol that DataSync uses to access your Amazon
	// FSx file system.
	Protocol *FsxProtocol `type:"structure"`

	// The security groups that DataSync uses to access your FSx for ONTAP file
	// system.
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system
	// where you're copying data to or from.
	StorageVirtualMachineArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOntapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOntapOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationFsxOntapOutput) SetCreationTime(v time.Time) *DescribeLocationFsxOntapOutput {
	s.CreationTime = &v
	return s
}

// SetFsxFilesystemArn sets the FsxFilesystemArn field's value.
func (s *DescribeLocationFsxOntapOutput) SetFsxFilesystemArn(v string) *DescribeLocationFsxOntapOutput {
	s.FsxFilesystemArn = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxOntapOutput) SetLocationArn(v string) *DescribeLocationFsxOntapOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationFsxOntapOutput) SetLocationUri(v string) *DescribeLocationFsxOntapOutput {
	s.LocationUri = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *DescribeLocationFsxOntapOutput) SetProtocol(v *FsxProtocol) *DescribeLocationFsxOntapOutput {
	s.Protocol = v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *DescribeLocationFsxOntapOutput) SetSecurityGroupArns(v []*string) *DescribeLocationFsxOntapOutput {
	s.SecurityGroupArns = v
	return s
}

// SetStorageVirtualMachineArn sets the StorageVirtualMachineArn field's value.
func (s *DescribeLocationFsxOntapOutput) SetStorageVirtualMachineArn(v string) *DescribeLocationFsxOntapOutput {
	s.StorageVirtualMachineArn = &v
	return s
}

type DescribeLocationFsxOpenZfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for OpenZFS location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOpenZfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOpenZfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationFsxOpenZfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationFsxOpenZfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxOpenZfsInput) SetLocationArn(v string) *DescribeLocationFsxOpenZfsInput {
	s.LocationArn = &v
	return s
}

type DescribeLocationFsxOpenZfsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the FSx for OpenZFS location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The ARN of the FSx for OpenZFS location that was described.
	LocationArn *string `type:"string"`

	// The uniform resource identifier (URI) of the FSx for OpenZFS location that
	// was described.
	//
	// Example: fsxz://us-west-2.fs-1234567890abcdef02/fsx/folderA/folder
	LocationUri *string `type:"string"`

	// The type of protocol that DataSync uses to access your file system.
	Protocol *FsxProtocol `type:"structure"`

	// The ARNs of the security groups that are configured for the FSx for OpenZFS
	// file system.
	SecurityGroupArns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOpenZfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxOpenZfsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationFsxOpenZfsOutput) SetCreationTime(v time.Time) *DescribeLocationFsxOpenZfsOutput {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxOpenZfsOutput) SetLocationArn(v string) *DescribeLocationFsxOpenZfsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationFsxOpenZfsOutput) SetLocationUri(v string) *DescribeLocationFsxOpenZfsOutput {
	s.LocationUri = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *DescribeLocationFsxOpenZfsOutput) SetProtocol(v *FsxProtocol) *DescribeLocationFsxOpenZfsOutput {
	s.Protocol = v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *DescribeLocationFsxOpenZfsOutput) SetSecurityGroupArns(v []*string) *DescribeLocationFsxOpenZfsOutput {
	s.SecurityGroupArns = v
	return s
}

type DescribeLocationFsxWindowsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for Windows File Server location
	// to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxWindowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxWindowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationFsxWindowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationFsxWindowsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxWindowsInput) SetLocationArn(v string) *DescribeLocationFsxWindowsInput {
	s.LocationArn = &v
	return s
}

type DescribeLocationFsxWindowsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the FSx for Windows File Server location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Windows domain that the FSx for Windows File Server belongs
	// to.
	Domain *string `type:"string"`

	// The Amazon Resource Name (ARN) of the FSx for Windows File Server location
	// that was described.
	LocationArn *string `type:"string"`

	// The URL of the FSx for Windows File Server location that was described.
	LocationUri *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the security groups that are configured
	// for the FSx for Windows File Server file system.
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The user who has the permissions to access files and folders in the FSx for
	// Windows File Server file system.
	User *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxWindowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationFsxWindowsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationFsxWindowsOutput) SetCreationTime(v time.Time) *DescribeLocationFsxWindowsOutput {
	s.CreationTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeLocationFsxWindowsOutput) SetDomain(v string) *DescribeLocationFsxWindowsOutput {
	s.Domain = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxWindowsOutput) SetLocationArn(v string) *DescribeLocationFsxWindowsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationFsxWindowsOutput) SetLocationUri(v string) *DescribeLocationFsxWindowsOutput {
	s.LocationUri = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *DescribeLocationFsxWindowsOutput) SetSecurityGroupArns(v []*string) *DescribeLocationFsxWindowsOutput {
	s.SecurityGroupArns = v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeLocationFsxWindowsOutput) SetUser(v string) *DescribeLocationFsxWindowsOutput {
	s.User = &v
	return s
}

type DescribeLocationHdfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the HDFS cluster location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationHdfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationHdfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationHdfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationHdfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationHdfsInput) SetLocationArn(v string) *DescribeLocationHdfsInput {
	s.LocationArn = &v
	return s
}

type DescribeLocationHdfsOutput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the agents that are used to connect to the HDFS cluster.
	AgentArns []*string `min:"1" type:"list"`

	// The type of authentication used to determine the identity of the user.
	AuthenticationType *string `type:"string" enum:"HdfsAuthenticationType"`

	// The size of the data blocks to write into the HDFS cluster.
	BlockSize *int64 `min:"1.048576e+06" type:"integer"`

	// The time that the HDFS location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Kerberos principal with access to the files and folders on the HDFS cluster.
	// This parameter is used if the AuthenticationType is defined as KERBEROS.
	KerberosPrincipal *string `min:"1" type:"string"`

	// The URI of the HDFS cluster's Key Management Server (KMS).
	KmsKeyProviderUri *string `min:"1" type:"string"`

	// The ARN of the HDFS cluster location.
	LocationArn *string `type:"string"`

	// The URI of the HDFS cluster location.
	LocationUri *string `type:"string"`

	// The NameNode that manage the HDFS namespace.
	NameNodes []*HdfsNameNode `min:"1" type:"list"`

	// The Quality of Protection (QOP) configuration specifies the Remote Procedure
	// Call (RPC) and data transfer protection settings configured on the Hadoop
	// Distributed File System (HDFS) cluster.
	QopConfiguration *QopConfiguration `type:"structure"`

	// The number of DataNodes to replicate the data to when writing to the HDFS
	// cluster.
	ReplicationFactor *int64 `min:"1" type:"integer"`

	// The user name used to identify the client on the host operating system. This
	// parameter is used if the AuthenticationType is defined as SIMPLE.
	SimpleUser *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationHdfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationHdfsOutput) GoString() string {
	return s.String()
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeLocationHdfsOutput) SetAgentArns(v []*string) *DescribeLocationHdfsOutput {
	s.AgentArns = v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DescribeLocationHdfsOutput) SetAuthenticationType(v string) *DescribeLocationHdfsOutput {
	s.AuthenticationType = &v
	return s
}

// SetBlockSize sets the BlockSize field's value.
func (s *DescribeLocationHdfsOutput) SetBlockSize(v int64) *DescribeLocationHdfsOutput {
	s.BlockSize = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationHdfsOutput) SetCreationTime(v time.Time) *DescribeLocationHdfsOutput {
	s.CreationTime = &v
	return s
}

// SetKerberosPrincipal sets the KerberosPrincipal field's value.
func (s *DescribeLocationHdfsOutput) SetKerberosPrincipal(v string) *DescribeLocationHdfsOutput {
	s.KerberosPrincipal = &v
	return s
}

// SetKmsKeyProviderUri sets the KmsKeyProviderUri field's value.
func (s *DescribeLocationHdfsOutput) SetKmsKeyProviderUri(v string) *DescribeLocationHdfsOutput {
	s.KmsKeyProviderUri = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationHdfsOutput) SetLocationArn(v string) *DescribeLocationHdfsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationHdfsOutput) SetLocationUri(v string) *DescribeLocationHdfsOutput {
	s.LocationUri = &v
	return s
}

// SetNameNodes sets the NameNodes field's value.
func (s *DescribeLocationHdfsOutput) SetNameNodes(v []*HdfsNameNode) *DescribeLocationHdfsOutput {
	s.NameNodes = v
	return s
}

// SetQopConfiguration sets the QopConfiguration field's value.
func (s *DescribeLocationHdfsOutput) SetQopConfiguration(v *QopConfiguration) *DescribeLocationHdfsOutput {
	s.QopConfiguration = v
	return s
}

// SetReplicationFactor sets the ReplicationFactor field's value.
func (s *DescribeLocationHdfsOutput) SetReplicationFactor(v int64) *DescribeLocationHdfsOutput {
	s.ReplicationFactor = &v
	return s
}

// SetSimpleUser sets the SimpleUser field's value.
func (s *DescribeLocationHdfsOutput) SetSimpleUser(v string) *DescribeLocationHdfsOutput {
	s.SimpleUser = &v
	return s
}

// DescribeLocationNfsRequest
type DescribeLocationNfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the NFS location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationNfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationNfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationNfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationNfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationNfsInput) SetLocationArn(v string) *DescribeLocationNfsInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationNfsResponse
type DescribeLocationNfsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the NFS location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the NFS location that was described.
	LocationArn *string `type:"string"`

	// The URL of the source NFS location that was described.
	LocationUri *string `type:"string"`

	// The NFS mount options that DataSync used to mount your NFS share.
	MountOptions *NfsMountOptions `type:"structure"`

	// A list of Amazon Resource Names (ARNs) of agents to use for a Network File
	// System (NFS) location.
	OnPremConfig *OnPremConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationNfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationNfsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationNfsOutput) SetCreationTime(v time.Time) *DescribeLocationNfsOutput {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationNfsOutput) SetLocationArn(v string) *DescribeLocationNfsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationNfsOutput) SetLocationUri(v string) *DescribeLocationNfsOutput {
	s.LocationUri = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *DescribeLocationNfsOutput) SetMountOptions(v *NfsMountOptions) *DescribeLocationNfsOutput {
	s.MountOptions = v
	return s
}

// SetOnPremConfig sets the OnPremConfig field's value.
func (s *DescribeLocationNfsOutput) SetOnPremConfig(v *OnPremConfig) *DescribeLocationNfsOutput {
	s.OnPremConfig = v
	return s
}

// DescribeLocationObjectStorageRequest
type DescribeLocationObjectStorageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the object storage system location that
	// you want information about.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationObjectStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationObjectStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationObjectStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationObjectStorageInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationObjectStorageInput) SetLocationArn(v string) *DescribeLocationObjectStorageInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationObjectStorageResponse
type DescribeLocationObjectStorageOutput struct {
	_ struct{} `type:"structure"`

	// The access key (for example, a user name) required to authenticate with the
	// object storage system.
	AccessKey *string `min:"1" type:"string"`

	// The ARNs of the DataSync agents that can securely connect with your location.
	AgentArns []*string `min:"1" type:"list"`

	// The time that the location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The ARN of the object storage system location.
	LocationArn *string `type:"string"`

	// The URL of the object storage system location.
	LocationUri *string `type:"string"`

	// The self-signed certificate that DataSync uses to securely authenticate with
	// your object storage system.
	// ServerCertificate is automatically base64 encoded/decoded by the SDK.
	ServerCertificate []byte `type:"blob"`

	// The port that your object storage server accepts inbound network traffic
	// on (for example, port 443).
	ServerPort *int64 `min:"1" type:"integer"`

	// The protocol that your object storage system uses to communicate.
	ServerProtocol *string `type:"string" enum:"ObjectStorageServerProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationObjectStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationObjectStorageOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *DescribeLocationObjectStorageOutput) SetAccessKey(v string) *DescribeLocationObjectStorageOutput {
	s.AccessKey = &v
	return s
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeLocationObjectStorageOutput) SetAgentArns(v []*string) *DescribeLocationObjectStorageOutput {
	s.AgentArns = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationObjectStorageOutput) SetCreationTime(v time.Time) *DescribeLocationObjectStorageOutput {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationObjectStorageOutput) SetLocationArn(v string) *DescribeLocationObjectStorageOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationObjectStorageOutput) SetLocationUri(v string) *DescribeLocationObjectStorageOutput {
	s.LocationUri = &v
	return s
}

// SetServerCertificate sets the ServerCertificate field's value.
func (s *DescribeLocationObjectStorageOutput) SetServerCertificate(v []byte) *DescribeLocationObjectStorageOutput {
	s.ServerCertificate = v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *DescribeLocationObjectStorageOutput) SetServerPort(v int64) *DescribeLocationObjectStorageOutput {
	s.ServerPort = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *DescribeLocationObjectStorageOutput) SetServerProtocol(v string) *DescribeLocationObjectStorageOutput {
	s.ServerProtocol = &v
	return s
}

// DescribeLocationS3Request
type DescribeLocationS3Input struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationS3Input"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationS3Input) SetLocationArn(v string) *DescribeLocationS3Input {
	s.LocationArn = &v
	return s
}

// DescribeLocationS3Response
type DescribeLocationS3Output struct {
	_ struct{} `type:"structure"`

	// If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource
	// Name (ARNs) of the EC2 agents deployed on your Outpost. For more information
	// about launching a DataSync agent on an Amazon Web Services Outpost, see Deploy
	// your DataSync agent on Outposts (https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
	AgentArns []*string `min:"1" type:"list"`

	// The time that the Amazon S3 bucket location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
	LocationArn *string `type:"string"`

	// The URL of the Amazon S3 location that was described.
	LocationUri *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role used to access an Amazon S3 bucket.
	//
	// For detailed information about using such a role, see Creating a Location
	// for Amazon S3 in the DataSync User Guide.
	S3Config *S3Config `type:"structure"`

	// The Amazon S3 storage class that you chose to store your files in when this
	// location is used as a task destination. For more information about S3 storage
	// classes, see Amazon S3 Storage Classes (http://aws.amazon.com/s3/storage-classes/).
	// Some storage classes have behaviors that can affect your S3 storage cost.
	// For detailed information, see Considerations when working with S3 storage
	// classes in DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	S3StorageClass *string `type:"string" enum:"S3StorageClass"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationS3Output) GoString() string {
	return s.String()
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeLocationS3Output) SetAgentArns(v []*string) *DescribeLocationS3Output {
	s.AgentArns = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationS3Output) SetCreationTime(v time.Time) *DescribeLocationS3Output {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationS3Output) SetLocationArn(v string) *DescribeLocationS3Output {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationS3Output) SetLocationUri(v string) *DescribeLocationS3Output {
	s.LocationUri = &v
	return s
}

// SetS3Config sets the S3Config field's value.
func (s *DescribeLocationS3Output) SetS3Config(v *S3Config) *DescribeLocationS3Output {
	s.S3Config = v
	return s
}

// SetS3StorageClass sets the S3StorageClass field's value.
func (s *DescribeLocationS3Output) SetS3StorageClass(v string) *DescribeLocationS3Output {
	s.S3StorageClass = &v
	return s
}

// DescribeLocationSmbRequest
type DescribeLocationSmbInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SMB location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationSmbInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationSmbInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationSmbInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationSmbInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationSmbInput) SetLocationArn(v string) *DescribeLocationSmbInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationSmbResponse
type DescribeLocationSmbOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source SMB file system location that
	// is created.
	AgentArns []*string `min:"1" type:"list"`

	// The time that the SMB location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Windows domain that the SMB server belongs to.
	Domain *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SMB location that was described.
	LocationArn *string `type:"string"`

	// The URL of the source SMB location that was described.
	LocationUri *string `type:"string"`

	// The mount options that are available for DataSync to use to access an SMB
	// location.
	MountOptions *SmbMountOptions `type:"structure"`

	// The user who can mount the share, has the permissions to access files and
	// folders in the SMB share.
	User *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationSmbOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLocationSmbOutput) GoString() string {
	return s.String()
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeLocationSmbOutput) SetAgentArns(v []*string) *DescribeLocationSmbOutput {
	s.AgentArns = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationSmbOutput) SetCreationTime(v time.Time) *DescribeLocationSmbOutput {
	s.CreationTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeLocationSmbOutput) SetDomain(v string) *DescribeLocationSmbOutput {
	s.Domain = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationSmbOutput) SetLocationArn(v string) *DescribeLocationSmbOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationSmbOutput) SetLocationUri(v string) *DescribeLocationSmbOutput {
	s.LocationUri = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *DescribeLocationSmbOutput) SetMountOptions(v *SmbMountOptions) *DescribeLocationSmbOutput {
	s.MountOptions = v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeLocationSmbOutput) SetUser(v string) *DescribeLocationSmbOutput {
	s.User = &v
	return s
}

type DescribeStorageSystemInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of an on-premises storage system
	// that you're using with DataSync Discovery.
	//
	// StorageSystemArn is a required field
	StorageSystemArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStorageSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStorageSystemInput"}
	if s.StorageSystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageSystemArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *DescribeStorageSystemInput) SetStorageSystemArn(v string) *DescribeStorageSystemInput {
	s.StorageSystemArn = &v
	return s
}

type DescribeStorageSystemOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the DataSync agent that connects to and reads from your on-premises
	// storage system.
	AgentArns []*string `min:"1" type:"list"`

	// The ARN of the Amazon CloudWatch log group that's used to monitor and log
	// discovery job events.
	CloudWatchLogGroupArn *string `type:"string"`

	// Indicates whether your DataSync agent can connect to your on-premises storage
	// system.
	ConnectivityStatus *string `type:"string" enum:"StorageSystemConnectivityStatus"`

	// The time when you added the on-premises storage system to DataSync Discovery.
	CreationTime *time.Time `type:"timestamp"`

	// Describes the connectivity error that the DataSync agent is encountering
	// with your on-premises storage system.
	ErrorMessage *string `type:"string"`

	// The name that you gave your on-premises storage system when adding it to
	// DataSync Discovery.
	Name *string `min:"1" type:"string"`

	// The ARN of the secret that stores your on-premises storage system's credentials.
	// DataSync Discovery stores these credentials in Secrets Manager (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html#discovery-add-storage).
	SecretsManagerArn *string `type:"string"`

	// The server name and network port required to connect with your on-premises
	// storage system's management interface.
	ServerConfiguration *DiscoveryServerConfiguration `type:"structure"`

	// The ARN of the on-premises storage system that the discovery job looked at.
	StorageSystemArn *string `type:"string"`

	// The type of on-premises storage system.
	//
	// DataSync Discovery currently only supports NetApp Fabric-Attached Storage
	// (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later.
	SystemType *string `type:"string" enum:"DiscoverySystemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemOutput) GoString() string {
	return s.String()
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeStorageSystemOutput) SetAgentArns(v []*string) *DescribeStorageSystemOutput {
	s.AgentArns = v
	return s
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *DescribeStorageSystemOutput) SetCloudWatchLogGroupArn(v string) *DescribeStorageSystemOutput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetConnectivityStatus sets the ConnectivityStatus field's value.
func (s *DescribeStorageSystemOutput) SetConnectivityStatus(v string) *DescribeStorageSystemOutput {
	s.ConnectivityStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeStorageSystemOutput) SetCreationTime(v time.Time) *DescribeStorageSystemOutput {
	s.CreationTime = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeStorageSystemOutput) SetErrorMessage(v string) *DescribeStorageSystemOutput {
	s.ErrorMessage = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeStorageSystemOutput) SetName(v string) *DescribeStorageSystemOutput {
	s.Name = &v
	return s
}

// SetSecretsManagerArn sets the SecretsManagerArn field's value.
func (s *DescribeStorageSystemOutput) SetSecretsManagerArn(v string) *DescribeStorageSystemOutput {
	s.SecretsManagerArn = &v
	return s
}

// SetServerConfiguration sets the ServerConfiguration field's value.
func (s *DescribeStorageSystemOutput) SetServerConfiguration(v *DiscoveryServerConfiguration) *DescribeStorageSystemOutput {
	s.ServerConfiguration = v
	return s
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *DescribeStorageSystemOutput) SetStorageSystemArn(v string) *DescribeStorageSystemOutput {
	s.StorageSystemArn = &v
	return s
}

// SetSystemType sets the SystemType field's value.
func (s *DescribeStorageSystemOutput) SetSystemType(v string) *DescribeStorageSystemOutput {
	s.SystemType = &v
	return s
}

type DescribeStorageSystemResourceMetricsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the discovery job that collects
	// information about your on-premises storage system.
	//
	// DiscoveryJobArn is a required field
	DiscoveryJobArn *string `type:"string" required:"true"`

	// Specifies a time within the total duration that the discovery job ran. To
	// see information gathered during a certain time frame, use this parameter
	// with StartTime.
	EndTime *time.Time `type:"timestamp"`

	// Specifies how many results that you want in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies an opaque string that indicates the position to begin the next
	// list of results in the response.
	NextToken *string `type:"string"`

	// Specifies the universally unique identifier (UUID) of the storage system
	// resource that you want information about.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Specifies the kind of storage system resource that you want information about.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"DiscoveryResourceType"`

	// Specifies a time within the total duration that the discovery job ran. To
	// see information gathered during a certain time frame, use this parameter
	// with EndTime.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourceMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourceMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStorageSystemResourceMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStorageSystemResourceMetricsInput"}
	if s.DiscoveryJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryJobArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetDiscoveryJobArn(v string) *DescribeStorageSystemResourceMetricsInput {
	s.DiscoveryJobArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetEndTime(v time.Time) *DescribeStorageSystemResourceMetricsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetMaxResults(v int64) *DescribeStorageSystemResourceMetricsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetNextToken(v string) *DescribeStorageSystemResourceMetricsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetResourceId(v string) *DescribeStorageSystemResourceMetricsInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetResourceType(v string) *DescribeStorageSystemResourceMetricsInput {
	s.ResourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeStorageSystemResourceMetricsInput) SetStartTime(v time.Time) *DescribeStorageSystemResourceMetricsInput {
	s.StartTime = &v
	return s
}

type DescribeStorageSystemResourceMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The details that your discovery job collected about your storage system resource.
	Metrics []*ResourceMetrics `type:"list"`

	// The opaque string that indicates the position to begin the next list of results
	// in the response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourceMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourceMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *DescribeStorageSystemResourceMetricsOutput) SetMetrics(v []*ResourceMetrics) *DescribeStorageSystemResourceMetricsOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStorageSystemResourceMetricsOutput) SetNextToken(v string) *DescribeStorageSystemResourceMetricsOutput {
	s.NextToken = &v
	return s
}

type DescribeStorageSystemResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the discovery job that's collecting
	// data from your on-premises storage system.
	//
	// DiscoveryJobArn is a required field
	DiscoveryJobArn *string `type:"string" required:"true"`

	// Filters the storage system resources that you want returned. For example,
	// this might be volumes associated with a specific storage virtual machine
	// (SVM).
	Filter map[string][]*string `type:"map"`

	// Specifies the maximum number of storage system resources that you want to
	// list in a response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies an opaque string that indicates the position to begin the next
	// list of results in the response.
	NextToken *string `type:"string"`

	// Specifies the universally unique identifiers (UUIDs) of the storage system
	// resources that you want information about. You can't use this parameter in
	// combination with the Filter parameter.
	ResourceIds []*string `min:"1" type:"list"`

	// Specifies what kind of storage system resources that you want information
	// about.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"DiscoveryResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStorageSystemResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStorageSystemResourcesInput"}
	if s.DiscoveryJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryJobArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *DescribeStorageSystemResourcesInput) SetDiscoveryJobArn(v string) *DescribeStorageSystemResourcesInput {
	s.DiscoveryJobArn = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *DescribeStorageSystemResourcesInput) SetFilter(v map[string][]*string) *DescribeStorageSystemResourcesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStorageSystemResourcesInput) SetMaxResults(v int64) *DescribeStorageSystemResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStorageSystemResourcesInput) SetNextToken(v string) *DescribeStorageSystemResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DescribeStorageSystemResourcesInput) SetResourceIds(v []*string) *DescribeStorageSystemResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeStorageSystemResourcesInput) SetResourceType(v string) *DescribeStorageSystemResourcesInput {
	s.ResourceType = &v
	return s
}

type DescribeStorageSystemResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The opaque string that indicates the position to begin the next list of results
	// in the response.
	NextToken *string `type:"string"`

	// The information collected about your storage system's resources. A response
	// can also include Amazon Web Services storage service recommendations.
	//
	// For more information, see storage resource information (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html)
	// collected by and recommendations (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html)
	// provided by DataSync Discovery.
	ResourceDetails *ResourceDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStorageSystemResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStorageSystemResourcesOutput) SetNextToken(v string) *DescribeStorageSystemResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceDetails sets the ResourceDetails field's value.
func (s *DescribeStorageSystemResourcesOutput) SetResourceDetails(v *ResourceDetails) *DescribeStorageSystemResourcesOutput {
	s.ResourceDetails = v
	return s
}

// DescribeTaskExecutionRequest
type DescribeTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task that is being executed.
	//
	// TaskExecutionArn is a required field
	TaskExecutionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskExecutionInput"}
	if s.TaskExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskExecutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *DescribeTaskExecutionInput) SetTaskExecutionArn(v string) *DescribeTaskExecutionInput {
	s.TaskExecutionArn = &v
	return s
}

// DescribeTaskExecutionResponse
type DescribeTaskExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The physical number of bytes transferred over the network after compression
	// was applied. In most cases, this number is less than BytesTransferred unless
	// the data isn't compressible.
	BytesCompressed *int64 `type:"long"`

	// The total number of bytes that are involved in the transfer. For the number
	// of bytes sent over the network, see BytesCompressed.
	BytesTransferred *int64 `type:"long"`

	// The number of logical bytes written to the destination Amazon Web Services
	// storage resource.
	BytesWritten *int64 `type:"long"`

	// The estimated physical number of bytes that is to be transferred over the
	// network.
	EstimatedBytesToTransfer *int64 `type:"long"`

	// The expected number of files that is to be transferred over the network.
	// This value is calculated during the PREPARING phase before the TRANSFERRING
	// phase of the task execution. This value is the expected number of files to
	// be transferred. It's calculated based on comparing the content of the source
	// and destination locations and finding the delta that needs to be transferred.
	EstimatedFilesToTransfer *int64 `type:"long"`

	// A list of filter rules that exclude specific data during your transfer. For
	// more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Excludes []*FilterRule `type:"list"`

	// The actual number of files that was transferred over the network. This value
	// is calculated and updated on an ongoing basis during the TRANSFERRING phase
	// of the task execution. It's updated periodically when each file is read from
	// the source and sent over the network.
	//
	// If failures occur during a transfer, this value can be less than EstimatedFilesToTransfer.
	// In some cases, this value can also be greater than EstimatedFilesToTransfer.
	// This element is implementation-specific for some location types, so don't
	// use it as an indicator for a correct file number or to monitor your task
	// execution.
	FilesTransferred *int64 `type:"long"`

	// A list of filter rules that include specific data during your transfer. For
	// more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Includes []*FilterRule `type:"list"`

	// Configures your DataSync task settings. These options include how DataSync
	// handles files, objects, and their associated metadata. You also can specify
	// how DataSync verifies data integrity, set bandwidth limits for your task,
	// among other options.
	//
	// Each task setting has a default value. Unless you need to, you don't have
	// to configure any of these Options before starting your task.
	Options *Options `type:"structure"`

	// The result of the task execution.
	Result *TaskExecutionResultDetail `type:"structure"`

	// The time that the task execution was started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task execution.
	//
	// For detailed information about task execution statuses, see Understanding
	// Task Statuses in the DataSync User Guide.
	Status *string `type:"string" enum:"TaskExecutionStatus"`

	// The Amazon Resource Name (ARN) of the task execution that was described.
	// TaskExecutionArn is hierarchical and includes TaskArn for the task that was
	// executed.
	//
	// For example, a TaskExecution value with the ARN arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b
	// executed the task with the ARN arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2.
	TaskExecutionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskExecutionOutput) GoString() string {
	return s.String()
}

// SetBytesCompressed sets the BytesCompressed field's value.
func (s *DescribeTaskExecutionOutput) SetBytesCompressed(v int64) *DescribeTaskExecutionOutput {
	s.BytesCompressed = &v
	return s
}

// SetBytesTransferred sets the BytesTransferred field's value.
func (s *DescribeTaskExecutionOutput) SetBytesTransferred(v int64) *DescribeTaskExecutionOutput {
	s.BytesTransferred = &v
	return s
}

// SetBytesWritten sets the BytesWritten field's value.
func (s *DescribeTaskExecutionOutput) SetBytesWritten(v int64) *DescribeTaskExecutionOutput {
	s.BytesWritten = &v
	return s
}

// SetEstimatedBytesToTransfer sets the EstimatedBytesToTransfer field's value.
func (s *DescribeTaskExecutionOutput) SetEstimatedBytesToTransfer(v int64) *DescribeTaskExecutionOutput {
	s.EstimatedBytesToTransfer = &v
	return s
}

// SetEstimatedFilesToTransfer sets the EstimatedFilesToTransfer field's value.
func (s *DescribeTaskExecutionOutput) SetEstimatedFilesToTransfer(v int64) *DescribeTaskExecutionOutput {
	s.EstimatedFilesToTransfer = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *DescribeTaskExecutionOutput) SetExcludes(v []*FilterRule) *DescribeTaskExecutionOutput {
	s.Excludes = v
	return s
}

// SetFilesTransferred sets the FilesTransferred field's value.
func (s *DescribeTaskExecutionOutput) SetFilesTransferred(v int64) *DescribeTaskExecutionOutput {
	s.FilesTransferred = &v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *DescribeTaskExecutionOutput) SetIncludes(v []*FilterRule) *DescribeTaskExecutionOutput {
	s.Includes = v
	return s
}

// SetOptions sets the Options field's value.
func (s *DescribeTaskExecutionOutput) SetOptions(v *Options) *DescribeTaskExecutionOutput {
	s.Options = v
	return s
}

// SetResult sets the Result field's value.
func (s *DescribeTaskExecutionOutput) SetResult(v *TaskExecutionResultDetail) *DescribeTaskExecutionOutput {
	s.Result = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeTaskExecutionOutput) SetStartTime(v time.Time) *DescribeTaskExecutionOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTaskExecutionOutput) SetStatus(v string) *DescribeTaskExecutionOutput {
	s.Status = &v
	return s
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *DescribeTaskExecutionOutput) SetTaskExecutionArn(v string) *DescribeTaskExecutionOutput {
	s.TaskExecutionArn = &v
	return s
}

// DescribeTaskRequest
type DescribeTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task to describe.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskInput"}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskArn sets the TaskArn field's value.
func (s *DescribeTaskInput) SetTaskArn(v string) *DescribeTaskInput {
	s.TaskArn = &v
	return s
}

// DescribeTaskResponse
type DescribeTaskOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was
	// used to monitor and log events in the task.
	//
	// For more information on these groups, see Working with Log Groups and Log
	// Streams in the Amazon CloudWatch User Guide.
	CloudWatchLogGroupArn *string `type:"string"`

	// The time that the task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the task execution that is transferring
	// files.
	CurrentTaskExecutionArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's
	// location.
	DestinationLocationArn *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the network interfaces created for your
	// destination location. For more information, see Network interface requirements
	// (https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces).
	DestinationNetworkInterfaceArns []*string `type:"list"`

	// Errors that DataSync encountered during execution of the task. You can use
	// this error code to help troubleshoot issues.
	ErrorCode *string `type:"string"`

	// Detailed description of an error that was encountered during the task execution.
	// You can use this information to help troubleshoot issues.
	ErrorDetail *string `type:"string"`

	// A list of filter rules that exclude specific data during your transfer. For
	// more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Excludes []*FilterRule `type:"list"`

	// A list of filter rules that include specific data during your transfer. For
	// more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Includes []*FilterRule `type:"list"`

	// The name of the task that was described.
	Name *string `min:"1" type:"string"`

	// The configuration options that control the behavior of the StartTaskExecution
	// operation. Some options include preserving file or object metadata and verifying
	// data integrity.
	//
	// You can override these options for each task execution. For more information,
	// see StartTaskExecution (https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
	Options *Options `type:"structure"`

	// The schedule used to periodically transfer files from a source to a destination
	// location.
	Schedule *TaskSchedule `type:"structure"`

	// The Amazon Resource Name (ARN) of the source file system's location.
	SourceLocationArn *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the network interfaces created for your
	// source location. For more information, see Network interface requirements
	// (https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces).
	SourceNetworkInterfaceArns []*string `type:"list"`

	// The status of the task that was described.
	//
	// For detailed information about task execution statuses, see Understanding
	// Task Statuses in the DataSync User Guide.
	Status *string `type:"string" enum:"TaskStatus"`

	// The Amazon Resource Name (ARN) of the task that was described.
	TaskArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *DescribeTaskOutput) SetCloudWatchLogGroupArn(v string) *DescribeTaskOutput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTaskOutput) SetCreationTime(v time.Time) *DescribeTaskOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentTaskExecutionArn sets the CurrentTaskExecutionArn field's value.
func (s *DescribeTaskOutput) SetCurrentTaskExecutionArn(v string) *DescribeTaskOutput {
	s.CurrentTaskExecutionArn = &v
	return s
}

// SetDestinationLocationArn sets the DestinationLocationArn field's value.
func (s *DescribeTaskOutput) SetDestinationLocationArn(v string) *DescribeTaskOutput {
	s.DestinationLocationArn = &v
	return s
}

// SetDestinationNetworkInterfaceArns sets the DestinationNetworkInterfaceArns field's value.
func (s *DescribeTaskOutput) SetDestinationNetworkInterfaceArns(v []*string) *DescribeTaskOutput {
	s.DestinationNetworkInterfaceArns = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *DescribeTaskOutput) SetErrorCode(v string) *DescribeTaskOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *DescribeTaskOutput) SetErrorDetail(v string) *DescribeTaskOutput {
	s.ErrorDetail = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *DescribeTaskOutput) SetExcludes(v []*FilterRule) *DescribeTaskOutput {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *DescribeTaskOutput) SetIncludes(v []*FilterRule) *DescribeTaskOutput {
	s.Includes = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeTaskOutput) SetName(v string) *DescribeTaskOutput {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *DescribeTaskOutput) SetOptions(v *Options) *DescribeTaskOutput {
	s.Options = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DescribeTaskOutput) SetSchedule(v *TaskSchedule) *DescribeTaskOutput {
	s.Schedule = v
	return s
}

// SetSourceLocationArn sets the SourceLocationArn field's value.
func (s *DescribeTaskOutput) SetSourceLocationArn(v string) *DescribeTaskOutput {
	s.SourceLocationArn = &v
	return s
}

// SetSourceNetworkInterfaceArns sets the SourceNetworkInterfaceArns field's value.
func (s *DescribeTaskOutput) SetSourceNetworkInterfaceArns(v []*string) *DescribeTaskOutput {
	s.SourceNetworkInterfaceArns = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTaskOutput) SetStatus(v string) *DescribeTaskOutput {
	s.Status = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *DescribeTaskOutput) SetTaskArn(v string) *DescribeTaskOutput {
	s.TaskArn = &v
	return s
}

// The details about a specific DataSync discovery job.
type DiscoveryJobListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a discovery job.
	DiscoveryJobArn *string `type:"string"`

	// The status of a discovery job. For more information, see Discovery job statuses
	// (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table).
	Status *string `type:"string" enum:"DiscoveryJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoveryJobListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoveryJobListEntry) GoString() string {
	return s.String()
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *DiscoveryJobListEntry) SetDiscoveryJobArn(v string) *DiscoveryJobListEntry {
	s.DiscoveryJobArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DiscoveryJobListEntry) SetStatus(v string) *DiscoveryJobListEntry {
	s.Status = &v
	return s
}

// The network settings that DataSync Discovery uses to connect with your on-premises
// storage system's management interface.
type DiscoveryServerConfiguration struct {
	_ struct{} `type:"structure"`

	// The domain name or IP address of your storage system's management interface.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// The network port for accessing the storage system's management interface.
	ServerPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoveryServerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoveryServerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoveryServerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DiscoveryServerConfiguration"}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.ServerPort != nil && *s.ServerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ServerPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerHostname sets the ServerHostname field's value.
func (s *DiscoveryServerConfiguration) SetServerHostname(v string) *DiscoveryServerConfiguration {
	s.ServerHostname = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *DiscoveryServerConfiguration) SetServerPort(v int64) *DiscoveryServerConfiguration {
	s.ServerPort = &v
	return s
}

// The subnet and security groups that DataSync uses to access your Amazon EFS
// file system.
type Ec2Config struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Names (ARNs) of the security groups associated
	// with an Amazon EFS file system's mount target.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// Specifies the ARN of a subnet where DataSync creates the network interfaces
	// (https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces)
	// for managing traffic during your transfer.
	//
	// The subnet must be located:
	//
	//    * In the same virtual private cloud (VPC) as the Amazon EFS file system.
	//
	//    * In the same Availability Zone as at least one mount target for the Amazon
	//    EFS file system.
	//
	// You don't need to specify a subnet that includes a file system mount target.
	//
	// SubnetArn is a required field
	SubnetArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2Config"}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.SubnetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *Ec2Config) SetSecurityGroupArns(v []*string) *Ec2Config {
	s.SecurityGroupArns = v
	return s
}

// SetSubnetArn sets the SubnetArn field's value.
func (s *Ec2Config) SetSubnetArn(v string) *Ec2Config {
	s.SubnetArn = &v
	return s
}

// Specifies which files, folders, and objects to include or exclude when transferring
// files from source to destination.
type FilterRule struct {
	_ struct{} `type:"structure"`

	// The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN
	// rule type.
	FilterType *string `type:"string" enum:"FilterType"`

	// A single filter string that consists of the patterns to include or exclude.
	// The patterns are delimited by "|" (that is, a pipe), for example: /folder1|/folder2
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterRule) GoString() string {
	return s.String()
}

// SetFilterType sets the FilterType field's value.
func (s *FilterRule) SetFilterType(v string) *FilterRule {
	s.FilterType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterRule) SetValue(v string) *FilterRule {
	s.Value = &v
	return s
}

// Specifies the data transfer protocol that DataSync uses to access your Amazon
// FSx file system.
type FsxProtocol struct {
	_ struct{} `type:"structure"`

	// Specifies the Network File System (NFS) protocol configuration that DataSync
	// uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's
	// storage virtual machine (SVM).
	NFS *FsxProtocolNfs `type:"structure"`

	// Specifies the Server Message Block (SMB) protocol configuration that DataSync
	// uses to access your FSx for ONTAP file system's SVM.
	SMB *FsxProtocolSmb `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxProtocol) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxProtocol) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FsxProtocol) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FsxProtocol"}
	if s.SMB != nil {
		if err := s.SMB.Validate(); err != nil {
			invalidParams.AddNested("SMB", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNFS sets the NFS field's value.
func (s *FsxProtocol) SetNFS(v *FsxProtocolNfs) *FsxProtocol {
	s.NFS = v
	return s
}

// SetSMB sets the SMB field's value.
func (s *FsxProtocol) SetSMB(v *FsxProtocolSmb) *FsxProtocol {
	s.SMB = v
	return s
}

// Specifies the Network File System (NFS) protocol configuration that DataSync
// uses to access your Amazon FSx for OpenZFS or Amazon FSx for NetApp ONTAP
// file system.
type FsxProtocolNfs struct {
	_ struct{} `type:"structure"`

	// Specifies how DataSync can access a location using the NFS protocol.
	MountOptions *NfsMountOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxProtocolNfs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxProtocolNfs) GoString() string {
	return s.String()
}

// SetMountOptions sets the MountOptions field's value.
func (s *FsxProtocolNfs) SetMountOptions(v *NfsMountOptions) *FsxProtocolNfs {
	s.MountOptions = v
	return s
}

// Specifies the Server Message Block (SMB) protocol configuration that DataSync
// uses to access your Amazon FSx for NetApp ONTAP file system. For more information,
// see Accessing FSx for ONTAP file systems (https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access).
type FsxProtocolSmb struct {
	_ struct{} `type:"structure"`

	// Specifies the fully qualified domain name (FQDN) of the Microsoft Active
	// Directory that your storage virtual machine (SVM) belongs to.
	Domain *string `type:"string"`

	// Specifies the version of the Server Message Block (SMB) protocol that DataSync
	// uses to access an SMB file server.
	MountOptions *SmbMountOptions `type:"structure"`

	// Specifies the password of a user who has permission to access your SVM.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FsxProtocolSmb's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// Specifies a user name that can mount the location and access the files, folders,
	// and metadata that you need in the SVM.
	//
	// If you provide a user in your Active Directory, note the following:
	//
	//    * If you're using Directory Service for Microsoft Active Directory, the
	//    user must be a member of the Amazon Web Services Delegated FSx Administrators
	//    group.
	//
	//    * If you're using a self-managed Active Directory, the user must be a
	//    member of either the Domain Admins group or a custom group that you specified
	//    for file system administration when you created your file system.
	//
	// Make sure that the user has the permissions it needs to copy the data you
	// want:
	//
	//    * SE_TCB_NAME: Required to set object ownership and file metadata. With
	//    this privilege, you also can copy NTFS discretionary access lists (DACLs).
	//
	//    * SE_SECURITY_NAME: May be needed to copy NTFS system access control lists
	//    (SACLs). This operation specifically requires the Windows privilege, which
	//    is granted to members of the Domain Admins group. If you configure your
	//    task to copy SACLs, make sure that the user has the required privileges.
	//    For information about copying SACLs, see Ownership and permissions-related
	//    options (https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions).
	//
	// User is a required field
	User *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxProtocolSmb) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxProtocolSmb) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FsxProtocolSmb) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FsxProtocolSmb"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *FsxProtocolSmb) SetDomain(v string) *FsxProtocolSmb {
	s.Domain = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *FsxProtocolSmb) SetMountOptions(v *SmbMountOptions) *FsxProtocolSmb {
	s.MountOptions = v
	return s
}

// SetPassword sets the Password field's value.
func (s *FsxProtocolSmb) SetPassword(v string) *FsxProtocolSmb {
	s.Password = &v
	return s
}

// SetUser sets the User field's value.
func (s *FsxProtocolSmb) SetUser(v string) *FsxProtocolSmb {
	s.User = &v
	return s
}

type GenerateRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the discovery job that collects
	// information about your on-premises storage system.
	//
	// DiscoveryJobArn is a required field
	DiscoveryJobArn *string `type:"string" required:"true"`

	// Specifies the universally unique identifiers (UUIDs) of the resources in
	// your storage system that you want recommendations on.
	//
	// ResourceIds is a required field
	ResourceIds []*string `min:"1" type:"list" required:"true"`

	// Specifies the type of resource in your storage system that you want recommendations
	// on.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"DiscoveryResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateRecommendationsInput"}
	if s.DiscoveryJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryJobArn"))
	}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *GenerateRecommendationsInput) SetDiscoveryJobArn(v string) *GenerateRecommendationsInput {
	s.DiscoveryJobArn = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *GenerateRecommendationsInput) SetResourceIds(v []*string) *GenerateRecommendationsInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GenerateRecommendationsInput) SetResourceType(v string) *GenerateRecommendationsInput {
	s.ResourceType = &v
	return s
}

type GenerateRecommendationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRecommendationsOutput) GoString() string {
	return s.String()
}

// The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages
// the file system's namespace. The NameNode performs operations such as opening,
// closing, and renaming files and directories. The NameNode contains the information
// to map blocks of data to the DataNodes.
type HdfsNameNode struct {
	_ struct{} `type:"structure"`

	// The hostname of the NameNode in the HDFS cluster. This value is the IP address
	// or Domain Name Service (DNS) name of the NameNode. An agent that's installed
	// on-premises uses this hostname to communicate with the NameNode in the network.
	//
	// Hostname is a required field
	Hostname *string `min:"1" type:"string" required:"true"`

	// The port that the NameNode uses to listen to client requests.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HdfsNameNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HdfsNameNode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HdfsNameNode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HdfsNameNode"}
	if s.Hostname == nil {
		invalidParams.Add(request.NewErrParamRequired("Hostname"))
	}
	if s.Hostname != nil && len(*s.Hostname) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Hostname", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *HdfsNameNode) SetHostname(v string) *HdfsNameNode {
	s.Hostname = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HdfsNameNode) SetPort(v int64) *HdfsNameNode {
	s.Port = &v
	return s
}

// The IOPS peaks for an on-premises storage system resource. Each data point
// represents the 95th percentile peak value during a 1-hour interval.
type IOPS struct {
	_ struct{} `type:"structure"`

	// Peak IOPS unrelated to read and write operations.
	Other *float64 `type:"double"`

	// Peak IOPS related to read operations.
	Read *float64 `type:"double"`

	// Peak total IOPS on your on-premises storage system resource.
	Total *float64 `type:"double"`

	// Peak IOPS related to write operations.
	Write *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IOPS) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IOPS) GoString() string {
	return s.String()
}

// SetOther sets the Other field's value.
func (s *IOPS) SetOther(v float64) *IOPS {
	s.Other = &v
	return s
}

// SetRead sets the Read field's value.
func (s *IOPS) SetRead(v float64) *IOPS {
	s.Read = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *IOPS) SetTotal(v float64) *IOPS {
	s.Total = &v
	return s
}

// SetWrite sets the Write field's value.
func (s *IOPS) SetWrite(v float64) *IOPS {
	s.Write = &v
	return s
}

// This exception is thrown when an error occurs in the DataSync service.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the client submits a malformed request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	DatasyncErrorCode *string `locationName:"datasyncErrorCode" type:"string"`

	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The latency peaks for an on-premises storage system resource. Each data point
// represents the 95th percentile peak value during a 1-hour interval.
type Latency struct {
	_ struct{} `type:"structure"`

	// Peak latency for operations unrelated to read and write operations.
	Other *float64 `type:"double"`

	// Peak latency for read operations.
	Read *float64 `type:"double"`

	// Peak latency for write operations.
	Write *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Latency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Latency) GoString() string {
	return s.String()
}

// SetOther sets the Other field's value.
func (s *Latency) SetOther(v float64) *Latency {
	s.Other = &v
	return s
}

// SetRead sets the Read field's value.
func (s *Latency) SetRead(v float64) *Latency {
	s.Read = &v
	return s
}

// SetWrite sets the Write field's value.
func (s *Latency) SetWrite(v float64) *Latency {
	s.Write = &v
	return s
}

// ListAgentsRequest
type ListAgentsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of DataSync agents to list in a response. By
	// default, a response shows a maximum of 100 agents.
	MaxResults *int64 `type:"integer"`

	// Specifies an opaque string that indicates the position to begin the next
	// list of results in the response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentsInput) SetMaxResults(v int64) *ListAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsInput) SetNextToken(v string) *ListAgentsInput {
	s.NextToken = &v
	return s
}

// ListAgentsResponse
type ListAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DataSync agents in your Amazon Web Services account in the Amazon
	// Web Services Region specified in the request. The list is ordered by the
	// agents' Amazon Resource Names (ARNs).
	Agents []*AgentListEntry `type:"list"`

	// The opaque string that indicates the position to begin the next list of results
	// in the response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsOutput) GoString() string {
	return s.String()
}

// SetAgents sets the Agents field's value.
func (s *ListAgentsOutput) SetAgents(v []*AgentListEntry) *ListAgentsOutput {
	s.Agents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsOutput) SetNextToken(v string) *ListAgentsOutput {
	s.NextToken = &v
	return s
}

type ListDiscoveryJobsInput struct {
	_ struct{} `type:"structure"`

	// Specifies how many results you want in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies an opaque string that indicates the position to begin the next
	// list of results in the response.
	NextToken *string `type:"string"`

	// Specifies the Amazon Resource Name (ARN) of an on-premises storage system.
	// Use this parameter if you only want to list the discovery jobs that are associated
	// with a specific storage system.
	StorageSystemArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveryJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveryJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDiscoveryJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDiscoveryJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDiscoveryJobsInput) SetMaxResults(v int64) *ListDiscoveryJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveryJobsInput) SetNextToken(v string) *ListDiscoveryJobsInput {
	s.NextToken = &v
	return s
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *ListDiscoveryJobsInput) SetStorageSystemArn(v string) *ListDiscoveryJobsInput {
	s.StorageSystemArn = &v
	return s
}

type ListDiscoveryJobsOutput struct {
	_ struct{} `type:"structure"`

	// The discovery jobs that you've run.
	DiscoveryJobs []*DiscoveryJobListEntry `type:"list"`

	// The opaque string that indicates the position to begin the next list of results
	// in the response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveryJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveryJobsOutput) GoString() string {
	return s.String()
}

// SetDiscoveryJobs sets the DiscoveryJobs field's value.
func (s *ListDiscoveryJobsOutput) SetDiscoveryJobs(v []*DiscoveryJobListEntry) *ListDiscoveryJobsOutput {
	s.DiscoveryJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveryJobsOutput) SetNextToken(v string) *ListDiscoveryJobsOutput {
	s.NextToken = &v
	return s
}

// ListLocationsRequest
type ListLocationsInput struct {
	_ struct{} `type:"structure"`

	// You can use API filters to narrow down the list of resources returned by
	// ListLocations. For example, to retrieve all tasks on a specific source location,
	// you can use ListLocations with filter name LocationType S3 and Operator Equals.
	Filters []*LocationFilter `type:"list"`

	// The maximum number of locations to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of locations.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLocationsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListLocationsInput) SetFilters(v []*LocationFilter) *ListLocationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLocationsInput) SetMaxResults(v int64) *ListLocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLocationsInput) SetNextToken(v string) *ListLocationsInput {
	s.NextToken = &v
	return s
}

// ListLocationsResponse
type ListLocationsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains a list of locations.
	Locations []*LocationListEntry `type:"list"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of locations.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLocationsOutput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *ListLocationsOutput) SetLocations(v []*LocationListEntry) *ListLocationsOutput {
	s.Locations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLocationsOutput) SetNextToken(v string) *ListLocationsOutput {
	s.NextToken = &v
	return s
}

type ListStorageSystemsInput struct {
	_ struct{} `type:"structure"`

	// Specifies how many results you want in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies an opaque string that indicates the position to begin the next
	// list of results in the response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageSystemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageSystemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageSystemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStorageSystemsInput) SetMaxResults(v int64) *ListStorageSystemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageSystemsInput) SetNextToken(v string) *ListStorageSystemsInput {
	s.NextToken = &v
	return s
}

type ListStorageSystemsOutput struct {
	_ struct{} `type:"structure"`

	// The opaque string that indicates the position to begin the next list of results
	// in the response.
	NextToken *string `type:"string"`

	// The Amazon Resource Names ARNs) of the on-premises storage systems that you're
	// using with DataSync Discovery.
	StorageSystems []*StorageSystemListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageSystemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageSystemsOutput) SetNextToken(v string) *ListStorageSystemsOutput {
	s.NextToken = &v
	return s
}

// SetStorageSystems sets the StorageSystems field's value.
func (s *ListStorageSystemsOutput) SetStorageSystems(v []*StorageSystemListEntry) *ListStorageSystemsOutput {
	s.StorageSystems = v
	return s
}

// ListTagsForResourceRequest
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies how many results that you want in the response.
	MaxResults *int64 `type:"integer"`

	// Specifies an opaque string that indicates the position to begin the next
	// list of results in the response.
	NextToken *string `type:"string"`

	// Specifies the Amazon Resource Name (ARN) of the resource that you want tag
	// information on.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// ListTagsForResourceResponse
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The opaque string that indicates the position to begin the next list of results
	// in the response.
	NextToken *string `type:"string"`

	// An array of tags applied to the specified resource.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*TagListEntry) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// ListTaskExecutions
type ListTaskExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of executed tasks to list.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of the executed tasks.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the task whose tasks you want to list.
	TaskArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskExecutionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTaskExecutionsInput) SetMaxResults(v int64) *ListTaskExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskExecutionsInput) SetNextToken(v string) *ListTaskExecutionsInput {
	s.NextToken = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *ListTaskExecutionsInput) SetTaskArn(v string) *ListTaskExecutionsInput {
	s.TaskArn = &v
	return s
}

// ListTaskExecutionsResponse
type ListTaskExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of executed tasks.
	NextToken *string `type:"string"`

	// A list of executed tasks.
	TaskExecutions []*TaskExecutionListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskExecutionsOutput) SetNextToken(v string) *ListTaskExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetTaskExecutions sets the TaskExecutions field's value.
func (s *ListTaskExecutionsOutput) SetTaskExecutions(v []*TaskExecutionListEntry) *ListTaskExecutionsOutput {
	s.TaskExecutions = v
	return s
}

// ListTasksRequest
type ListTasksInput struct {
	_ struct{} `type:"structure"`

	// You can use API filters to narrow down the list of resources returned by
	// ListTasks. For example, to retrieve all tasks on a specific source location,
	// you can use ListTasks with filter name LocationId and Operator Equals with
	// the ARN for the location.
	Filters []*TaskFilter `type:"list"`

	// The maximum number of tasks to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of tasks.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListTasksInput) SetFilters(v []*TaskFilter) *ListTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTasksInput) SetMaxResults(v int64) *ListTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksInput) SetNextToken(v string) *ListTasksInput {
	s.NextToken = &v
	return s
}

// ListTasksResponse
type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of tasks.
	NextToken *string `type:"string"`

	// A list of all the tasks that are returned.
	Tasks []*TaskListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksOutput) SetNextToken(v string) *ListTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *ListTasksOutput) SetTasks(v []*TaskListEntry) *ListTasksOutput {
	s.Tasks = v
	return s
}

// Narrow down the list of resources returned by ListLocations. For example,
// to see all your Amazon S3 locations, create a filter using "Name": "LocationType",
// "Operator": "Equals", and "Values": "S3".
//
// For more information, see filtering resources (https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html).
type LocationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter being used. Each API call supports a list of filters
	// that are available for it (for example, LocationType for ListLocations).
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"LocationFilterName"`

	// The operator that is used to compare filter values (for example, Equals or
	// Contains).
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"Operator"`

	// The values that you want to filter for. For example, you might want to display
	// only Amazon S3 locations.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LocationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LocationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LocationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LocationFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *LocationFilter) SetName(v string) *LocationFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *LocationFilter) SetOperator(v string) *LocationFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *LocationFilter) SetValues(v []*string) *LocationFilter {
	s.Values = v
	return s
}

// Represents a single entry in a list of locations. LocationListEntry returns
// an array that contains a list of locations when the ListLocations (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html)
// operation is called.
type LocationListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the location. For Network File System (NFS)
	// or Amazon EFS, the location is the export path. For Amazon S3, the location
	// is the prefix path that you want to mount and use as the root of the location.
	LocationArn *string `type:"string"`

	// Represents a list of URIs of a location. LocationUri returns an array that
	// contains a list of locations when the ListLocations (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html)
	// operation is called.
	//
	// Format: TYPE://GLOBAL_ID/SUBDIR.
	//
	// TYPE designates the type of location (for example, nfs or s3).
	//
	// GLOBAL_ID is the globally unique identifier of the resource that backs the
	// location. An example for EFS is us-east-2.fs-abcd1234. An example for Amazon
	// S3 is the bucket name, such as myBucket. An example for NFS is a valid IPv4
	// address or a hostname that is compliant with Domain Name Service (DNS).
	//
	// SUBDIR is a valid file system path, delimited by forward slashes as is the
	// *nix convention. For NFS and Amazon EFS, it's the export path to mount the
	// location. For Amazon S3, it's the prefix path that you mount to and treat
	// as the root of the location.
	LocationUri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LocationListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LocationListEntry) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *LocationListEntry) SetLocationArn(v string) *LocationListEntry {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *LocationListEntry) SetLocationUri(v string) *LocationListEntry {
	s.LocationUri = &v
	return s
}

// The performance data that DataSync Discovery collects about an on-premises
// storage system resource.
type MaxP95Performance struct {
	_ struct{} `type:"structure"`

	// Peak IOPS unrelated to read and write operations.
	IopsOther *float64 `type:"double"`

	// Peak IOPS related to read operations.
	IopsRead *float64 `type:"double"`

	// Peak total IOPS on your on-premises storage system resource.
	IopsTotal *float64 `type:"double"`

	// Peak IOPS related to write operations.
	IopsWrite *float64 `type:"double"`

	// Peak latency for operations unrelated to read and write operations.
	LatencyOther *float64 `type:"double"`

	// Peak latency for read operations.
	LatencyRead *float64 `type:"double"`

	// Peak latency for write operations.
	LatencyWrite *float64 `type:"double"`

	// Peak throughput unrelated to read and write operations.
	ThroughputOther *float64 `type:"double"`

	// Peak throughput related to read operations.
	ThroughputRead *float64 `type:"double"`

	// Peak total throughput on your on-premises storage system resource.
	ThroughputTotal *float64 `type:"double"`

	// Peak throughput related to write operations.
	ThroughputWrite *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxP95Performance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxP95Performance) GoString() string {
	return s.String()
}

// SetIopsOther sets the IopsOther field's value.
func (s *MaxP95Performance) SetIopsOther(v float64) *MaxP95Performance {
	s.IopsOther = &v
	return s
}

// SetIopsRead sets the IopsRead field's value.
func (s *MaxP95Performance) SetIopsRead(v float64) *MaxP95Performance {
	s.IopsRead = &v
	return s
}

// SetIopsTotal sets the IopsTotal field's value.
func (s *MaxP95Performance) SetIopsTotal(v float64) *MaxP95Performance {
	s.IopsTotal = &v
	return s
}

// SetIopsWrite sets the IopsWrite field's value.
func (s *MaxP95Performance) SetIopsWrite(v float64) *MaxP95Performance {
	s.IopsWrite = &v
	return s
}

// SetLatencyOther sets the LatencyOther field's value.
func (s *MaxP95Performance) SetLatencyOther(v float64) *MaxP95Performance {
	s.LatencyOther = &v
	return s
}

// SetLatencyRead sets the LatencyRead field's value.
func (s *MaxP95Performance) SetLatencyRead(v float64) *MaxP95Performance {
	s.LatencyRead = &v
	return s
}

// SetLatencyWrite sets the LatencyWrite field's value.
func (s *MaxP95Performance) SetLatencyWrite(v float64) *MaxP95Performance {
	s.LatencyWrite = &v
	return s
}

// SetThroughputOther sets the ThroughputOther field's value.
func (s *MaxP95Performance) SetThroughputOther(v float64) *MaxP95Performance {
	s.ThroughputOther = &v
	return s
}

// SetThroughputRead sets the ThroughputRead field's value.
func (s *MaxP95Performance) SetThroughputRead(v float64) *MaxP95Performance {
	s.ThroughputRead = &v
	return s
}

// SetThroughputTotal sets the ThroughputTotal field's value.
func (s *MaxP95Performance) SetThroughputTotal(v float64) *MaxP95Performance {
	s.ThroughputTotal = &v
	return s
}

// SetThroughputWrite sets the ThroughputWrite field's value.
func (s *MaxP95Performance) SetThroughputWrite(v float64) *MaxP95Performance {
	s.ThroughputWrite = &v
	return s
}

// The information that DataSync Discovery collects about an on-premises storage
// system cluster.
type NetAppONTAPCluster struct {
	_ struct{} `type:"structure"`

	// The number of CIFS shares in the cluster.
	CifsShareCount *int64 `type:"long"`

	// The storage space that's being used in the cluster without accounting for
	// compression or deduplication.
	ClusterBlockStorageLogicalUsed *int64 `type:"long"`

	// The total storage space that's available in the cluster.
	ClusterBlockStorageSize *int64 `type:"long"`

	// The storage space that's being used in a cluster.
	ClusterBlockStorageUsed *int64 `type:"long"`

	// The name of the cluster.
	ClusterName *string `type:"string"`

	// The performance data that DataSync Discovery collects about the cluster.
	MaxP95Performance *MaxP95Performance `type:"structure"`

	// The number of NFS volumes in the cluster.
	NfsExportedVolumes *int64 `type:"long"`

	// Indicates whether DataSync Discovery recommendations for the cluster are
	// ready to view, incomplete, or can't be determined.
	//
	// For more information, see Recommendation statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table).
	RecommendationStatus *string `type:"string" enum:"RecommendationStatus"`

	// The Amazon Web Services storage services that DataSync Discovery recommends
	// for the cluster. For more information, see Recommendations provided by DataSync
	// Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
	Recommendations []*Recommendation `type:"list"`

	// The universally unique identifier (UUID) of the cluster.
	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetAppONTAPCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetAppONTAPCluster) GoString() string {
	return s.String()
}

// SetCifsShareCount sets the CifsShareCount field's value.
func (s *NetAppONTAPCluster) SetCifsShareCount(v int64) *NetAppONTAPCluster {
	s.CifsShareCount = &v
	return s
}

// SetClusterBlockStorageLogicalUsed sets the ClusterBlockStorageLogicalUsed field's value.
func (s *NetAppONTAPCluster) SetClusterBlockStorageLogicalUsed(v int64) *NetAppONTAPCluster {
	s.ClusterBlockStorageLogicalUsed = &v
	return s
}

// SetClusterBlockStorageSize sets the ClusterBlockStorageSize field's value.
func (s *NetAppONTAPCluster) SetClusterBlockStorageSize(v int64) *NetAppONTAPCluster {
	s.ClusterBlockStorageSize = &v
	return s
}

// SetClusterBlockStorageUsed sets the ClusterBlockStorageUsed field's value.
func (s *NetAppONTAPCluster) SetClusterBlockStorageUsed(v int64) *NetAppONTAPCluster {
	s.ClusterBlockStorageUsed = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *NetAppONTAPCluster) SetClusterName(v string) *NetAppONTAPCluster {
	s.ClusterName = &v
	return s
}

// SetMaxP95Performance sets the MaxP95Performance field's value.
func (s *NetAppONTAPCluster) SetMaxP95Performance(v *MaxP95Performance) *NetAppONTAPCluster {
	s.MaxP95Performance = v
	return s
}

// SetNfsExportedVolumes sets the NfsExportedVolumes field's value.
func (s *NetAppONTAPCluster) SetNfsExportedVolumes(v int64) *NetAppONTAPCluster {
	s.NfsExportedVolumes = &v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *NetAppONTAPCluster) SetRecommendationStatus(v string) *NetAppONTAPCluster {
	s.RecommendationStatus = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *NetAppONTAPCluster) SetRecommendations(v []*Recommendation) *NetAppONTAPCluster {
	s.Recommendations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *NetAppONTAPCluster) SetResourceId(v string) *NetAppONTAPCluster {
	s.ResourceId = &v
	return s
}

// The information that DataSync Discovery collects about a storage virtual
// machine (SVM) in your on-premises storage system.
type NetAppONTAPSVM struct {
	_ struct{} `type:"structure"`

	// The number of CIFS shares in the SVM.
	CifsShareCount *int64 `type:"long"`

	// The universally unique identifier (UUID) of the cluster associated with the
	// SVM.
	ClusterUuid *string `type:"string"`

	// The data transfer protocols (such as NFS) configured for the SVM.
	EnabledProtocols []*string `type:"list"`

	// The performance data that DataSync Discovery collects about the SVM.
	MaxP95Performance *MaxP95Performance `type:"structure"`

	// The number of NFS volumes in the SVM.
	NfsExportedVolumes *int64 `type:"long"`

	// Indicates whether DataSync Discovery recommendations for the SVM are ready
	// to view, incomplete, or can't be determined.
	//
	// For more information, see Recommendation statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table).
	RecommendationStatus *string `type:"string" enum:"RecommendationStatus"`

	// The Amazon Web Services storage services that DataSync Discovery recommends
	// for the SVM. For more information, see Recommendations provided by DataSync
	// Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
	Recommendations []*Recommendation `type:"list"`

	// The UUID of the SVM.
	ResourceId *string `type:"string"`

	// The name of the SVM
	SvmName *string `type:"string"`

	// The total storage space that's available in the SVM.
	TotalCapacityProvisioned *int64 `type:"long"`

	// The storage space that's being used in the SVM.
	TotalCapacityUsed *int64 `type:"long"`

	// The storage space that's being used in the SVM without accounting for compression
	// or deduplication.
	TotalLogicalCapacityUsed *int64 `type:"long"`

	// The amount of storage in the SVM that's being used for snapshots.
	TotalSnapshotCapacityUsed *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetAppONTAPSVM) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetAppONTAPSVM) GoString() string {
	return s.String()
}

// SetCifsShareCount sets the CifsShareCount field's value.
func (s *NetAppONTAPSVM) SetCifsShareCount(v int64) *NetAppONTAPSVM {
	s.CifsShareCount = &v
	return s
}

// SetClusterUuid sets the ClusterUuid field's value.
func (s *NetAppONTAPSVM) SetClusterUuid(v string) *NetAppONTAPSVM {
	s.ClusterUuid = &v
	return s
}

// SetEnabledProtocols sets the EnabledProtocols field's value.
func (s *NetAppONTAPSVM) SetEnabledProtocols(v []*string) *NetAppONTAPSVM {
	s.EnabledProtocols = v
	return s
}

// SetMaxP95Performance sets the MaxP95Performance field's value.
func (s *NetAppONTAPSVM) SetMaxP95Performance(v *MaxP95Performance) *NetAppONTAPSVM {
	s.MaxP95Performance = v
	return s
}

// SetNfsExportedVolumes sets the NfsExportedVolumes field's value.
func (s *NetAppONTAPSVM) SetNfsExportedVolumes(v int64) *NetAppONTAPSVM {
	s.NfsExportedVolumes = &v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *NetAppONTAPSVM) SetRecommendationStatus(v string) *NetAppONTAPSVM {
	s.RecommendationStatus = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *NetAppONTAPSVM) SetRecommendations(v []*Recommendation) *NetAppONTAPSVM {
	s.Recommendations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *NetAppONTAPSVM) SetResourceId(v string) *NetAppONTAPSVM {
	s.ResourceId = &v
	return s
}

// SetSvmName sets the SvmName field's value.
func (s *NetAppONTAPSVM) SetSvmName(v string) *NetAppONTAPSVM {
	s.SvmName = &v
	return s
}

// SetTotalCapacityProvisioned sets the TotalCapacityProvisioned field's value.
func (s *NetAppONTAPSVM) SetTotalCapacityProvisioned(v int64) *NetAppONTAPSVM {
	s.TotalCapacityProvisioned = &v
	return s
}

// SetTotalCapacityUsed sets the TotalCapacityUsed field's value.
func (s *NetAppONTAPSVM) SetTotalCapacityUsed(v int64) *NetAppONTAPSVM {
	s.TotalCapacityUsed = &v
	return s
}

// SetTotalLogicalCapacityUsed sets the TotalLogicalCapacityUsed field's value.
func (s *NetAppONTAPSVM) SetTotalLogicalCapacityUsed(v int64) *NetAppONTAPSVM {
	s.TotalLogicalCapacityUsed = &v
	return s
}

// SetTotalSnapshotCapacityUsed sets the TotalSnapshotCapacityUsed field's value.
func (s *NetAppONTAPSVM) SetTotalSnapshotCapacityUsed(v int64) *NetAppONTAPSVM {
	s.TotalSnapshotCapacityUsed = &v
	return s
}

// The information that DataSync Discovery collects about a volume in your on-premises
// storage system.
type NetAppONTAPVolume struct {
	_ struct{} `type:"structure"`

	// The total storage space that's available in the volume.
	CapacityProvisioned *int64 `type:"long"`

	// The storage space that's being used in the volume.
	CapacityUsed *int64 `type:"long"`

	// The number of CIFS shares in the volume.
	CifsShareCount *int64 `type:"long"`

	// The storage space that's being used in the volume without accounting for
	// compression or deduplication.
	LogicalCapacityUsed *int64 `type:"long"`

	// The performance data that DataSync Discovery collects about the volume.
	MaxP95Performance *MaxP95Performance `type:"structure"`

	// The number of NFS volumes in the volume.
	NfsExported *bool `type:"boolean"`

	// Indicates whether DataSync Discovery recommendations for the volume are ready
	// to view, incomplete, or can't be determined.
	//
	// For more information, see Recommendation statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table).
	RecommendationStatus *string `type:"string" enum:"RecommendationStatus"`

	// The Amazon Web Services storage services that DataSync Discovery recommends
	// for the volume. For more information, see Recommendations provided by DataSync
	// Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
	Recommendations []*Recommendation `type:"list"`

	// The universally unique identifier (UUID) of the volume.
	ResourceId *string `type:"string"`

	// The volume's security style (such as Unix or NTFS).
	SecurityStyle *string `type:"string"`

	// The amount of storage in the volume that's being used for snapshots.
	SnapshotCapacityUsed *int64 `type:"long"`

	// The name of the SVM associated with the volume.
	SvmName *string `type:"string"`

	// The UUID of the storage virtual machine (SVM) associated with the volume.
	SvmUuid *string `type:"string"`

	// The name of the volume.
	VolumeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetAppONTAPVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetAppONTAPVolume) GoString() string {
	return s.String()
}

// SetCapacityProvisioned sets the CapacityProvisioned field's value.
func (s *NetAppONTAPVolume) SetCapacityProvisioned(v int64) *NetAppONTAPVolume {
	s.CapacityProvisioned = &v
	return s
}

// SetCapacityUsed sets the CapacityUsed field's value.
func (s *NetAppONTAPVolume) SetCapacityUsed(v int64) *NetAppONTAPVolume {
	s.CapacityUsed = &v
	return s
}

// SetCifsShareCount sets the CifsShareCount field's value.
func (s *NetAppONTAPVolume) SetCifsShareCount(v int64) *NetAppONTAPVolume {
	s.CifsShareCount = &v
	return s
}

// SetLogicalCapacityUsed sets the LogicalCapacityUsed field's value.
func (s *NetAppONTAPVolume) SetLogicalCapacityUsed(v int64) *NetAppONTAPVolume {
	s.LogicalCapacityUsed = &v
	return s
}

// SetMaxP95Performance sets the MaxP95Performance field's value.
func (s *NetAppONTAPVolume) SetMaxP95Performance(v *MaxP95Performance) *NetAppONTAPVolume {
	s.MaxP95Performance = v
	return s
}

// SetNfsExported sets the NfsExported field's value.
func (s *NetAppONTAPVolume) SetNfsExported(v bool) *NetAppONTAPVolume {
	s.NfsExported = &v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *NetAppONTAPVolume) SetRecommendationStatus(v string) *NetAppONTAPVolume {
	s.RecommendationStatus = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *NetAppONTAPVolume) SetRecommendations(v []*Recommendation) *NetAppONTAPVolume {
	s.Recommendations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *NetAppONTAPVolume) SetResourceId(v string) *NetAppONTAPVolume {
	s.ResourceId = &v
	return s
}

// SetSecurityStyle sets the SecurityStyle field's value.
func (s *NetAppONTAPVolume) SetSecurityStyle(v string) *NetAppONTAPVolume {
	s.SecurityStyle = &v
	return s
}

// SetSnapshotCapacityUsed sets the SnapshotCapacityUsed field's value.
func (s *NetAppONTAPVolume) SetSnapshotCapacityUsed(v int64) *NetAppONTAPVolume {
	s.SnapshotCapacityUsed = &v
	return s
}

// SetSvmName sets the SvmName field's value.
func (s *NetAppONTAPVolume) SetSvmName(v string) *NetAppONTAPVolume {
	s.SvmName = &v
	return s
}

// SetSvmUuid sets the SvmUuid field's value.
func (s *NetAppONTAPVolume) SetSvmUuid(v string) *NetAppONTAPVolume {
	s.SvmUuid = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *NetAppONTAPVolume) SetVolumeName(v string) *NetAppONTAPVolume {
	s.VolumeName = &v
	return s
}

// Specifies how DataSync can access a location using the NFS protocol.
type NfsMountOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the NFS version that you want DataSync to use when mounting your
	// NFS share. If the server refuses to use the version specified, the task fails.
	//
	// You can specify the following options:
	//
	//    * AUTOMATIC (default): DataSync chooses NFS version 4.1.
	//
	//    * NFS3: Stateless protocol version that allows for asynchronous writes
	//    on the server.
	//
	//    * NFSv4_0: Stateful, firewall-friendly protocol version that supports
	//    delegations and pseudo file systems.
	//
	//    * NFSv4_1: Stateful protocol version that supports sessions, directory
	//    delegations, and parallel data processing. NFS version 4.1 also includes
	//    all features available in version 4.0.
	//
	// DataSync currently only supports NFS version 3 with Amazon FSx for NetApp
	// ONTAP locations.
	Version *string `type:"string" enum:"NfsVersion"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NfsMountOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NfsMountOptions) GoString() string {
	return s.String()
}

// SetVersion sets the Version field's value.
func (s *NfsMountOptions) SetVersion(v string) *NfsMountOptions {
	s.Version = &v
	return s
}

// A list of Amazon Resource Names (ARNs) of agents to use for a Network File
// System (NFS) location.
type OnPremConfig struct {
	_ struct{} `type:"structure"`

	// ARNs of the agents to use for an NFS location.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnPremConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnPremConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnPremConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnPremConfig"}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *OnPremConfig) SetAgentArns(v []*string) *OnPremConfig {
	s.AgentArns = v
	return s
}

// Configures your DataSync task settings. These options include how DataSync
// handles files, objects, and their associated metadata. You also can specify
// how DataSync verifies data integrity, set bandwidth limits for your task,
// among other options.
//
// Each task setting has a default value. Unless you need to, you don't have
// to configure any of these Options before starting your task.
type Options struct {
	_ struct{} `type:"structure"`

	// Specifies whether to preserve metadata indicating the last time a file was
	// read or written to. If you set Atime to BEST_EFFORT, DataSync attempts to
	// preserve the original Atime attribute on all source files (that is, the version
	// before the PREPARING phase of the task execution).
	//
	// The behavior of Atime isn't fully standard across platforms, so DataSync
	// can only do this on a best-effort basis.
	//
	// Default value: BEST_EFFORT
	//
	// BEST_EFFORT: Attempt to preserve the per-file Atime value (recommended).
	//
	// NONE: Ignore Atime.
	//
	// If Atime is set to BEST_EFFORT, Mtime must be set to PRESERVE.
	//
	// If Atime is set to NONE, Mtime must also be NONE.
	Atime *string `type:"string" enum:"Atime"`

	// Limits the bandwidth used by a DataSync task. For example, if you want DataSync
	// to use a maximum of 1 MB, set this value to 1048576 (=1024*1024).
	BytesPerSecond *int64 `type:"long"`

	// Specifies the POSIX group ID (GID) of the file's owners.
	//
	// For more information, see Metadata copied by DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
	//
	// Default value: INT_VALUE. This preserves the integer value of the ID.
	//
	// INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).
	//
	// NONE: Ignore UID and GID.
	Gid *string `type:"string" enum:"Gid"`

	// Specifies the type of logs that DataSync publishes to a Amazon CloudWatch
	// Logs log group. To specify the log group, see CloudWatchLogGroupArn (https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn).
	//
	// If you set LogLevel to OFF, no logs are published. BASIC publishes logs on
	// errors for individual files transferred. TRANSFER publishes logs for every
	// file or object that is transferred and integrity checked.
	LogLevel *string `type:"string" enum:"LogLevel"`

	// Specifies whether to preserve metadata indicating the last time that a file
	// was written to before the PREPARING phase of your task execution. This option
	// is required when you need to run the a task more than once.
	//
	// Default Value: PRESERVE
	//
	// PRESERVE: Preserve original Mtime (recommended)
	//
	// NONE: Ignore Mtime.
	//
	// If Mtime is set to PRESERVE, Atime must be set to BEST_EFFORT.
	//
	// If Mtime is set to NONE, Atime must also be set to NONE.
	Mtime *string `type:"string" enum:"Mtime"`

	// Specifies whether object tags are preserved when transferring between object
	// storage systems. If you want your DataSync task to ignore object tags, specify
	// the NONE value.
	//
	// Default Value: PRESERVE
	ObjectTags *string `type:"string" enum:"ObjectTags"`

	// Specifies whether data at the destination location should be overwritten
	// or preserved. If set to NEVER, a destination file for example will not be
	// replaced by a source file (even if the destination file differs from the
	// source file). If you modify files in the destination and you sync the files,
	// you can use this value to protect against overwriting those changes.
	//
	// Some storage classes have specific behaviors that can affect your Amazon
	// S3 storage cost. For detailed information, see Considerations when working
	// with Amazon S3 storage classes in DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	OverwriteMode *string `type:"string" enum:"OverwriteMode"`

	// Specifies which users or groups can access a file for a specific purpose
	// such as reading, writing, or execution of the file.
	//
	// For more information, see Metadata copied by DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
	//
	// Default value: PRESERVE
	//
	// PRESERVE: Preserve POSIX-style permissions (recommended).
	//
	// NONE: Ignore permissions.
	//
	// DataSync can preserve extant permissions of a source location.
	PosixPermissions *string `type:"string" enum:"PosixPermissions"`

	// Specifies whether files in the destination location that don't exist in the
	// source should be preserved. This option can affect your Amazon S3 storage
	// cost. If your task deletes objects, you might incur minimum storage duration
	// charges for certain storage classes. For detailed information, see Considerations
	// when working with Amazon S3 storage classes in DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	//
	// Default value: PRESERVE
	//
	// PRESERVE: Ignore such destination files (recommended).
	//
	// REMOVE: Delete destination files that aren’t present in the source.
	//
	// If you set this parameter to REMOVE, you can't set TransferMode to ALL. When
	// you transfer all data, DataSync doesn't scan your destination location and
	// doesn't know what to delete.
	PreserveDeletedFiles *string `type:"string" enum:"PreserveDeletedFiles"`

	// Specifies whether DataSync should preserve the metadata of block and character
	// devices in the source location and recreate the files with that device name
	// and metadata on the destination. DataSync copies only the name and metadata
	// of such devices.
	//
	// DataSync can't copy the actual contents of these devices because they're
	// nonterminal and don't return an end-of-file (EOF) marker.
	//
	// Default value: NONE
	//
	// NONE: Ignore special devices (recommended).
	//
	// PRESERVE: Preserve character and block device metadata. This option currently
	// isn't supported for Amazon EFS.
	PreserveDevices *string `type:"string" enum:"PreserveDevices"`

	// Specifies which components of the SMB security descriptor are copied from
	// source to destination objects.
	//
	// This value is only used for transfers between SMB and Amazon FSx for Windows
	// File Server locations or between two FSx for Windows File Server locations.
	// For more information, see how DataSync handles metadata (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html).
	//
	// Default value: OWNER_DACL
	//
	// OWNER_DACL: For each copied object, DataSync copies the following metadata:
	//
	//    * The object owner.
	//
	//    * NTFS discretionary access control lists (DACLs), which determine whether
	//    to grant access to an object. DataSync won't copy NTFS system access control
	//    lists (SACLs) with this option.
	//
	// OWNER_DACL_SACL: For each copied object, DataSync copies the following metadata:
	//
	//    * The object owner.
	//
	//    * NTFS discretionary access control lists (DACLs), which determine whether
	//    to grant access to an object.
	//
	//    * SACLs, which are used by administrators to log attempts to access a
	//    secured object. Copying SACLs requires granting additional permissions
	//    to the Windows user that DataSync uses to access your SMB location. For
	//    information about choosing a user that ensures sufficient permissions
	//    to files, folders, and metadata, see user (create-smb-location.html#SMBuser).
	//
	// NONE: None of the SMB security descriptor components are copied. Destination
	// objects are owned by the user that was provided for accessing the destination
	// location. DACLs and SACLs are set based on the destination server’s configuration.
	SecurityDescriptorCopyFlags *string `type:"string" enum:"SmbSecurityDescriptorCopyFlags"`

	// Specifies whether tasks should be queued before executing the tasks. The
	// default is ENABLED, which means the tasks will be queued.
	//
	// If you use the same agent to run multiple tasks, you can enable the tasks
	// to run in series. For more information, see Queueing task executions (https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution).
	TaskQueueing *string `type:"string" enum:"TaskQueueing"`

	// Determines whether DataSync transfers only the data and metadata that differ
	// between the source and the destination location or transfers all the content
	// from the source (without comparing what's in the destination).
	//
	// CHANGED: DataSync copies only data or metadata that is new or different content
	// from the source location to the destination location.
	//
	// ALL: DataSync copies all source location content to the destination (without
	// comparing what's in the destination).
	TransferMode *string `type:"string" enum:"TransferMode"`

	// Specifies the POSIX user ID (UID) of the file's owner.
	//
	// For more information, see Metadata copied by DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
	//
	// Default value: INT_VALUE. This preserves the integer value of the ID.
	//
	// INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).
	//
	// NONE: Ignore UID and GID.
	Uid *string `type:"string" enum:"Uid"`

	// Specifies how and when DataSync checks the integrity of your data during
	// a transfer.
	//
	// Default value: POINT_IN_TIME_CONSISTENT
	//
	// ONLY_FILES_TRANSFERRED (recommended): DataSync calculates the checksum of
	// transferred files and metadata at the source location. At the end of the
	// transfer, DataSync then compares this checksum to the checksum calculated
	// on those files at the destination.
	//
	// We recommend this option when transferring to S3 Glacier Flexible Retrieval
	// or S3 Glacier Deep Archive storage classes. For more information, see Storage
	// class considerations with Amazon S3 locations (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	//
	// POINT_IN_TIME_CONSISTENT: At the end of the transfer, DataSync scans the
	// entire source and destination to verify that both locations are fully synchronized.
	//
	// You can't use this option when transferring to S3 Glacier Flexible Retrieval
	// or S3 Glacier Deep Archive storage classes. For more information, see Storage
	// class considerations with Amazon S3 locations (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	//
	// NONE: DataSync doesn't run additional verification at the end of the transfer.
	// All data transmissions are still integrity-checked with checksum verification
	// during the transfer.
	VerifyMode *string `type:"string" enum:"VerifyMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Options) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Options) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Options) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Options"}
	if s.BytesPerSecond != nil && *s.BytesPerSecond < -1 {
		invalidParams.Add(request.NewErrParamMinValue("BytesPerSecond", -1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAtime sets the Atime field's value.
func (s *Options) SetAtime(v string) *Options {
	s.Atime = &v
	return s
}

// SetBytesPerSecond sets the BytesPerSecond field's value.
func (s *Options) SetBytesPerSecond(v int64) *Options {
	s.BytesPerSecond = &v
	return s
}

// SetGid sets the Gid field's value.
func (s *Options) SetGid(v string) *Options {
	s.Gid = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *Options) SetLogLevel(v string) *Options {
	s.LogLevel = &v
	return s
}

// SetMtime sets the Mtime field's value.
func (s *Options) SetMtime(v string) *Options {
	s.Mtime = &v
	return s
}

// SetObjectTags sets the ObjectTags field's value.
func (s *Options) SetObjectTags(v string) *Options {
	s.ObjectTags = &v
	return s
}

// SetOverwriteMode sets the OverwriteMode field's value.
func (s *Options) SetOverwriteMode(v string) *Options {
	s.OverwriteMode = &v
	return s
}

// SetPosixPermissions sets the PosixPermissions field's value.
func (s *Options) SetPosixPermissions(v string) *Options {
	s.PosixPermissions = &v
	return s
}

// SetPreserveDeletedFiles sets the PreserveDeletedFiles field's value.
func (s *Options) SetPreserveDeletedFiles(v string) *Options {
	s.PreserveDeletedFiles = &v
	return s
}

// SetPreserveDevices sets the PreserveDevices field's value.
func (s *Options) SetPreserveDevices(v string) *Options {
	s.PreserveDevices = &v
	return s
}

// SetSecurityDescriptorCopyFlags sets the SecurityDescriptorCopyFlags field's value.
func (s *Options) SetSecurityDescriptorCopyFlags(v string) *Options {
	s.SecurityDescriptorCopyFlags = &v
	return s
}

// SetTaskQueueing sets the TaskQueueing field's value.
func (s *Options) SetTaskQueueing(v string) *Options {
	s.TaskQueueing = &v
	return s
}

// SetTransferMode sets the TransferMode field's value.
func (s *Options) SetTransferMode(v string) *Options {
	s.TransferMode = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *Options) SetUid(v string) *Options {
	s.Uid = &v
	return s
}

// SetVerifyMode sets the VerifyMode field's value.
func (s *Options) SetVerifyMode(v string) *Options {
	s.VerifyMode = &v
	return s
}

// The types of performance data that DataSync Discovery collects about an on-premises
// storage system resource.
type P95Metrics struct {
	_ struct{} `type:"structure"`

	// The IOPS peaks for an on-premises storage system resource. Each data point
	// represents the 95th percentile peak value during a 1-hour interval.
	IOPS *IOPS `type:"structure"`

	// The latency peaks for an on-premises storage system resource. Each data point
	// represents the 95th percentile peak value during a 1-hour interval.
	Latency *Latency `type:"structure"`

	// The throughput peaks for an on-premises storage system resource. Each data
	// point represents the 95th percentile peak value during a 1-hour interval.
	Throughput *Throughput `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s P95Metrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s P95Metrics) GoString() string {
	return s.String()
}

// SetIOPS sets the IOPS field's value.
func (s *P95Metrics) SetIOPS(v *IOPS) *P95Metrics {
	s.IOPS = v
	return s
}

// SetLatency sets the Latency field's value.
func (s *P95Metrics) SetLatency(v *Latency) *P95Metrics {
	s.Latency = v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *P95Metrics) SetThroughput(v *Throughput) *P95Metrics {
	s.Throughput = v
	return s
}

// The VPC endpoint, subnet, and security group that an agent uses to access
// IP addresses in a VPC (Virtual Private Cloud).
type PrivateLinkConfig struct {
	_ struct{} `type:"structure"`

	// The private endpoint that is configured for an agent that has access to IP
	// addresses in a PrivateLink (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html).
	// An agent that is configured with this endpoint will not be accessible over
	// the public internet.
	PrivateLinkEndpoint *string `min:"7" type:"string"`

	// The Amazon Resource Names (ARNs) of the security groups that are configured
	// for the EC2 resource that hosts an agent activated in a VPC or an agent that
	// has access to a VPC endpoint.
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The Amazon Resource Names (ARNs) of the subnets that are configured for an
	// agent activated in a VPC or an agent that has access to a VPC endpoint.
	SubnetArns []*string `min:"1" type:"list"`

	// The ID of the VPC endpoint that is configured for an agent. An agent that
	// is configured with a VPC endpoint will not be accessible over the public
	// internet.
	VpcEndpointId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateLinkConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateLinkConfig) GoString() string {
	return s.String()
}

// SetPrivateLinkEndpoint sets the PrivateLinkEndpoint field's value.
func (s *PrivateLinkConfig) SetPrivateLinkEndpoint(v string) *PrivateLinkConfig {
	s.PrivateLinkEndpoint = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *PrivateLinkConfig) SetSecurityGroupArns(v []*string) *PrivateLinkConfig {
	s.SecurityGroupArns = v
	return s
}

// SetSubnetArns sets the SubnetArns field's value.
func (s *PrivateLinkConfig) SetSubnetArns(v []*string) *PrivateLinkConfig {
	s.SubnetArns = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *PrivateLinkConfig) SetVpcEndpointId(v string) *PrivateLinkConfig {
	s.VpcEndpointId = &v
	return s
}

// The Quality of Protection (QOP) configuration specifies the Remote Procedure
// Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed
// File System (HDFS) cluster.
type QopConfiguration struct {
	_ struct{} `type:"structure"`

	// The data transfer protection setting configured on the HDFS cluster. This
	// setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml
	// file on your Hadoop cluster.
	DataTransferProtection *string `type:"string" enum:"HdfsDataTransferProtection"`

	// The RPC protection setting configured on the HDFS cluster. This setting corresponds
	// to your hadoop.rpc.protection setting in your core-site.xml file on your
	// Hadoop cluster.
	RpcProtection *string `type:"string" enum:"HdfsRpcProtection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QopConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QopConfiguration) GoString() string {
	return s.String()
}

// SetDataTransferProtection sets the DataTransferProtection field's value.
func (s *QopConfiguration) SetDataTransferProtection(v string) *QopConfiguration {
	s.DataTransferProtection = &v
	return s
}

// SetRpcProtection sets the RpcProtection field's value.
func (s *QopConfiguration) SetRpcProtection(v string) *QopConfiguration {
	s.RpcProtection = &v
	return s
}

// The details about an Amazon Web Services storage service that DataSync Discovery
// recommends for a resource in your on-premises storage system.
//
// For more information, see Recommendations provided by DataSync Discovery
// (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The estimated monthly cost of the recommended Amazon Web Services storage
	// service.
	EstimatedMonthlyStorageCost *string `type:"string"`

	// Information about how you can set up a recommended Amazon Web Services storage
	// service.
	StorageConfiguration map[string]*string `type:"map"`

	// A recommended Amazon Web Services storage service that you can migrate data
	// to based on information that DataSync Discovery collects about your on-premises
	// storage system.
	StorageType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetEstimatedMonthlyStorageCost sets the EstimatedMonthlyStorageCost field's value.
func (s *Recommendation) SetEstimatedMonthlyStorageCost(v string) *Recommendation {
	s.EstimatedMonthlyStorageCost = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *Recommendation) SetStorageConfiguration(v map[string]*string) *Recommendation {
	s.StorageConfiguration = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *Recommendation) SetStorageType(v string) *Recommendation {
	s.StorageType = &v
	return s
}

type RemoveStorageSystemInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the storage system that you want
	// to permanently remove from DataSync Discovery.
	//
	// StorageSystemArn is a required field
	StorageSystemArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveStorageSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveStorageSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveStorageSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveStorageSystemInput"}
	if s.StorageSystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageSystemArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *RemoveStorageSystemInput) SetStorageSystemArn(v string) *RemoveStorageSystemInput {
	s.StorageSystemArn = &v
	return s
}

type RemoveStorageSystemOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveStorageSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveStorageSystemOutput) GoString() string {
	return s.String()
}

// Information provided by DataSync Discovery about the resources in your on-premises
// storage system.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// The information that DataSync Discovery collects about the cluster in your
	// on-premises storage system.
	NetAppONTAPClusters []*NetAppONTAPCluster `type:"list"`

	// The information that DataSync Discovery collects about storage virtual machines
	// (SVMs) in your on-premises storage system.
	NetAppONTAPSVMs []*NetAppONTAPSVM `type:"list"`

	// The information that DataSync Discovery collects about volumes in your on-premises
	// storage system.
	NetAppONTAPVolumes []*NetAppONTAPVolume `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) GoString() string {
	return s.String()
}

// SetNetAppONTAPClusters sets the NetAppONTAPClusters field's value.
func (s *ResourceDetails) SetNetAppONTAPClusters(v []*NetAppONTAPCluster) *ResourceDetails {
	s.NetAppONTAPClusters = v
	return s
}

// SetNetAppONTAPSVMs sets the NetAppONTAPSVMs field's value.
func (s *ResourceDetails) SetNetAppONTAPSVMs(v []*NetAppONTAPSVM) *ResourceDetails {
	s.NetAppONTAPSVMs = v
	return s
}

// SetNetAppONTAPVolumes sets the NetAppONTAPVolumes field's value.
func (s *ResourceDetails) SetNetAppONTAPVolumes(v []*NetAppONTAPVolume) *ResourceDetails {
	s.NetAppONTAPVolumes = v
	return s
}

// Information, including performance data and capacity usage, provided by DataSync
// Discovery about a resource in your on-premises storage system.
type ResourceMetrics struct {
	_ struct{} `type:"structure"`

	// The storage capacity of the on-premises storage system resource.
	Capacity *Capacity `type:"structure"`

	// The types of performance data that DataSync Discovery collects about the
	// on-premises storage system resource.
	P95Metrics *P95Metrics `type:"structure"`

	// The universally unique identifier (UUID) of the on-premises storage system
	// resource.
	ResourceId *string `type:"string"`

	// The type of on-premises storage system resource.
	ResourceType *string `type:"string" enum:"DiscoveryResourceType"`

	// The time when DataSync Discovery collected this information from the resource.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMetrics) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *ResourceMetrics) SetCapacity(v *Capacity) *ResourceMetrics {
	s.Capacity = v
	return s
}

// SetP95Metrics sets the P95Metrics field's value.
func (s *ResourceMetrics) SetP95Metrics(v *P95Metrics) *ResourceMetrics {
	s.P95Metrics = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceMetrics) SetResourceId(v string) *ResourceMetrics {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceMetrics) SetResourceType(v string) *ResourceMetrics {
	s.ResourceType = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *ResourceMetrics) SetTimestamp(v time.Time) *ResourceMetrics {
	s.Timestamp = &v
	return s
}

// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
// role used to access an Amazon S3 bucket.
//
// For detailed information about using such a role, see Creating a Location
// for Amazon S3 in the DataSync User Guide.
type S3Config struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role for accessing the S3 bucket.
	//
	// BucketAccessRoleArn is a required field
	BucketAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.BucketAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketAccessRoleArn sets the BucketAccessRoleArn field's value.
func (s *S3Config) SetBucketAccessRoleArn(v string) *S3Config {
	s.BucketAccessRoleArn = &v
	return s
}

// Specifies the version of the Server Message Block (SMB) protocol that DataSync
// uses to access an SMB file server.
type SmbMountOptions struct {
	_ struct{} `type:"structure"`

	// By default, DataSync automatically chooses an SMB protocol version based
	// on negotiation with your SMB file server. You also can configure DataSync
	// to use a specific SMB version, but we recommend doing this only if DataSync
	// has trouble negotiating with the SMB file server automatically.
	//
	// These are the following options for configuring the SMB version:
	//
	//    * AUTOMATIC (default): DataSync and the SMB file server negotiate the
	//    highest version of SMB that they mutually support between 2.1 and 3.1.1.
	//    This is the recommended option. If you instead choose a specific version
	//    that your file server doesn't support, you may get an Operation Not Supported
	//    error.
	//
	//    * SMB3: Restricts the protocol negotiation to only SMB version 3.0.2.
	//
	//    * SMB2: Restricts the protocol negotiation to only SMB version 2.1.
	//
	//    * SMB2_0: Restricts the protocol negotiation to only SMB version 2.0.
	//
	//    * SMB1: Restricts the protocol negotiation to only SMB version 1.0. The
	//    SMB1 option isn't available when creating an Amazon FSx for NetApp ONTAP
	//    location (https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html).
	Version *string `type:"string" enum:"SmbVersion"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SmbMountOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SmbMountOptions) GoString() string {
	return s.String()
}

// SetVersion sets the Version field's value.
func (s *SmbMountOptions) SetVersion(v string) *SmbMountOptions {
	s.Version = &v
	return s
}

type StartDiscoveryJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies a client token to make sure requests with this API operation are
	// idempotent. If you don't specify a client token, DataSync generates one for
	// you automatically.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// Specifies in minutes how long you want the discovery job to run.
	//
	// For more accurate recommendations, we recommend a duration of at least 14
	// days. Longer durations allow time to collect a sufficient number of data
	// points and provide a realistic representation of storage performance and
	// utilization.
	//
	// CollectionDurationMinutes is a required field
	CollectionDurationMinutes *int64 `min:"60" type:"integer" required:"true"`

	// Specifies the Amazon Resource Name (ARN) of the on-premises storage system
	// that you want to run the discovery job on.
	//
	// StorageSystemArn is a required field
	StorageSystemArn *string `type:"string" required:"true"`

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDiscoveryJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDiscoveryJobInput"}
	if s.CollectionDurationMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionDurationMinutes"))
	}
	if s.CollectionDurationMinutes != nil && *s.CollectionDurationMinutes < 60 {
		invalidParams.Add(request.NewErrParamMinValue("CollectionDurationMinutes", 60))
	}
	if s.StorageSystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageSystemArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartDiscoveryJobInput) SetClientToken(v string) *StartDiscoveryJobInput {
	s.ClientToken = &v
	return s
}

// SetCollectionDurationMinutes sets the CollectionDurationMinutes field's value.
func (s *StartDiscoveryJobInput) SetCollectionDurationMinutes(v int64) *StartDiscoveryJobInput {
	s.CollectionDurationMinutes = &v
	return s
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *StartDiscoveryJobInput) SetStorageSystemArn(v string) *StartDiscoveryJobInput {
	s.StorageSystemArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartDiscoveryJobInput) SetTags(v []*TagListEntry) *StartDiscoveryJobInput {
	s.Tags = v
	return s
}

type StartDiscoveryJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the discovery job that you started.
	DiscoveryJobArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryJobOutput) GoString() string {
	return s.String()
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *StartDiscoveryJobOutput) SetDiscoveryJobArn(v string) *StartDiscoveryJobOutput {
	s.DiscoveryJobArn = &v
	return s
}

// StartTaskExecutionRequest
type StartTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// Specifies a list of filter rules that determines which files to exclude from
	// a task. The list contains a single filter string that consists of the patterns
	// to exclude. The patterns are delimited by "|" (that is, a pipe), for example,
	// "/folder1|/folder2".
	Excludes []*FilterRule `type:"list"`

	// Specifies a list of filter rules that determines which files to include when
	// running a task. The pattern should contain a single filter string that consists
	// of the patterns to include. The patterns are delimited by "|" (that is, a
	// pipe), for example, "/folder1|/folder2".
	Includes []*FilterRule `type:"list"`

	// Configures your DataSync task settings. These options include how DataSync
	// handles files, objects, and their associated metadata. You also can specify
	// how DataSync verifies data integrity, set bandwidth limits for your task,
	// among other options.
	//
	// Each task setting has a default value. Unless you need to, you don't have
	// to configure any of these Options before starting your task.
	OverrideOptions *Options `type:"structure"`

	// Specifies the tags that you want to apply to the Amazon Resource Name (ARN)
	// representing the task execution.
	//
	// Tags are key-value pairs that help you manage, filter, and search for your
	// DataSync resources.
	Tags []*TagListEntry `type:"list"`

	// Specifies the Amazon Resource Name (ARN) of the task that you want to start.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTaskExecutionInput"}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}
	if s.OverrideOptions != nil {
		if err := s.OverrideOptions.Validate(); err != nil {
			invalidParams.AddNested("OverrideOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludes sets the Excludes field's value.
func (s *StartTaskExecutionInput) SetExcludes(v []*FilterRule) *StartTaskExecutionInput {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *StartTaskExecutionInput) SetIncludes(v []*FilterRule) *StartTaskExecutionInput {
	s.Includes = v
	return s
}

// SetOverrideOptions sets the OverrideOptions field's value.
func (s *StartTaskExecutionInput) SetOverrideOptions(v *Options) *StartTaskExecutionInput {
	s.OverrideOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTaskExecutionInput) SetTags(v []*TagListEntry) *StartTaskExecutionInput {
	s.Tags = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *StartTaskExecutionInput) SetTaskArn(v string) *StartTaskExecutionInput {
	s.TaskArn = &v
	return s
}

// StartTaskExecutionResponse
type StartTaskExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the running task execution.
	TaskExecutionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskExecutionOutput) GoString() string {
	return s.String()
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *StartTaskExecutionOutput) SetTaskExecutionArn(v string) *StartTaskExecutionOutput {
	s.TaskExecutionArn = &v
	return s
}

type StopDiscoveryJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the discovery job that you want
	// to stop.
	//
	// DiscoveryJobArn is a required field
	DiscoveryJobArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscoveryJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscoveryJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDiscoveryJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDiscoveryJobInput"}
	if s.DiscoveryJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *StopDiscoveryJobInput) SetDiscoveryJobArn(v string) *StopDiscoveryJobInput {
	s.DiscoveryJobArn = &v
	return s
}

type StopDiscoveryJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscoveryJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscoveryJobOutput) GoString() string {
	return s.String()
}

// Information that identifies an on-premises storage system that you're using
// with DataSync Discovery.
type StorageSystemListEntry struct {
	_ struct{} `type:"structure"`

	// The name of an on-premises storage system that you added to DataSync Discovery.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Names (ARN) of an on-premises storage system that you
	// added to DataSync Discovery.
	StorageSystemArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageSystemListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageSystemListEntry) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StorageSystemListEntry) SetName(v string) *StorageSystemListEntry {
	s.Name = &v
	return s
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *StorageSystemListEntry) SetStorageSystemArn(v string) *StorageSystemListEntry {
	s.StorageSystemArn = &v
	return s
}

// A key-value pair representing a single tag that's been applied to an Amazon
// Web Services resource.
type TagListEntry struct {
	_ struct{} `type:"structure"`

	// The key for an Amazon Web Services resource tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for an Amazon Web Services resource tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagListEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagListEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagListEntry"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagListEntry) SetKey(v string) *TagListEntry {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagListEntry) SetValue(v string) *TagListEntry {
	s.Value = &v
	return s
}

// TagResourceRequest
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the resource to apply the tag
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// Specifies the tags that you want to apply to the resource.
	//
	// Tags is a required field
	Tags []*TagListEntry `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*TagListEntry) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Represents a single entry in a list of task executions. TaskExecutionListEntry
// returns an array that contains a list of specific invocations of a task when
// the ListTaskExecutions (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTaskExecutions.html)
// operation is called.
type TaskExecutionListEntry struct {
	_ struct{} `type:"structure"`

	// The status of a task execution.
	Status *string `type:"string" enum:"TaskExecutionStatus"`

	// The Amazon Resource Name (ARN) of the task that was executed.
	TaskExecutionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskExecutionListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskExecutionListEntry) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *TaskExecutionListEntry) SetStatus(v string) *TaskExecutionListEntry {
	s.Status = &v
	return s
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *TaskExecutionListEntry) SetTaskExecutionArn(v string) *TaskExecutionListEntry {
	s.TaskExecutionArn = &v
	return s
}

// Describes the detailed result of a TaskExecution operation. This result includes
// the time in milliseconds spent in each phase, the status of the task execution,
// and the errors encountered.
type TaskExecutionResultDetail struct {
	_ struct{} `type:"structure"`

	// Errors that DataSync encountered during execution of the task. You can use
	// this error code to help troubleshoot issues.
	ErrorCode *string `type:"string"`

	// Detailed description of an error that was encountered during the task execution.
	// You can use this information to help troubleshoot issues.
	ErrorDetail *string `type:"string"`

	// The total time in milliseconds that DataSync spent in the PREPARING phase.
	PrepareDuration *int64 `type:"long"`

	// The status of the PREPARING phase.
	PrepareStatus *string `type:"string" enum:"PhaseStatus"`

	// The total time in milliseconds that DataSync took to transfer the file from
	// the source to the destination location.
	TotalDuration *int64 `type:"long"`

	// The total time in milliseconds that DataSync spent in the TRANSFERRING phase.
	TransferDuration *int64 `type:"long"`

	// The status of the TRANSFERRING phase.
	TransferStatus *string `type:"string" enum:"PhaseStatus"`

	// The total time in milliseconds that DataSync spent in the VERIFYING phase.
	VerifyDuration *int64 `type:"long"`

	// The status of the VERIFYING phase.
	VerifyStatus *string `type:"string" enum:"PhaseStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskExecutionResultDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskExecutionResultDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *TaskExecutionResultDetail) SetErrorCode(v string) *TaskExecutionResultDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *TaskExecutionResultDetail) SetErrorDetail(v string) *TaskExecutionResultDetail {
	s.ErrorDetail = &v
	return s
}

// SetPrepareDuration sets the PrepareDuration field's value.
func (s *TaskExecutionResultDetail) SetPrepareDuration(v int64) *TaskExecutionResultDetail {
	s.PrepareDuration = &v
	return s
}

// SetPrepareStatus sets the PrepareStatus field's value.
func (s *TaskExecutionResultDetail) SetPrepareStatus(v string) *TaskExecutionResultDetail {
	s.PrepareStatus = &v
	return s
}

// SetTotalDuration sets the TotalDuration field's value.
func (s *TaskExecutionResultDetail) SetTotalDuration(v int64) *TaskExecutionResultDetail {
	s.TotalDuration = &v
	return s
}

// SetTransferDuration sets the TransferDuration field's value.
func (s *TaskExecutionResultDetail) SetTransferDuration(v int64) *TaskExecutionResultDetail {
	s.TransferDuration = &v
	return s
}

// SetTransferStatus sets the TransferStatus field's value.
func (s *TaskExecutionResultDetail) SetTransferStatus(v string) *TaskExecutionResultDetail {
	s.TransferStatus = &v
	return s
}

// SetVerifyDuration sets the VerifyDuration field's value.
func (s *TaskExecutionResultDetail) SetVerifyDuration(v int64) *TaskExecutionResultDetail {
	s.VerifyDuration = &v
	return s
}

// SetVerifyStatus sets the VerifyStatus field's value.
func (s *TaskExecutionResultDetail) SetVerifyStatus(v string) *TaskExecutionResultDetail {
	s.VerifyStatus = &v
	return s
}

// You can use API filters to narrow down the list of resources returned by
// ListTasks. For example, to retrieve all tasks on a source location, you can
// use ListTasks with filter name LocationId and Operator Equals with the ARN
// for the location.
//
// For more information, see filtering DataSync resources (https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html).
type TaskFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter being used. Each API call supports a list of filters
	// that are available for it. For example, LocationId for ListTasks.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"TaskFilterName"`

	// The operator that is used to compare filter values (for example, Equals or
	// Contains).
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"Operator"`

	// The values that you want to filter for. For example, you might want to display
	// only tasks for a specific destination location.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TaskFilter) SetName(v string) *TaskFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *TaskFilter) SetOperator(v string) *TaskFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TaskFilter) SetValues(v []*string) *TaskFilter {
	s.Values = v
	return s
}

// Represents a single entry in a list of tasks. TaskListEntry returns an array
// that contains a list of tasks when the ListTasks (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTasks.html)
// operation is called. A task includes the source and destination file systems
// to sync and the options to use for the tasks.
type TaskListEntry struct {
	_ struct{} `type:"structure"`

	// The name of the task.
	Name *string `min:"1" type:"string"`

	// The status of the task.
	Status *string `type:"string" enum:"TaskStatus"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskListEntry) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TaskListEntry) SetName(v string) *TaskListEntry {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskListEntry) SetStatus(v string) *TaskListEntry {
	s.Status = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *TaskListEntry) SetTaskArn(v string) *TaskListEntry {
	s.TaskArn = &v
	return s
}

// Specifies the schedule you want your task to use for repeated executions.
// For more information, see Schedule Expressions for Rules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
type TaskSchedule struct {
	_ struct{} `type:"structure"`

	// A cron expression that specifies when DataSync initiates a scheduled transfer
	// from a source to a destination location.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskSchedule"}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *TaskSchedule) SetScheduleExpression(v string) *TaskSchedule {
	s.ScheduleExpression = &v
	return s
}

// The throughput peaks for an on-premises storage system volume. Each data
// point represents the 95th percentile peak value during a 1-hour interval.
type Throughput struct {
	_ struct{} `type:"structure"`

	// Peak throughput unrelated to read and write operations.
	Other *float64 `type:"double"`

	// Peak throughput related to read operations.
	Read *float64 `type:"double"`

	// Peak total throughput on your on-premises storage system resource.
	Total *float64 `type:"double"`

	// Peak throughput related to write operations.
	Write *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Throughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Throughput) GoString() string {
	return s.String()
}

// SetOther sets the Other field's value.
func (s *Throughput) SetOther(v float64) *Throughput {
	s.Other = &v
	return s
}

// SetRead sets the Read field's value.
func (s *Throughput) SetRead(v float64) *Throughput {
	s.Read = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *Throughput) SetTotal(v float64) *Throughput {
	s.Total = &v
	return s
}

// SetWrite sets the Write field's value.
func (s *Throughput) SetWrite(v float64) *Throughput {
	s.Write = &v
	return s
}

// UntagResourceRequest
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the keys in the tags that you want to remove.
	//
	// Keys is a required field
	Keys []*string `min:"1" type:"list" required:"true"`

	// Specifies the Amazon Resource Name (ARN) of the resource to remove the tags
	// from.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("Keys"))
	}
	if s.Keys != nil && len(s.Keys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keys", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeys sets the Keys field's value.
func (s *UntagResourceInput) SetKeys(v []*string) *UntagResourceInput {
	s.Keys = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// UpdateAgentRequest
type UpdateAgentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent to update.
	//
	// AgentArn is a required field
	AgentArn *string `type:"string" required:"true"`

	// The name that you want to use to configure the agent.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentInput"}
	if s.AgentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArn sets the AgentArn field's value.
func (s *UpdateAgentInput) SetAgentArn(v string) *UpdateAgentInput {
	s.AgentArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAgentInput) SetName(v string) *UpdateAgentInput {
	s.Name = &v
	return s
}

type UpdateAgentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentOutput) GoString() string {
	return s.String()
}

type UpdateDiscoveryJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies in minutes how long that you want the discovery job to run. (You
	// can't set this parameter to less than the number of minutes that the job
	// has already run for.)
	//
	// CollectionDurationMinutes is a required field
	CollectionDurationMinutes *int64 `min:"60" type:"integer" required:"true"`

	// Specifies the Amazon Resource Name (ARN) of the discovery job that you want
	// to update.
	//
	// DiscoveryJobArn is a required field
	DiscoveryJobArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscoveryJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscoveryJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDiscoveryJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDiscoveryJobInput"}
	if s.CollectionDurationMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionDurationMinutes"))
	}
	if s.CollectionDurationMinutes != nil && *s.CollectionDurationMinutes < 60 {
		invalidParams.Add(request.NewErrParamMinValue("CollectionDurationMinutes", 60))
	}
	if s.DiscoveryJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionDurationMinutes sets the CollectionDurationMinutes field's value.
func (s *UpdateDiscoveryJobInput) SetCollectionDurationMinutes(v int64) *UpdateDiscoveryJobInput {
	s.CollectionDurationMinutes = &v
	return s
}

// SetDiscoveryJobArn sets the DiscoveryJobArn field's value.
func (s *UpdateDiscoveryJobInput) SetDiscoveryJobArn(v string) *UpdateDiscoveryJobInput {
	s.DiscoveryJobArn = &v
	return s
}

type UpdateDiscoveryJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscoveryJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscoveryJobOutput) GoString() string {
	return s.String()
}

type UpdateLocationHdfsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the agents that are used to connect to the HDFS cluster.
	AgentArns []*string `min:"1" type:"list"`

	// The type of authentication used to determine the identity of the user.
	AuthenticationType *string `type:"string" enum:"HdfsAuthenticationType"`

	// The size of the data blocks to write into the HDFS cluster.
	BlockSize *int64 `min:"1.048576e+06" type:"integer"`

	// The Kerberos key table (keytab) that contains mappings between the defined
	// Kerberos principal and the encrypted keys. You can load the keytab from a
	// file by providing the file's address. If you use the CLI, it performs base64
	// encoding for you. Otherwise, provide the base64-encoded text.
	// KerberosKeytab is automatically base64 encoded/decoded by the SDK.
	KerberosKeytab []byte `type:"blob"`

	// The krb5.conf file that contains the Kerberos configuration information.
	// You can load the krb5.conf file by providing the file's address. If you're
	// using the CLI, it performs the base64 encoding for you. Otherwise, provide
	// the base64-encoded text.
	// KerberosKrb5Conf is automatically base64 encoded/decoded by the SDK.
	KerberosKrb5Conf []byte `type:"blob"`

	// The Kerberos principal with access to the files and folders on the HDFS cluster.
	KerberosPrincipal *string `min:"1" type:"string"`

	// The URI of the HDFS cluster's Key Management Server (KMS).
	KmsKeyProviderUri *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the source HDFS cluster location.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`

	// The NameNode that manages the HDFS namespace. The NameNode performs operations
	// such as opening, closing, and renaming files and directories. The NameNode
	// contains the information to map blocks of data to the DataNodes. You can
	// use only one NameNode.
	NameNodes []*HdfsNameNode `min:"1" type:"list"`

	// The Quality of Protection (QOP) configuration specifies the Remote Procedure
	// Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed
	// File System (HDFS) cluster.
	QopConfiguration *QopConfiguration `type:"structure"`

	// The number of DataNodes to replicate the data to when writing to the HDFS
	// cluster.
	ReplicationFactor *int64 `min:"1" type:"integer"`

	// The user name used to identify the client on the host operating system.
	SimpleUser *string `min:"1" type:"string"`

	// A subdirectory in the HDFS cluster. This subdirectory is used to read data
	// from or write data to the HDFS cluster.
	Subdirectory *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationHdfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationHdfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLocationHdfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLocationHdfsInput"}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.BlockSize != nil && *s.BlockSize < 1.048576e+06 {
		invalidParams.Add(request.NewErrParamMinValue("BlockSize", 1.048576e+06))
	}
	if s.KerberosPrincipal != nil && len(*s.KerberosPrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KerberosPrincipal", 1))
	}
	if s.KmsKeyProviderUri != nil && len(*s.KmsKeyProviderUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyProviderUri", 1))
	}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}
	if s.NameNodes != nil && len(s.NameNodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameNodes", 1))
	}
	if s.ReplicationFactor != nil && *s.ReplicationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReplicationFactor", 1))
	}
	if s.SimpleUser != nil && len(*s.SimpleUser) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SimpleUser", 1))
	}
	if s.NameNodes != nil {
		for i, v := range s.NameNodes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NameNodes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *UpdateLocationHdfsInput) SetAgentArns(v []*string) *UpdateLocationHdfsInput {
	s.AgentArns = v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *UpdateLocationHdfsInput) SetAuthenticationType(v string) *UpdateLocationHdfsInput {
	s.AuthenticationType = &v
	return s
}

// SetBlockSize sets the BlockSize field's value.
func (s *UpdateLocationHdfsInput) SetBlockSize(v int64) *UpdateLocationHdfsInput {
	s.BlockSize = &v
	return s
}

// SetKerberosKeytab sets the KerberosKeytab field's value.
func (s *UpdateLocationHdfsInput) SetKerberosKeytab(v []byte) *UpdateLocationHdfsInput {
	s.KerberosKeytab = v
	return s
}

// SetKerberosKrb5Conf sets the KerberosKrb5Conf field's value.
func (s *UpdateLocationHdfsInput) SetKerberosKrb5Conf(v []byte) *UpdateLocationHdfsInput {
	s.KerberosKrb5Conf = v
	return s
}

// SetKerberosPrincipal sets the KerberosPrincipal field's value.
func (s *UpdateLocationHdfsInput) SetKerberosPrincipal(v string) *UpdateLocationHdfsInput {
	s.KerberosPrincipal = &v
	return s
}

// SetKmsKeyProviderUri sets the KmsKeyProviderUri field's value.
func (s *UpdateLocationHdfsInput) SetKmsKeyProviderUri(v string) *UpdateLocationHdfsInput {
	s.KmsKeyProviderUri = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *UpdateLocationHdfsInput) SetLocationArn(v string) *UpdateLocationHdfsInput {
	s.LocationArn = &v
	return s
}

// SetNameNodes sets the NameNodes field's value.
func (s *UpdateLocationHdfsInput) SetNameNodes(v []*HdfsNameNode) *UpdateLocationHdfsInput {
	s.NameNodes = v
	return s
}

// SetQopConfiguration sets the QopConfiguration field's value.
func (s *UpdateLocationHdfsInput) SetQopConfiguration(v *QopConfiguration) *UpdateLocationHdfsInput {
	s.QopConfiguration = v
	return s
}

// SetReplicationFactor sets the ReplicationFactor field's value.
func (s *UpdateLocationHdfsInput) SetReplicationFactor(v int64) *UpdateLocationHdfsInput {
	s.ReplicationFactor = &v
	return s
}

// SetSimpleUser sets the SimpleUser field's value.
func (s *UpdateLocationHdfsInput) SetSimpleUser(v string) *UpdateLocationHdfsInput {
	s.SimpleUser = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *UpdateLocationHdfsInput) SetSubdirectory(v string) *UpdateLocationHdfsInput {
	s.Subdirectory = &v
	return s
}

type UpdateLocationHdfsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationHdfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationHdfsOutput) GoString() string {
	return s.String()
}

type UpdateLocationNfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the NFS location to update.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`

	// Specifies how DataSync can access a location using the NFS protocol.
	MountOptions *NfsMountOptions `type:"structure"`

	// A list of Amazon Resource Names (ARNs) of agents to use for a Network File
	// System (NFS) location.
	OnPremConfig *OnPremConfig `type:"structure"`

	// The subdirectory in the NFS file system that is used to read data from the
	// NFS source location or write data to the NFS destination. The NFS path should
	// be a path that's exported by the NFS server, or a subdirectory of that path.
	// The path should be such that it can be mounted by other NFS clients in your
	// network.
	//
	// To see all the paths exported by your NFS server, run "showmount -e nfs-server-name"
	// from an NFS client that has access to your server. You can specify any directory
	// that appears in the results, and any subdirectory of that directory. Ensure
	// that the NFS export is accessible without Kerberos authentication.
	//
	// To transfer all the data in the folder that you specified, DataSync must
	// have permissions to read all the data. To ensure this, either configure the
	// NFS export with no_root_squash, or ensure that the files you want DataSync
	// to access have permissions that allow read access for all users. Doing either
	// option enables the agent to read the files. For the agent to access directories,
	// you must additionally enable all execute access.
	//
	// If you are copying data to or from your Snowcone device, see NFS Server on
	// Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// For information about NFS export configuration, see 18.7. The /etc/exports
	// Configuration File in the Red Hat Enterprise Linux documentation.
	Subdirectory *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationNfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationNfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLocationNfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLocationNfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}
	if s.OnPremConfig != nil {
		if err := s.OnPremConfig.Validate(); err != nil {
			invalidParams.AddNested("OnPremConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *UpdateLocationNfsInput) SetLocationArn(v string) *UpdateLocationNfsInput {
	s.LocationArn = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *UpdateLocationNfsInput) SetMountOptions(v *NfsMountOptions) *UpdateLocationNfsInput {
	s.MountOptions = v
	return s
}

// SetOnPremConfig sets the OnPremConfig field's value.
func (s *UpdateLocationNfsInput) SetOnPremConfig(v *OnPremConfig) *UpdateLocationNfsInput {
	s.OnPremConfig = v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *UpdateLocationNfsInput) SetSubdirectory(v string) *UpdateLocationNfsInput {
	s.Subdirectory = &v
	return s
}

type UpdateLocationNfsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationNfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationNfsOutput) GoString() string {
	return s.String()
}

type UpdateLocationObjectStorageInput struct {
	_ struct{} `type:"structure"`

	// Specifies the access key (for example, a user name) if credentials are required
	// to authenticate with the object storage server.
	AccessKey *string `min:"1" type:"string"`

	// Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can
	// securely connect with your location.
	AgentArns []*string `min:"1" type:"list"`

	// Specifies the ARN of the object storage system location that you're updating.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`

	// Specifies the secret key (for example, a password) if credentials are required
	// to authenticate with the object storage server.
	//
	// SecretKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateLocationObjectStorageInput's
	// String and GoString methods.
	SecretKey *string `min:"1" type:"string" sensitive:"true"`

	// Specifies a certificate to authenticate with an object storage system that
	// uses a private or self-signed certificate authority (CA). You must specify
	// a Base64-encoded .pem file (for example, file:///home/user/.ssh/storage_sys_certificate.pem).
	// The certificate can be up to 32768 bytes (before Base64 encoding).
	//
	// To use this parameter, configure ServerProtocol to HTTPS.
	//
	// Updating the certificate doesn't interfere with tasks that you have in progress.
	// ServerCertificate is automatically base64 encoded/decoded by the SDK.
	ServerCertificate []byte `type:"blob"`

	// Specifies the port that your object storage server accepts inbound network
	// traffic on (for example, port 443).
	ServerPort *int64 `min:"1" type:"integer"`

	// Specifies the protocol that your object storage server uses to communicate.
	ServerProtocol *string `type:"string" enum:"ObjectStorageServerProtocol"`

	// Specifies the object prefix for your object storage server. If this is a
	// source location, DataSync only copies objects with this prefix. If this is
	// a destination location, DataSync writes all objects with this prefix.
	Subdirectory *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationObjectStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationObjectStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLocationObjectStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLocationObjectStorageInput"}
	if s.AccessKey != nil && len(*s.AccessKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKey", 1))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}
	if s.SecretKey != nil && len(*s.SecretKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretKey", 1))
	}
	if s.ServerPort != nil && *s.ServerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ServerPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *UpdateLocationObjectStorageInput) SetAccessKey(v string) *UpdateLocationObjectStorageInput {
	s.AccessKey = &v
	return s
}

// SetAgentArns sets the AgentArns field's value.
func (s *UpdateLocationObjectStorageInput) SetAgentArns(v []*string) *UpdateLocationObjectStorageInput {
	s.AgentArns = v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *UpdateLocationObjectStorageInput) SetLocationArn(v string) *UpdateLocationObjectStorageInput {
	s.LocationArn = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *UpdateLocationObjectStorageInput) SetSecretKey(v string) *UpdateLocationObjectStorageInput {
	s.SecretKey = &v
	return s
}

// SetServerCertificate sets the ServerCertificate field's value.
func (s *UpdateLocationObjectStorageInput) SetServerCertificate(v []byte) *UpdateLocationObjectStorageInput {
	s.ServerCertificate = v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *UpdateLocationObjectStorageInput) SetServerPort(v int64) *UpdateLocationObjectStorageInput {
	s.ServerPort = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *UpdateLocationObjectStorageInput) SetServerProtocol(v string) *UpdateLocationObjectStorageInput {
	s.ServerProtocol = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *UpdateLocationObjectStorageInput) SetSubdirectory(v string) *UpdateLocationObjectStorageInput {
	s.Subdirectory = &v
	return s
}

type UpdateLocationObjectStorageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationObjectStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationObjectStorageOutput) GoString() string {
	return s.String()
}

type UpdateLocationSmbInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block
	// (SMB) location.
	AgentArns []*string `min:"1" type:"list"`

	// The name of the Windows domain that the SMB server belongs to.
	Domain *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SMB location to update.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`

	// Specifies the version of the Server Message Block (SMB) protocol that DataSync
	// uses to access an SMB file server.
	MountOptions *SmbMountOptions `type:"structure"`

	// The password of the user who can mount the share has the permissions to access
	// files and folders in the SMB share.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateLocationSmbInput's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// The subdirectory in the SMB file system that is used to read data from the
	// SMB source location or write data to the SMB destination. The SMB path should
	// be a path that's exported by the SMB server, or a subdirectory of that path.
	// The path should be such that it can be mounted by other SMB clients in your
	// network.
	//
	// Subdirectory must be specified with forward slashes. For example, /path/to/folder.
	//
	// To transfer all the data in the folder that you specified, DataSync must
	// have permissions to mount the SMB share and to access all the data in that
	// share. To ensure this, do either of the following:
	//
	//    * Ensure that the user/password specified belongs to the user who can
	//    mount the share and who has the appropriate permissions for all of the
	//    files and directories that you want DataSync to access.
	//
	//    * Use credentials of a member of the Backup Operators group to mount the
	//    share.
	//
	// Doing either of these options enables the agent to access the data. For the
	// agent to access directories, you must also enable all execute access.
	Subdirectory *string `type:"string"`

	// The user who can mount the share has the permissions to access files and
	// folders in the SMB share.
	User *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationSmbInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationSmbInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLocationSmbInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLocationSmbInput"}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *UpdateLocationSmbInput) SetAgentArns(v []*string) *UpdateLocationSmbInput {
	s.AgentArns = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UpdateLocationSmbInput) SetDomain(v string) *UpdateLocationSmbInput {
	s.Domain = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *UpdateLocationSmbInput) SetLocationArn(v string) *UpdateLocationSmbInput {
	s.LocationArn = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *UpdateLocationSmbInput) SetMountOptions(v *SmbMountOptions) *UpdateLocationSmbInput {
	s.MountOptions = v
	return s
}

// SetPassword sets the Password field's value.
func (s *UpdateLocationSmbInput) SetPassword(v string) *UpdateLocationSmbInput {
	s.Password = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *UpdateLocationSmbInput) SetSubdirectory(v string) *UpdateLocationSmbInput {
	s.Subdirectory = &v
	return s
}

// SetUser sets the User field's value.
func (s *UpdateLocationSmbInput) SetUser(v string) *UpdateLocationSmbInput {
	s.User = &v
	return s
}

type UpdateLocationSmbOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationSmbOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLocationSmbOutput) GoString() string {
	return s.String()
}

type UpdateStorageSystemInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects
	// to and reads your on-premises storage system.
	AgentArns []*string `min:"1" type:"list"`

	// Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging
	// discovery job events.
	CloudWatchLogGroupArn *string `type:"string"`

	// Specifies the user name and password for accessing your on-premises storage
	// system's management interface.
	Credentials *Credentials `type:"structure"`

	// Specifies a familiar name for your on-premises storage system.
	Name *string `min:"1" type:"string"`

	// Specifies the server name and network port required to connect with your
	// on-premises storage system's management interface.
	ServerConfiguration *DiscoveryServerConfiguration `type:"structure"`

	// Specifies the ARN of the on-premises storage system that you want reconfigure.
	//
	// StorageSystemArn is a required field
	StorageSystemArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStorageSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStorageSystemInput"}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StorageSystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageSystemArn"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerConfiguration != nil {
		if err := s.ServerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *UpdateStorageSystemInput) SetAgentArns(v []*string) *UpdateStorageSystemInput {
	s.AgentArns = v
	return s
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *UpdateStorageSystemInput) SetCloudWatchLogGroupArn(v string) *UpdateStorageSystemInput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *UpdateStorageSystemInput) SetCredentials(v *Credentials) *UpdateStorageSystemInput {
	s.Credentials = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStorageSystemInput) SetName(v string) *UpdateStorageSystemInput {
	s.Name = &v
	return s
}

// SetServerConfiguration sets the ServerConfiguration field's value.
func (s *UpdateStorageSystemInput) SetServerConfiguration(v *DiscoveryServerConfiguration) *UpdateStorageSystemInput {
	s.ServerConfiguration = v
	return s
}

// SetStorageSystemArn sets the StorageSystemArn field's value.
func (s *UpdateStorageSystemInput) SetStorageSystemArn(v string) *UpdateStorageSystemInput {
	s.StorageSystemArn = &v
	return s
}

type UpdateStorageSystemOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageSystemOutput) GoString() string {
	return s.String()
}

type UpdateTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// Configures your DataSync task settings. These options include how DataSync
	// handles files, objects, and their associated metadata. You also can specify
	// how DataSync verifies data integrity, set bandwidth limits for your task,
	// among other options.
	//
	// Each task setting has a default value. Unless you need to, you don't have
	// to configure any of these Options before starting your task.
	//
	// Options is a required field
	Options *Options `type:"structure" required:"true"`

	// Specifies the Amazon Resource Name (ARN) of the task execution that you're
	// updating.
	//
	// TaskExecutionArn is a required field
	TaskExecutionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTaskExecutionInput"}
	if s.Options == nil {
		invalidParams.Add(request.NewErrParamRequired("Options"))
	}
	if s.TaskExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskExecutionArn"))
	}
	if s.Options != nil {
		if err := s.Options.Validate(); err != nil {
			invalidParams.AddNested("Options", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptions sets the Options field's value.
func (s *UpdateTaskExecutionInput) SetOptions(v *Options) *UpdateTaskExecutionInput {
	s.Options = v
	return s
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *UpdateTaskExecutionInput) SetTaskExecutionArn(v string) *UpdateTaskExecutionInput {
	s.TaskExecutionArn = &v
	return s
}

type UpdateTaskExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskExecutionOutput) GoString() string {
	return s.String()
}

// UpdateTaskResponse
type UpdateTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch
	// log group.
	CloudWatchLogGroupArn *string `type:"string"`

	// Specifies a list of filter rules that exclude specific data during your transfer.
	// For more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Excludes []*FilterRule `type:"list"`

	// Specifies a list of filter rules that include specific data during your transfer.
	// For more information and examples, see Filtering data transferred by DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Includes []*FilterRule `type:"list"`

	// The name of the task to update.
	Name *string `min:"1" type:"string"`

	// Configures your DataSync task settings. These options include how DataSync
	// handles files, objects, and their associated metadata. You also can specify
	// how DataSync verifies data integrity, set bandwidth limits for your task,
	// among other options.
	//
	// Each task setting has a default value. Unless you need to, you don't have
	// to configure any of these Options before starting your task.
	Options *Options `type:"structure"`

	// Specifies a schedule used to periodically transfer files from a source to
	// a destination location. You can configure your task to execute hourly, daily,
	// weekly or on specific days of the week. You control when in the day or hour
	// you want the task to execute. The time you specify is UTC time. For more
	// information, see Scheduling your task (https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
	Schedule *TaskSchedule `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource name of the task to update.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTaskInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}
	if s.Options != nil {
		if err := s.Options.Validate(); err != nil {
			invalidParams.AddNested("Options", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *UpdateTaskInput) SetCloudWatchLogGroupArn(v string) *UpdateTaskInput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *UpdateTaskInput) SetExcludes(v []*FilterRule) *UpdateTaskInput {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *UpdateTaskInput) SetIncludes(v []*FilterRule) *UpdateTaskInput {
	s.Includes = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTaskInput) SetName(v string) *UpdateTaskInput {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *UpdateTaskInput) SetOptions(v *Options) *UpdateTaskInput {
	s.Options = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateTaskInput) SetSchedule(v *TaskSchedule) *UpdateTaskInput {
	s.Schedule = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *UpdateTaskInput) SetTaskArn(v string) *UpdateTaskInput {
	s.TaskArn = &v
	return s
}

type UpdateTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskOutput) GoString() string {
	return s.String()
}

const (
	// AgentStatusOnline is a AgentStatus enum value
	AgentStatusOnline = "ONLINE"

	// AgentStatusOffline is a AgentStatus enum value
	AgentStatusOffline = "OFFLINE"
)

// AgentStatus_Values returns all elements of the AgentStatus enum
func AgentStatus_Values() []string {
	return []string{
		AgentStatusOnline,
		AgentStatusOffline,
	}
}

const (
	// AtimeNone is a Atime enum value
	AtimeNone = "NONE"

	// AtimeBestEffort is a Atime enum value
	AtimeBestEffort = "BEST_EFFORT"
)

// Atime_Values returns all elements of the Atime enum
func Atime_Values() []string {
	return []string{
		AtimeNone,
		AtimeBestEffort,
	}
}

const (
	// DiscoveryJobStatusRunning is a DiscoveryJobStatus enum value
	DiscoveryJobStatusRunning = "RUNNING"

	// DiscoveryJobStatusWarning is a DiscoveryJobStatus enum value
	DiscoveryJobStatusWarning = "WARNING"

	// DiscoveryJobStatusTerminated is a DiscoveryJobStatus enum value
	DiscoveryJobStatusTerminated = "TERMINATED"

	// DiscoveryJobStatusFailed is a DiscoveryJobStatus enum value
	DiscoveryJobStatusFailed = "FAILED"

	// DiscoveryJobStatusStopped is a DiscoveryJobStatus enum value
	DiscoveryJobStatusStopped = "STOPPED"

	// DiscoveryJobStatusCompleted is a DiscoveryJobStatus enum value
	DiscoveryJobStatusCompleted = "COMPLETED"

	// DiscoveryJobStatusCompletedWithIssues is a DiscoveryJobStatus enum value
	DiscoveryJobStatusCompletedWithIssues = "COMPLETED_WITH_ISSUES"
)

// DiscoveryJobStatus_Values returns all elements of the DiscoveryJobStatus enum
func DiscoveryJobStatus_Values() []string {
	return []string{
		DiscoveryJobStatusRunning,
		DiscoveryJobStatusWarning,
		DiscoveryJobStatusTerminated,
		DiscoveryJobStatusFailed,
		DiscoveryJobStatusStopped,
		DiscoveryJobStatusCompleted,
		DiscoveryJobStatusCompletedWithIssues,
	}
}

const (
	// DiscoveryResourceFilterSvm is a DiscoveryResourceFilter enum value
	DiscoveryResourceFilterSvm = "SVM"
)

// DiscoveryResourceFilter_Values returns all elements of the DiscoveryResourceFilter enum
func DiscoveryResourceFilter_Values() []string {
	return []string{
		DiscoveryResourceFilterSvm,
	}
}

const (
	// DiscoveryResourceTypeSvm is a DiscoveryResourceType enum value
	DiscoveryResourceTypeSvm = "SVM"

	// DiscoveryResourceTypeVolume is a DiscoveryResourceType enum value
	DiscoveryResourceTypeVolume = "VOLUME"

	// DiscoveryResourceTypeCluster is a DiscoveryResourceType enum value
	DiscoveryResourceTypeCluster = "CLUSTER"
)

// DiscoveryResourceType_Values returns all elements of the DiscoveryResourceType enum
func DiscoveryResourceType_Values() []string {
	return []string{
		DiscoveryResourceTypeSvm,
		DiscoveryResourceTypeVolume,
		DiscoveryResourceTypeCluster,
	}
}

const (
	// DiscoverySystemTypeNetAppOntap is a DiscoverySystemType enum value
	DiscoverySystemTypeNetAppOntap = "NetAppONTAP"
)

// DiscoverySystemType_Values returns all elements of the DiscoverySystemType enum
func DiscoverySystemType_Values() []string {
	return []string{
		DiscoverySystemTypeNetAppOntap,
	}
}

const (
	// EfsInTransitEncryptionNone is a EfsInTransitEncryption enum value
	EfsInTransitEncryptionNone = "NONE"

	// EfsInTransitEncryptionTls12 is a EfsInTransitEncryption enum value
	EfsInTransitEncryptionTls12 = "TLS1_2"
)

// EfsInTransitEncryption_Values returns all elements of the EfsInTransitEncryption enum
func EfsInTransitEncryption_Values() []string {
	return []string{
		EfsInTransitEncryptionNone,
		EfsInTransitEncryptionTls12,
	}
}

const (
	// EndpointTypePublic is a EndpointType enum value
	EndpointTypePublic = "PUBLIC"

	// EndpointTypePrivateLink is a EndpointType enum value
	EndpointTypePrivateLink = "PRIVATE_LINK"

	// EndpointTypeFips is a EndpointType enum value
	EndpointTypeFips = "FIPS"
)

// EndpointType_Values returns all elements of the EndpointType enum
func EndpointType_Values() []string {
	return []string{
		EndpointTypePublic,
		EndpointTypePrivateLink,
		EndpointTypeFips,
	}
}

const (
	// FilterTypeSimplePattern is a FilterType enum value
	FilterTypeSimplePattern = "SIMPLE_PATTERN"
)

// FilterType_Values returns all elements of the FilterType enum
func FilterType_Values() []string {
	return []string{
		FilterTypeSimplePattern,
	}
}

const (
	// GidNone is a Gid enum value
	GidNone = "NONE"

	// GidIntValue is a Gid enum value
	GidIntValue = "INT_VALUE"

	// GidName is a Gid enum value
	GidName = "NAME"

	// GidBoth is a Gid enum value
	GidBoth = "BOTH"
)

// Gid_Values returns all elements of the Gid enum
func Gid_Values() []string {
	return []string{
		GidNone,
		GidIntValue,
		GidName,
		GidBoth,
	}
}

const (
	// HdfsAuthenticationTypeSimple is a HdfsAuthenticationType enum value
	HdfsAuthenticationTypeSimple = "SIMPLE"

	// HdfsAuthenticationTypeKerberos is a HdfsAuthenticationType enum value
	HdfsAuthenticationTypeKerberos = "KERBEROS"
)

// HdfsAuthenticationType_Values returns all elements of the HdfsAuthenticationType enum
func HdfsAuthenticationType_Values() []string {
	return []string{
		HdfsAuthenticationTypeSimple,
		HdfsAuthenticationTypeKerberos,
	}
}

const (
	// HdfsDataTransferProtectionDisabled is a HdfsDataTransferProtection enum value
	HdfsDataTransferProtectionDisabled = "DISABLED"

	// HdfsDataTransferProtectionAuthentication is a HdfsDataTransferProtection enum value
	HdfsDataTransferProtectionAuthentication = "AUTHENTICATION"

	// HdfsDataTransferProtectionIntegrity is a HdfsDataTransferProtection enum value
	HdfsDataTransferProtectionIntegrity = "INTEGRITY"

	// HdfsDataTransferProtectionPrivacy is a HdfsDataTransferProtection enum value
	HdfsDataTransferProtectionPrivacy = "PRIVACY"
)

// HdfsDataTransferProtection_Values returns all elements of the HdfsDataTransferProtection enum
func HdfsDataTransferProtection_Values() []string {
	return []string{
		HdfsDataTransferProtectionDisabled,
		HdfsDataTransferProtectionAuthentication,
		HdfsDataTransferProtectionIntegrity,
		HdfsDataTransferProtectionPrivacy,
	}
}

const (
	// HdfsRpcProtectionDisabled is a HdfsRpcProtection enum value
	HdfsRpcProtectionDisabled = "DISABLED"

	// HdfsRpcProtectionAuthentication is a HdfsRpcProtection enum value
	HdfsRpcProtectionAuthentication = "AUTHENTICATION"

	// HdfsRpcProtectionIntegrity is a HdfsRpcProtection enum value
	HdfsRpcProtectionIntegrity = "INTEGRITY"

	// HdfsRpcProtectionPrivacy is a HdfsRpcProtection enum value
	HdfsRpcProtectionPrivacy = "PRIVACY"
)

// HdfsRpcProtection_Values returns all elements of the HdfsRpcProtection enum
func HdfsRpcProtection_Values() []string {
	return []string{
		HdfsRpcProtectionDisabled,
		HdfsRpcProtectionAuthentication,
		HdfsRpcProtectionIntegrity,
		HdfsRpcProtectionPrivacy,
	}
}

const (
	// LocationFilterNameLocationUri is a LocationFilterName enum value
	LocationFilterNameLocationUri = "LocationUri"

	// LocationFilterNameLocationType is a LocationFilterName enum value
	LocationFilterNameLocationType = "LocationType"

	// LocationFilterNameCreationTime is a LocationFilterName enum value
	LocationFilterNameCreationTime = "CreationTime"
)

// LocationFilterName_Values returns all elements of the LocationFilterName enum
func LocationFilterName_Values() []string {
	return []string{
		LocationFilterNameLocationUri,
		LocationFilterNameLocationType,
		LocationFilterNameCreationTime,
	}
}

const (
	// LogLevelOff is a LogLevel enum value
	LogLevelOff = "OFF"

	// LogLevelBasic is a LogLevel enum value
	LogLevelBasic = "BASIC"

	// LogLevelTransfer is a LogLevel enum value
	LogLevelTransfer = "TRANSFER"
)

// LogLevel_Values returns all elements of the LogLevel enum
func LogLevel_Values() []string {
	return []string{
		LogLevelOff,
		LogLevelBasic,
		LogLevelTransfer,
	}
}

const (
	// MtimeNone is a Mtime enum value
	MtimeNone = "NONE"

	// MtimePreserve is a Mtime enum value
	MtimePreserve = "PRESERVE"
)

// Mtime_Values returns all elements of the Mtime enum
func Mtime_Values() []string {
	return []string{
		MtimeNone,
		MtimePreserve,
	}
}

const (
	// NfsVersionAutomatic is a NfsVersion enum value
	NfsVersionAutomatic = "AUTOMATIC"

	// NfsVersionNfs3 is a NfsVersion enum value
	NfsVersionNfs3 = "NFS3"

	// NfsVersionNfs40 is a NfsVersion enum value
	NfsVersionNfs40 = "NFS4_0"

	// NfsVersionNfs41 is a NfsVersion enum value
	NfsVersionNfs41 = "NFS4_1"
)

// NfsVersion_Values returns all elements of the NfsVersion enum
func NfsVersion_Values() []string {
	return []string{
		NfsVersionAutomatic,
		NfsVersionNfs3,
		NfsVersionNfs40,
		NfsVersionNfs41,
	}
}

const (
	// ObjectStorageServerProtocolHttps is a ObjectStorageServerProtocol enum value
	ObjectStorageServerProtocolHttps = "HTTPS"

	// ObjectStorageServerProtocolHttp is a ObjectStorageServerProtocol enum value
	ObjectStorageServerProtocolHttp = "HTTP"
)

// ObjectStorageServerProtocol_Values returns all elements of the ObjectStorageServerProtocol enum
func ObjectStorageServerProtocol_Values() []string {
	return []string{
		ObjectStorageServerProtocolHttps,
		ObjectStorageServerProtocolHttp,
	}
}

const (
	// ObjectTagsPreserve is a ObjectTags enum value
	ObjectTagsPreserve = "PRESERVE"

	// ObjectTagsNone is a ObjectTags enum value
	ObjectTagsNone = "NONE"
)

// ObjectTags_Values returns all elements of the ObjectTags enum
func ObjectTags_Values() []string {
	return []string{
		ObjectTagsPreserve,
		ObjectTagsNone,
	}
}

const (
	// OperatorEquals is a Operator enum value
	OperatorEquals = "Equals"

	// OperatorNotEquals is a Operator enum value
	OperatorNotEquals = "NotEquals"

	// OperatorIn is a Operator enum value
	OperatorIn = "In"

	// OperatorLessThanOrEqual is a Operator enum value
	OperatorLessThanOrEqual = "LessThanOrEqual"

	// OperatorLessThan is a Operator enum value
	OperatorLessThan = "LessThan"

	// OperatorGreaterThanOrEqual is a Operator enum value
	OperatorGreaterThanOrEqual = "GreaterThanOrEqual"

	// OperatorGreaterThan is a Operator enum value
	OperatorGreaterThan = "GreaterThan"

	// OperatorContains is a Operator enum value
	OperatorContains = "Contains"

	// OperatorNotContains is a Operator enum value
	OperatorNotContains = "NotContains"

	// OperatorBeginsWith is a Operator enum value
	OperatorBeginsWith = "BeginsWith"
)

// Operator_Values returns all elements of the Operator enum
func Operator_Values() []string {
	return []string{
		OperatorEquals,
		OperatorNotEquals,
		OperatorIn,
		OperatorLessThanOrEqual,
		OperatorLessThan,
		OperatorGreaterThanOrEqual,
		OperatorGreaterThan,
		OperatorContains,
		OperatorNotContains,
		OperatorBeginsWith,
	}
}

const (
	// OverwriteModeAlways is a OverwriteMode enum value
	OverwriteModeAlways = "ALWAYS"

	// OverwriteModeNever is a OverwriteMode enum value
	OverwriteModeNever = "NEVER"
)

// OverwriteMode_Values returns all elements of the OverwriteMode enum
func OverwriteMode_Values() []string {
	return []string{
		OverwriteModeAlways,
		OverwriteModeNever,
	}
}

const (
	// PhaseStatusPending is a PhaseStatus enum value
	PhaseStatusPending = "PENDING"

	// PhaseStatusSuccess is a PhaseStatus enum value
	PhaseStatusSuccess = "SUCCESS"

	// PhaseStatusError is a PhaseStatus enum value
	PhaseStatusError = "ERROR"
)

// PhaseStatus_Values returns all elements of the PhaseStatus enum
func PhaseStatus_Values() []string {
	return []string{
		PhaseStatusPending,
		PhaseStatusSuccess,
		PhaseStatusError,
	}
}

const (
	// PosixPermissionsNone is a PosixPermissions enum value
	PosixPermissionsNone = "NONE"

	// PosixPermissionsPreserve is a PosixPermissions enum value
	PosixPermissionsPreserve = "PRESERVE"
)

// PosixPermissions_Values returns all elements of the PosixPermissions enum
func PosixPermissions_Values() []string {
	return []string{
		PosixPermissionsNone,
		PosixPermissionsPreserve,
	}
}

const (
	// PreserveDeletedFilesPreserve is a PreserveDeletedFiles enum value
	PreserveDeletedFilesPreserve = "PRESERVE"

	// PreserveDeletedFilesRemove is a PreserveDeletedFiles enum value
	PreserveDeletedFilesRemove = "REMOVE"
)

// PreserveDeletedFiles_Values returns all elements of the PreserveDeletedFiles enum
func PreserveDeletedFiles_Values() []string {
	return []string{
		PreserveDeletedFilesPreserve,
		PreserveDeletedFilesRemove,
	}
}

const (
	// PreserveDevicesNone is a PreserveDevices enum value
	PreserveDevicesNone = "NONE"

	// PreserveDevicesPreserve is a PreserveDevices enum value
	PreserveDevicesPreserve = "PRESERVE"
)

// PreserveDevices_Values returns all elements of the PreserveDevices enum
func PreserveDevices_Values() []string {
	return []string{
		PreserveDevicesNone,
		PreserveDevicesPreserve,
	}
}

const (
	// RecommendationStatusNone is a RecommendationStatus enum value
	RecommendationStatusNone = "NONE"

	// RecommendationStatusInProgress is a RecommendationStatus enum value
	RecommendationStatusInProgress = "IN_PROGRESS"

	// RecommendationStatusCompleted is a RecommendationStatus enum value
	RecommendationStatusCompleted = "COMPLETED"

	// RecommendationStatusFailed is a RecommendationStatus enum value
	RecommendationStatusFailed = "FAILED"
)

// RecommendationStatus_Values returns all elements of the RecommendationStatus enum
func RecommendationStatus_Values() []string {
	return []string{
		RecommendationStatusNone,
		RecommendationStatusInProgress,
		RecommendationStatusCompleted,
		RecommendationStatusFailed,
	}
}

const (
	// S3StorageClassStandard is a S3StorageClass enum value
	S3StorageClassStandard = "STANDARD"

	// S3StorageClassStandardIa is a S3StorageClass enum value
	S3StorageClassStandardIa = "STANDARD_IA"

	// S3StorageClassOnezoneIa is a S3StorageClass enum value
	S3StorageClassOnezoneIa = "ONEZONE_IA"

	// S3StorageClassIntelligentTiering is a S3StorageClass enum value
	S3StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// S3StorageClassGlacier is a S3StorageClass enum value
	S3StorageClassGlacier = "GLACIER"

	// S3StorageClassDeepArchive is a S3StorageClass enum value
	S3StorageClassDeepArchive = "DEEP_ARCHIVE"

	// S3StorageClassOutposts is a S3StorageClass enum value
	S3StorageClassOutposts = "OUTPOSTS"

	// S3StorageClassGlacierInstantRetrieval is a S3StorageClass enum value
	S3StorageClassGlacierInstantRetrieval = "GLACIER_INSTANT_RETRIEVAL"
)

// S3StorageClass_Values returns all elements of the S3StorageClass enum
func S3StorageClass_Values() []string {
	return []string{
		S3StorageClassStandard,
		S3StorageClassStandardIa,
		S3StorageClassOnezoneIa,
		S3StorageClassIntelligentTiering,
		S3StorageClassGlacier,
		S3StorageClassDeepArchive,
		S3StorageClassOutposts,
		S3StorageClassGlacierInstantRetrieval,
	}
}

const (
	// SmbSecurityDescriptorCopyFlagsNone is a SmbSecurityDescriptorCopyFlags enum value
	SmbSecurityDescriptorCopyFlagsNone = "NONE"

	// SmbSecurityDescriptorCopyFlagsOwnerDacl is a SmbSecurityDescriptorCopyFlags enum value
	SmbSecurityDescriptorCopyFlagsOwnerDacl = "OWNER_DACL"

	// SmbSecurityDescriptorCopyFlagsOwnerDaclSacl is a SmbSecurityDescriptorCopyFlags enum value
	SmbSecurityDescriptorCopyFlagsOwnerDaclSacl = "OWNER_DACL_SACL"
)

// SmbSecurityDescriptorCopyFlags_Values returns all elements of the SmbSecurityDescriptorCopyFlags enum
func SmbSecurityDescriptorCopyFlags_Values() []string {
	return []string{
		SmbSecurityDescriptorCopyFlagsNone,
		SmbSecurityDescriptorCopyFlagsOwnerDacl,
		SmbSecurityDescriptorCopyFlagsOwnerDaclSacl,
	}
}

const (
	// SmbVersionAutomatic is a SmbVersion enum value
	SmbVersionAutomatic = "AUTOMATIC"

	// SmbVersionSmb2 is a SmbVersion enum value
	SmbVersionSmb2 = "SMB2"

	// SmbVersionSmb3 is a SmbVersion enum value
	SmbVersionSmb3 = "SMB3"

	// SmbVersionSmb1 is a SmbVersion enum value
	SmbVersionSmb1 = "SMB1"

	// SmbVersionSmb20 is a SmbVersion enum value
	SmbVersionSmb20 = "SMB2_0"
)

// SmbVersion_Values returns all elements of the SmbVersion enum
func SmbVersion_Values() []string {
	return []string{
		SmbVersionAutomatic,
		SmbVersionSmb2,
		SmbVersionSmb3,
		SmbVersionSmb1,
		SmbVersionSmb20,
	}
}

const (
	// StorageSystemConnectivityStatusPass is a StorageSystemConnectivityStatus enum value
	StorageSystemConnectivityStatusPass = "PASS"

	// StorageSystemConnectivityStatusFail is a StorageSystemConnectivityStatus enum value
	StorageSystemConnectivityStatusFail = "FAIL"

	// StorageSystemConnectivityStatusUnknown is a StorageSystemConnectivityStatus enum value
	StorageSystemConnectivityStatusUnknown = "UNKNOWN"
)

// StorageSystemConnectivityStatus_Values returns all elements of the StorageSystemConnectivityStatus enum
func StorageSystemConnectivityStatus_Values() []string {
	return []string{
		StorageSystemConnectivityStatusPass,
		StorageSystemConnectivityStatusFail,
		StorageSystemConnectivityStatusUnknown,
	}
}

const (
	// TaskExecutionStatusQueued is a TaskExecutionStatus enum value
	TaskExecutionStatusQueued = "QUEUED"

	// TaskExecutionStatusLaunching is a TaskExecutionStatus enum value
	TaskExecutionStatusLaunching = "LAUNCHING"

	// TaskExecutionStatusPreparing is a TaskExecutionStatus enum value
	TaskExecutionStatusPreparing = "PREPARING"

	// TaskExecutionStatusTransferring is a TaskExecutionStatus enum value
	TaskExecutionStatusTransferring = "TRANSFERRING"

	// TaskExecutionStatusVerifying is a TaskExecutionStatus enum value
	TaskExecutionStatusVerifying = "VERIFYING"

	// TaskExecutionStatusSuccess is a TaskExecutionStatus enum value
	TaskExecutionStatusSuccess = "SUCCESS"

	// TaskExecutionStatusError is a TaskExecutionStatus enum value
	TaskExecutionStatusError = "ERROR"
)

// TaskExecutionStatus_Values returns all elements of the TaskExecutionStatus enum
func TaskExecutionStatus_Values() []string {
	return []string{
		TaskExecutionStatusQueued,
		TaskExecutionStatusLaunching,
		TaskExecutionStatusPreparing,
		TaskExecutionStatusTransferring,
		TaskExecutionStatusVerifying,
		TaskExecutionStatusSuccess,
		TaskExecutionStatusError,
	}
}

const (
	// TaskFilterNameLocationId is a TaskFilterName enum value
	TaskFilterNameLocationId = "LocationId"

	// TaskFilterNameCreationTime is a TaskFilterName enum value
	TaskFilterNameCreationTime = "CreationTime"
)

// TaskFilterName_Values returns all elements of the TaskFilterName enum
func TaskFilterName_Values() []string {
	return []string{
		TaskFilterNameLocationId,
		TaskFilterNameCreationTime,
	}
}

const (
	// TaskQueueingEnabled is a TaskQueueing enum value
	TaskQueueingEnabled = "ENABLED"

	// TaskQueueingDisabled is a TaskQueueing enum value
	TaskQueueingDisabled = "DISABLED"
)

// TaskQueueing_Values returns all elements of the TaskQueueing enum
func TaskQueueing_Values() []string {
	return []string{
		TaskQueueingEnabled,
		TaskQueueingDisabled,
	}
}

const (
	// TaskStatusAvailable is a TaskStatus enum value
	TaskStatusAvailable = "AVAILABLE"

	// TaskStatusCreating is a TaskStatus enum value
	TaskStatusCreating = "CREATING"

	// TaskStatusQueued is a TaskStatus enum value
	TaskStatusQueued = "QUEUED"

	// TaskStatusRunning is a TaskStatus enum value
	TaskStatusRunning = "RUNNING"

	// TaskStatusUnavailable is a TaskStatus enum value
	TaskStatusUnavailable = "UNAVAILABLE"
)

// TaskStatus_Values returns all elements of the TaskStatus enum
func TaskStatus_Values() []string {
	return []string{
		TaskStatusAvailable,
		TaskStatusCreating,
		TaskStatusQueued,
		TaskStatusRunning,
		TaskStatusUnavailable,
	}
}

const (
	// TransferModeChanged is a TransferMode enum value
	TransferModeChanged = "CHANGED"

	// TransferModeAll is a TransferMode enum value
	TransferModeAll = "ALL"
)

// TransferMode_Values returns all elements of the TransferMode enum
func TransferMode_Values() []string {
	return []string{
		TransferModeChanged,
		TransferModeAll,
	}
}

const (
	// UidNone is a Uid enum value
	UidNone = "NONE"

	// UidIntValue is a Uid enum value
	UidIntValue = "INT_VALUE"

	// UidName is a Uid enum value
	UidName = "NAME"

	// UidBoth is a Uid enum value
	UidBoth = "BOTH"
)

// Uid_Values returns all elements of the Uid enum
func Uid_Values() []string {
	return []string{
		UidNone,
		UidIntValue,
		UidName,
		UidBoth,
	}
}

const (
	// VerifyModePointInTimeConsistent is a VerifyMode enum value
	VerifyModePointInTimeConsistent = "POINT_IN_TIME_CONSISTENT"

	// VerifyModeOnlyFilesTransferred is a VerifyMode enum value
	VerifyModeOnlyFilesTransferred = "ONLY_FILES_TRANSFERRED"

	// VerifyModeNone is a VerifyMode enum value
	VerifyModeNone = "NONE"
)

// VerifyMode_Values returns all elements of the VerifyMode enum
func VerifyMode_Values() []string {
	return []string{
		VerifyModePointInTimeConsistent,
		VerifyModeOnlyFilesTransferred,
		VerifyModeNone,
	}
}
