/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2020-2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
; generated by igemm_codegen.py (d52258ea47284c75ea1745530f85c9049c5f98cb)
;
.macro .v_u32_div v_q, v_n, v_d, v_tmp4, s_tmp4
    v_cvt_f32_u32     v[\v_tmp4+0],   v[\v_d]
    v_rcp_f32         v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_f32         v[\v_tmp4+0],   0x4f800000, v[\v_tmp4+0]
    v_cvt_u32_f32     v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   v[\v_d],      v[\v_tmp4+0]
    v_mul_hi_u32      v[\v_tmp4+2],   v[\v_d],      v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+3],   vcc, 0,     v[\v_tmp4+1]
    v_cmp_ne_i32      s[\s_tmp4:\s_tmp4+1], 0,          v[\v_tmp4+2]
    v_cndmask_b32     v[\v_tmp4+1],   v[\v_tmp4+3],   v[\v_tmp4+1],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+1],   v[\v_tmp4+1],   v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_add_co_u32      v[\v_tmp4+0],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_cndmask_b32     v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_tmp4+2],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_n]
    v_mul_lo_u32      v[\v_tmp4+1],   v[\v_tmp4+0],   v[\v_d]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4:\s_tmp4+1], v[\v_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4+2:\s_tmp4+3], v[\v_tmp4+2],   v[\v_d]
    v_add_co_u32      v[\v_tmp4+2],   vcc, 1, v[\v_tmp4+0]
    s_and_b64         s[\s_tmp4+2:\s_tmp4+3], s[\s_tmp4:\s_tmp4+1], s[\s_tmp4+2:\s_tmp4+3]
    v_add_co_u32      v[\v_tmp4+1],   vcc, -1,    v[\v_tmp4+0]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+0],   v[\v_tmp4+2],      s[\s_tmp4+2:\s_tmp4+3]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+1],   v[\v_tmp4+2],      s[\s_tmp4:\s_tmp4+1]
    v_cmp_ne_i32      vcc,          0,          v[\v_d]
    v_cndmask_b32     v[\v_q],      -1,         v[\v_tmp4+2],      vcc
.endm

.macro .v_u32_div_vs v_q, v_n, s_d, v_tmp4, s_tmp4
    v_cvt_f32_u32     v[\v_tmp4+0],   s[\s_d]
    v_rcp_f32         v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_f32         v[\v_tmp4+0],   0x4f800000, v[\v_tmp4+0]
    v_cvt_u32_f32     v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],      v[\v_tmp4+0]
    v_mul_hi_u32      v[\v_tmp4+2],   s[\s_d],      v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+3],   vcc, 0,     v[\v_tmp4+1]
    v_cmp_ne_i32      s[\s_tmp4:\s_tmp4+1], 0,          v[\v_tmp4+2]
    v_cndmask_b32     v[\v_tmp4+1],   v[\v_tmp4+3],   v[\v_tmp4+1],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+1],   v[\v_tmp4+1],   v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_add_co_u32      v[\v_tmp4+0],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_cndmask_b32     v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_tmp4+2],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_n]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],     v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4:\s_tmp4+1], v[\v_n],      v[\v_tmp4+1]
    v_cmp_le_u32      s[\s_tmp4+2:\s_tmp4+3],  s[\s_d],    v[\v_tmp4+2]
    v_add_co_u32      v[\v_tmp4+2],   vcc, 1, v[\v_tmp4+0]
    s_and_b64         s[\s_tmp4+2:\s_tmp4+3], s[\s_tmp4:\s_tmp4+1], s[\s_tmp4+2:\s_tmp4+3]
    v_add_co_u32      v[\v_tmp4+1],   vcc, -1,    v[\v_tmp4+0]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+0],   v[\v_tmp4+2],      s[\s_tmp4+2:\s_tmp4+3]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+1],   v[\v_tmp4+2],      s[\s_tmp4:\s_tmp4+1]
    v_cmp_ne_i32      vcc,          s[\s_d],   0
    v_cndmask_b32     v[\v_q],      -1,         v[\v_tmp4+2],      vcc
.endm

.macro .v_u32_div_ss v_q, s_n, s_d, v_tmp4, s_tmp4
    v_cvt_f32_u32     v[\v_tmp4+0],   s[\s_d]
    v_rcp_f32         v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_f32         v[\v_tmp4+0],   0x4f800000, v[\v_tmp4+0]
    v_cvt_u32_f32     v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],      v[\v_tmp4+0]
    v_mul_hi_u32      v[\v_tmp4+2],   s[\s_d],      v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+3],   vcc, 0,     v[\v_tmp4+1]
    v_cmp_ne_i32      s[\s_tmp4:\s_tmp4+1], 0,          v[\v_tmp4+2]
    v_cndmask_b32     v[\v_tmp4+1],   v[\v_tmp4+3],   v[\v_tmp4+1],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+1],   v[\v_tmp4+1],   v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_add_co_u32      v[\v_tmp4+0],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_cndmask_b32     v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_tmp4+2],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+0],   s[\s_n],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],     v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        s[\s_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4:\s_tmp4+1], s[\s_n],      v[\v_tmp4+1]
    v_cmp_le_u32      s[\s_tmp4+2:\s_tmp4+3],  s[\s_d],    v[\v_tmp4+2]
    v_add_co_u32      v[\v_tmp4+2],   vcc, 1, v[\v_tmp4+0]
    s_and_b64         s[\s_tmp4+2:\s_tmp4+3], s[\s_tmp4:\s_tmp4+1], s[\s_tmp4+2:\s_tmp4+3]
    v_add_co_u32      v[\v_tmp4+1],   vcc, -1,    v[\v_tmp4+0]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+0],   v[\v_tmp4+2],      s[\s_tmp4+2:\s_tmp4+3]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+1],   v[\v_tmp4+2],      s[\s_tmp4:\s_tmp4+1]
    v_cmp_ne_i32      vcc,          s[\s_d],   0
    v_cndmask_b32     v[\v_q],      -1,         v[\v_tmp4+2],      vcc
.endm

.macro .v_u32_div_rem v_r, v_q, v_n, v_d, v_tmp4, s_tmp4
    .v_u32_div \v_q, \v_n, \v_d, \v_tmp4, \s_tmp4
    v_mul_lo_u32 v[\v_tmp4], v[\v_d], v[\v_q]
    v_sub_u32 v[\v_r], v[\v_n], v[\v_tmp4]
.endm

.macro .v_u32_div_rem_vs v_r, v_q, v_n, s_d, v_tmp4, s_tmp4
    .v_u32_div_vs \v_q, \v_n, \s_d, \v_tmp4, \s_tmp4
    v_mul_lo_u32 v[\v_tmp4], s[\s_d], v[\v_q]
    v_sub_u32 v[\v_r], v[\v_n], v[\v_tmp4]
.endm

.macro .v_u32_div_rem_ss s_r, s_q, s_n, s_d, v_q, v_tmp4, s_tmp4
    .v_u32_div_ss \v_q, \s_n, \s_d, \v_tmp4, \s_tmp4
    v_readfirstlane_b32 s[\s_q], v[\v_q]
    s_mul_i32 s[\s_tmp4], s[\s_d], s[\s_q]
    s_sub_i32 s[\s_r], s[\s_n], s[\s_tmp4]
.endm

.macro .mdiv_u32_ss s_quot s_numer s_magic s_shift s_tmp
    s_mul_hi_u32 s[\s_tmp], s[\s_magic], s[\s_numer]
    s_add_u32 s[\s_tmp], s[\s_tmp], s[\s_numer]
    s_lshr_b32 s[\s_quot], s[\s_tmp], s[\s_shift]
.endm

.macro .mdiv_u32_rem_ss s_rem s_quot s_numer s_magic s_shift s_denom s_tmp
    .mdiv_u32_ss \s_quot,\s_numer,\s_magic,\s_shift,\s_tmp
    s_mul_i32 s[\s_tmp], s[\s_denom], s[\s_quot]
    s_sub_u32 s[\s_rem], s[\s_numer], s[\s_tmp]
.endm

.macro .mdiv_u32_vs v_quot v_numer s_magic s_shift v_tmp
    v_mul_hi_u32 v[\v_tmp], s[\s_magic], v[\v_numer]
    v_add_u32 v[\v_tmp], v[\v_tmp], v[\v_numer]
    v_lshrrev_b32 v[\v_quot], s[\s_shift], v[\v_tmp]
.endm

.macro .mdiv_u32_rem_vs v_rem v_quot v_numer s_magic s_shift s_denom v_tmp
    .mdiv_u32_vs \v_quot,\v_numer,\s_magic,\s_shift,\v_tmp
    v_mul_lo_u32 v[\v_tmp], s[\s_denom], v[\v_quot]
    v_sub_u32 v[\v_rem], v[\v_numer], v[\v_tmp]
.endm

.macro .v_clear_acc_c a, num
    _a = \a
    .rept \num
        v_accvgpr_write_b32 a[_a], 0
        _a = _a + 1
    .endr
.endm

.macro .v_clear_nc vid, num
    _v = \vid
    .rept \num
        v_mov_b32 v[_v], 0
        _v = _v + 1
    .endr
.endm

;----------------------------------------------------------
; starting of kernel igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs
; tensor_layout              : 'nchw'
; gemm_m_per_block           : 256
; gemm_n_per_block           : 16
; gemm_k_per_block           : 32
; wave_tile_m                : 64
; wave_step_m                : 1
; wave_repeat_m              : 2
; wave_tile_n                : 4
; wave_step_n                : 1
; wave_repeat_n              : 2
; wave_tile_k                : 4
; tensor_a_thread_lengths    : [1, 2, 1, 16]
; tensor_a_cluster_lengths   : [1, 16, 1, 16]
; tensor_b_thread_lengths    : [1, 2, 1, 1]
; tensor_b_cluster_lengths   : [1, 16, 1, 16]
; direction                  : 'wrw'
; precision                  : 'fp16'
; nxb                        : 4
; nxe                        : 0
; gemm_k_global_split        : 1
; 
; block_size                 : 256
; lds_total                  : 32768
; 
.set k_p_in, 0
.set k_p_wei, 8
.set k_p_out, 16
.set k_hi, 24
.set k_wi, 28
.set k_n, 32
.set k_k, 36
.set k_c, 40
.set k_ho, 44
.set k_wo, 48
.set k_stride_h, 52
.set k_stride_w, 56
.set k_dilation_h, 60
.set k_dilation_w, 64
.set k_pad_h, 68
.set k_pad_w, 72
.set k_y, 76
.set k_x, 80
.set k_gemm_k_global_split, 84
.set k_group, 88
.set k_pack_0, 92
.set k_end, 96

.set s_ka, 0
.set s_bx, 2
.set s_p_in, 4
.set s_p_wei, 8
.set s_p_out, 12
.set s_hi, 16
.set s_wi, 17
.set s_n, 18
.set s_k, 19
.set s_c, 20
.set s_ho, 21
.set s_wo, 22
.set s_stride_h, 23
.set s_stride_w, 24
.set s_dilation_h, 25
.set s_dilation_w, 26
.set s_pad_h, 27
.set s_pad_w, 28
.set s_y, 29
.set s_x, 30
.set s_gemmk_split, 31
.set s_group, 32
.set s_ho_padded, 33
.set s_out_stride_k, 34
.set s_hoxwo, 31
.set s_out_stride_n, 35
.set s_in_stride_c, 36
.set s_in_stride_n, 37
.set s_wei_stride_c, 38
.set s_wei_stride_k, 39
.set s_out_stride_n_n1, 40
.set s_in_stride_n_n1, 41
.set s_move_slice_n_n1, 42
.set s_move_slice_n_dsho, 43
.set s_move_slice_n_dswo, 44
.set s_block_gtc_ik, 45
.set s_block_gtc_ic0, 46
.set s_block_gtc_ic1e, 47
.set s_block_gtc_in, 48
.set s_block_gtc_ig, 49
.set s_knum, 1
.set s_gemm_k_num_n1, 0
.set s_kitr, 3
.set s_in_offset, 50
.set s_out_offset, 50
.set s_sub_n, 64
.set s_k_padded, 65
.set s_tmp, 66
.set s_end, 72

.set v_c, 0  ; coalescing:16, needed:0, resuable:45
.set v_a, 0
.set v_b, 8
.set v_gld_a, 16
.set v_gld_b, 32
.set v_sst_a_os, 33
.set v_sst_b_os, 34
.set v_sld_a_os, 35
.set v_sld_b_os, 36
.set v_in_ihi, 37
.set v_in_iwi, 38
.set v_in_os, 39
.set v_in_os_base, 40
.set v_out_iho, 41
.set v_out_iwo, 42
.set v_out_os, 43
.set v_out_os_base, 44
.set v_co_sst, 45
.set v_co_sld, 46
.set v_wei_flag, 47
.set v_wei_os, 48
.set v_gtc_ik1, 49
.set v_move_slice_n_in1, 50
.set v_move_slice_n_idsho, 51
.set v_move_slice_n_idswo, 52
.set v_wei_iy, 53
.set v_wei_ix, 54
.set v_gtc_ic0, 55
.set v_gtc_ic1e, 56
.set v_gtc_ik0, 57
.set v_gtc_ic1, 58
.set v_gtc_in0, 59
.set v_out_flag_prev, 59
.set v_gtc_in1b, 60
.set v_gtc_in1, 61
.set v_gemm_in, 62
.set v_gemm_im, 63
.set v_wei_ic0, 64
.set v_wei_ic1e, 65
.set v_wei_ic1, 66
.set v_co_sub_m_index, 67
.set v_co_sub_n_index, 68
.set v_cur_k, 69
.set v_cur_c, 70
.set v_in_flag_with_wi, 71
.set v_tmp, 72
.set v_end, 78

.set a_c, 0
.set a_end, 16

.text
.globl igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs
.p2align 8
.type igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs,@function
igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs:
    ; unmerge_sub_n:8, unmerge_sub_n1:8, unmerge_sub_c:16, unmerge_sub_c1:16
    ; gemm_m_unmerge_cluster:0, gemm_n_unmerge_cluster:0, gemm_k_unmerge_cluster:0
    s_load_dwordx2  s[s_p_in+0:s_p_in+1],       s[s_ka+0:s_ka+1],    0+k_p_in
    s_load_dwordx2  s[s_p_wei+0:s_p_wei+1],      s[s_ka+0:s_ka+1],    0+k_p_wei
    s_load_dwordx2  s[s_p_out+0:s_p_out+1],      s[s_ka+0:s_ka+1],    0+k_p_out
    s_load_dwordx16 s[s_hi+0:s_hi+15],        s[s_ka+0:s_ka+1],    0+k_hi
    s_load_dwordx2  s[s_group+0:s_group+1],      s[s_ka+0:s_ka+1],    0+k_group

    ; input, thread(n0,n1b,c0,c1e): 1x2x1x1, cluster(n0,n1b,c0,c1e): 1x16x1x16
    v_mov_b32 v[v_tmp], v0
    v_and_b32 v[v_gtc_in1b], 15, v[v_tmp]
    v_lshlrev_b32 v[v_gtc_in1b], 1, v[v_gtc_in1b]
    v_lshrrev_b32 v[v_tmp], 4, v[v_tmp]
    v_mov_b32 v[v_gtc_in0], 0
    v_and_b32 v[v_gtc_ic1e], 15, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 4, v[v_tmp]
    v_mov_b32 v[v_gtc_ic0], 0

    ; output, thread(n0,n1b,k0,k1): 1x2x1x16, cluster(n0,n1b,k0,k1) 1x16x1x16
    v_lshrrev_b32 v[v_tmp], 4, v0
    v_and_b32 v[v_gtc_ik1], 15, v[v_tmp]
    v_lshlrev_b32 v[v_gtc_ik1], 4, v[v_gtc_ik1]
    v_lshrrev_b32 v[v_tmp], 4, v[v_tmp]
    v_mov_b32 v[v_gtc_ik0], 0

    s_mov_b32 s[s_p_in+3], 0x27000
    s_mov_b32 s[s_p_wei+2], 0xffffffff
    s_mov_b32 s[s_p_wei+3], 0x27000
    s_mov_b32 s[s_p_out+3], 0x27000
    s_waitcnt lgkmcnt(0)

    ; calculate index
    s_mul_i32 s[s_in_stride_c],      s[s_hi],       s[s_wi]
    s_mul_i32 s[s_tmp],  s[s_in_stride_c], s[s_c]
    s_mul_i32 s[s_in_stride_n],      s[s_group],        s[s_tmp]
    s_mul_i32 s[s_wei_stride_c],       s[s_y],       s[s_x]
    s_mul_i32 s[s_wei_stride_k],       s[s_c],        s[s_wei_stride_c]
    s_mul_i32 s[s_out_stride_k],      s[s_ho],        s[s_wo]
    s_mul_i32 s[s_tmp],  s[s_out_stride_k],  s[s_k]
    s_mul_i32 s[s_out_stride_n],      s[s_group],        s[s_tmp]
    ; config for weight range
    s_mul_i32 s[s_p_out+2], s[s_out_stride_n], s[s_n]
    s_lshl_b32 s[s_p_out+2], s[s_p_out+2], 1
    ; n1b transform
    .v_u32_div_rem_vs v_tmp+4, v_move_slice_n_in1, v_gtc_in1b, s_out_stride_k, v_tmp, s_tmp
    .v_u32_div_rem_vs v_move_slice_n_idswo, v_move_slice_n_idsho, v_tmp+4, s_wo, v_tmp, s_tmp

    ; pad gemm_m if needed
    s_add_u32 s[s_tmp], 255, s[s_k]
    s_lshr_b32 s[s_tmp], s[s_tmp], 8
    s_lshl_b32 s[s_k_padded], s[s_tmp], 8

    ; add block i_n
    ; gemm_m_per_block:256, gemm_n_per_block:16
    s_lshr_b32 s[0], s[s_wei_stride_k], 4

    s_lshr_b32 s[s_tmp], s[s_k], 8
    s_mul_i32 s[1], s[0], s[s_tmp]
    s_lshl_b32 s[3], s[1], s[s_gemmk_split]
    .v_u32_div_rem_ss s_tmp+4, s_block_gtc_ig, s_bx, 3, v_tmp+5, v_tmp, s_tmp
    .v_u32_div_rem_ss s_bx, s_block_gtc_in, s_tmp+4, 1, v_tmp+5, v_tmp, s_tmp
    ; config input and output n offset
    s_lshr_b32 s[s_sub_n], s[s_n], s[s_gemmk_split]
    s_mul_i32 s[s_block_gtc_in], s[s_block_gtc_in], s[s_sub_n]
    .v_u32_div_rem_ss s_tmp+4, s_tmp+5, s_bx, 0, v_tmp+5, v_tmp, s_tmp
    ; s_tmp+4:block_gtc_in, s_tmp+5:block_gtc_im
    s_lshl_b32 s[s_block_gtc_ik], s[s_tmp+5], 8
    s_mov_b32 s[0], s[s_wei_stride_c] ; total number of c1e
    .v_u32_div_rem_ss s_block_gtc_ic1e, s_block_gtc_ic0, s_tmp+4, 0, v_tmp+5, v_tmp, s_tmp
    s_lshl_b32 s[s_block_gtc_ic1e], s[s_block_gtc_ic1e], 4

    ; c1e transform
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ic1e], v[v_gtc_ic1e]
    .v_u32_div_rem_vs v_tmp+4, v_gtc_ic1, v_tmp+5, s_wei_stride_c, v_tmp, s_tmp
    .v_u32_div_rem_vs v_wei_ix, v_wei_iy, v_tmp+4, s_x, v_tmp, s_tmp

    v_mul_u32_u24 v[v_tmp], s[s_dilation_h], v[v_wei_iy]
    v_mul_u32_u24 v[v_tmp+1], s[s_dilation_w], v[v_wei_ix]
    v_sub_i32 v[v_wei_iy], v[v_tmp], s[s_pad_h]
    v_sub_i32 v[v_wei_ix], v[v_tmp+1], s[s_pad_w]
    ; ihi = iho * s_stride_h + iy * s_dilation_h - s_pad_h,   here make sure iy <- iy * s_dilation_h - s_pad_h before hand
    ; iwi = iwo * s_stride_w + ix * s_dilation_w - s_pad_w,   here make sure ix <- ix * s_dilation_w - s_pad_w before hand
    v_mul_lo_u32 v[v_tmp], s[s_stride_h], v[v_move_slice_n_idsho]
    v_add_i32 v[v_in_ihi], v[v_tmp], v[v_wei_iy]
    v_mul_lo_u32 v[v_tmp+1], s[s_stride_w], v[v_move_slice_n_idswo]
    v_add_i32 v[v_in_iwi], v[v_tmp+1], v[v_wei_ix]
    ; calculate input offset
    ; set input range
    s_mul_i32 s[s_p_in+2], s[s_in_stride_n], s[s_n]
    s_lshl_b32 s[s_p_in+2], s[s_p_in+2], 1
    s_mul_i32 s[s_tmp+5], s[s_c], s[s_in_stride_c]
    s_lshl_b32 s[s_block_gtc_ig], s[s_block_gtc_ig], 1
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+5]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+5]
    s_sub_u32 s[s_p_in+2], s[s_p_in+2], s[s_tmp]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]
    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ic0], 5
    s_mul_i32 s[s_tmp], s[s_in_stride_c], s[s_tmp+3]
    s_mul_hi_u32 s[s_tmp+1], s[s_in_stride_c], s[s_tmp+3]
    s_sub_u32 s[s_p_in+2], s[s_p_in+2], s[s_tmp]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]

    v_mov_b32 v[v_tmp], v[v_move_slice_n_in1]
    v_add_u32 v[v_tmp], v[v_tmp], s[s_block_gtc_in]
    v_mul_lo_u32 v[v_tmp], s[s_in_stride_n], v[v_tmp]
    v_mov_b32 v[v_tmp+1], v[v_gtc_ic1]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_c], v[v_tmp+1]
    v_add_lshl_u32 v[v_in_os_base], v[v_tmp], v[v_tmp+1], 1
    ; from hi, wi, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wi], v[v_in_ihi], v[v_in_iwi]
    v_lshl_add_u32 v[v_in_os], v[v_tmp], 1, v[v_in_os_base]

    s_lshl_b32 s[s_in_stride_n], s[s_in_stride_n], 1

    
    ; load input
    buffer_load_dword v[v_gld_b+0], v[v_in_os], s[s_p_in:s_p_in+3], 0 offen offset:0

    ; calculate out offset
    ; set output range
    s_mul_i32 s[s_p_out+2], s[s_out_stride_n], s[s_n]
    s_lshl_b32 s[s_p_out+2], s[s_p_out+2], 1
    s_mul_i32 s[s_tmp+2], s[s_k], s[s_out_stride_k]
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+2]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+2]
    s_sub_u32 s[s_p_out+2], s[s_p_out+2], s[s_tmp]
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], s[s_tmp+1]

    v_mov_b32 v[v_tmp], v[v_gtc_ik1]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ik], v[v_tmp]
    v_mul_lo_u32 v[v_tmp], s[s_out_stride_k], v[v_tmp+5]
    v_mov_b32 v[v_tmp+1], v[v_move_slice_n_in1]
    v_add_u32 v[v_tmp+1], v[v_tmp+1], s[s_block_gtc_in]
    v_mul_lo_u32 v[v_tmp+1], s[s_out_stride_n], v[v_tmp+1]
    v_add_lshl_u32 v[v_out_os_base], v[v_tmp], v[v_tmp+1], 1
    ; from ho, wo, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wo], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    v_lshl_add_u32 v[v_out_os], v[v_tmp], 1, v[v_out_os_base]

    s_lshl_b32 s[s_out_stride_n], s[s_out_stride_n], 1
    s_lshl_b32 s[s_out_stride_k], s[s_out_stride_k], 1

    s_mul_i32 s[s_out_offset+0], 2, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+1], 3, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+2], 4, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+3], 5, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+4], 6, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+5], 7, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+6], 8, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+7], 9, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+8], 10, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+9], 11, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+10], 12, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+11], 13, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+12], 14, s[s_out_stride_k]
    s_mul_i32 s[s_out_offset+13], 15, s[s_out_stride_k]
    ; load output
    buffer_load_dword v[v_gld_a+0], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:0
    buffer_load_dword v[v_gld_a+1], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_stride_k] offen offset:0
    buffer_load_dword v[v_gld_a+2], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+0] offen offset:0
    buffer_load_dword v[v_gld_a+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+1] offen offset:0
    buffer_load_dword v[v_gld_a+4], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+2] offen offset:0
    buffer_load_dword v[v_gld_a+5], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+3] offen offset:0
    buffer_load_dword v[v_gld_a+6], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+4] offen offset:0
    buffer_load_dword v[v_gld_a+7], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+5] offen offset:0
    buffer_load_dword v[v_gld_a+8], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+6] offen offset:0
    buffer_load_dword v[v_gld_a+9], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+7] offen offset:0
    buffer_load_dword v[v_gld_a+10], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+8] offen offset:0
    buffer_load_dword v[v_gld_a+11], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+9] offen offset:0
    buffer_load_dword v[v_gld_a+12], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+10] offen offset:0
    buffer_load_dword v[v_gld_a+13], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+11] offen offset:0
    buffer_load_dword v[v_gld_a+14], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+12] offen offset:0
    buffer_load_dword v[v_gld_a+15], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+13] offen offset:0

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get source matrix gemm index
    v_and_b32 v[v_gemm_in], 3, v[v_tmp+5]           ; block_n index 
    v_and_b32 v[v_gemm_im], 3, v[v_tmp+5]           ; block_m index 
    v_lshrrev_b32 v[v_tmp+5], 2, v[v_tmp+5]
    v_and_b32 v[v_tmp + 1], 15, v[v_tmp+5]          ; block_m_per_wave index
    v_lshl_or_b32 v[v_gemm_im], v[v_tmp + 1], 2, v[v_gemm_im]
    v_lshrrev_b32 v[v_tmp+5], 4, v[v_tmp+5]
    v_and_b32 v[v_tmp + 2], 1, v[v_tmp+5]  ; waves_per_n index
    v_lshl_or_b32 v[v_gemm_in], v[v_tmp + 2], 2, v[v_gemm_in]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_and_b32 v[v_tmp + 3], 1, v[v_tmp+5]  ; waves_per_m index
    v_lshl_or_b32 v[v_gemm_im], v[v_tmp + 3], 6, v[v_gemm_im]

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get dst matrix gemm index
    v_and_b32 v[v_tmp+0], 3, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 2, v[v_tmp+5]
    v_and_b32 v[v_tmp+3], 15, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 4, v[v_tmp+5]
    v_mov_b32 v[v_co_sst], v[v_tmp+0]
    v_lshlrev_b32 v[v_co_sld], 2, v[v_tmp+3]
    v_and_b32 v[v_tmp+0], 1, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_and_b32 v[v_tmp+1], 1, v[v_tmp+5]
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+0], 2, v[v_co_sst]
    v_lshl_or_b32 v[v_co_sld], v[v_tmp+1], 6, v[v_co_sld]

    ; LDS store, in: n0,n1b,c0,c1e: 1x2x1x1, 1x16x1x16, order:4
    v_lshlrev_b32 v[v_tmp], 2, v[v_gtc_ic1e]
    v_lshrrev_b32 v[v_tmp+1], 2, v[v_gtc_in1b]
    v_lshl_add_u32 v[v_tmp], v[v_tmp+1], 6, v[v_tmp]
    v_and_b32 v[v_tmp+1], 3, v[v_gtc_in1b]
    v_add_u32 v[v_tmp], v[v_tmp], v[v_tmp+1]
    v_lshlrev_b32 v[v_sst_b_os], 1, v[v_tmp]
    v_add_u32 v[v_sst_b_os], 16384, v[v_sst_b_os]

    ; LDS store, out: n0,n1b,k0,k1: 1x2x1x16, 1x16x1x16, order:0
    v_lshlrev_b32 v[v_tmp], 2, v[v_gtc_ik1]
    v_lshrrev_b32 v[v_tmp+1], 2, v[v_gtc_in1b]
    v_lshl_add_u32 v[v_tmp], v[v_tmp+1], 10, v[v_tmp]
    v_and_b32 v[v_tmp+1], 3, v[v_gtc_in1b]
    v_add_u32 v[v_tmp], v[v_tmp], v[v_tmp+1]
    v_lshlrev_b32 v[v_sst_a_os], 1, v[v_tmp]

    ; LDS load
    v_lshlrev_b32 v[v_sld_b_os], 3, v[v_gemm_in]
    v_lshlrev_b32 v[v_sld_a_os], 3, v[v_gemm_im]
    v_add_u32 v[v_sld_b_os], 16384, v[v_sld_b_os]

    v_mov_b32 v[v_gemm_in], v[v_co_sst]
    v_mov_b32 v[v_gemm_im], v[v_co_sld]
    ; init_co_lds_offset for xdlops
    v_lshrrev_b32 v[v_tmp], 2, v[v_gemm_im]
    v_and_b32 v[v_tmp], 0, v[v_tmp]   ; thread id of lanegroup_m_per_cluster
    v_lshlrev_b32 v[v_co_sst], 2, v[v_tmp]
    v_lshrrev_b32 v[v_tmp+1], 2, v[v_gemm_im]
    v_and_b32 v[v_tmp+1], 15  , v[v_tmp+1]   ; thread id of block_m_per_lanegroup
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+1], 2, v[v_co_sst]
    v_lshrrev_b32 v[v_tmp+2], 6, v[v_gemm_im]  ; thread id of waves_per_m
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+2], 6, v[v_co_sst]
    v_lshrrev_b32 v[v_tmp], 2, v[v_co_sst]
    v_lshlrev_b32 v[v_tmp+1], 2, v[v_gemm_in]   ; implicit transpose with m granularity:4 while store
    v_lshl_or_b32 v[v_co_sst], v[v_tmp], 6, v[v_tmp+1]
    v_lshlrev_b32 v[v_co_sst], 2, v[v_co_sst]
    v_lshlrev_b32 v[v_co_sld], 4, v[0]
    ; init_co_sub_m_index xdlops, block_size:256, macro-tile:256x16 sub_m_index:[0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:1, g_mt:1 | l_mr:2, l_ms:1, l_mw:1, l_mb:1, l_mt:4 | n_mc:1, n_ml:16, n_mv:2
    ; nd_stride:[1, 16, 1, 1, 1, 2, 1]
    v_lshrrev_b32 v[v_co_sub_m_index], 4, v[0]   ; get tid along m
    v_and_b32 v[v_tmp+0], 15, v[v_co_sub_m_index]                   ; => x_ml
    v_mov_b32 v[v_co_sub_m_index], v[v_tmp+0]      ; => accumulate x_ml
    v_lshlrev_b32 v[v_co_sub_m_index], 2, v[v_co_sub_m_index]
    ; init_co_sub_n_index xdlops
    v_and_b32 v[v_co_sub_n_index], 15, v[0]

    ; weight offset
    s_mul_i32 s[s_tmp+2], s[s_k], s[s_wei_stride_k]
    s_lshl_b32 s[s_tmp+2], s[s_tmp+2], 6 - 5
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+2]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+2]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]
    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ic0], 6
    s_mul_i32 s[s_tmp], s[s_wei_stride_c], s[s_tmp+3]
    s_mul_hi_u32 s[s_tmp+1], s[s_wei_stride_c], s[s_tmp+3]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]

    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ik], 2
    s_mul_i32 s[s_tmp], s[s_wei_stride_k], s[s_tmp+3]
    s_mul_hi_u32 s[s_tmp+1], s[s_wei_stride_k], s[s_tmp+3]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]

    ; compute v_co_sub_n_index along c0 x c1e : 1x16
    v_and_b32 v[v_wei_ic1e], 15, v[v_co_sub_n_index]     ; => C1E
    ;   compute from n1b
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ic1e], v[v_wei_ic1e]
    .v_u32_div_rem_vs v_tmp+4, v_wei_ic1, v_tmp+5, s_wei_stride_c, v_tmp, s_tmp

    ; add wei_ic0, wei_ic1
    v_mul_lo_u32 v[v_wei_os], s[s_wei_stride_c], v[v_wei_ic1]
    ; add i_k
    v_mul_lo_u32 v[v_tmp], s[s_wei_stride_k], v[v_co_sub_m_index]
    v_add_u32 v[v_wei_os], v[v_wei_os], v[v_tmp]
    ; add y, x
    v_add_u32 v[v_wei_os], v[v_wei_os], v[v_tmp+4]
    v_lshlrev_b32 v[v_wei_os], 2, v[v_wei_os]
    ; move slice stride
    s_mul_i32 s[s_hoxwo], s[s_ho], s[s_wo]
    s_mov_b32 s[0], 32
    .v_u32_div_rem_ss s_tmp+4, s_move_slice_n_n1, 0, s_hoxwo, v_tmp+4, v_tmp, s_tmp
    .v_u32_div_rem_ss s_move_slice_n_dswo, s_move_slice_n_dsho, s_tmp+4, s_wo, v_tmp+4, v_tmp, s_tmp

    s_lshr_b32 s[s_tmp], s[s_out_stride_n], 1
    s_lshr_b32 s[s_tmp+1], s[s_in_stride_n], 1
    s_mul_i32 s[s_in_stride_n_n1], s[s_move_slice_n_n1], s[s_tmp+1]  ; might be 0 or larger
    s_mul_i32 s[s_out_stride_n_n1], s[s_move_slice_n_n1], s[s_tmp]  ; might be 0 or larger
    s_lshl_b32 s[s_in_stride_n_n1], s[s_in_stride_n_n1], 1
    s_lshl_b32 s[s_out_stride_n_n1], s[s_out_stride_n_n1], 1
    
    
    s_lshl_b32 s[s_wei_stride_k], s[s_wei_stride_k], 2
    s_mov_b32 s[s_gemm_k_num_n1], 8
    s_mul_i32 s[s_knum], s[s_hoxwo], s[s_sub_n]

    ; start MFMA loop, 64x4 wave tile with 2x2 repeat, 1x1 step
    s_waitcnt vmcnt(16)
    ds_write_b32 v[v_sst_b_os], v[v_gld_b+0] 

    s_waitcnt vmcnt(0)
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a], v[v_gld_a+1], offset0:0, offset1:2
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+2], v[v_gld_a+3], offset0:4, offset1:6
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+4], v[v_gld_a+5], offset0:8, offset1:10
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+6], v[v_gld_a+7], offset0:12, offset1:14
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+8], v[v_gld_a+9], offset0:16, offset1:18
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+10], v[v_gld_a+11], offset0:20, offset1:22
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+12], v[v_gld_a+13], offset0:24, offset1:26
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+14], v[v_gld_a+15], offset0:28, offset1:30

    .v_clear_acc_c a_c, 16
    ; make sure acc WAR harzard, at least 1 nop for src_c
    s_sub_i32 s[s_kitr], s[s_knum], 32
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs_mfma_end

    v_add_u32 v[v_move_slice_n_idswo], s[s_move_slice_n_dswo], v[v_move_slice_n_idswo]
    v_cmpx_le_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_subrev_u32 v[v_move_slice_n_idswo], s[s_wo], v[v_move_slice_n_idswo]
    v_add_u32 v[v_move_slice_n_idsho], 1, v[v_move_slice_n_idsho]
    s_mov_b64 exec, -1

    v_add_u32 v[v_move_slice_n_idsho], s[s_move_slice_n_dsho], v[v_move_slice_n_idsho]
    v_cmpx_le_u32 vcc, s[s_ho], v[v_move_slice_n_idsho]
    v_subrev_u32 v[v_move_slice_n_idsho], s[s_ho], v[v_move_slice_n_idsho]
    v_add_u32 v[v_in_os_base], s[s_in_stride_n], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n], v[v_out_os_base]
    s_mov_b64 exec, -1

    v_add_u32 v[v_in_os_base], s[s_in_stride_n_n1], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n_n1], v[v_out_os_base]
    ; from hi, wi, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wi], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    v_lshl_add_u32 v[v_in_os], v[v_tmp], 1, v[v_in_os_base]
    ; from ho, wo, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wo], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    v_lshl_add_u32 v[v_out_os], v[v_tmp], 1, v[v_out_os_base]
    s_waitcnt lgkmcnt(0)
    s_barrier
L_igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs_mfma_body:
    ; do fma accumulate with unroll 32
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] 
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] 
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:64
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:1024
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_b+0], v[v_in_os], s[s_p_in:s_p_in+3], 0 offen offset:0
    buffer_load_dword v[v_gld_a+0], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:0
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:2048 ; load i_k:1 into local buffer 1, repeat 0
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:128 ; load i_k:1 into local buffer 1, repeat 0
    s_waitcnt lgkmcnt(3)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+1], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_stride_k] offen offset:0
    buffer_load_dword v[v_gld_a+2], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+0] offen offset:0
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:192 ; load i_k:1 into local buffer 1, repeat 1
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:3072 ; load i_k:1 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(4)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+1] offen offset:0
    buffer_load_dword v[v_gld_a+4], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+2] offen offset:0
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] offset:4096 ; load i_k:2 into local buffer 0, repeat 0
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:256 ; load i_k:2 into local buffer 0, repeat 0
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+5], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+3] offen offset:0
    buffer_load_dword v[v_gld_a+6], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+4] offen offset:0
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:320 ; load i_k:2 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+7], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+5] offen offset:0
    buffer_load_dword v[v_gld_a+8], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+6] offen offset:0
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:5120 ; load i_k:2 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+9], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+7] offen offset:0
    buffer_load_dword v[v_gld_a+10], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+8] offen offset:0
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:6144 ; load i_k:3 into local buffer 1, repeat 0
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+11], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+9] offen offset:0
    buffer_load_dword v[v_gld_a+12], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+10] offen offset:0
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:384 ; load i_k:3 into local buffer 1, repeat 0
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+13], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+11] offen offset:0
    buffer_load_dword v[v_gld_a+14], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+12] offen offset:0
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:448 ; load i_k:3 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    buffer_load_dword v[v_gld_a+15], v[v_out_os], s[s_p_out:s_p_out+3], s[s_out_offset+13] offen offset:0
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:7168 ; load i_k:3 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    v_add_u32 v[v_move_slice_n_idswo], s[s_move_slice_n_dswo], v[v_move_slice_n_idswo]
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] offset:8192 ; load i_k:4 into local buffer 0, repeat 0
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    v_cmpx_le_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_subrev_u32 v[v_move_slice_n_idswo], s[s_wo], v[v_move_slice_n_idswo]
    v_add_u32 v[v_move_slice_n_idsho], 1, v[v_move_slice_n_idsho]
    s_mov_b64 exec, -1
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:512 ; load i_k:4 into local buffer 0, repeat 0
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    v_add_u32 v[v_move_slice_n_idsho], s[s_move_slice_n_dsho], v[v_move_slice_n_idsho]
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:576 ; load i_k:4 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_cmpx_le_u32 vcc, s[s_ho], v[v_move_slice_n_idsho]
    v_subrev_u32 v[v_move_slice_n_idsho], s[s_ho], v[v_move_slice_n_idsho]
    v_add_u32 v[v_in_os_base], s[s_in_stride_n], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n], v[v_out_os_base]
    s_mov_b64 exec, -1
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:9216 ; load i_k:4 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    v_add_u32 v[v_in_os_base], s[s_in_stride_n_n1], v[v_in_os_base]
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:10240 ; load i_k:5 into local buffer 1, repeat 0
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    v_add_u32 v[v_out_os_base], s[s_out_stride_n_n1], v[v_out_os_base]
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:640 ; load i_k:5 into local buffer 1, repeat 0
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    v_mad_u32_u24 v[v_tmp], s[s_wi], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:704 ; load i_k:5 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_lshl_add_u32 v[v_in_os], v[v_tmp], 1, v[v_in_os_base]
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:11264 ; load i_k:5 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    v_mad_u32_u24 v[v_tmp], s[s_wo], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] offset:12288 ; load i_k:6 into local buffer 0, repeat 0
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    v_lshl_add_u32 v[v_out_os], v[v_tmp], 1, v[v_out_os_base]
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:768 ; load i_k:6 into local buffer 0, repeat 0
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:832 ; load i_k:6 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:13312 ; load i_k:6 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:14336 ; load i_k:7 into local buffer 1, repeat 0
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:896 ; load i_k:7 into local buffer 1, repeat 0
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:960 ; load i_k:7 into local buffer 1, repeat 1
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:15360 ; load i_k:7 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(0)
    s_barrier
    s_waitcnt vmcnt(16)
    ds_write_b32 v[v_sst_b_os], v[v_gld_b+0]
    s_waitcnt vmcnt(0)
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a], v[v_gld_a+1], offset0:0, offset1:2
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+2], v[v_gld_a+3], offset0:4, offset1:6
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+4], v[v_gld_a+5], offset0:8, offset1:10
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+6], v[v_gld_a+7], offset0:12, offset1:14
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+8], v[v_gld_a+9], offset0:16, offset1:18
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+10], v[v_gld_a+11], offset0:20, offset1:22
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+12], v[v_gld_a+13], offset0:24, offset1:26
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_write2_b32 v[v_sst_a_os], v[v_gld_a+14], v[v_gld_a+15], offset0:28, offset1:30
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    s_sub_i32 s[s_kitr], s[s_kitr], 32
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs_mfma_end
    s_waitcnt lgkmcnt(0)
    s_barrier
    s_branch L_igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs_mfma_body
L_igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs_mfma_end:
    s_waitcnt lgkmcnt(0)
    s_barrier
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] 
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] 
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:64
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:1024
    ; k iteration : 0
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:2048 ; load i_k:1 into local buffer 1, repeat 0
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:128 ; load i_k:1 into local buffer 1, repeat 0

    s_waitcnt lgkmcnt(3)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:192 ; load i_k:1 into local buffer 1, repeat 1
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:3072 ; load i_k:1 into local buffer 1, repeat 1

    s_waitcnt lgkmcnt(4)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] offset:4096 ; load i_k:2 into local buffer 0, repeat 0
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:256 ; load i_k:2 into local buffer 0, repeat 0

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:320 ; load i_k:2 into local buffer 0, repeat 1

    ; k iteration : 1
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:5120 ; load i_k:2 into local buffer 0, repeat 1

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:6144 ; load i_k:3 into local buffer 1, repeat 0

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:384 ; load i_k:3 into local buffer 1, repeat 0

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:448 ; load i_k:3 into local buffer 1, repeat 1

    ; k iteration : 2
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:7168 ; load i_k:3 into local buffer 1, repeat 1

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] offset:8192 ; load i_k:4 into local buffer 0, repeat 0

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:512 ; load i_k:4 into local buffer 0, repeat 0

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:576 ; load i_k:4 into local buffer 0, repeat 1

    ; k iteration : 3
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:9216 ; load i_k:4 into local buffer 0, repeat 1

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:10240 ; load i_k:5 into local buffer 1, repeat 0

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:640 ; load i_k:5 into local buffer 1, repeat 0

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:704 ; load i_k:5 into local buffer 1, repeat 1

    ; k iteration : 4
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:11264 ; load i_k:5 into local buffer 1, repeat 1

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_a:v_a+1], v[v_sld_a_os] offset:12288 ; load i_k:6 into local buffer 0, repeat 0

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:768 ; load i_k:6 into local buffer 0, repeat 0

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:832 ; load i_k:6 into local buffer 0, repeat 1

    ; k iteration : 5
    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+2:v_a+2+1], v[v_sld_a_os] offset:13312 ; load i_k:6 into local buffer 0, repeat 1

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_a+4:v_a+4+1], v[v_sld_a_os] offset:14336 ; load i_k:7 into local buffer 1, repeat 0

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:896 ; load i_k:7 into local buffer 1, repeat 0

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:960 ; load i_k:7 into local buffer 1, repeat 1
    ds_read_b64 v[v_a+6:v_a+6+1], v[v_sld_a_os] offset:15360 ; load i_k:7 into local buffer 1, repeat 1

    ; k iteration : 30
    s_waitcnt lgkmcnt(6)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+0:v_a+1], v[v_b+0:v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4

    s_waitcnt lgkmcnt(5)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+0:v_a+1], v[v_b+2:v_b+3], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4

    s_waitcnt lgkmcnt(4)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+2:v_a+3], v[v_b+0:v_b+1], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+2:v_a+3], v[v_b+2:v_b+3], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4
    ; k iteration : 31
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x4f16 a[a_c+0:a_c+3], v[v_a+4:v_a+5], v[v_b+4:v_b+5], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4

    s_waitcnt lgkmcnt(1)
    v_mfma_f32_4x4x4f16 a[a_c+4:a_c+7], v[v_a+4:v_a+5], v[v_b+6:v_b+7], a[a_c+4:a_c+7]     ; repeat:0x1, step:0x0, num_a_c:4

    s_waitcnt lgkmcnt(0)
    v_mfma_f32_4x4x4f16 a[a_c+8:a_c+11], v[v_a+6:v_a+7], v[v_b+4:v_b+5], a[a_c+8:a_c+11]     ; repeat:1x0, step:0x0, num_a_c:4

    v_mfma_f32_4x4x4f16 a[a_c+12:a_c+15], v[v_a+6:v_a+7], v[v_b+6:v_b+7], a[a_c+12:a_c+15]     ; repeat:1x1, step:0x0, num_a_c:4

    s_nop 3
    ; coalescing store, mapping:mt_m:256, mt_n:16, wt_m:64, wt_n:4, ws:4, r_m:2, r_n:2, s_m:1, s_n:1 | 4x4x4, lanegroup_m_tcbw:4x1x1x1, lanegroup_n_tcbw:1x4x1x1
    ; coalescing_groups:1, num_dword_per_group:16
    ; init_co_sub_m_index xdlops, block_size:256, macro-tile:256x16 sub_m_index:[0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:1, g_mt:1 | l_mr:2, l_ms:1, l_mw:1, l_mb:1, l_mt:4 | n_mc:1, n_ml:16, n_mv:2
    ; nd_stride:[1, 16, 1, 1, 1, 2, 1]
    ; start group 0, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:0, i_g_mt:0, m index start from 0
    s_barrier
    v_accvgpr_read_b32 v[v_c], a[a_c]
    v_accvgpr_read_b32 v[v_c+1], a[a_c+1]
    v_accvgpr_read_b32 v[v_c+2], a[a_c+2]
    v_accvgpr_read_b32 v[v_c+3], a[a_c+3]
    ds_write_b128 v[v_co_sst], v[v_c:v_c+3]    ; idword:0(0,0),  0x0 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    v_accvgpr_read_b32 v[v_c+4], a[a_c+4]
    v_accvgpr_read_b32 v[v_c+5], a[a_c+5]
    v_accvgpr_read_b32 v[v_c+6], a[a_c+6]
    v_accvgpr_read_b32 v[v_c+7], a[a_c+7]
    ds_write_b128 v[v_co_sst], v[v_c+4:v_c+4+3] offset:128   ; idword:8(0,8),  0x8 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    v_accvgpr_read_b32 v[v_c+8], a[a_c+8]
    v_accvgpr_read_b32 v[v_c+9], a[a_c+9]
    v_accvgpr_read_b32 v[v_c+10], a[a_c+10]
    v_accvgpr_read_b32 v[v_c+11], a[a_c+11]
    ds_write_b128 v[v_co_sst], v[v_c+8:v_c+8+3] offset:8192   ; idword:512(32,0),  32x0 | /4, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    v_accvgpr_read_b32 v[v_c+12], a[a_c+12]
    v_accvgpr_read_b32 v[v_c+13], a[a_c+13]
    v_accvgpr_read_b32 v[v_c+14], a[a_c+14]
    v_accvgpr_read_b32 v[v_c+15], a[a_c+15]
    ds_write_b128 v[v_co_sst], v[v_c+12:v_c+12+3] offset:8320   ; idword:520(32,8),  32x8 | /4, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] 
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:4096
    ds_read_b128 v[v_c+8:v_c+8+3], v[v_co_sld] offset:8192
    ds_read_b128 v[v_c+12:v_c+12+3], v[v_co_sld] offset:12288
    ;   store to global, m index start from 0, m0:0, m1:0
    s_mov_b32 s[s_tmp], 0   ; i_m:0(i_m0:0,i_m1:0)
    v_add_u32 v[v_cur_k], s[s_block_gtc_ik], v[v_co_sub_m_index]
    v_mov_b32 v[v_tmp], v[v_cur_k]
    s_waitcnt lgkmcnt(3)
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mov_b32 s[s_tmp], s[s_wei_stride_k]   ; i_m:1(i_m0:0,i_m1:1)
    v_add_u32 v[v_tmp], 1, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+1], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 2, s[s_wei_stride_k]   ; i_m:2(i_m0:0,i_m1:2)
    v_add_u32 v[v_tmp], 2, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+2], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 3, s[s_wei_stride_k]   ; i_m:3(i_m0:0,i_m1:3)
    v_add_u32 v[v_tmp], 3, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 64, s[s_wei_stride_k]   ; i_m:64(i_m0:0,i_m1:64)
    v_add_u32 v[v_tmp], 64, v[v_cur_k]
    s_waitcnt lgkmcnt(2)
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+4], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 65, s[s_wei_stride_k]   ; i_m:65(i_m0:0,i_m1:65)
    v_add_u32 v[v_tmp], 65, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+5], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 66, s[s_wei_stride_k]   ; i_m:66(i_m0:0,i_m1:66)
    v_add_u32 v[v_tmp], 66, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+6], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 67, s[s_wei_stride_k]   ; i_m:67(i_m0:0,i_m1:67)
    v_add_u32 v[v_tmp], 67, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+7], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 128, s[s_wei_stride_k]   ; i_m:128(i_m0:0,i_m1:128)
    v_add_u32 v[v_tmp], 128, v[v_cur_k]
    s_waitcnt lgkmcnt(1)
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+8], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 129, s[s_wei_stride_k]   ; i_m:129(i_m0:0,i_m1:129)
    v_add_u32 v[v_tmp], 129, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+9], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 130, s[s_wei_stride_k]   ; i_m:130(i_m0:0,i_m1:130)
    v_add_u32 v[v_tmp], 130, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+10], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 131, s[s_wei_stride_k]   ; i_m:131(i_m0:0,i_m1:131)
    v_add_u32 v[v_tmp], 131, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+11], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 192, s[s_wei_stride_k]   ; i_m:192(i_m0:0,i_m1:192)
    v_add_u32 v[v_tmp], 192, v[v_cur_k]
    s_waitcnt lgkmcnt(0)
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+12], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 193, s[s_wei_stride_k]   ; i_m:193(i_m0:0,i_m1:193)
    v_add_u32 v[v_tmp], 193, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+13], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 194, s[s_wei_stride_k]   ; i_m:194(i_m0:0,i_m1:194)
    v_add_u32 v[v_tmp], 194, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+14], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 195, s[s_wei_stride_k]   ; i_m:195(i_m0:0,i_m1:195)
    v_add_u32 v[v_tmp], 195, v[v_cur_k]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_atomic_add_f32 v[v_c+15], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]

L_igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs_out:
    s_endpgm
.rodata
.p2align 6
.amdhsa_kernel igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs
    .amdhsa_group_segment_fixed_size 32768
    .amdhsa_user_sgpr_kernarg_segment_ptr 1
    .amdhsa_system_sgpr_workgroup_id_x 1
    .amdhsa_system_vgpr_workitem_id 0
    .amdhsa_next_free_vgpr 78
    .amdhsa_next_free_sgpr 72
    .amdhsa_ieee_mode 0
    .amdhsa_dx10_clamp 0
.end_amdhsa_kernel

.amdgpu_metadata
---
amdhsa.version: [ 1, 0 ]
amdhsa.kernels:
  - .name: igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs
    .symbol: igemm_wrw_gtcx_nchw_fp16_bx4_ex0_bt256x16x32_wt64x4x4_ws1x1_wr2x2_ta1x2x1x16_1x16x1x16_tb1x2x1x1_1x16x1x16_gkgs.kd
    .sgpr_count: 78
    .vgpr_count: 78
    .kernarg_segment_align: 8
    .kernarg_segment_size: 96
    .group_segment_fixed_size: 32768
    .private_segment_fixed_size: 0
    .wavefront_size: 64
    .reqd_workgroup_size : [256, 1, 1]
    .max_flat_workgroup_size: 256
    .args:
    - { .name: p_in      , .size: 8, .offset:   0, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: false}
    - { .name: p_wei     , .size: 8, .offset:   8, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: p_out     , .size: 8, .offset:  16, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: hi        , .size: 4, .offset:  24, .value_kind: by_value, .value_type: i32}
    - { .name: wi        , .size: 4, .offset:  28, .value_kind: by_value, .value_type: i32}
    - { .name: n_         , .size: 4, .offset:  32, .value_kind: by_value, .value_type: i32}
    - { .name: k         , .size: 4, .offset:  36, .value_kind: by_value, .value_type: i32}
    - { .name: c         , .size: 4, .offset:  40, .value_kind: by_value, .value_type: i32}
    - { .name: ho        , .size: 4, .offset:  44, .value_kind: by_value, .value_type: i32}
    - { .name: wo        , .size: 4, .offset:  48, .value_kind: by_value, .value_type: i32}
    - { .name: stride_h  , .size: 4, .offset:  52, .value_kind: by_value, .value_type: i32}
    - { .name: stride_w  , .size: 4, .offset:  56, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_h, .size: 4, .offset:  60, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_w, .size: 4, .offset:  64, .value_kind: by_value, .value_type: i32}
    - { .name: pad_h     , .size: 4, .offset:  68, .value_kind: by_value, .value_type: i32}
    - { .name: pad_w     , .size: 4, .offset:  72, .value_kind: by_value, .value_type: i32}
    - { .name: y_         , .size: 4, .offset:  76, .value_kind: by_value, .value_type: i32}
    - { .name: x         , .size: 4, .offset:  80, .value_kind: by_value, .value_type: i32}
    - { .name: gemm_k_global_split, .size: 4, .offset:  84, .value_kind: by_value, .value_type: i32}
    - { .name: group     , .size: 4, .offset:  88, .value_kind: by_value, .value_type: i32}
    - { .name: __pack_0  , .size: 4, .offset:  92, .value_kind: by_value, .value_type: i32}
...
.end_amdgpu_metadata
