#pragma once

#include <wayland-version.h>

#if defined(_DEBUG)
static const struct shm_formats {
    uint32_t format;
    const char *description;
} shm_formats[] = {
    {WL_SHM_FORMAT_ARGB8888, "ARGB8888"},
    {WL_SHM_FORMAT_XRGB8888, "XRGB8888"},
    {WL_SHM_FORMAT_C8, "C8"},
    {WL_SHM_FORMAT_RGB332, "RGB332"},
    {WL_SHM_FORMAT_BGR233, "BGR233"},
    {WL_SHM_FORMAT_XRGB4444, "XRGB4444"},
    {WL_SHM_FORMAT_XBGR4444, "XBGR4444"},
    {WL_SHM_FORMAT_RGBX4444, "RGBX4444"},
    {WL_SHM_FORMAT_BGRX4444, "BGRX4444"},
    {WL_SHM_FORMAT_ARGB4444, "ARGB4444"},
    {WL_SHM_FORMAT_ABGR4444, "ABGR4444"},
    {WL_SHM_FORMAT_RGBA4444, "RGBA4444"},
    {WL_SHM_FORMAT_BGRA4444, "BGRA4444"},
    {WL_SHM_FORMAT_XRGB1555, "XRGB1555"},
    {WL_SHM_FORMAT_XBGR1555, "XBGR1555"},
    {WL_SHM_FORMAT_RGBX5551, "RGBX5551"},
    {WL_SHM_FORMAT_BGRX5551, "BGRX5551"},
    {WL_SHM_FORMAT_ARGB1555, "ARGB1555"},
    {WL_SHM_FORMAT_ABGR1555, "ABGR1555"},
    {WL_SHM_FORMAT_RGBA5551, "RGBA5551"},
    {WL_SHM_FORMAT_BGRA5551, "BGRA5551"},
    {WL_SHM_FORMAT_RGB565, "RGB565"},
    {WL_SHM_FORMAT_BGR565, "BGR565"},
    {WL_SHM_FORMAT_RGB888, "RGB888"},
    {WL_SHM_FORMAT_BGR888, "BGR888"},
    {WL_SHM_FORMAT_XBGR8888, "XBGR8888"},
    {WL_SHM_FORMAT_RGBX8888, "RGBX8888"},
    {WL_SHM_FORMAT_BGRX8888, "BGRX8888"},
    {WL_SHM_FORMAT_ABGR8888, "ABGR8888"},
    {WL_SHM_FORMAT_RGBA8888, "RGBA8888"},
    {WL_SHM_FORMAT_BGRA8888, "BGRA8888"},
    {WL_SHM_FORMAT_XRGB2101010, "XRGB2101010"},
    {WL_SHM_FORMAT_XBGR2101010, "XBGR2101010"},
    {WL_SHM_FORMAT_RGBX1010102, "RGBX1010102"},
    {WL_SHM_FORMAT_BGRX1010102, "BGRX1010102"},
    {WL_SHM_FORMAT_ARGB2101010, "ARGB2101010"},
    {WL_SHM_FORMAT_ABGR2101010, "ABGR2101010"},
    {WL_SHM_FORMAT_RGBA1010102, "RGBA1010102"},
    {WL_SHM_FORMAT_BGRA1010102, "BGRA1010102"},
    {WL_SHM_FORMAT_YUYV, "YUYV"},
    {WL_SHM_FORMAT_YVYU, "YVYU"},
    {WL_SHM_FORMAT_UYVY, "UYVY"},
    {WL_SHM_FORMAT_VYUY, "VYUY"},
    {WL_SHM_FORMAT_AYUV, "AYUV"},
    {WL_SHM_FORMAT_NV12, "NV12"},
    {WL_SHM_FORMAT_NV21, "NV21"},
    {WL_SHM_FORMAT_NV16, "NV16"},
    {WL_SHM_FORMAT_NV61, "NV61"},
    {WL_SHM_FORMAT_YUV410, "YUV410"},
    {WL_SHM_FORMAT_YVU410, "YVU410"},
    {WL_SHM_FORMAT_YUV411, "YUV411"},
    {WL_SHM_FORMAT_YVU411, "YVU411"},
    {WL_SHM_FORMAT_YUV420, "YUV420"},
    {WL_SHM_FORMAT_YVU420, "YVU420"},
    {WL_SHM_FORMAT_YUV422, "YUV422"},
    {WL_SHM_FORMAT_YVU422, "YVU422"},
    {WL_SHM_FORMAT_YUV444, "YUV444"},
    {WL_SHM_FORMAT_YVU444, "YVU444"},
    {WL_SHM_FORMAT_R8, "R8"},
    {WL_SHM_FORMAT_R16, "R16"},
    {WL_SHM_FORMAT_RG88, "RG88"},
    {WL_SHM_FORMAT_GR88, "GR88"},
    {WL_SHM_FORMAT_RG1616, "RG1616"},
    {WL_SHM_FORMAT_GR1616, "GR1616"},
    {WL_SHM_FORMAT_XRGB16161616F, "XRGB16161616F"},
    {WL_SHM_FORMAT_XBGR16161616F, "XBGR16161616F"},
    {WL_SHM_FORMAT_ARGB16161616F, "ARGB16161616F"},
    {WL_SHM_FORMAT_ABGR16161616F, "ABGR16161616F"},
    {WL_SHM_FORMAT_XYUV8888, "XYUV8888"},
    {WL_SHM_FORMAT_VUY888, "VUY888"},
    {WL_SHM_FORMAT_VUY101010, "VUY101010"},
    {WL_SHM_FORMAT_Y210, "Y210"},
    {WL_SHM_FORMAT_Y212, "Y212"},
    {WL_SHM_FORMAT_Y216, "Y216"},
    {WL_SHM_FORMAT_Y410, "Y410"},
    {WL_SHM_FORMAT_Y412, "Y412"},
    {WL_SHM_FORMAT_Y416, "Y416"},
    {WL_SHM_FORMAT_XVYU2101010, "XVYU2101010"},
    {WL_SHM_FORMAT_XVYU12_16161616, "XVYU12_16161616"},
    {WL_SHM_FORMAT_XVYU16161616, "XVYU16161616"},
    {WL_SHM_FORMAT_Y0L0, "Y0L0"},
    {WL_SHM_FORMAT_X0L0, "X0L0"},
    {WL_SHM_FORMAT_Y0L2, "Y0L2"},
    {WL_SHM_FORMAT_X0L2, "X0L2"},
    {WL_SHM_FORMAT_YUV420_8BIT, "YUV420_8BIT"},
    {WL_SHM_FORMAT_YUV420_10BIT, "YUV420_10BIT"},
    {WL_SHM_FORMAT_XRGB8888_A8, "XRGB8888_A8"},
    {WL_SHM_FORMAT_XBGR8888_A8, "XBGR8888_A8"},
    {WL_SHM_FORMAT_RGBX8888_A8, "RGBX8888_A8"},
    {WL_SHM_FORMAT_BGRX8888_A8, "BGRX8888_A8"},
    {WL_SHM_FORMAT_RGB888_A8, "RGB888_A8"},
    {WL_SHM_FORMAT_BGR888_A8, "BGR888_A8"},
    {WL_SHM_FORMAT_RGB565_A8, "RGB565_A8"},
    {WL_SHM_FORMAT_BGR565_A8, "BGR565_A8"},
    {WL_SHM_FORMAT_NV24, "NV24"},
    {WL_SHM_FORMAT_NV42, "NV42"},
    {WL_SHM_FORMAT_P210, "P210"},
    {WL_SHM_FORMAT_P010, "P010"},
    {WL_SHM_FORMAT_P012, "P012"},
    {WL_SHM_FORMAT_P016, "P016"},
    {WL_SHM_FORMAT_AXBXGXRX106106106106, "AXBXGXRX106106106106"},
    {WL_SHM_FORMAT_NV15, "NV15"},
    {WL_SHM_FORMAT_Q410, "Q410"},
    {WL_SHM_FORMAT_Q401, "Q401"},
#if WAYLAND_VERSION_MAJOR > 1 || WAYLAND_VERSION_MINOR >= 20
    {WL_SHM_FORMAT_XRGB16161616, "XRGB16161616"},
    {WL_SHM_FORMAT_XBGR16161616, "XBGR16161616"},
    {WL_SHM_FORMAT_ARGB16161616, "ARGB16161616"},
    {WL_SHM_FORMAT_ABGR16161616, "ABGR16161616"},
#endif
};
#endif
