---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références, 
              note en bas de page
---

# Comment renvoyer une référence en note de bas de page ?

La question peut se comprendre de plusieurs manières :

- placer le numéro de la référence en note de bas de page, tout en conservant 
  la bibliographie à sa place usuelle ;
- placer tout le contenu de l'entrée citée en note de bas de page.


## Avec des commandes de base

Dans le premier cas, il suffit de redéfinir la commande `\@cite` comme suit :

```{noedit}
\makeatletter
\def\@cite#1#2{%
  \footnote{#1\if@tempswa, #2\fi}}
\makeatother
```

En voici un exemple appliqué.

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{dioph-arith,
    author = {Diophante},
    title = {Les arithmétiques},
    publisher = {Les belles lettres},
    volume = {1},
    year = {1982},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % La redéfinition de la commande \cite
  \makeatletter
    \def\@cite#1#2{%
    \footnote{#1\if@tempswa, #2\fi}}
  \makeatother

\begin{document}
\section{Prolégomènes importants}
Par respect pour M. Fermat, la note en bas de page qui suit\cite{dioph-arith}
ne dispose pas d'assez d'espace pour insérer des démonstrations pouvant
défrayer les mathématiques modernes.
\bibliographystyle{alpha}
\bibliography{\jobname}
\end{document}
```


## Avec l'extension <ctanpkg:footbib>

:::{warning}
L’extension <ctanpkg:footbib> peut rencontrer des difficultés car 
elle ne peut agir si la routine de sortie de LaTeX est modifiée par une
autre extension. Cette solution n'est donc pas vraiment recommandée.
Ce qui suit est informatif. 
:::

Dans le second cas, la solution consiste à passer par l'extension 
<ctanpkg:footbib>. Bien que pratique, elle ne cohabite pas bien 
avec l'extension <ctanpkg:multicol>, entre autres.


:::{todo} Ajouter un exemple.
:::