---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, travail, commerce, 
              code-barre, QR code, URL, smartphone, QR-facture, QR-Rechnung
---

# Comment générer des QR codes ?

Les [QR codes](wpfr:Code_QR) (pour *Quick Response Code*) sont un type de
code-barres en deux dimensions constitué de points noirs disposés dans un carré
à fond blanc. L'agencement de ces points décrit l'information que contient le
code. Ils peuvent être lus par un lecteur de code-barre ou un smartphone.


## Avec l'extension <ctanpkg:qrcode>

L'extension <ctanpkg:qrcode> permet de générer des QR codes directement depuis
LaTeX :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{qrcode}

\begin{document}
\qrcode{Données à coder}
\end{document}
```

Dans la plupart des cas, c’est une URL que vous voudrez inclure 
dans le QR code. Par exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{qrcode}

\begin{document}
\qrcode{https://www.gutenberg-asso.fr/}
\end{document}
```

Notez que si vous utilisez <ctanpkg:hyperref>, `qrcode` mettra automatiquement 
un lien cliquable vers l'adresse en question, à moins de spécifier l’option
`nolink` à la commande.

Il est également possible de spécifier la hauteur du QR code, avec l’option
`height` (sachant que les QR codes sont obligatoirement carrés...).


### Versions des QR codes

Vous noterez la différence de résolution entre les deux QR codes
précédents. Ceci s’explique par le fait que la chaîne de caractère à coder dans
le second exemple est plus longue que dans le premier. Les QR codes 
sont définis suivant différentes tailles de grille, chaque taille correspondant
à une "version" : de 21×21 points (version 1) jusqu’à 177×177 points 
(version 40).

Ainsi, la version 1 permet de coder au maximum 25 caractères alphanumériques
tandis que la version 40 peut en coder 4296.

L'extension <ctanpkg:qrcode> calcule automatiquement la version minimale 
à utiliser pour chaque chaîne (ça se voit dans le log de compilation), 
mais il est possible de forcer cette valeur (pour augmenter la version, 
évidemment), par exemple pour un aspect esthétique (si vous avez deux QR codes
côte à côte) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{qrcode}

\begin{document}
\qrcode[version=3]{Données à coder}
\end{document}
```


## QR-factures

L'extension <ctanpkg:qrbill> permet de générer les 
[QR factures utilisées en Suisse depuis 2020](wpfr:QR-facture), qui incluent
un QR code particulier, avec le dessin d'une croix suisse en leur centre. 
Il s'utilise avec `lualatex` ou `xelatex` (versions de 2020 et ultérieures), 
car il appelle <ctanpkg:fontspec> [^footnote-1]. Dans l'exemple ci-dessous, 
le document est affiché sur une page mis en format paysage (vous pourriez
aussi redimensionner la QR-facture). 

```
%!TEX engine=lualatex
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{qrbill}
  \usepackage[a4paper,landscape]{geometry}

\begin{document}
\QRbill[
  creditor={TexBanque\\
  1 Avenue Donald Knuth\\ 
  2342 Zurich\\
  CH},
  Account=CH3141592653589793238,
]
\end{document}
```


## QR-EPC

Le package <ctanpkg:epcqrcode> permet de générer les 
[QR codes du conseil européen des paiements](wpfr:QR_code_EPC), qui incluent 
un QR code particulier, dont le contenu peut être utilisé pour initier 
des virements SEPA au sein de l'espace unique de paiement en euros.

:::{todo} Ajouter un exemple.
:::


## QR codes pour références bibliographiques

L'extension <ctanpkg:bib2qr> permet de créer un QR code associé à une référence
bibliographique présente dans un fichier `.bib` appelé par votre document.
L'exemple suivant, adapté de la [documentation](texdoc:bib2qr) de l'extension, 
illustre son utilisation. Ici, c'est l'environnement `filecontents` qui crée 
le fichier `.bib` mais ce contournement est propre à la FAQ. Vous retrouverez 
fréquemment cette méthode dans la section 
[Bibliographie](/3_composition/annexes/bibliographie/start) de la FAQ).

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @software{bib2qr,
    author = {Schreinemachers, Christian},
    title = {bib2qr - A LaTeX package for citing BibTeX entries with QR codes},
    url = {https://codeberg.org/Cs137/bib2qr/releases/tag/v0.2},
    version = {v0.2},
   date = {2024-07-31}
  }
  \end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{bib2qr}
  
  \addbibresource{\jobname.bib}

\begin{document}
Si vous voulez en savoir plus sur \textsf{bib2qr}, vous pouvez consulter
la référence suivante : \\[1ex]
\qrfullcite{bib2qr}
\end{document}
```


:::{sources}
- [Générer des QR codes directement dans LaTeX](https://blog.dorian-depriester.fr/latex/generer-des-qr-codes-directement-dans-latex),
  sur le site [le Blog de Dorian](https://blog.dorian-depriester.fr/)
- [Style Guide QR-bill](https://www.six-group.com/en/products-services/banking-services/payment-standardization.html)
:::


[^footnote-1]: Sa documentation indique cependant une façon de l'utiliser avec
  `pdflatex`, en redéfinissant la commande `\qrbillfont`.