/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.EnumMap;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TopLevel
extends IdScriptableObject {
    static final long serialVersionUID = -4648046356662472260L;
    private EnumMap<Builtins, BaseFunction> ctors;
    private EnumMap<NativeErrors, BaseFunction> errors;

    @Override
    public String getClassName() {
        return "global";
    }

    public void cacheBuiltins() {
        Object object;
        this.ctors = new EnumMap(Builtins.class);
        for (Builtins enum_ : Builtins.values()) {
            object = ScriptableObject.getProperty((Scriptable)this, enum_.name());
            if (!(object instanceof BaseFunction)) continue;
            this.ctors.put(enum_, (BaseFunction)object);
        }
        this.errors = new EnumMap(NativeErrors.class);
        for (Enum enum_ : NativeErrors.values()) {
            object = ScriptableObject.getProperty((Scriptable)this, enum_.name());
            if (!(object instanceof BaseFunction)) continue;
            this.errors.put((NativeErrors)enum_, (BaseFunction)object);
        }
    }

    public static Function getBuiltinCtor(Context context, Scriptable scriptable, Builtins builtins) {
        BaseFunction baseFunction;
        assert (scriptable.getParentScope() == null);
        if (scriptable instanceof TopLevel && (baseFunction = ((TopLevel)scriptable).getBuiltinCtor(builtins)) != null) {
            return baseFunction;
        }
        return ScriptRuntime.getExistingCtor(context, scriptable, builtins.name());
    }

    static Function getNativeErrorCtor(Context context, Scriptable scriptable, NativeErrors nativeErrors) {
        BaseFunction baseFunction;
        assert (scriptable.getParentScope() == null);
        if (scriptable instanceof TopLevel && (baseFunction = ((TopLevel)scriptable).getNativeErrorCtor(nativeErrors)) != null) {
            return baseFunction;
        }
        return ScriptRuntime.getExistingCtor(context, scriptable, nativeErrors.name());
    }

    public static Scriptable getBuiltinPrototype(Scriptable scriptable, Builtins builtins) {
        Scriptable scriptable2;
        assert (scriptable.getParentScope() == null);
        if (scriptable instanceof TopLevel && (scriptable2 = ((TopLevel)scriptable).getBuiltinPrototype(builtins)) != null) {
            return scriptable2;
        }
        return ScriptableObject.getClassPrototype(scriptable, builtins.name());
    }

    public BaseFunction getBuiltinCtor(Builtins builtins) {
        return this.ctors != null ? this.ctors.get((Object)builtins) : null;
    }

    BaseFunction getNativeErrorCtor(NativeErrors nativeErrors) {
        return this.errors != null ? this.errors.get((Object)nativeErrors) : null;
    }

    public Scriptable getBuiltinPrototype(Builtins builtins) {
        BaseFunction baseFunction = this.getBuiltinCtor(builtins);
        Object object = baseFunction != null ? baseFunction.getPrototypeProperty() : null;
        return object instanceof Scriptable ? (Scriptable)object : null;
    }

    public static enum Builtins {
        Object,
        Array,
        Function,
        String,
        Number,
        Boolean,
        RegExp,
        Error;

    }

    static enum NativeErrors {
        Error,
        EvalError,
        RangeError,
        ReferenceError,
        SyntaxError,
        TypeError,
        URIError,
        InternalError,
        JavaException;

    }
}

