(*************************************************************
 *                                                           *
 *  Cryptographic protocol verifier                          *
 *                                                           *
 *  Bruno Blanchet, Vincent Cheval, and Marc Sylvestre       *
 *                                                           *
 *  Copyright (C) INRIA, CNRS 2000-2020                      *
 *                                                           *
 *************************************************************)

(*

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details (in file LICENSE).

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)
(* [solve_auth horn_state queries] solves the correspondence queries [queries]
   using the Horn clauses and other information for resolution in
   [horn_state] obtained by translation from the process.

   This function takes as argument pairs of queries.
   The first component of the pair is the original query as entered by the user, for display.
   The second component is the encoded query, used for resolution. *)

val solve_auth : Types.t_horn_state -> Pitypes.t_pi_state -> (Pitypes.query_res * Pitypes.t_query) list
