/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog;

import com.jfrog.GradleDependencyNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;

public class GradleDependencyTreeUtils {
    private static final int MAX_DEP_POPULATIONS_IN_CONFIG = 10;

    public static void addConfiguration(GradleDependencyNode root, Configuration configuration, Map<String, GradleDependencyNode> nodes) {
        if (configuration.isCanBeResolved()) {
            GradleDependencyTreeUtils.addResolvedConfiguration(root, configuration, nodes);
        } else {
            GradleDependencyTreeUtils.addUnresolvedConfiguration(root, configuration, nodes);
        }
    }

    private static void addResolvedConfiguration(GradleDependencyNode root, Configuration configuration, Map<String, GradleDependencyNode> nodes) {
        root.getConfigurations().add(configuration.getName());
        ResolvedComponentResult componentResult = configuration.getIncoming().getResolutionResult().getRoot();
        HashMap<String, Integer> depPopulations = new HashMap<String, Integer>();
        for (DependencyResult dependency : componentResult.getDependencies()) {
            GradleDependencyTreeUtils.populateTree(root, configuration.getName(), dependency, new HashSet<String>(), nodes, depPopulations);
        }
    }

    private static void addUnresolvedConfiguration(GradleDependencyNode root, Configuration configuration, Map<String, GradleDependencyNode> nodes) {
        for (Dependency dependency : configuration.getDependencies()) {
            GradleDependencyNode child = new GradleDependencyNode(configuration.getName());
            child.setUnresolved(true);
            if (dependency.getVersion() == null) continue;
            GradleDependencyTreeUtils.addChild(root, String.join((CharSequence)":", dependency.getGroup(), dependency.getName(), dependency.getVersion()), child, nodes);
        }
    }

    private static void populateTree(GradleDependencyNode node, String configurationName, DependencyResult dependency, Set<String> addedChildren, Map<String, GradleDependencyNode> nodes, Map<String, Integer> depPopulations) {
        GradleDependencyNode child = new GradleDependencyNode(configurationName);
        if (dependency instanceof UnresolvedDependencyResult) {
            child.setUnresolved(true);
            GradleDependencyTreeUtils.addChild(node, dependency.getRequested().getDisplayName(), child, nodes);
            return;
        }
        ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependency;
        ModuleVersionIdentifier moduleVersion = resolvedDependency.getSelected().getModuleVersion();
        if (moduleVersion == null) {
            return;
        }
        String nodeId = moduleVersion.toString();
        int populations = depPopulations.getOrDefault(nodeId, 0);
        if (!addedChildren.add(nodeId) || populations >= 10) {
            return;
        }
        depPopulations.put(nodeId, populations + 1);
        for (DependencyResult dependencyResult : resolvedDependency.getSelected().getDependencies()) {
            GradleDependencyTreeUtils.populateTree(child, configurationName, dependencyResult, new HashSet<String>(addedChildren), nodes, depPopulations);
        }
        GradleDependencyTreeUtils.addChild(node, nodeId, child, nodes);
    }

    static void addChild(GradleDependencyNode parent, String childId, GradleDependencyNode childToAdd, Map<String, GradleDependencyNode> nodes) {
        GradleDependencyNode child = nodes.get(childId);
        if (child == null) {
            nodes.put(childId, childToAdd);
        } else {
            child.getConfigurations().addAll(childToAdd.getConfigurations());
            child.setUnresolved(child.isUnresolved() && childToAdd.isUnresolved());
            child.getChildren().addAll(childToAdd.getChildren());
        }
        parent.getChildren().add(childId);
    }
}

