# C++ Static Reflection library for Thrift
This is the C++ static reflection library for Thrift, which provides reflection support at compile-time through the use of meta-programming.


## Usage
Since there's no native support for static reflection in C++, Thrift will generate some metadata to ensure portability. This metadata needs to be included to enable static reflection support.

Static reflection is only provided for the `cpp2` language backend, but it's backwards compatible with `cpp` through the existing `compatibility` option from `cpp2`.

To direct Thrift to generate the static reflection metadata, use the `reflection` option for the `cpp2` language:

```sh
$ thrift --gen cpp2:reflection MyModule.thrift
```

Thrift breaks the metadata up in different headers to help reduce compilation times, so that a user can include only what's needed. To include this metadata in your code, include the appropriate header containing the metadata you need, as described below.

Say your module is defined in `some_dir/MyModule.thrift`, these headers will be generated:
- `some_dir/gen-cpp2/MyModule_fatal.h`: general module metadata. Necessary when using `reflect_module` and related primitives;
- `some_dir/gen-cpp2/MyModule_fatal_types.h`: metadata for all types declared in the module, necessary when using `reflect_struct`, `reflect_enum`, `fatal::enum_traits`, `reflect_variant`, `fatal::variant_traits` and related primitives;
- `some_dir/gen-cpp2/MyModule_fatal_all.h`: convenience header that includes all the static reflection metadata generated by the Thrift compiler.


## Documentation
Most documentation can be found inline in the header files under the reflection library directory.

There are some demo applications unside the [`demo/` directory](demo/).

There's a [video from the CppCon 2016 presentation](https://www.youtube.com/watch?v=tq0YfWFlVZA) that goes through the basics of reflection, as well as some of the [demo applications](demo/). The [accompanying slides](docs/cppcon16.pdf) with additional examples can be found in the [`docs/` directory](docs/).


## Dependencies
Thrift's C++ Static Reflection makes use of the [Facebook Template Library](https://github.com/facebook/fatal) to abstract most of the template meta-programming.


# Troubleshooting
The most common issue by far is forgetting to add some of the metadata headers generated by Thrift. Refer to the [Usage](#usage) section for more information.
