"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWindowOverlap = exports.getScrollableOverlap = exports.getOverlap = exports.canScrollWindow = exports.canScrollScrollable = exports.canPartiallyScroll = void 0;
var _position = require("./position");
// Source: https://github.com/atlassian/react-beautiful-dnd

var smallestSigned = (0, _position.apply)(function (value) {
  if (value === 0) {
    return 0;
  }
  return value > 0 ? 1 : -1;
});
// We need to figure out how much of the movement
// cannot be done with a scroll
var getOverlap = exports.getOverlap = function () {
  var getRemainder = function getRemainder(target, max) {
    if (target < 0) {
      return target;
    }
    if (target > max) {
      return target - max;
    }
    return 0;
  };
  return function (_ref) {
    var current = _ref.current,
      max = _ref.max,
      change = _ref.change;
    var targetScroll = (0, _position.add)(current, change);
    var overlap = {
      x: getRemainder(targetScroll.x, max.x),
      y: getRemainder(targetScroll.y, max.y)
    };
    if ((0, _position.isEqual)(overlap, _position.origin)) {
      return null;
    }
    return overlap;
  };
}();
var canPartiallyScroll = exports.canPartiallyScroll = function canPartiallyScroll(_ref2) {
  var rawMax = _ref2.max,
    current = _ref2.current,
    change = _ref2.change;
  // It is possible for the max scroll to be greater than the current scroll
  // when there are scrollbars on the cross axis. We adjust for this by
  // increasing the max scroll point if needed
  // This will allow movements backwards even if the current scroll is greater than the max scroll
  var max = {
    x: Math.max(current.x, rawMax.x),
    y: Math.max(current.y, rawMax.y)
  };

  // Only need to be able to move the smallest amount in the desired direction
  var smallestChange = smallestSigned(change);
  var overlap = getOverlap({
    max: max,
    current: current,
    change: smallestChange
  });

  // no overlap at all - we can move there!
  if (!overlap) {
    return true;
  }

  // if there was an x value, but there is no x overlap - then we can scroll on the x!
  if (smallestChange.x !== 0 && overlap.x === 0) {
    return true;
  }

  // if there was an y value, but there is no y overlap - then we can scroll on the y!
  if (smallestChange.y !== 0 && overlap.y === 0) {
    return true;
  }
  return false;
};
var canScrollWindow = exports.canScrollWindow = function canScrollWindow(viewport, change) {
  return canPartiallyScroll({
    current: viewport.scroll.current,
    max: viewport.scroll.max,
    change: change
  });
};
var getWindowOverlap = exports.getWindowOverlap = function getWindowOverlap(viewport, change) {
  if (!canScrollWindow(viewport, change)) {
    return null;
  }
  var max = viewport.scroll.max;
  var current = viewport.scroll.current;
  return getOverlap({
    current: current,
    max: max,
    change: change
  });
};
var canScrollScrollable = exports.canScrollScrollable = function canScrollScrollable(scrollable, change) {
  return canPartiallyScroll({
    current: scrollable.scroll.current,
    max: scrollable.scroll.max,
    change: change
  });
};
var getScrollableOverlap = exports.getScrollableOverlap = function getScrollableOverlap(scrollable, change) {
  if (!canScrollScrollable(scrollable, change)) {
    return null;
  }
  return getOverlap({
    current: scrollable.scroll.current,
    max: scrollable.scroll.max,
    change: change
  });
};