/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.swtgui;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.charabia.jsmoothgen.application.swtgui.JSmoothApplication;
import net.charabia.jsmoothgen.application.swtgui.SkeletonPage;
import net.charabia.jsmoothgen.skeleton.SkeletonProperty;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SkeletonPropertiesDialog
extends Dialog {
    private Text text;
    private Button check;
    private List controls = new Vector();
    private SkeletonPage page;
    private JSmoothApplication app;

    public SkeletonPropertiesDialog(SkeletonPage page) {
        super(page.getApplication().getShell());
        this.page = page;
    }

    protected Control createDialogArea(Composite parent) {
        int i;
        Composite cmpDlgArea = new Composite(parent, 0);
        cmpDlgArea.setLayout((Layout)new GridLayout());
        SkeletonProperty[] props = this.page.getApplication().getSkeletonProperties();
        for (i = 0; i < props.length; ++i) {
            System.out.println("[DEBUG] Loading skeleton property: " + props[i].getIdName() + "=" + props[i].getValue());
        }
        for (i = 0; i < props.length; ++i) {
            Control c = this.createPropertyControl(cmpDlgArea, props[i]);
            c.setData((Object)props[i]);
            this.controls.add(c);
        }
        return cmpDlgArea;
    }

    private Control createPropertyControl(Composite wParent, SkeletonProperty prop) {
        Group group = null;
        GridData grid = null;
        if (prop.getType().equals(SkeletonProperty.TYPE_STRING)) {
            group = new Group(wParent, 0);
            grid = new GridData(4);
            grid.widthHint = 400;
            group.setLayoutData((Object)grid);
            group.setLayout((Layout)new GridLayout());
            group.setText(prop.getLabel());
            this.text = new Text((Composite)group, 2052);
            grid = new GridData(1808);
            this.text.setLayoutData((Object)grid);
            this.text.setText(prop.getValue());
            return this.text;
        }
        if (prop.getType().equals(SkeletonProperty.TYPE_TEXTAREA)) {
            group = new Group(wParent, 0);
            grid = new GridData(4);
            grid.widthHint = 400;
            grid.heightHint = 100;
            group.setLayoutData((Object)grid);
            group.setLayout((Layout)new GridLayout());
            group.setText(prop.getLabel());
            this.text = new Text((Composite)group, 2818);
            grid = new GridData(1808);
            this.text.setLayoutData((Object)grid);
            this.text.setText(prop.getValue());
            return this.text;
        }
        if (prop.getType().equals(SkeletonProperty.TYPE_BOOLEAN)) {
            Button chk = new Button(wParent, 32);
            chk.setText(prop.getLabel());
            chk.setSelection("1".equals(prop.getValue()));
            return chk;
        }
        throw new UnsupportedOperationException("Unknown skeleton property type.");
    }

    protected void okPressed() {
        Iterator it = this.controls.iterator();
        JSmoothApplication app = this.page.getApplication();
        Control ctrl = null;
        String value = null;
        SkeletonProperty prop = null;
        while (it.hasNext()) {
            ctrl = (Control)it.next();
            prop = (SkeletonProperty)ctrl.getData();
            if (prop.getType().equals(SkeletonProperty.TYPE_STRING)) {
                value = ((Text)ctrl).getText();
                prop.setValue(value);
            } else if (prop.getType().equals(SkeletonProperty.TYPE_TEXTAREA)) {
                value = ((Text)ctrl).getText();
                prop.setValue(value);
            } else if (prop.getType().equals(SkeletonProperty.TYPE_BOOLEAN)) {
                boolean b = ((Button)ctrl).getSelection();
                value = b ? "1" : "0";
                prop.setValue(value);
            }
            app.setSkeletonProperty(prop);
        }
        super.okPressed();
    }
}

