/*
# Copyright (C) 2001 Cyberdude47
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ---------------------------------------------------------------------------
#                   ADSL4LINUX ADSL MAIN CONTROL BINARY
# ---------------------------------------------------------------------------
#
# $Id: cyberdude47 Exp $
#                                                      
# Program to display your ADSL Statistics, actually only works with ADSL4Linux.
# To use this program "as" ADSL4Linux component you need to do it this way to
# make sure it works.
# . /status /var/log/adslusage.log /var/log/adsltotalusage.log
#
#
# Thanx go out to Zapata! Actually he created or debugged most (well.. all)
# of these functions. 
# Thanx again!! :)
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/stat.h>
#include <signal.h>

#include "adsl.h"
#include "adslstatus.h"

time_t    tmNow;
uid_t     uid;

int main (int argc, char *argv[])
{	time(&tmNow);
	if (argc < 2 )
	{	return usage(argv[0]);
	}
	if (strcmp(argv[1], "start") == 0)
	{	return start(argc, argv[0], argv[2]);
	}
	if (strcmp(argv[1], "stop") == 0)
	{	return stop();
	}
	if (strcmp(argv[1], "version") == 0)
	{	return version();
	}
	if (strcmp(argv[1], "restart") == 0)
	{	return restart(argc, argv[0], argv[2]);
	}
	if (strcmp(argv[1], "status") == 0)
	{	if ( !isAdslUp() )
			return 1;
			return statuslogging();
	}
	if (strcmp(argv[1], "startlog") == 0 && uid == 0)
	{	if ( !isAdslUp() )
			return 1;
			return startlogging();
	}
	if (strcmp(argv[1], "stoplog") == 0 && uid == 0)
	{	if ( !isAdslUp() )
			return 1;
			return stoplogging();
	}

	if (strcmp(argv[1], "update") == 0)
	{	if ( !isAdslUp() )
			return 1;
			return usagelogging();
	}

	return usage(argv[0]);
}

int usage(char *programpath)
{	fprintf(stderr,"\nUsage: %s {start|stop|status|version}\n", programpath);
	fprintf(stderr," Status options:\n");
	fprintf(stderr,"\tstatus       only show counters\n");
	fprintf(stderr,"\tstartlog     start logging (root only)\n");
	fprintf(stderr,"\tstoplog      stop logging (root only)\n");
	fprintf(stderr,"\tupdate       update counters in logging (root only)\n");

	return 0;
}


int waitforconnection()
{	int i;
	for (i=0; i<RETRY; i++)
	{	if (isadslconnected())
			break;
		else
		{	printf(".");
			fflush(stdout);
			sleep(SLEEP);
		}
	}
	return isadslconnected();
}

int start(int args, char name[10], char arg[5])
{	int out;
	int pc;
	int i;

	if ( args < 3)
	{	pc=1;
	}
	else if (strcmp(arg, "pc1") == 0)
	{	pc=1;
	}
	else if (strcmp(arg, "pc2") == 0)
	{	pc=2;
	}
	else if (strcmp(arg, "pc3") == 0)
	{	pc=3;
	}
	else if (strcmp(arg, "pc4") == 0)
	{	pc=4;     
	}
	else
	{	printf("\nUsage: %s start pc<number 1 to 4>\n", name);
		printf("Example: %s start pc2\n", name);
		return 1;
	}

	if (!isadslrunning())
	{	switch(pc)
		{	case 1:	out=system("pppd call adsl");
				break;
			case 2:	out=system("pppd call adsl2");
				break;
			case 3:	out=system("pppd call adsl3");
				break;
			case 4:	out=system("pppd call adsl4");
				break;
		}
	}
	else
	{	printf("\nError: connection already available!\n");
		return 1;
	}

	if (waitforconnection())
	{	printf("\nConnection Established\n");
		sleep(5);
		isAdslUp();     
		startlogging();
		return 0;
	}
	else
	{	printf("\nConnection FAILED!\n");
		return 1;
	}
}

int stop(void)
{	pid_t ppppid;
	int j;

	if ( !isAdslUp() )
	{	printf("\nADSL connection already down.\nNo need to stop it.\n");
		return 1;
	}
	else
	{	stoplogging();     

		ppppid=getpidofconn(STAT_FILE);
		if (ppppid > 1)
		{	printf("\nSending SIGTERM to pppd(%d) ",ppppid);
			kill(ppppid, SIGTERM);

			for(j=0; j<RETRY; j++)
				if (!kill(ppppid, 0) || isadslrunning())
				{	printf(".");
					fflush(stdout);
					sleep(SLEEP);
				}
				else
					break;
					if (!kill(ppppid, 0) || isadslrunning() )
					{	printf("FAILED\n");
						return 2;
					}
					else
					{	printf("OK\n");
						return 0;
					}
		}
		else
		{	printf("\nError fetching pid!\n");
			return 1;
		}
	}
	return 0;
}

int restart(int argr, char name[10], char arg[5])
{	int out;
	pid_t ppppid;

	int j;
	if ( !isAdslUp() )
	{	printf("\nADSL connection already down.\nCan't restart it.\n");
		return 1;
	}
	else
	{	stoplogging();     

		ppppid=getpidofconn(STAT_FILE);
		if (ppppid > 1)
		{	printf("\nSending SIGTERM to pppd(%d)",ppppid);
			kill(ppppid, SIGTERM);

			for(j=0; j<RETRY; j++)
				if (!kill(ppppid, 0) || isadslrunning())
				{	printf(".");
					fflush(stdout);
					sleep(SLEEP);
				}
				else
					break;

			if (!kill(ppppid, 0) || isadslrunning() )
			{	printf("Failed stopping the connection\n");
				return 2;
			}
			else
			{	printf("\nConnection stopped succesfully\n");
			}
		}
		else
		{	printf("\nError fetching pid!\n");
			return 1;
		}

		sleep(5);
		int pc;                       
		if ( argr < 3)
		{	pc=1;
		}
		else if (strcmp(arg, "pc1") == 0)
		{	pc=1;
		}
		else if (strcmp(arg, "pc2") == 0)
		{	pc=2;
		}
		else if (strcmp(arg, "pc3") == 0)
		{	pc=3;
		}
		else if (strcmp(arg, "pc4") == 0)
		{	pc=4;     
		}
		else
		{	printf("\nUsage: %s start pc<number 1 to 4>\n", name);
			printf("Example: %s start pc2\n", name);
			return 1;
		}

		switch(pc)
		{	case 1:	out=system("pppd call adsl");
				break;
			case 2:	out=system("pppd call adsl2");
				break;
			case 3:	out=system("pppd call adsl3");
				break;
			case 4:	out=system("pppd call adsl4");
				break;
		}

		printf("\nEstablishing connection");

		if (waitforconnection())
		{	printf("\nConnection Established\n");
			sleep(5);

			isAdslUp();     
			startlogging();
			return 0;
		}
		else
		{	printf("\nCouldn't establish connection!\n");
			return 1;
		}

		return 0;
	}
}

int version(void)
{	fprintf(stdout,"\nADSL4Linux version: %s\n\n", VERSION);
	return 0;
}

int getdevicename(char *devicename, int maxlen, const char *statfile)
{	FILE *f;
	char line[100];
	int result=FALSE;

	f=fopen(statfile, "rt");
	if (f)
	{	if	(fgets((char *) &line, 100, f) && fgets((char *) &line, min(100, maxlen), f) && sscanf(line,"%s",devicename)==1)
			result=TRUE;

		fclose(f);
	}
	return result;
}

int hasroute(const char *devicename)
{	FILE *f;
	int result = FALSE;
	int count;
	char line[1000];
	char device[100];
	unsigned int destination;

	f=fopen(ROUTE_FILE, "rt");
	if (f)
	{	fgets(line, 1000, f);
		while(fgets(line, 1000, f))
		{	count = sscanf(line, "%100s %x", (char *) &device, &destination);
			if (count==2 && strcmp(devicename, device)==0)
			{	result=TRUE;
				break;
			}
		}
		fclose(f);
	}
	else
		fprintf(stderr, "can't open route file!");
		return result;
}

int isadslconnected()
{	int i;
	char device[100];

	if (getdevicename((char *) &device, 100, STAT_FILE) && hasroute(device))
		return TRUE;
	else
		return FALSE;
}

int isadslrunning()
{	struct stat st;
	return (stat(STATFILE, &st)>=0);
}

int getpidofconn(char *statfile)
{	FILE *f;
	pid_t result;

	f=fopen(statfile, "rt");
	if (f)
	{	fscanf(f, "%d", &result);
		fclose(f);
	}

	return result;
}
