/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik.suggestions_ordering;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class DetailedDamerauLevenstheinDistance {
    public static final List<EditOperation> editOperations = Arrays.asList(new Insert(), new Replace(), new Transpose(), new Delete());
    private static final Random random = new Random();

    private DetailedDamerauLevenstheinDistance() {
    }

    private static char randomChar(Random random) {
        return (char)(97 + random.nextInt(26));
    }

    public static final EditOperation randomEdit() {
        return editOperations.get(random.nextInt(editOperations.size()));
    }

    public static Distance compare(String s1, String s2) {
        int i;
        int d;
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return new Distance();
        }
        int inf = s1.length() + s2.length();
        HashMap<Character, Integer> da = new HashMap<Character, Integer>();
        for (d = 0; d < s1.length(); ++d) {
            da.put(Character.valueOf(s1.charAt(d)), 0);
        }
        for (d = 0; d < s2.length(); ++d) {
            da.put(Character.valueOf(s2.charAt(d)), 0);
        }
        Distance[][] h = new Distance[s1.length() + 2][s2.length() + 2];
        for (i = 0; i < s1.length() + 2; ++i) {
            for (int j = 0; j < s2.length() + 2; ++j) {
                h[i][j] = new Distance();
            }
        }
        for (i = 0; i <= s1.length(); ++i) {
            h[i + 1][0] = new Distance(inf, 0, 0, 0);
            h[i + 1][1] = new Distance(i, 0, 0, 0);
        }
        for (int j = 0; j <= s2.length(); ++j) {
            h[0][j + 1] = new Distance(inf, 0, 0, 0);
            h[1][j + 1] = new Distance(j, 0, 0, 0);
        }
        for (i = 1; i <= s1.length(); ++i) {
            int db = 0;
            for (int j = 1; j <= s2.length(); ++j) {
                int i1 = (Integer)da.get(Character.valueOf(s2.charAt(j - 1)));
                int j1 = db;
                int cost = 1;
                if (s1.charAt(i - 1) == s2.charAt(j - 1)) {
                    cost = 0;
                    db = j;
                }
                int substitution = h[i][j].value() + cost;
                int insertion = h[i + 1][j].value() + 1;
                int deletion = h[i][j + 1].value() + 1;
                int transpose = h[i1][j1].value() + (i - i1 - 1) + 1 + (j - j1 - 1);
                int min = IntStream.of(substitution, insertion, deletion, transpose).min().getAsInt();
                if (min == substitution) {
                    if (cost == 1) {
                        h[i + 1][j + 1] = h[i][j].replace();
                        continue;
                    }
                    h[i + 1][j + 1] = h[i][j];
                    continue;
                }
                if (min == insertion) {
                    h[i + 1][j + 1] = h[i + 1][j].insert();
                    continue;
                }
                if (min == deletion) {
                    h[i + 1][j + 1] = h[i][j + 1].delete();
                    continue;
                }
                if (min != transpose) continue;
                int transposeCost = i - i1 - 1 + 1 + (j - j1 - 1);
                Distance value = h[i1][j1];
                for (int k = 0; k < transposeCost; ++k) {
                    value = value.transpose();
                }
                h[i + 1][j + 1] = value;
            }
            da.put(Character.valueOf(s1.charAt(i - 1)), i);
        }
        return h[s1.length() + 1][s2.length() + 1];
    }

    public static class Distance {
        public final int inserts;
        public final int deletes;
        public final int replaces;
        public final int transposes;

        public Distance() {
            this(0, 0, 0, 0);
        }

        public Distance(int inserts, int deletes, int replaces, int transposes) {
            this.inserts = inserts;
            this.deletes = deletes;
            this.replaces = replaces;
            this.transposes = transposes;
        }

        public Distance insert() {
            return new Distance(this.inserts + 1, this.deletes, this.replaces, this.transposes);
        }

        public Distance delete() {
            return new Distance(this.inserts, this.deletes + 1, this.replaces, this.transposes);
        }

        public Distance replace() {
            return new Distance(this.inserts, this.deletes, this.replaces + 1, this.transposes);
        }

        public Distance transpose() {
            return new Distance(this.inserts, this.deletes, this.replaces, this.transposes + 1);
        }

        public Distance track(EditOperation operation) {
            if (operation instanceof Insert) {
                return this.insert();
            }
            if (operation instanceof Delete) {
                return this.delete();
            }
            if (operation instanceof Replace) {
                return this.replace();
            }
            if (operation instanceof Transpose) {
                return this.transpose();
            }
            throw new IllegalArgumentException("Unknown operation: " + operation);
        }

        public int value() {
            return this.inserts + this.deletes + this.replaces + this.transposes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Distance other = (Distance)o;
            return new EqualsBuilder().append(this.inserts, other.inserts).append(this.deletes, other.deletes).append(this.replaces, other.replaces).append(this.transposes, other.transposes).build();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("value", this.value()).append("inserts", this.inserts).append("deletes", this.deletes).append("replaces", this.replaces).append("transposes", this.transposes).build();
        }
    }

    public static class Replace
    extends EditOperation {
        @Override
        public String apply(String s) {
            if (s.length() == 0) {
                return null;
            }
            int i = this.random.nextInt(s.length());
            char c = DetailedDamerauLevenstheinDistance.randomChar(this.random);
            if (i == 0) {
                return "" + c + s.substring(1);
            }
            if (i == s.length() - 1) {
                return s.substring(0, i) + c;
            }
            return s.substring(0, i) + c + s.substring(i + 1);
        }
    }

    public static class Insert
    extends EditOperation {
        @Override
        public String apply(String s) {
            int i = this.random.nextInt(s.length() + 1);
            char c = DetailedDamerauLevenstheinDistance.randomChar(this.random);
            if (i == 0) {
                return "" + c + s;
            }
            if (i == s.length()) {
                return s + c;
            }
            return s.substring(0, i) + c + s.substring(i);
        }
    }

    public static class Transpose
    extends EditOperation {
        @Override
        public String apply(String s) {
            if (s.length() <= 1) {
                return null;
            }
            int i = this.random.nextInt(s.length() - 1);
            String transposed = "" + s.charAt(i + 1) + s.charAt(i);
            if (i == 0) {
                return transposed + s.substring(2);
            }
            if (i == s.length() - 1) {
                return s.substring(0, i) + transposed;
            }
            return s.substring(0, i) + transposed + s.substring(i + 2);
        }
    }

    public static class Delete
    extends EditOperation {
        @Override
        public String apply(String s) {
            if (s.length() <= 1) {
                return null;
            }
            int i = this.random.nextInt(s.length());
            if (i == 0) {
                return s.substring(1);
            }
            if (i == s.length() - 1) {
                return s.substring(0, i);
            }
            return s.substring(0, i) + s.substring(i + 1);
        }
    }

    public static abstract class EditOperation
    implements UnaryOperator<String> {
        protected final Random random;

        public EditOperation() {
            this.random = new Random();
        }

        public EditOperation(long seed) {
            this.random = new Random(seed);
        }
    }
}

